/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.integration.configuration.configuration;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.UUIDDeserializer;
import org.apache.kafka.common.serialization.UUIDSerializer;
import org.qubership.atp.integration.configuration.model.KafkaMailResponse;
import org.qubership.atp.integration.configuration.model.MailRequest;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.kafka.config.ConcurrentKafkaListenerContainerFactory;
import org.springframework.kafka.config.TopicBuilder;
import org.springframework.kafka.core.ConsumerFactory;
import org.springframework.kafka.core.DefaultKafkaConsumerFactory;
import org.springframework.kafka.core.DefaultKafkaProducerFactory;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.kafka.core.ProducerFactory;
import org.springframework.kafka.support.serializer.JsonDeserializer;
import org.springframework.kafka.support.serializer.JsonSerializer;

@Configuration
@ConditionalOnProperty(name={"kafka.mails.enable"})
public class KafkaMailSenderConfiguration {
    @Value(value="${kafka.mails.topic:ci_mails}")
    private String kafkaMailsTopic;
    @Value(value="${kafka.mails.topic.partitions:1}")
    private int kafkaMailsPartitions;
    @Value(value="${kafka.mails.topic.replicas:3}")
    private short kafkaMailsReplicas;
    @Value(value="${kafka.mails.message.size:15728640}")
    public int messageSize;
    @Value(value="${kafka.mails.compression.type:lz4}")
    public String compressionType;
    @Value(value="${spring.kafka.producer.bootstrap-servers}")
    private String kafkaServers;
    @Value(value="${kafka.mails.responses.group.id}")
    private String groupId;

    @Bean
    public NewTopic mailsTopic() {
        return TopicBuilder.name((String)this.kafkaMailsTopic).partitions(this.kafkaMailsPartitions).replicas((int)this.kafkaMailsReplicas).build();
    }

    @Bean
    public KafkaTemplate<UUID, MailRequest> kafkaTemplate() {
        return new KafkaTemplate((ProducerFactory)new DefaultKafkaProducerFactory(this.producerConfig()));
    }

    @Bean
    public ConcurrentKafkaListenerContainerFactory<UUID, KafkaMailResponse> kafkaListenerContainerFactory() {
        ConcurrentKafkaListenerContainerFactory factory = new ConcurrentKafkaListenerContainerFactory();
        factory.setConsumerFactory((ConsumerFactory)new DefaultKafkaConsumerFactory(this.consumerConfig(), (Deserializer)new UUIDDeserializer(), (Deserializer)new JsonDeserializer(KafkaMailResponse.class)));
        return factory;
    }

    private Map<String, Object> producerConfig() {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("bootstrap.servers", this.kafkaServers);
        props.put("key.serializer", UUIDSerializer.class);
        props.put("value.serializer", JsonSerializer.class);
        props.put("max.request.size", this.messageSize);
        props.put("compression.type", this.compressionType);
        return props;
    }

    private Map<String, Object> consumerConfig() {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("bootstrap.servers", this.kafkaServers);
        props.put("group.id", this.groupId);
        props.put("key.deserializer", UUIDDeserializer.class);
        props.put("value.deserializer", JsonDeserializer.class);
        return props;
    }
}

