/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.integration.configuration.metrics.providers;

import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.qubership.atp.integration.configuration.mdc.MdcField;
import org.qubership.atp.integration.configuration.mdc.MdcUtils;
import org.slf4j.MDC;
import org.springframework.boot.actuate.metrics.web.servlet.WebMvcTags;
import org.springframework.boot.actuate.metrics.web.servlet.WebMvcTagsContributor;
import org.springframework.boot.actuate.metrics.web.servlet.WebMvcTagsProvider;

public class CustomWebMvcTagsProvider
implements WebMvcTagsProvider {
    public static final String UNKNOWN_PROJECT = "unknown";
    private final boolean ignoreTrailingSlash;
    private final List<WebMvcTagsContributor> contributors;

    public CustomWebMvcTagsProvider(boolean ignoreTrailingSlash, List<WebMvcTagsContributor> contributors) {
        this.ignoreTrailingSlash = ignoreTrailingSlash;
        this.contributors = contributors;
    }

    public Iterable<Tag> getTags(HttpServletRequest request, HttpServletResponse response, Object handler, Throwable exception) {
        Tags tags = this.addProjectIdTag(request, Tags.of((Tag[])new Tag[]{WebMvcTags.method((HttpServletRequest)request), WebMvcTags.uri((HttpServletRequest)request, (HttpServletResponse)response, (boolean)this.ignoreTrailingSlash), WebMvcTags.exception((Throwable)exception), WebMvcTags.status((HttpServletResponse)response), WebMvcTags.outcome((HttpServletResponse)response)}));
        for (WebMvcTagsContributor contributor : this.contributors) {
            tags = tags.and(contributor.getTags(request, response, handler, exception));
        }
        return tags;
    }

    public Iterable<Tag> getLongRequestTags(HttpServletRequest request, Object handler) {
        Tags tags = this.addProjectIdTag(request, Tags.of((Tag[])new Tag[]{WebMvcTags.method((HttpServletRequest)request), WebMvcTags.uri((HttpServletRequest)request, null, (boolean)this.ignoreTrailingSlash)}));
        for (WebMvcTagsContributor contributor : this.contributors) {
            tags = tags.and(contributor.getLongRequestTags(request, handler));
        }
        return tags;
    }

    private Tags addProjectIdTag(HttpServletRequest request, Tags tags) {
        String projectId = MdcUtils.getHeaderFromRequest(request, MdcUtils.convertIdNameToHeader(MdcField.PROJECT_ID.toString()));
        projectId = projectId == null ? MDC.get((String)MdcField.PROJECT_ID.toString()) : projectId;
        return tags.and(new Tag[]{Tag.of((String)MdcField.PROJECT_ID.toString(), (String)(projectId == null ? UNKNOWN_PROJECT : projectId))});
    }
}

