/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.integration.configuration.service;

import org.qubership.atp.integration.configuration.model.AtpRoute;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class RouteService {
    @Value(value="${spring.application.name}")
    private String serviceId;
    @Value(value="${server.port: #{8080}}")
    private int port;
    @Value(value="${atp.service.path:#{null}}")
    private String path;
    @Value(value="${atp.service.public: #{true}}")
    private boolean isPublic;
    @Value(value="${atp.service.internal: #{true}}")
    private boolean isInternal;
    @Value(value="#{servletContext.contextPath}")
    private String servletContextPath;
    @Value(value="${atp.service.url:#{null}}")
    private String serviceUrl;

    public AtpRoute getRoute() {
        AtpRoute atpRoute = new AtpRoute();
        atpRoute.setServiceId(this.serviceId);
        atpRoute.setPort(this.port);
        atpRoute.setPath(this.preparePath(this.path));
        atpRoute.setPublic(this.isPublic);
        atpRoute.setInternal(this.isInternal);
        atpRoute.setContextPath(this.servletContextPath);
        atpRoute.setUrl(this.serviceUrl);
        return atpRoute;
    }

    private String preparePath(String path) {
        if (StringUtils.isEmpty((Object)path)) {
            return "/api/" + this.serviceId + "/v1/**";
        }
        return path;
    }
}

