/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech) (6.2.1).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
package org.qubership.atp.dataset.controllers.api;

import java.util.List;
import org.qubership.atp.dataset.controllers.api.dto.parameters.ParameterDto;
import org.qubership.atp.dataset.controllers.api.dto.parameters.TableResponseDto;
import java.util.UUID;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.multipart.MultipartFile;

import javax.validation.Valid;
import javax.validation.constraints.*;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;

@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-07-09T19:23:02.151151024Z[Etc/UTC]")
@Validated
@Tag(name = "ParameterController", description = "Parameter Controller")
public interface ParameterControllerApi {

    /**
     * POST /parameter/bulk/attribute/{attributeId} : Bulk update value of parameters.
     *
     * @param attributeId attributeId (required)
     * @param dataSetListId dataSetListId (required)
     * @param value value (optional)
     * @param file file (optional)
     * @param dataSetsIds dataSetsIds (optional)
     * @param modifiedWhen modifiedWhen (optional)
     * @param attrPathIds attrPathIds (optional)
     * @return OK (status code 200)
     *         or Created (status code 201)
     *         or IM Used (status code 226)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "bulkUpdateAttribute",
        summary = "Bulk update value of parameters.",
        tags = { "parameter-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = Object.class))
            }),
            @ApiResponse(responseCode = "201", description = "Created"),
            @ApiResponse(responseCode = "226", description = "IM Used"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/parameter/bulk/attribute/{attributeId}",
        produces = { "application/json" }
    )
    ResponseEntity<List<Object>> bulkUpdateAttribute(
        @Parameter(name = "attributeId", description = "attributeId", required = true) @PathVariable("attributeId") UUID attributeId,
        @NotNull @Parameter(name = "dataSetListId", description = "dataSetListId", required = true) @Valid @RequestParam(value = "dataSetListId", required = true) UUID dataSetListId,
        @Parameter(name = "value", description = "value") @Valid @RequestParam(value = "value", required = false) String value,
        @Parameter(name = "file", description = "file") @Valid @RequestParam(value = "file", required = false) org.springframework.core.io.Resource file,
        @Parameter(name = "dataSetsIds", description = "dataSetsIds") @Valid @RequestParam(value = "dataSetsIds", required = false) List<UUID> dataSetsIds,
        @Parameter(name = "modifiedWhen", description = "modifiedWhen") @Valid @RequestParam(value = "modifiedWhen", required = false) Long modifiedWhen,
        @Parameter(name = "attrPathIds", description = "attrPathIds") @Valid @RequestParam(value = "attrPathIds", required = false) List<UUID> attrPathIds
    );


    /**
     * PUT /parameter/ds/{dataSetId}/attribute/{attributeId} : Creates new parameter with provided text.
     *
     * @param dataSetId dataSetId (required)
     * @param attributeId attributeId (required)
     * @param value value (optional)
     * @param dataSetReference dataSetReference (optional)
     * @param listValueReference listValueReference (optional)
     * @param dataSetListId dataSetListId (optional)
     * @param modifiedWhen modifiedWhen (optional)
     * @return OK (status code 200)
     *         or Created (status code 201)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "create",
        summary = "Creates new parameter with provided text.",
        tags = { "parameter-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = UUID.class))
            }),
            @ApiResponse(responseCode = "201", description = "Created"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.PUT,
        value = "/parameter/ds/{dataSetId}/attribute/{attributeId}",
        produces = { "application/json" }
    )
    ResponseEntity<UUID> create(
        @Parameter(name = "dataSetId", description = "dataSetId", required = true) @PathVariable("dataSetId") UUID dataSetId,
        @Parameter(name = "attributeId", description = "attributeId", required = true) @PathVariable("attributeId") UUID attributeId,
        @Parameter(name = "value", description = "value") @Valid @RequestParam(value = "value", required = false) String value,
        @Parameter(name = "dataSetReference", description = "dataSetReference") @Valid @RequestParam(value = "dataSetReference", required = false) UUID dataSetReference,
        @Parameter(name = "listValueReference", description = "listValueReference") @Valid @RequestParam(value = "listValueReference", required = false) UUID listValueReference,
        @Parameter(name = "dataSetListId", description = "dataSetListId") @Valid @RequestParam(value = "dataSetListId", required = false) UUID dataSetListId,
        @Parameter(name = "modifiedWhen", description = "modifiedWhen") @Valid @RequestParam(value = "modifiedWhen", required = false) Long modifiedWhen
    );


    /**
     * DELETE /parameter : Deletes value of the selected parameter.
     *
     * @param dataSetId dataSetId (required)
     * @param attributeId attributeId (required)
     * @param dataSetListId dataSetListId (optional)
     * @param modifiedWhen modifiedWhen (optional)
     * @return OK (status code 200)
     *         or No Content (status code 204)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     */
    @Operation(
        operationId = "delete",
        summary = "Deletes value of the selected parameter.",
        tags = { "parameter-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK"),
            @ApiResponse(responseCode = "204", description = "No Content"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden")
        }
    )
    @RequestMapping(
        method = RequestMethod.DELETE,
        value = "/parameter"
    )
    ResponseEntity<Void> delete(
        @NotNull @Parameter(name = "dataSetId", description = "dataSetId", required = true) @Valid @RequestParam(value = "dataSetId", required = true) UUID dataSetId,
        @NotNull @Parameter(name = "attributeId", description = "attributeId", required = true) @Valid @RequestParam(value = "attributeId", required = true) UUID attributeId,
        @Parameter(name = "dataSetListId", description = "dataSetListId") @Valid @RequestParam(value = "dataSetListId", required = false) UUID dataSetListId,
        @Parameter(name = "modifiedWhen", description = "modifiedWhen") @Valid @RequestParam(value = "modifiedWhen", required = false) Long modifiedWhen
    );


    /**
     * GET /parameter/affected/by/ : Get all parameters which uses provided ListValue
     *
     * @param listValueId listValueId (optional)
     * @param full full (optional)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getAffectedParametersByListValue",
        summary = "Get all parameters which uses provided ListValue",
        tags = { "parameter-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = Object.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/parameter/affected/by/",
        produces = { "application/json" }
    )
    ResponseEntity<List<Object>> getAffectedParametersByListValue(
        @Parameter(name = "listValueId", description = "listValueId") @Valid @RequestParam(value = "listValueId", required = false) UUID listValueId,
        @Parameter(name = "full", description = "full") @Valid @RequestParam(value = "full", required = false) String full
    );


    /**
     * POST /parameter/affected/by/listValues : Get all parameters which use provided ListValue
     *
     * @param UUID  (optional)
     * @return OK (status code 200)
     *         or Created (status code 201)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getAffectedParametersByListValues",
        summary = "Get all parameters which use provided ListValue",
        tags = { "parameter-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = TableResponseDto.class))
            }),
            @ApiResponse(responseCode = "201", description = "Created"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/parameter/affected/by/listValues",
        produces = { "application/json" },
        consumes = { "application/json" }
    )
    ResponseEntity<List<TableResponseDto>> getAffectedParametersByListValues(
        @Parameter(name = "UUID", description = "") @Valid @RequestBody(required = false) List<UUID> UUID
    );


    /**
     * GET /parameter/ds/{dataSetId} : Returns the parameters of selected DS.
     *
     * @param dataSetId dataSetId (required)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getDataSetParameters",
        summary = "Returns the parameters of selected DS.",
        tags = { "parameter-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = ParameterDto.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/parameter/ds/{dataSetId}",
        produces = { "application/json" }
    )
    ResponseEntity<List<ParameterDto>> getDataSetParameters(
        @Parameter(name = "dataSetId", description = "dataSetId", required = true) @PathVariable("dataSetId") UUID dataSetId
    );


    /**
     * POST /parameter/get/original : getOriginalParameter
     *
     * @param dataSetId dataSetId (required)
     * @param targetAttrId targetAttrId (required)
     * @param dataSetListId dataSetListId (optional)
     * @param modifiedWhen modifiedWhen (optional)
     * @param UUID  (optional)
     * @return OK (status code 200)
     *         or Created (status code 201)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getOriginalParameter",
        summary = "getOriginalParameter",
        tags = { "parameter-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = ParameterDto.class))
            }),
            @ApiResponse(responseCode = "201", description = "Created"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/parameter/get/original",
        produces = { "application/json" },
        consumes = { "application/json" }
    )
    ResponseEntity<ParameterDto> getOriginalParameter(
        @NotNull @Parameter(name = "dataSetId", description = "dataSetId", required = true) @Valid @RequestParam(value = "dataSetId", required = true) UUID dataSetId,
        @NotNull @Parameter(name = "targetAttrId", description = "targetAttrId", required = true) @Valid @RequestParam(value = "targetAttrId", required = true) UUID targetAttrId,
        @Parameter(name = "dataSetListId", description = "dataSetListId") @Valid @RequestParam(value = "dataSetListId", required = false) UUID dataSetListId,
        @Parameter(name = "modifiedWhen", description = "modifiedWhen") @Valid @RequestParam(value = "modifiedWhen", required = false) Long modifiedWhen,
        @Parameter(name = "UUID", description = "") @Valid @RequestBody(required = false) List<UUID> UUID
    );


    /**
     * POST /parameter/ds/{dataSetId}/attribute/{attributeId} : Updates value of the selected parameter.
     *
     * @param dataSetId dataSetId (required)
     * @param attributeId attributeId (required)
     * @param value value (optional)
     * @param dataSetReference dataSetReference (optional)
     * @param listValueReference listValueReference (optional)
     * @param dataSetListId dataSetListId (optional)
     * @param modifiedWhen modifiedWhen (optional)
     * @param UUID  (optional)
     * @return OK (status code 200)
     *         or Created (status code 201)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "update",
        summary = "Updates value of the selected parameter.",
        tags = { "parameter-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = ParameterDto.class))
            }),
            @ApiResponse(responseCode = "201", description = "Created"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/parameter/ds/{dataSetId}/attribute/{attributeId}",
        produces = { "application/json" },
        consumes = { "application/json" }
    )
    ResponseEntity<ParameterDto> update(
        @Parameter(name = "dataSetId", description = "dataSetId", required = true) @PathVariable("dataSetId") UUID dataSetId,
        @Parameter(name = "attributeId", description = "attributeId", required = true) @PathVariable("attributeId") UUID attributeId,
        @Parameter(name = "value", description = "value") @Valid @RequestParam(value = "value", required = false) String value,
        @Parameter(name = "dataSetReference", description = "dataSetReference") @Valid @RequestParam(value = "dataSetReference", required = false) UUID dataSetReference,
        @Parameter(name = "listValueReference", description = "listValueReference") @Valid @RequestParam(value = "listValueReference", required = false) UUID listValueReference,
        @Parameter(name = "dataSetListId", description = "dataSetListId") @Valid @RequestParam(value = "dataSetListId", required = false) UUID dataSetListId,
        @Parameter(name = "modifiedWhen", description = "modifiedWhen") @Valid @RequestParam(value = "modifiedWhen", required = false) Long modifiedWhen,
        @Parameter(name = "UUID", description = "") @Valid @RequestBody(required = false) List<UUID> UUID
    );


    /**
     * POST /parameter/update/bulk : Updates value of the selected parameters. Please do not use for files or overlaps!
     *
     * @param dataSetListId dataSetListId (required)
     * @param value value (optional)
     * @param dataSetReference dataSetReference (optional)
     * @param listValueReference listValueReference (optional)
     * @param modifiedWhen modifiedWhen (optional)
     * @param dataSetId dataSetId (optional)
     * @param UUID  (optional)
     * @return OK (status code 200)
     *         or Created (status code 201)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "updateParameters",
        summary = "Updates value of the selected parameters. Please do not use for files or overlaps!",
        tags = { "parameter-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK"),
            @ApiResponse(responseCode = "201", description = "Created"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/parameter/update/bulk",
        consumes = { "application/json" }
    )
    ResponseEntity<Void> updateParameters(
        @NotNull @Parameter(name = "dataSetListId", description = "dataSetListId", required = true) @Valid @RequestParam(value = "dataSetListId", required = true) UUID dataSetListId,
        @Parameter(name = "value", description = "value") @Valid @RequestParam(value = "value", required = false) String value,
        @Parameter(name = "dataSetReference", description = "dataSetReference") @Valid @RequestParam(value = "dataSetReference", required = false) UUID dataSetReference,
        @Parameter(name = "listValueReference", description = "listValueReference") @Valid @RequestParam(value = "listValueReference", required = false) UUID listValueReference,
        @Parameter(name = "modifiedWhen", description = "modifiedWhen") @Valid @RequestParam(value = "modifiedWhen", required = false) Long modifiedWhen,
        @Parameter(name = "dataSetId", description = "dataSetId") @Valid @RequestParam(value = "dataSetId", required = false) UUID dataSetId,
        @Parameter(name = "UUID", description = "") @Valid @RequestBody(required = false) List<UUID> UUID
    );

}
