package org.qubership.atp.dataset.controllers.api.dto.datasetlists;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.qubership.atp.dataset.controllers.api.dto.datasetlists.AttributeTypeDto;
import org.qubership.atp.dataset.controllers.api.dto.datasetlists.DataSetListDto;
import org.qubership.atp.dataset.controllers.api.dto.datasetlists.ListValueDto;
import org.qubership.atp.dataset.controllers.api.dto.datasetlists.ParameterDto;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * AttributeDto
 */

@JsonTypeName("Attribute")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-07-09T19:23:01.532988626Z[Etc/UTC]")
public class AttributeDto {

  @JsonProperty("dataSetList")
  private DataSetListDto dataSetList;

  @JsonProperty("dataSetListReference")
  private DataSetListDto dataSetListReference;

  @JsonProperty("id")
  private UUID id;

  @JsonProperty("listValues")
  @Valid
  private List<ListValueDto> listValues = null;

  @JsonProperty("name")
  private String name;

  @JsonProperty("parameters")
  @Valid
  private List<ParameterDto> parameters = null;

  @JsonProperty("type")
  private AttributeTypeDto type;

  public AttributeDto dataSetList(DataSetListDto dataSetList) {
    this.dataSetList = dataSetList;
    return this;
  }

  /**
   * Get dataSetList
   * @return dataSetList
  */
  @NotNull @Valid 
  @Schema(name = "dataSetList", required = true)
  public DataSetListDto getDataSetList() {
    return dataSetList;
  }

  public void setDataSetList(DataSetListDto dataSetList) {
    this.dataSetList = dataSetList;
  }

  public AttributeDto dataSetListReference(DataSetListDto dataSetListReference) {
    this.dataSetListReference = dataSetListReference;
    return this;
  }

  /**
   * Get dataSetListReference
   * @return dataSetListReference
  */
  @Valid 
  @Schema(name = "dataSetListReference", required = false)
  public DataSetListDto getDataSetListReference() {
    return dataSetListReference;
  }

  public void setDataSetListReference(DataSetListDto dataSetListReference) {
    this.dataSetListReference = dataSetListReference;
  }

  public AttributeDto id(UUID id) {
    this.id = id;
    return this;
  }

  /**
   * Get id
   * @return id
  */
  @NotNull @Valid 
  @Schema(name = "id", required = true)
  public UUID getId() {
    return id;
  }

  public void setId(UUID id) {
    this.id = id;
  }

  public AttributeDto listValues(List<ListValueDto> listValues) {
    this.listValues = listValues;
    return this;
  }

  public AttributeDto addListValuesItem(ListValueDto listValuesItem) {
    if (this.listValues == null) {
      this.listValues = new ArrayList<>();
    }
    this.listValues.add(listValuesItem);
    return this;
  }

  /**
   * for list type
   * @return listValues
  */
  @Valid 
  @Schema(name = "listValues", description = "for list type", required = false)
  public List<ListValueDto> getListValues() {
    return listValues;
  }

  public void setListValues(List<ListValueDto> listValues) {
    this.listValues = listValues;
  }

  public AttributeDto name(String name) {
    this.name = name;
    return this;
  }

  /**
   * Get name
   * @return name
  */
  @NotNull 
  @Schema(name = "name", required = true)
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public AttributeDto parameters(List<ParameterDto> parameters) {
    this.parameters = parameters;
    return this;
  }

  public AttributeDto addParametersItem(ParameterDto parametersItem) {
    if (this.parameters == null) {
      this.parameters = new ArrayList<>();
    }
    this.parameters.add(parametersItem);
    return this;
  }

  /**
   * Get parameters
   * @return parameters
  */
  @Valid 
  @Schema(name = "parameters", required = false)
  public List<ParameterDto> getParameters() {
    return parameters;
  }

  public void setParameters(List<ParameterDto> parameters) {
    this.parameters = parameters;
  }

  public AttributeDto type(AttributeTypeDto type) {
    this.type = type;
    return this;
  }

  /**
   * Get type
   * @return type
  */
  @NotNull @Valid 
  @Schema(name = "type", required = true)
  public AttributeTypeDto getType() {
    return type;
  }

  public void setType(AttributeTypeDto type) {
    this.type = type;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AttributeDto attribute = (AttributeDto) o;
    return Objects.equals(this.dataSetList, attribute.dataSetList) &&
        Objects.equals(this.dataSetListReference, attribute.dataSetListReference) &&
        Objects.equals(this.id, attribute.id) &&
        Objects.equals(this.listValues, attribute.listValues) &&
        Objects.equals(this.name, attribute.name) &&
        Objects.equals(this.parameters, attribute.parameters) &&
        Objects.equals(this.type, attribute.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(dataSetList, dataSetListReference, id, listValues, name, parameters, type);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AttributeDto {\n");
    sb.append("    dataSetList: ").append(toIndentedString(dataSetList)).append("\n");
    sb.append("    dataSetListReference: ").append(toIndentedString(dataSetListReference)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    listValues: ").append(toIndentedString(listValues)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    parameters: ").append(toIndentedString(parameters)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

