/*
 * # Copyright 2024-2025 NetCracker Technology Corporation
 * #
 * # Licensed under the Apache License, Version 2.0 (the "License");
 * # you may not use this file except in compliance with the License.
 * # You may obtain a copy of the License at
 * #
 * #      http://www.apache.org/licenses/LICENSE-2.0
 * #
 * # Unless required by applicable law or agreed to in writing, software
 * # distributed under the License is distributed on an "AS IS" BASIS,
 * # WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * # See the License for the specific language governing permissions and
 * # limitations under the License.
 */

package org.qubership.atp.dataset.db.jpa.repositories;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;

import org.qubership.atp.dataset.db.jdbc.JdbcTemplates;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class JpaDataSetListRepositoryCustomImpl implements JpaDataSetListRepositoryCustom {
    @Autowired
    JdbcTemplates jdbc;

    @Override
    public Set<UUID> getDslIdsByVa(UUID vaId) {
        return jdbc.executeSelect(
                "select id from datasetlist where visibility_area_id = ?",
                resultSet -> {
                    Set<UUID> dslIds = new HashSet<>();
                    while (resultSet.next()) {
                        dslIds.add(resultSet.getObject("id", UUID.class));
                    }
                    return dslIds;
                },
                vaId
        );
    }
}
