/*
 * # Copyright 2024-2025 NetCracker Technology Corporation
 * #
 * # Licensed under the Apache License, Version 2.0 (the "License");
 * # you may not use this file except in compliance with the License.
 * # You may obtain a copy of the License at
 * #
 * #      http://www.apache.org/licenses/LICENSE-2.0
 * #
 * # Unless required by applicable law or agreed to in writing, software
 * # distributed under the License is distributed on an "AS IS" BASIS,
 * # WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * # See the License for the specific language governing permissions and
 * # limitations under the License.
 */

package org.qubership.atp.dataset.service.direct;

import org.qubership.atp.dataset.macros.args.RefArg;
import org.qubership.atp.dataset.model.DataSetList;
import org.qubership.atp.dataset.model.Identified;
import org.qubership.atp.dataset.model.Named;
import org.qubership.atp.dataset.model.VisibilityArea;

public interface AliasWrapperService {

    /**
     * Method wraps user friendly value to alias in a form of object id.
     */
    String wrapToAlias(String text, VisibilityArea visibilityArea, DataSetList dsl);

    /**
     * Tries to unwrap.
     *
     * @throws NullPointerException if ref is broken:
     */
    <T extends Identified & Named> UnwrapStatus unWrapAlias(RefArg.Signature<T> ref);

    String unWrapAlias(String text);
}