/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.antlr4;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.qubership.atp.dataset.antlr4.TextParameterParser;
import org.qubership.atp.dataset.db.jpa.entities.DataSetListEntity;
import org.qubership.atp.dataset.service.jpa.DataSetServiceException;
import org.qubership.atp.dataset.service.jpa.delegates.DataSetList;
import org.qubership.atp.dataset.service.jpa.impl.macro.CachedDslMacroResultContainer;
import org.qubership.atp.dataset.service.jpa.impl.macro.MacroContext;
import org.qubership.atp.dataset.service.jpa.model.MacroContextService;
import org.qubership.atp.dataset.service.jpa.model.PathStep;
import org.qubership.atp.dataset.service.jpa.model.dscontext.DataSetListContext;
import org.qubership.atp.dataset.service.jpa.model.tree.params.AbstractTextParameter;
import org.qubership.atp.dataset.service.jpa.model.tree.params.macros.ParameterPositionContext;
import org.qubership.atp.dataset.service.jpa.model.tree.params.macros.RefDslMacro;
import org.springframework.test.context.junit.jupiter.SpringExtension;

@ExtendWith(value={SpringExtension.class})
public class TextParameterParserTest {
    private static MacroContext macroContext;
    public static String MACRO_RESULT;
    public static UUID DATA_SET_LIST_ID;
    public static UUID DATA_SET_ID;
    @Mock
    CachedDslMacroResultContainer dslMacroResultContainer;

    @BeforeEach
    public void setUp() {
        macroContext = new MacroContext();
        macroContext.addAtpDataSetContext("{'ER_NAME': 'Some Er Name'}");
        Mockito.when((Object)this.dslMacroResultContainer.getCachedValue((PathStep)ArgumentMatchers.any(), (PathStep)ArgumentMatchers.any(), (List)ArgumentMatchers.any(), (PathStep)ArgumentMatchers.any())).thenReturn(null);
        ((CachedDslMacroResultContainer)Mockito.doNothing().when((Object)this.dslMacroResultContainer)).storeValue((PathStep)ArgumentMatchers.any(), (PathStep)ArgumentMatchers.any(), (List)ArgumentMatchers.any(), (PathStep)ArgumentMatchers.any(), (String)ArgumentMatchers.any());
        MacroContextService macroContextService = new MacroContextService(){

            public String getTextParameterByListDataSetAndPath(UUID visibilityAreaId, PathStep dataSetList, PathStep dataSet, List<PathStep> referenceAttributePath, PathStep parameterAttribute) throws DataSetServiceException {
                return MACRO_RESULT;
            }

            public String getTextParameterByExternalListDataSetAndPath(UUID visibilityAreaId, PathStep dataSetList, PathStep dataSet, List<PathStep> referenceAttributePath, PathStep parameterAttribute) throws DataSetServiceException {
                return MACRO_RESULT;
            }

            public String getTextParameterFromCachedContextByNamesPath(UUID visibilityAreaId, PathStep topLevelDataSetList, UUID dataSetId, int dataSetColumn, List<UUID> macroPosition, List<PathStep> pathSteps, PathStep attribute) throws DataSetServiceException {
                return MACRO_RESULT;
            }

            public String getDataSetListName(UUID dataSetListId) throws DataSetServiceException {
                return MACRO_RESULT;
            }

            public String getDataSetName(UUID dataSetListId) throws DataSetServiceException {
                return MACRO_RESULT;
            }

            public UUID getDataSetUuid(String dataSetName, UUID dataSetListId) {
                return DATA_SET_ID;
            }

            public DataSetList getDataSetList(UUID visibilityAreaId, PathStep dataSetListPathStep) throws DataSetServiceException {
                DataSetListEntity dataSetListEntity = new DataSetListEntity();
                dataSetListEntity.setId(DATA_SET_LIST_ID);
                return new DataSetList(dataSetListEntity);
            }

            public String getAttributeName(UUID dataSetListId) throws DataSetServiceException {
                return MACRO_RESULT;
            }

            public Map<ParameterPositionContext, String> getCachedEvaluatedValues(UUID dataSetListId) {
                return null;
            }

            public CachedDslMacroResultContainer getDslMacroCache() {
                return TextParameterParserTest.this.dslMacroResultContainer;
            }

            public void dropLocalThreadCache() {
            }
        };
        macroContext.setMacroContextService(macroContextService);
        DataSetListContext dataSetListContext = new DataSetListContext(null);
        macroContext.setDataSetListContext(dataSetListContext);
    }

    @Test
    public void TestParseMacroService() {
        ParameterPositionContext parameterPositionContext = new ParameterPositionContext(Collections.emptyList(), 0, null, Long.valueOf(0L), null);
        TextParameterParser parser = new TextParameterParser(macroContext, parameterPositionContext);
        String parameterValue = "text #REF_DSL(#REF(ce8a95b5-2bf4-47c7-9fc3-fba56df0fa52.ce8a95b5-2bf4-47c7-9fc3-fba56df0fa52).#REF(ce8a95b5-2bf4-47c7-9fc3-fba56df0fa52.ce8a95b5-2bf4-47c7-9fc3-fba56df0fa52)some.#REF(ce8a95b5-2bf4-47c7-9fc3-fba56df0fa52.ce8a95b5-2bf4-47c7-9fc3-fba56df0fa52))";
        List parseResult = parser.parse(parameterValue, false);
        StringBuilder result = new StringBuilder();
        for (AbstractTextParameter abstractTextParameter : parseResult) {
            result.append(abstractTextParameter.getValue());
        }
        Assertions.assertEquals((Object)parameterValue, (Object)result.toString());
    }

    @Test
    public void TestParseMacroService_quoteIsNotLost() {
        ParameterPositionContext parameterPositionContext = new ParameterPositionContext(Collections.emptyList(), 0, null, Long.valueOf(0L), null);
        TextParameterParser parser = new TextParameterParser(macroContext, parameterPositionContext);
        String parameterValue = " AAA ' BBB \" CCC , DDD $RANDOM('aa', 'bb \\'cc\\'') \\ EEE $RANDOM('$RANDOM('df')')";
        List parseResult = parser.parse(parameterValue, false);
        StringBuilder result = new StringBuilder();
        for (AbstractTextParameter abstractTextParameter : parseResult) {
            result.append(abstractTextParameter.getValue());
        }
        Assertions.assertEquals((Object)parameterValue, (Object)result.toString());
    }

    @Test
    public void testParseMacroServiceCollectsDataSetsAndDataSetListsId() {
        ParameterPositionContext parameterPositionContext = new ParameterPositionContext(Collections.emptyList(), 0, null, Long.valueOf(0L), null);
        TextParameterParser parser = new TextParameterParser(macroContext, parameterPositionContext);
        String parameterValue = "text #REF_DSL(#REF_DSL(ce8a95b5-2bf4-47c7-9fc3-fba56df0fa52.ce8a95b5-2bf4-47c7-9fc3-fba56df0fa52.#REF(ce8a95b5-2bf4-47c7-9fc3-fba56df0fa52.ce8a95b5-2bf4-47c7-9fc3-fba56df0fa52)).#REF(ce8a95b5-2bf4-47c7-9fc3-fba56df0fa52.ce8a95b5-2bf4-47c7-9fc3-fba56df0fa52)some.#REF(ce8a95b5-2bf4-47c7-9fc3-fba56df0fa52.ce8a95b5-2bf4-47c7-9fc3-fba56df0fa52))";
        List parseResult = parser.parse(parameterValue, true);
        for (AbstractTextParameter abstractTextParameter : parseResult) {
            abstractTextParameter.getValue();
        }
        Assertions.assertTrue((boolean)(parseResult.get(1) instanceof RefDslMacro));
        RefDslMacro dslMacro = (RefDslMacro)parseResult.get(1);
        Assertions.assertEquals((int)1, (int)dslMacro.getDataSets().size());
        Assertions.assertEquals((int)1, (int)dslMacro.getDataSetLists().size());
        Assertions.assertTrue((boolean)dslMacro.getDataSets().contains(DATA_SET_ID));
        Assertions.assertTrue((boolean)dslMacro.getDataSetLists().contains(DATA_SET_LIST_ID));
    }

    @Test
    public void TestParseUnknownMacro_MacroStartsWithDollarSign_MacroNameHasNotChanged() {
        ParameterPositionContext parameterPositionContext = new ParameterPositionContext(Collections.emptyList(), 0, null, Long.valueOf(0L), null);
        TextParameterParser parser = new TextParameterParser(macroContext, parameterPositionContext);
        String parameterValue = "$EXECUTION_REQUEST_NUMBER()";
        List parseResult = parser.parse(parameterValue, true);
        StringBuilder result = new StringBuilder();
        for (AbstractTextParameter abstractTextParameter : parseResult) {
            result.append(abstractTextParameter.getValue());
        }
        Assertions.assertEquals((Object)parameterValue, (Object)result.toString());
    }

    @Test
    public void TestParseMacroService_noParamsMacro() {
        ParameterPositionContext parameterPositionContext = new ParameterPositionContext(Collections.emptyList(), 0, null, Long.valueOf(0L), null);
        TextParameterParser parser = new TextParameterParser(macroContext, parameterPositionContext);
        String parameterValue = "#INN()";
        List parseResult = parser.parse(parameterValue, false);
        StringBuilder result = new StringBuilder();
        for (AbstractTextParameter abstractTextParameter : parseResult) {
            result.append(abstractTextParameter.getValue());
        }
        Assertions.assertEquals((Object)parameterValue, (Object)result.toString());
    }

    static {
        MACRO_RESULT = "MY TEXT";
        DATA_SET_LIST_ID = UUID.randomUUID();
        DATA_SET_ID = UUID.randomUUID();
    }
}

