/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.controllers.api;

import com.google.common.reflect.ClassPath;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;

public class ConsistentControllerApiUnitTest {
    private static final Logger log = LoggerFactory.getLogger(ConsistentControllerApiUnitTest.class);
    static final List<String> controllersPackage = Arrays.asList("org.qubership.atp.dataset.service.rest.server");
    static final String apiPackage = "org.qubership.atp.dataset.controllers.api";
    static final Map<Class, List<String>> ctrlMethodsToSkip = new HashMap<Class, List<String>>();

    @Test
    public void testInterface() {
        Set<Class> apis = this.findAllClassesInPackage(apiPackage);
        ArrayList errors = new ArrayList();
        apis.forEach(aClass -> this.checkController((Class)aClass, errors));
        if (!errors.isEmpty()) {
            throw new RuntimeException(StringUtils.join(errors, (String)"\n"));
        }
    }

    private void checkController(Class apiClass, List<String> errors) {
        String classNameWithApi = apiClass.getSimpleName();
        List controllersList = controllersPackage.stream().map(s -> this.findControllerByClassName((String)s, this.removeApiPostfix(classNameWithApi))).filter(Objects::nonNull).collect(Collectors.toList());
        if (controllersList.isEmpty()) {
            log.error("No one controller is found for api {}", (Object)apiClass.getCanonicalName());
            errors.add("No one controller is found for api " + apiClass.getCanonicalName());
        }
        if (controllersList.size() > 1) {
            log.error("There are two controllers for api {}", (Object)apiClass.getCanonicalName());
            errors.add("There are two controllers for api " + apiClass.getCanonicalName());
        }
        List listOfControllerMethods = Arrays.asList(((Class)controllersList.get(0)).getDeclaredMethods()).stream().filter(method -> this.isRestMethod((Method)method)).collect(Collectors.toList());
        listOfControllerMethods.stream().filter(method -> Modifier.isPublic(method.getModifiers())).forEach(method -> this.checkMethodInController((Method)method, apiClass, errors));
    }

    private boolean isRestMethod(Method method) {
        return method.isAnnotationPresent(RequestMapping.class) || method.isAnnotationPresent(PostMapping.class) || method.isAnnotationPresent(PutMapping.class) || method.isAnnotationPresent(PostMapping.class) || method.isAnnotationPresent(DeleteMapping.class) || method.isAnnotationPresent(GetMapping.class) || method.isAnnotationPresent(GetMapping.class) || method.isAnnotationPresent(GetMapping.class) || method.isAnnotationPresent(PatchMapping.class);
    }

    private void checkMethodInController(Method ctrlMethod, Class<?> apiClass, List<String> errors) {
        List<Method> listOfApiMethods = Arrays.asList(apiClass.getDeclaredMethods());
        List apiMethods = listOfApiMethods.stream().filter(apiMethod -> apiMethod.getName().equals(ctrlMethod.getName())).collect(Collectors.toList());
        if (apiMethods.isEmpty() && (ctrlMethodsToSkip.get(apiClass) == null || !ctrlMethodsToSkip.get(apiClass).contains(ctrlMethod.getName()))) {
            errors.add("Found new or not excluded method '" + ctrlMethod.getName() + "' for class " + apiClass);
        }
    }

    private String removeApiPostfix(String classNameWithApi) {
        return classNameWithApi.replaceFirst("Api$", "");
    }

    private Class<?> findControllerByClassName(String packagePath, String className) {
        String fullClassName = packagePath + "." + className;
        try {
            return this.getClass().getClassLoader().loadClass(fullClassName);
        }
        catch (ClassNotFoundException e) {
            log.error("class {} not found in package {}", (Object)fullClassName, (Object)packagePath);
            return null;
        }
    }

    public Set<Class> findAllClassesInPackage(String packageName) {
        return ClassPath.from((ClassLoader)this.getClass().getClassLoader()).getAllClasses().stream().filter(clazz -> clazz.getPackageName().equalsIgnoreCase(packageName)).filter(clazz -> clazz.getSimpleName().matches("^.*Api$")).map(clazz -> clazz.load()).collect(Collectors.toSet());
    }
}

