/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.controllers.api;

import au.com.dius.pact.provider.junit5.PactVerificationContext;
import au.com.dius.pact.provider.junit5.PactVerificationInvocationContextProvider;
import au.com.dius.pact.provider.junit5.TestTarget;
import au.com.dius.pact.provider.junitsupport.State;
import au.com.dius.pact.provider.junitsupport.loader.PactUrl;
import au.com.dius.pact.provider.spring.junit5.MockMvcTestTarget;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import org.json.simple.JSONObject;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.parallel.Isolated;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.qubership.atp.auth.springbootstarter.entities.UserInfo;
import org.qubership.atp.auth.springbootstarter.ssl.Provider;
import org.qubership.atp.dataset.model.DataSet;
import org.qubership.atp.dataset.model.DataSetList;
import org.qubership.atp.dataset.model.MixInId;
import org.qubership.atp.dataset.model.TestPlan;
import org.qubership.atp.dataset.model.VisibilityArea;
import org.qubership.atp.dataset.model.api.DetailedComparisonDsRequest;
import org.qubership.atp.dataset.model.api.DetailedComparisonDsResponse;
import org.qubership.atp.dataset.model.enums.DetailedComparisonStatus;
import org.qubership.atp.dataset.model.impl.ComparedAttribute;
import org.qubership.atp.dataset.model.impl.DataSetImpl;
import org.qubership.atp.dataset.model.impl.DataSetListImpl;
import org.qubership.atp.dataset.model.impl.LabelImpl;
import org.qubership.atp.dataset.model.impl.MixInIdImpl;
import org.qubership.atp.dataset.model.impl.TestPlanImpl;
import org.qubership.atp.dataset.model.impl.VisibilityAreaImpl;
import org.qubership.atp.dataset.model.utils.DatasetResponse;
import org.qubership.atp.dataset.service.direct.AttributeService;
import org.qubership.atp.dataset.service.direct.ConcurrentModificationService;
import org.qubership.atp.dataset.service.direct.DataSetListService;
import org.qubership.atp.dataset.service.direct.DataSetService;
import org.qubership.atp.dataset.service.direct.ParameterService;
import org.qubership.atp.dataset.service.direct.impl.CompareDatasetServiceImpl;
import org.qubership.atp.dataset.service.direct.importexport.service.DatasetListExportService;
import org.qubership.atp.dataset.service.direct.importexport.service.DatasetListImportService;
import org.qubership.atp.dataset.service.jpa.ContextType;
import org.qubership.atp.dataset.service.jpa.DataSetServiceException;
import org.qubership.atp.dataset.service.jpa.JpaDataSetListService;
import org.qubership.atp.dataset.service.jpa.JpaDataSetService;
import org.qubership.atp.dataset.service.jpa.JpaParameterService;
import org.qubership.atp.dataset.service.jpa.impl.DataSetListCheckService;
import org.qubership.atp.dataset.service.jpa.model.AttributeTypeName;
import org.qubership.atp.dataset.service.jpa.model.DataSetListDependencyNode;
import org.qubership.atp.dataset.service.rest.server.CopyDataSetListsResponse;
import org.qubership.atp.dataset.service.rest.server.DataSetController;
import org.qubership.atp.dataset.service.rest.server.DataSetListController;
import org.qubership.atp.dataset.service.rest.server.ParameterController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.autoconfigure.http.HttpMessageConvertersAutoConfiguration;
import org.springframework.boot.autoconfigure.jackson.JacksonAutoConfiguration;
import org.springframework.boot.test.autoconfigure.web.servlet.AutoConfigureMockMvc;
import org.springframework.boot.test.autoconfigure.web.servlet.WebMvcTest;
import org.springframework.boot.test.mock.mockito.MockBean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.http.HttpStatus;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.web.servlet.MockMvc;

@Isolated
@au.com.dius.pact.provider.junitsupport.Provider(value="atp-datasets")
@PactUrl(urls={"src/test/resources/pacts/atp-catalogue-atp-datasets.json"})
@AutoConfigureMockMvc(addFilters=false, webDriverEnabled=false)
@WebMvcTest(controllers={DataSetController.class, ParameterController.class, DataSetListController.class})
@ContextConfiguration(classes={TestApp.class})
@EnableAutoConfiguration
@Import(value={JacksonAutoConfiguration.class, HttpMessageConvertersAutoConfiguration.class, DataSetListController.class, ParameterController.class, DataSetController.class})
public class DatasetsAndCatalogContractTest {
    private static final Logger log = LoggerFactory.getLogger(DatasetsAndCatalogContractTest.class);
    @Autowired
    private MockMvc mockMvc;
    @MockBean
    private DataSetService dsService;
    @MockBean
    private ConcurrentModificationService concurrentModificationService;
    @MockBean
    private JpaDataSetService dataSetService;
    @MockBean
    private DataSetListService dslService;
    @MockBean
    private DataSetListCheckService dataSetListCheckService;
    @MockBean
    private JpaDataSetListService jpaDataSetListService;
    @MockBean
    private AttributeService attributeService;
    @MockBean
    private Provider<UserInfo> userInfoProvider;
    @MockBean
    private DatasetListExportService datasetListExportService;
    @MockBean
    private DatasetListImportService importService;
    @MockBean
    private ParameterService parameterService;
    @MockBean
    private JpaParameterService jpaParameterService;
    @MockBean
    CompareDatasetServiceImpl compareDs;

    public void beforeAll() throws DataSetServiceException {
        JSONObject jsonObject = new JSONObject();
        ArrayList<JSONObject> resultListJson = new ArrayList<JSONObject>();
        resultListJson.add(jsonObject);
        ArrayList<DatasetResponse> resultList = new ArrayList<DatasetResponse>();
        DatasetResponse datasetResponse = new DatasetResponse(UUID.randomUUID(), "dsName", UUID.randomUUID(), "dslName");
        resultList.add(datasetResponse);
        DataSetImpl dataSet = new DataSetImpl();
        dataSet.setName("dataSetName");
        dataSet.setMixInId((MixInId)new MixInIdImpl(UUID.randomUUID()));
        dataSet.setId(UUID.randomUUID());
        DataSetListImpl dataSetList = new DataSetListImpl();
        VisibilityAreaImpl visibilityArea = new VisibilityAreaImpl();
        visibilityArea.setId(UUID.fromString("c2737427-05e4-4c17-8032-455539deaa02"));
        dataSetList.setId(UUID.fromString("c2737427-05e4-4c17-8032-455539deaa01"));
        dataSetList.setName("name");
        dataSetList.setVisibilityArea((VisibilityArea)visibilityArea);
        dataSetList.setCreatedBy(UUID.fromString("f0c1d2ba-7c99-4e0b-a39d-0566f2ae9f25"));
        dataSetList.setModifiedBy(UUID.randomUUID());
        ArrayList<LabelImpl> labelList = new ArrayList<LabelImpl>();
        labelList.add(new LabelImpl(UUID.randomUUID(), "name"));
        dataSetList.setLabels(labelList);
        dataSetList.setModifiedWhen(new Timestamp(0L));
        dataSetList.setTestPlan((TestPlan)new TestPlanImpl(UUID.randomUUID(), "name", (VisibilityArea)visibilityArea));
        LinkedList<DataSetListImpl> dataSetListLinkedList = new LinkedList<DataSetListImpl>();
        dataSetListLinkedList.add(dataSetList);
        DataSetImpl ds = new DataSetImpl();
        ds.setName("dataSetName");
        ds.setMixInId((MixInId)new MixInIdImpl(UUID.randomUUID()));
        ds.setId(UUID.randomUUID());
        LinkedList<DataSetImpl> list = new LinkedList<DataSetImpl>();
        list.add(ds);
        Mockito.when((Object)this.concurrentModificationService.getHttpStatus((UUID)ArgumentMatchers.any(), (Long)ArgumentMatchers.any())).thenReturn((Object)HttpStatus.OK);
        Mockito.when((Object)((DataSet)this.dsService.get((UUID)ArgumentMatchers.any(UUID.class)))).thenReturn((Object)dataSet);
        ((DataSetService)Mockito.doNothing().when((Object)this.dsService)).delete((UUID)ArgumentMatchers.any());
        Mockito.when((Object)this.dataSetService.getDataSetTreeInAtpFormat((UUID)ArgumentMatchers.any(UUID.class), ArgumentMatchers.anyBoolean(), ArgumentMatchers.anyString(), (ContextType)ArgumentMatchers.any(ContextType.class), Integer.valueOf(ArgumentMatchers.anyInt()))).thenReturn(resultListJson);
        Mockito.when((Object)((DataSetList)this.dslService.get((UUID)ArgumentMatchers.any()))).thenReturn((Object)this.getDataSetList());
        ((DataSetListService)Mockito.doNothing().when((Object)this.dslService)).delete((UUID)ArgumentMatchers.any());
        Mockito.when((Object)((UserInfo)this.userInfoProvider.get())).thenReturn((Object)new UserInfo());
        Mockito.when((Object)this.dslService.getListOfDsIdsAndNameAndDslId((List)ArgumentMatchers.any())).thenReturn(resultList);
        Mockito.when((Object)this.dslService.getAll((UUID)ArgumentMatchers.any(), (String)ArgumentMatchers.any())).thenReturn(dataSetListLinkedList);
        Mockito.when((Object)this.dslService.getChildren((UUID)ArgumentMatchers.any(UUID.class), ArgumentMatchers.anyBoolean(), (String)ArgumentMatchers.any())).thenReturn(list);
        Mockito.when((Object)this.jpaDataSetListService.copyDataSetLists((List)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean(), ArgumentMatchers.anyString(), (String)ArgumentMatchers.any())).thenReturn(this.getCopyDataSetListsResponseDto());
        Mockito.when((Object)this.jpaDataSetListService.getDependenciesRecursive((List)ArgumentMatchers.any())).thenReturn(this.getListDataSetListDependencyNode());
        Mockito.when((Object)this.jpaParameterService.bulkUpdateValues((String)ArgumentMatchers.any(), (UUID)ArgumentMatchers.any(), (UUID)ArgumentMatchers.any(), (UUID)ArgumentMatchers.any(), (UUID)ArgumentMatchers.any(), (List)ArgumentMatchers.any())).thenReturn((Object)true);
        Mockito.when((Object)this.compareDs.detailedComparison((DetailedComparisonDsRequest)ArgumentMatchers.any())).thenReturn((Object)this.getDetailedComparisonDsResponse());
    }

    @TestTemplate
    @ExtendWith(value={PactVerificationInvocationContextProvider.class})
    void pactVerificationTestTemplate(PactVerificationContext context) {
        context.verifyInteraction();
    }

    @BeforeEach
    void before(PactVerificationContext context) throws Exception {
        this.beforeAll();
        context.setTarget((TestTarget)new MockMvcTestTarget(this.mockMvc));
    }

    @State(value={"all ok"})
    public void allPass() {
    }

    private DataSetList getDataSetList() {
        DataSetListImpl dataSetList = new DataSetListImpl();
        VisibilityAreaImpl visibilityArea = new VisibilityAreaImpl();
        visibilityArea.setId(UUID.fromString("c2737427-05e4-4c17-8032-455539deaa02"));
        dataSetList.setId(UUID.fromString("c2737427-05e4-4c17-8032-455539deaa01"));
        dataSetList.setName("name");
        dataSetList.setVisibilityArea((VisibilityArea)visibilityArea);
        dataSetList.setCreatedBy(UUID.fromString("f0c1d2ba-7c99-4e0b-a39d-0566f2ae9f25"));
        dataSetList.setCreatedWhen(new Timestamp(1L));
        dataSetList.setModifiedBy(UUID.randomUUID());
        ArrayList<LabelImpl> labelList = new ArrayList<LabelImpl>();
        labelList.add(new LabelImpl(UUID.randomUUID(), "name"));
        dataSetList.setLabels(labelList);
        dataSetList.setTestPlan((TestPlan)new TestPlanImpl(UUID.randomUUID(), "name", (VisibilityArea)visibilityArea));
        return dataSetList;
    }

    public List<DataSet> getListDataSet() {
        LinkedList<DataSet> list = new LinkedList<DataSet>();
        list.add(this.getDataSet());
        return list;
    }

    public DataSet getDataSet() {
        DataSetImpl dataSet = new DataSetImpl();
        dataSet.setName("dataSetName");
        dataSet.setMixInId((MixInId)new MixInIdImpl(UUID.fromString("c2737427-05e4-4c17-8032-455539deaa01")));
        dataSet.setId(UUID.fromString("c2737427-05e4-4c17-8032-455539deaa01"));
        return dataSet;
    }

    public List<CopyDataSetListsResponse> getCopyDataSetListsResponseDto() {
        CopyDataSetListsResponse copy = new CopyDataSetListsResponse();
        copy.setCopyId(UUID.fromString("fb551031-4bd0-4a10-aa0a-98f43e208fcf"));
        copy.setOriginalId(UUID.fromString("30c0ba97-7576-40fe-b62a-c85ddce50baf"));
        ArrayList<CopyDataSetListsResponse> list = new ArrayList<CopyDataSetListsResponse>();
        list.add(copy);
        return list;
    }

    public List<DataSetListDependencyNode> getListDataSetListDependencyNode() {
        ArrayList<DataSetListDependencyNode> list = new ArrayList<DataSetListDependencyNode>();
        DataSetListDependencyNode dataSetListDependencyNode = new DataSetListDependencyNode();
        dataSetListDependencyNode.setName("asd");
        dataSetListDependencyNode.setId(UUID.randomUUID());
        dataSetListDependencyNode.setDependencies(new LinkedList());
        list.add(dataSetListDependencyNode);
        return list;
    }

    public DetailedComparisonDsResponse getDetailedComparisonDsResponse() {
        ComparedAttribute comparedAttribute1 = this.generateComparedAttribute();
        return new DetailedComparisonDsResponse(UUID.randomUUID(), "leftDatasetName", "leftDslName", UUID.randomUUID(), "rightDatasetName", "rightDslName", 1, Collections.singletonList(comparedAttribute1));
    }

    public ComparedAttribute generateComparedAttribute() {
        ComparedAttribute comparedAttr = new ComparedAttribute();
        comparedAttr.setRightAttributeType(AttributeTypeName.FILE);
        comparedAttr.setStatus(DetailedComparisonStatus.NOT_EQUAL);
        comparedAttr.setAttributeName("string");
        return comparedAttr;
    }

    @Configuration
    public static class TestApp {
    }
}

