/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.controllers.api;

import au.com.dius.pact.provider.junit5.PactVerificationContext;
import au.com.dius.pact.provider.junit5.PactVerificationInvocationContextProvider;
import au.com.dius.pact.provider.junit5.TestTarget;
import au.com.dius.pact.provider.junitsupport.Provider;
import au.com.dius.pact.provider.junitsupport.State;
import au.com.dius.pact.provider.junitsupport.loader.PactUrl;
import au.com.dius.pact.provider.spring.junit5.MockMvcTestTarget;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.parallel.Isolated;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.qubership.atp.dataset.db.jpa.entities.AttributeEntity;
import org.qubership.atp.dataset.db.jpa.entities.DataSetListEntity;
import org.qubership.atp.dataset.db.jpa.entities.VisibilityAreaEntity;
import org.qubership.atp.dataset.model.DataSet;
import org.qubership.atp.dataset.model.DataSetList;
import org.qubership.atp.dataset.model.MixInId;
import org.qubership.atp.dataset.model.TestPlan;
import org.qubership.atp.dataset.model.impl.DataSetImpl;
import org.qubership.atp.dataset.model.impl.DataSetListImpl;
import org.qubership.atp.dataset.model.impl.MixInIdImpl;
import org.qubership.atp.dataset.model.impl.TestPlanImpl;
import org.qubership.atp.dataset.service.jpa.ContextType;
import org.qubership.atp.dataset.service.jpa.DataSetServiceException;
import org.qubership.atp.dataset.service.jpa.delegates.Attribute;
import org.qubership.atp.dataset.service.jpa.impl.DataSetParameterProvider;
import org.qubership.atp.dataset.service.jpa.impl.macro.MacroContext;
import org.qubership.atp.dataset.service.jpa.model.AttributeTypeName;
import org.qubership.atp.dataset.service.jpa.model.VisibilityAreaFlatModel;
import org.qubership.atp.dataset.service.jpa.model.dscontext.DataSetContext;
import org.qubership.atp.dataset.service.jpa.model.dscontext.DataSetListContext;
import org.qubership.atp.dataset.service.jpa.model.dscontext.ParameterContext;
import org.qubership.atp.dataset.service.jpa.model.tree.OverlapNode;
import org.qubership.atp.dataset.service.jpa.model.tree.ds.DataSetTree;
import org.qubership.atp.dataset.service.rest.QueryParamFlag;
import org.qubership.atp.dataset.service.rest.server.AttachmentController;
import org.qubership.atp.dataset.service.rest.server.AttributeController;
import org.qubership.atp.dataset.service.rest.server.DataSetController;
import org.qubership.atp.dataset.service.rest.server.DataSetListController;
import org.qubership.atp.dataset.service.rest.server.VisibilityAreaController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.autoconfigure.http.HttpMessageConvertersAutoConfiguration;
import org.springframework.boot.autoconfigure.jackson.JacksonAutoConfiguration;
import org.springframework.boot.test.autoconfigure.web.servlet.AutoConfigureMockMvc;
import org.springframework.boot.test.autoconfigure.web.servlet.WebMvcTest;
import org.springframework.boot.test.mock.mockito.MockBean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.io.InputStreamResource;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

@Isolated
@Provider(value="atp-datasets")
@PactUrl(urls={"src/test/resources/pacts/atp-itf-executor-atp-datasets.json"})
@AutoConfigureMockMvc(addFilters=false, webDriverEnabled=false)
@WebMvcTest(controllers={AttachmentController.class, DataSetController.class, DataSetListController.class, AttributeController.class, VisibilityAreaController.class})
@ContextConfiguration(classes={TestApp.class})
@EnableAutoConfiguration
@Import(value={JacksonAutoConfiguration.class, HttpMessageConvertersAutoConfiguration.class, AttachmentController.class, DataSetController.class, DataSetListController.class, AttributeController.class, VisibilityAreaController.class})
public class DatasetsAndItfExecutorContractTest {
    @Autowired
    private MockMvc mockMvc;
    @MockBean
    private AttachmentController attachmentController;
    @MockBean
    private DataSetController dataSetController;
    @MockBean
    private DataSetListController dataSetListController;
    @MockBean
    private AttributeController attributeController;
    @MockBean
    private VisibilityAreaController visibilityAreaController;

    public void beforeAll() throws DataSetServiceException, IOException {
        InputStreamResource responseBody1 = new InputStreamResource((InputStream)new ByteArrayInputStream("test".getBytes()));
        LinkedMultiValueMap headers = new LinkedMultiValueMap();
        headers.add((Object)"Content-Disposition", (Object)"attachment; filename=\"name\"");
        Mockito.when((Object)this.attachmentController.getAttachmentByParameterId((UUID)ArgumentMatchers.any())).thenReturn((Object)new ResponseEntity((Object)responseBody1, (MultiValueMap)headers, HttpStatus.OK));
        String responseBody2 = "{\"key\":\"context\"}";
        Mockito.when((Object)this.dataSetController.getItfContext((UUID)ArgumentMatchers.any())).thenReturn((Object)responseBody2);
        Mockito.when((Object)this.dataSetController.getAtpContextFull((UUID)ArgumentMatchers.any(UUID.class), (QueryParamFlag)ArgumentMatchers.any(), (String)ArgumentMatchers.any())).thenReturn((Object)this.getResponseBody3_4_5_6(ContextType.FULL));
        Mockito.when((Object)this.dataSetController.getAtpContextObject((UUID)ArgumentMatchers.any(UUID.class), (QueryParamFlag)ArgumentMatchers.any(), (String)ArgumentMatchers.any())).thenReturn((Object)this.getResponseBody3_4_5_6(ContextType.OBJECT));
        Mockito.when((Object)this.dataSetController.getAtpContextObjectExtended((UUID)ArgumentMatchers.any(UUID.class), (QueryParamFlag)ArgumentMatchers.any(), (String)ArgumentMatchers.any())).thenReturn((Object)this.getResponseBody3_4_5_6(ContextType.OBJECT_EXTENDED));
        Mockito.when((Object)this.dataSetController.getAtpContextOptimized((UUID)ArgumentMatchers.any(UUID.class), (QueryParamFlag)ArgumentMatchers.any(), (String)ArgumentMatchers.any())).thenReturn((Object)this.getResponseBody3_4_5_6(ContextType.NO_NULL_VALUES));
        Mockito.when((Object)this.visibilityAreaController.getVisibilityAreas()).thenReturn(this.getResponseBody7());
        Mockito.when((Object)this.dataSetListController.getDataSetLists((UUID)ArgumentMatchers.any(UUID.class), (String)ArgumentMatchers.any())).thenReturn(this.getResponseBody8());
        Mockito.when((Object)this.dataSetListController.getDataSets((UUID)ArgumentMatchers.any(UUID.class), (QueryParamFlag)ArgumentMatchers.any(), (String)ArgumentMatchers.any())).thenReturn(this.getResponseBody9());
        Mockito.when((Object)this.attributeController.getAttributesInItfFormat((UUID)ArgumentMatchers.any(UUID.class))).thenReturn(this.getResponseBody10());
    }

    @TestTemplate
    @ExtendWith(value={PactVerificationInvocationContextProvider.class})
    void pactVerificationTestTemplate(PactVerificationContext context) {
        context.verifyInteraction();
    }

    @BeforeEach
    void before(PactVerificationContext context) throws Exception {
        this.beforeAll();
        context.setTarget((TestTarget)new MockMvcTestTarget(this.mockMvc));
    }

    @State(value={"all ok"})
    public void allPass() {
    }

    private DataSetTree getResponseBody3_4_5_6(ContextType contextType) {
        DataSetContext dataSetContext = this.getDataSetContext();
        DataSetParameterProvider dataSetParameterProvider = new DataSetParameterProvider();
        MacroContext macroContext = new MacroContext();
        DataSetListContext dataSetListContext = new DataSetListContext(UUID.randomUUID());
        macroContext.setDataSetListContext(dataSetListContext);
        DataSetTree dataSetTree = new DataSetTree(dataSetContext, 0, true, macroContext, dataSetListContext, dataSetParameterProvider, contextType);
        return dataSetTree;
    }

    private DataSetContext getDataSetContext() {
        OverlapNode overlapNode = new OverlapNode(UUID.randomUUID(), UUID.randomUUID(), 0);
        DataSetContext dataSetContext = new DataSetContext(0, new ArrayList(), overlapNode, new ArrayList(), new ArrayList());
        AttributeEntity attributeEntity2 = new AttributeEntity();
        attributeEntity2.setAttributeTypeId(Long.valueOf(2L));
        attributeEntity2.setId(UUID.fromString("c2737427-05e4-4c17-8032-455539deaa02"));
        Attribute attribute2 = new Attribute(attributeEntity2);
        attribute2.setAttributeType(AttributeTypeName.TEXT);
        attribute2.setOrdering(Integer.valueOf(1));
        attribute2.setName("1ATTRIBUTE");
        ParameterContext parameterContext2 = new ParameterContext(attribute2);
        dataSetContext.setParameters(Arrays.asList(parameterContext2));
        return dataSetContext;
    }

    private VisibilityAreaFlatModel getVisibilityAreaFlatModel() {
        VisibilityAreaEntity visibilityAreaEntity = new VisibilityAreaEntity();
        visibilityAreaEntity.setId(UUID.fromString("c2737427-05e4-4c17-8032-455539deaa02"));
        LinkedList<DataSetListEntity> dataSetListEntityList = new LinkedList<DataSetListEntity>();
        DataSetListEntity dataSetListEntity = new DataSetListEntity();
        dataSetListEntity.setId(UUID.fromString("c2737427-05e4-4c17-8032-455539deaa03"));
        dataSetListEntityList.add(dataSetListEntity);
        visibilityAreaEntity.setDataSetLists(dataSetListEntityList);
        VisibilityAreaFlatModel visibilityAreaFlatModel = new VisibilityAreaFlatModel();
        visibilityAreaFlatModel.setId(UUID.fromString("c2737427-05e4-4c17-8032-455539deaa02"));
        visibilityAreaFlatModel.setName("visibilityArea");
        ArrayList<UUID> uuids = new ArrayList<UUID>();
        uuids.add(UUID.fromString("c2737427-05e4-4c17-8032-455539deaa03"));
        visibilityAreaFlatModel.setDataSetLists(uuids);
        return visibilityAreaFlatModel;
    }

    private List<VisibilityAreaFlatModel> getResponseBody7() {
        return Arrays.asList(this.getVisibilityAreaFlatModel());
    }

    private DataSetList getDataSetList() {
        DataSetListImpl dataSetList = new DataSetListImpl();
        dataSetList.setCreatedBy(UUID.fromString("f0c1d2ba-7c99-4e0b-a39d-0566f2ae9f25"));
        dataSetList.setModifiedBy(UUID.fromString("f0c1d2ba-7c99-4e0b-a39d-0566f2ae9f26"));
        TestPlanImpl testPlanCreatedModifiedViewDto = new TestPlanImpl(UUID.fromString("c2737427-05e4-4c17-8032-455539deaa02"), null, null);
        dataSetList.setTestPlan((TestPlan)testPlanCreatedModifiedViewDto);
        return dataSetList;
    }

    private List<DataSetList> getResponseBody8() {
        return Arrays.asList(this.getDataSetList());
    }

    private DataSet getDataSet() {
        DataSetImpl dataSet = new DataSetImpl();
        dataSet.setName("dataSetName");
        dataSet.setMixInId((MixInId)new MixInIdImpl(UUID.fromString("c2737427-05e4-4c17-8032-455539deaa01")));
        dataSet.setId(UUID.fromString("c2737427-05e4-4c17-8032-455539deaa01"));
        return dataSet;
    }

    private List<DataSet> getResponseBody9() {
        return Arrays.asList(this.getDataSet());
    }

    private List<String> getResponseBody10() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("1ATTRIBUTE");
        list.add("2ATTRIBUTE");
        return list;
    }

    @Configuration
    public static class TestApp {
    }
}

