/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.controllers.api;

import au.com.dius.pact.provider.junit5.PactVerificationContext;
import au.com.dius.pact.provider.junit5.PactVerificationInvocationContextProvider;
import au.com.dius.pact.provider.junit5.TestTarget;
import au.com.dius.pact.provider.junitsupport.State;
import au.com.dius.pact.provider.junitsupport.loader.PactUrl;
import au.com.dius.pact.provider.spring.junit5.MockMvcTestTarget;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.parallel.Isolated;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.qubership.atp.auth.springbootstarter.entities.UserInfo;
import org.qubership.atp.auth.springbootstarter.ssl.Provider;
import org.qubership.atp.dataset.model.DataSet;
import org.qubership.atp.dataset.model.MixInId;
import org.qubership.atp.dataset.model.impl.DataSetImpl;
import org.qubership.atp.dataset.model.impl.MixInIdImpl;
import org.qubership.atp.dataset.model.utils.DatasetResponse;
import org.qubership.atp.dataset.service.direct.AttributeService;
import org.qubership.atp.dataset.service.direct.ConcurrentModificationService;
import org.qubership.atp.dataset.service.direct.DataSetListService;
import org.qubership.atp.dataset.service.direct.DataSetService;
import org.qubership.atp.dataset.service.direct.impl.CompareDatasetServiceImpl;
import org.qubership.atp.dataset.service.direct.importexport.service.DatasetListExportService;
import org.qubership.atp.dataset.service.direct.importexport.service.DatasetListImportService;
import org.qubership.atp.dataset.service.jpa.JpaDataSetListService;
import org.qubership.atp.dataset.service.jpa.JpaDataSetService;
import org.qubership.atp.dataset.service.jpa.impl.DataSetListCheckService;
import org.qubership.atp.dataset.service.rest.server.DataSetController;
import org.qubership.atp.dataset.service.rest.server.DataSetListController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.autoconfigure.http.HttpMessageConvertersAutoConfiguration;
import org.springframework.boot.autoconfigure.jackson.JacksonAutoConfiguration;
import org.springframework.boot.test.autoconfigure.web.servlet.AutoConfigureMockMvc;
import org.springframework.boot.test.autoconfigure.web.servlet.WebMvcTest;
import org.springframework.boot.test.mock.mockito.MockBean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.web.servlet.MockMvc;

@Isolated
@au.com.dius.pact.provider.junitsupport.Provider(value="atp-datasets")
@PactUrl(urls={"src/test/resources/pacts/atp-ram-atp-datasets.json"})
@AutoConfigureMockMvc(addFilters=false, webDriverEnabled=false)
@WebMvcTest(controllers={DataSetController.class, DataSetListController.class})
@ContextConfiguration(classes={TestApp.class})
@EnableAutoConfiguration
@Import(value={JacksonAutoConfiguration.class, HttpMessageConvertersAutoConfiguration.class, DataSetListController.class, DataSetController.class})
public class DatasetsAndRamContractTest {
    private static final Logger log = LoggerFactory.getLogger(DatasetsAndRamContractTest.class);
    @Autowired
    private MockMvc mockMvc;
    @MockBean
    private DataSetService dsService;
    @MockBean
    private ConcurrentModificationService concurrentModificationService;
    @MockBean
    private JpaDataSetService dataSetService;
    @MockBean
    private DataSetListService dslService;
    @MockBean
    private DataSetListCheckService dataSetListCheckService;
    @MockBean
    private JpaDataSetListService jpaDataSetListService;
    @MockBean
    private AttributeService attributeService;
    @MockBean
    private Provider<UserInfo> userInfoProvider;
    @MockBean
    private DatasetListExportService datasetListExportService;
    @MockBean
    private DatasetListImportService importService;
    @MockBean
    CompareDatasetServiceImpl compareDs;

    public void beforeAll() {
        ArrayList<DatasetResponse> resultList = new ArrayList<DatasetResponse>();
        DatasetResponse datasetResponse = new DatasetResponse(UUID.randomUUID(), "dsName", UUID.randomUUID(), "dslName");
        resultList.add(datasetResponse);
        DataSetImpl dataSet = new DataSetImpl();
        dataSet.setName("dataSetName");
        dataSet.setMixInId((MixInId)new MixInIdImpl(UUID.randomUUID()));
        dataSet.setId(UUID.randomUUID());
        Mockito.when((Object)((DataSet)this.dsService.get((UUID)ArgumentMatchers.any(UUID.class)))).thenReturn((Object)dataSet);
        Mockito.when((Object)this.dslService.getListOfDsIdsAndNameAndDslId((List)ArgumentMatchers.any())).thenReturn(resultList);
    }

    @TestTemplate
    @ExtendWith(value={PactVerificationInvocationContextProvider.class})
    void pactVerificationTestTemplate(PactVerificationContext context) {
        context.verifyInteraction();
    }

    @BeforeEach
    void before(PactVerificationContext context) throws Exception {
        this.beforeAll();
        context.setTarget((TestTarget)new MockMvcTestTarget(this.mockMvc));
    }

    @State(value={"all ok"})
    public void allPass() {
    }

    @Configuration
    public static class TestApp {
    }
}

