/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.db;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.parallel.Isolated;
import org.qubership.atp.dataset.config.TestConfiguration;
import org.qubership.atp.dataset.db.DataSetListTreeRepository;
import org.qubership.atp.dataset.db.IdentifiedCache;
import org.qubership.atp.dataset.db.utils.StrongIdentifiedCache;
import org.qubership.atp.dataset.model.Attribute;
import org.qubership.atp.dataset.model.DataSet;
import org.qubership.atp.dataset.model.DataSetList;
import org.qubership.atp.dataset.model.Identified;
import org.qubership.atp.dataset.model.Parameter;
import org.qubership.atp.dataset.model.VisibilityArea;
import org.qubership.atp.dataset.service.AbstractTest;
import org.qubership.atp.dataset.service.direct.helper.CreationFacade;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.TestPropertySource;
import org.springframework.test.context.junit.jupiter.SpringExtension;

@Isolated
@ExtendWith(value={SpringExtension.class})
@ContextConfiguration(classes={TestConfiguration.class})
@TestPropertySource(properties={"atp-dataset.javers.enabled=false"})
public class DataSetListTreeRepositoryTest
extends AbstractTest {
    @Autowired
    DataSetListTreeRepository repo;

    @Test
    public void loadDslTree_WithDsRefOverlap_EachGroupIsLazyLoaded() throws Exception {
        TestData d = this.createTestDataInstance(TestData::new);
        StrongIdentifiedCache cache = new StrongIdentifiedCache();
        DataSetListTreeRepository.ToLoadLater loadLater = new DataSetListTreeRepository.ToLoadLater(this.repo, (IdentifiedCache)cache);
        DataSetList dsl = this.repo.getDslTree(d.dslTop.getId(), (Collection)ImmutableList.of((Object)d.dsTop.getId()), loadLater);
        Assertions.assertEquals((Object)d.dslTop, (Object)dsl);
        Attribute topIntoMiddle = (Attribute)cache.getIfPresent(Attribute.class, d.topIntoMiddle.getAttribute().getId());
        DataSetList dslMiddle = topIntoMiddle.getDataSetListReference();
        Assertions.assertEquals((Object)d.erTop, (Object)cache);
        dslMiddle.getName();
        Assertions.assertEquals((Object)d.dslMiddle, (Object)dslMiddle);
        Parameter middleIntoLowOverlap = (Parameter)cache.getIfPresent(Parameter.class, d.middleIntoLowOverlap.getId());
        DataSet dsLowOverlap = middleIntoLowOverlap.getDataSetReference();
        Assertions.assertEquals((Object)d.erMiddle, (Object)cache);
        dsLowOverlap.getName();
        Assertions.assertEquals((Object)d.dsLowOverlap, (Object)dsLowOverlap);
        Assertions.assertEquals((Object)d.erLow, (Object)cache);
    }

    private static class TestData
    implements Supplier<VisibilityArea> {
        final VisibilityArea va;
        final DataSetList dslTop;
        final DataSet dsTop;
        final Parameter topIntoMiddle;
        final DataSetList dslMiddle;
        final DataSet dsMiddle;
        final Parameter middleIntoLow;
        final Parameter middleIntoLowOverlap;
        final DataSetList dslLow;
        final DataSet dsLowDefault;
        final DataSet dsLowOverlap;
        final IdentifiedCache erTop;
        final IdentifiedCache erMiddle;
        final IdentifiedCache erLow;

        public TestData(CreationFacade create) {
            this.va = create.va("ATPII-1877");
            this.dslTop = create.dsl(this.va, "Top");
            this.dsTop = create.ds(this.dslTop, "Default");
            this.dslMiddle = create.dsl(this.va, "Middle");
            this.dsMiddle = create.ds(this.dslMiddle, "Default");
            this.dslLow = create.dsl(this.va, "Low");
            this.dsLowDefault = create.ds(this.dslLow, "Default");
            this.dsLowOverlap = create.ds(this.dslLow, "Overlap");
            Attribute someAttr = create.textAttr(this.dslLow, "SomeAttr");
            Parameter someParam1 = create.textParam(this.dsLowDefault, someAttr, "Some value");
            Parameter someParam2 = create.textParam(this.dsLowOverlap, someAttr, "Some value");
            this.middleIntoLow = create.refParam(this.dsMiddle, this.dsLowDefault);
            this.topIntoMiddle = create.refParam(this.dsTop, this.dsMiddle);
            this.middleIntoLowOverlap = create.overrideParam(this.dsTop, this.middleIntoLow.getAttribute(), null, null, this.dsLowOverlap, null, new Attribute[]{this.topIntoMiddle.getAttribute()});
            this.erTop = TestData.createErCache(Lists.newArrayList((Object[])new DataSetList[]{this.dslTop}), Lists.newArrayList((Object[])new DataSet[]{this.dsTop}), Lists.newArrayList((Object[])new Attribute[]{this.topIntoMiddle.getAttribute()}), Lists.newArrayList((Object[])new Parameter[]{this.topIntoMiddle, this.middleIntoLowOverlap}));
            this.erMiddle = TestData.createErCache(Lists.newArrayList((Object[])new DataSetList[]{this.dslTop, this.dslMiddle}), Lists.newArrayList((Object[])new DataSet[]{this.dsTop, this.dsMiddle}), Lists.newArrayList((Object[])new Attribute[]{this.topIntoMiddle.getAttribute(), this.middleIntoLow.getAttribute()}), Lists.newArrayList((Object[])new Parameter[]{this.topIntoMiddle, this.middleIntoLowOverlap, this.middleIntoLow}));
            this.erLow = TestData.createErCache(Lists.newArrayList((Object[])new DataSetList[]{this.dslTop, this.dslMiddle, this.dslLow}), Lists.newArrayList((Object[])new DataSet[]{this.dsTop, this.dsMiddle, this.dsLowDefault, this.dsLowOverlap}), Lists.newArrayList((Object[])new Attribute[]{this.topIntoMiddle.getAttribute(), this.middleIntoLow.getAttribute(), someAttr}), Lists.newArrayList((Object[])new Parameter[]{this.topIntoMiddle, this.middleIntoLowOverlap, this.middleIntoLow, someParam1, someParam2}));
        }

        private static IdentifiedCache createErCache(@Nonnull Collection<DataSetList> dsls, @Nullable Collection<DataSet> dses, @Nullable Collection<Attribute> attrs, @Nullable Collection<Parameter> params) {
            return TestData.createErCache(dsls.stream().collect(Collectors.toMap(Identified::getId, v -> v)), TestData.index(dses), TestData.index(attrs), TestData.index(params));
        }

        private static IdentifiedCache createErCache(@Nonnull Map<UUID, DataSetList> dsls, @Nullable Map<UUID, DataSet> dses, @Nullable Map<UUID, Attribute> attrs, @Nullable Map<UUID, Parameter> params) {
            HashMap<Class, Map<UUID, Object>> caches = new HashMap<Class, Map<UUID, Object>>();
            caches.put(DataSetList.class, dsls);
            if (dses != null) {
                caches.put(DataSet.class, dses);
            }
            if (attrs != null) {
                caches.put(Attribute.class, attrs);
            }
            if (params != null) {
                caches.put(Parameter.class, params);
            }
            return new StrongIdentifiedCache(caches);
        }

        @Nullable
        private static <T extends Identified> Map<UUID, T> index(@Nullable Collection<T> i) {
            return Optional.ofNullable(i).map(d -> d.stream().collect(Collectors.toMap(Identified::getId, v -> v))).orElse(null);
        }

        @Override
        public VisibilityArea get() {
            return this.va;
        }
    }
}

