/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.ei;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Sets;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.io.TempDir;
import org.junit.jupiter.api.parallel.Isolated;
import org.mockito.ArgumentMatchers;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.verification.VerificationMode;
import org.qubership.atp.dataset.db.GridFsRepository;
import org.qubership.atp.dataset.db.jpa.entities.AbstractAttributeEntity;
import org.qubership.atp.dataset.db.jpa.entities.AttributeEntity;
import org.qubership.atp.dataset.db.jpa.entities.DataSetEntity;
import org.qubership.atp.dataset.db.jpa.entities.DataSetListEntity;
import org.qubership.atp.dataset.db.jpa.entities.ParameterEntity;
import org.qubership.atp.dataset.db.jpa.entities.VisibilityAreaEntity;
import org.qubership.atp.dataset.db.jpa.repositories.JpaDataSetListRepository;
import org.qubership.atp.dataset.db.jpa.repositories.JpaDataSetRepository;
import org.qubership.atp.dataset.ei.DataSetExportExecutor;
import org.qubership.atp.dataset.ei.model.DataSet;
import org.qubership.atp.dataset.model.impl.file.FileData;
import org.qubership.atp.dataset.service.jpa.DataSetServiceException;
import org.qubership.atp.dataset.service.jpa.JpaDataSetListService;
import org.qubership.atp.dataset.service.jpa.impl.DataSetListContextService;
import org.qubership.atp.dataset.service.jpa.impl.JpaDataSetServiceImpl;
import org.qubership.atp.dataset.service.jpa.model.MacroContextService;
import org.qubership.atp.ei.node.dto.ExportFormat;
import org.qubership.atp.ei.node.dto.ExportImportData;
import org.qubership.atp.ei.node.dto.ExportScope;
import org.qubership.atp.ei.node.services.FileService;
import org.qubership.atp.ei.node.services.ObjectSaverToDiskService;
import org.springframework.test.context.junit.jupiter.SpringExtension;
import org.springframework.test.util.ReflectionTestUtils;

@Isolated
@ExtendWith(value={SpringExtension.class})
public class DataSetExportExecutorTest {
    @Spy
    private ObjectSaverToDiskService objectSaverToDiskService = new ObjectSaverToDiskService(new FileService(), true);
    @Mock
    private JpaDataSetListRepository jpaDataSetListRepository;
    @Mock
    private JpaDataSetRepository jpaDataSetRepository;
    @Mock
    private GridFsRepository gridFsRepository;
    @Mock
    private MacroContextService macroContextService;
    @Mock
    private DataSetListContextService dataSetListContextService;
    @Spy
    private ObjectMapper objectMapper;
    @InjectMocks
    DataSetExportExecutor dataSetExportExecutor;
    @Mock
    private JpaDataSetListService dslService;
    @Mock
    private JpaDataSetServiceImpl dsService;
    @TempDir
    private Path tempDir;
    private String erDatasetFile = "{\n  \"id\" : \"8147cd6a-b742-4f63-be42-59c7c1ab5f2f\",\n  \"name\" : \"ds1\",\n  \"ordering\" : null,\n  \"dataSetList\" : \"70030fdd-816a-4455-b117-b2e718f0396c\",\n  \"sourceId\" : null,\n  \"isLocked\" : false\n}\n";
    private String serviceName = "dataset-export";
    private String dataSetListName = "dsl";
    private static final String PROJECT_BODY_DATA_SET_IN_NTT_EXPORT = "dsName=ds1\n\nname=attribute 2; description=; value=./files/dsl/ds1/filename.txt\nname=attribute 1; description=; value=123\n";
    private String dsName;
    private UUID dsId = UUID.fromString("8147cd6a-b742-4f63-be42-59c7c1ab5f2f");
    private UUID dslId = UUID.fromString("70030fdd-816a-4455-b117-b2e718f0396c");
    private UUID paramId;
    private ExportScope atpExportScope;
    private DataSetEntity dataSet = new DataSetEntity();
    private DataSetListEntity dataSetList = new DataSetListEntity();

    @BeforeEach
    public void setUp() {
        VisibilityAreaEntity visibilityArea = new VisibilityAreaEntity();
        visibilityArea.setId(UUID.fromString("0cce99d6-ef89-4163-8518-9e1dbf173a6d"));
        visibilityArea.setName("va");
        this.dataSetList.setName(this.dataSetListName);
        this.dataSetList.setId(this.dslId);
        this.dataSetList.setVisibilityArea(visibilityArea);
        this.dataSetList.setAttributes(new ArrayList());
        AttributeEntity attr1 = new AttributeEntity();
        attr1.setId(UUID.fromString("226c77ce-4d9d-44d5-a9c3-4063e440f0fc"));
        attr1.setName("attribute 1");
        attr1.setAttributeTypeId(Long.valueOf("1"));
        attr1.setDataSetList(this.dataSetList);
        AttributeEntity attr2 = new AttributeEntity();
        attr2.setId(UUID.fromString("d194b108-e208-4f94-b3ef-5cae740dbccf"));
        attr2.setName("attribute 2");
        attr2.setAttributeTypeId(Long.valueOf("2"));
        attr2.setDataSetList(this.dataSetList);
        this.dataSetList.getAttributes().add(attr1);
        this.dataSetList.getAttributes().add(attr2);
        this.dataSet.setId(this.dsId);
        this.dsName = "ds1";
        this.dataSet.setName(this.dsName);
        this.dataSet.setDataSetList(this.dataSetList);
        this.dataSet.setParameters(new ArrayList());
        ParameterEntity textParam = new ParameterEntity();
        textParam.setId(UUID.fromString("8281ec64-8f3b-4eae-bec7-1b41671464a1"));
        textParam.setAttribute((AbstractAttributeEntity)attr1);
        textParam.setDataSet(this.dataSet);
        textParam.setStringValue("123");
        ParameterEntity fileParam = new ParameterEntity();
        this.paramId = UUID.fromString("5dd548e9-e63b-47c5-834e-ae754730e62d");
        fileParam.setId(this.paramId);
        fileParam.setDataSet(this.dataSet);
        fileParam.setAttribute((AbstractAttributeEntity)attr2);
        FileData fileData = new FileData();
        fileData.setParameterUuid(this.paramId);
        fileData.setFileName(this.paramId.toString());
        fileData.setFileType("txt");
        this.dataSet.getParameters().add(textParam);
        this.dataSet.getParameters().add(fileParam);
        InputStream stream = IOUtils.toInputStream((String)"string1\nstring2\nstring3", (Charset)StandardCharsets.UTF_8);
        Optional<InputStream> testFile = Optional.of(stream);
        HashMap<UUID, Optional<InputStream>> files = new HashMap<UUID, Optional<InputStream>>();
        files.put(fileParam.getId(), testFile);
        this.atpExportScope = new ExportScope();
        this.atpExportScope.getEntities().put("datasetStorage", Sets.newHashSet((Object[])new String[]{this.dataSetList.getId().toString()}));
        this.atpExportScope.getEntities().put("datasets", Sets.newHashSet((Object[])new String[]{this.dataSet.getId().toString()}));
        Optional<DataSetListEntity> dataSetListOptional = Optional.of(this.dataSetList);
        Mockito.when((Object)this.jpaDataSetListRepository.findById((UUID)ArgumentMatchers.any(UUID.class))).thenReturn(dataSetListOptional);
        Mockito.when((Object)this.jpaDataSetRepository.findById((UUID)ArgumentMatchers.any())).thenReturn(Optional.of(this.dataSet));
        Mockito.when((Object)this.gridFsRepository.getAll((List)ArgumentMatchers.any())).thenReturn(files);
        Mockito.when((Object)this.gridFsRepository.getFileInfo((UUID)ArgumentMatchers.any())).thenReturn(Optional.of(fileData));
        Mockito.when((Object)this.dsService.getDataSetsListIdByDataSetId((UUID)ArgumentMatchers.any(UUID.class))).thenReturn((Object)this.dslId);
        ReflectionTestUtils.setField((Object)this.dataSetExportExecutor, (String)"implementationName", (Object)this.serviceName);
        ReflectionTestUtils.setField((Object)this.dataSetExportExecutor, (String)"fileService", (Object)new FileService());
    }

    @Test
    public void exportToFolder_GetNeededDatasetAndPlacedItToFolderAsFile_NeededDataSetPlacedToFolderAndCorrectlyOpened() throws Exception {
        HashSet<UUID> datasetIds = new HashSet<UUID>();
        datasetIds.add(this.dsId);
        Path path = Files.createDirectories(this.tempDir.resolve("dsExport"), new FileAttribute[0]);
        UUID visibilityAreaId = UUID.fromString("0cce99d6-ef89-4163-8518-9e1dbf173a6d");
        ExportImportData exportData = new ExportImportData(visibilityAreaId, this.atpExportScope, ExportFormat.ATP);
        exportData.getExportScope().getEntities().put("datasets", datasetIds.stream().map(UUID::toString).collect(Collectors.toSet()));
        this.dataSetExportExecutor.exportToFolder(exportData, path);
        Path arDatasetFilePath = path.resolve(DataSet.class.getSimpleName()).resolve(this.dslId.toString()).resolve(this.dsId + ".json");
        StringBuilder dataFromFile = new StringBuilder();
        try (Stream<String> lines = Files.lines(arDatasetFilePath, Charset.defaultCharset());){
            lines.forEach(str -> dataFromFile.append((String)str).append("\n"));
        }
        Assertions.assertEquals((Object)this.erDatasetFile, (Object)dataFromFile.toString());
    }

    @Test
    public void getExportImplementationName() {
        Assertions.assertEquals((Object)this.serviceName, (Object)this.dataSetExportExecutor.getExportImplementationName());
    }

    @Test
    public void exportToFolder_convertToNttFormat() throws Exception {
        HashSet<UUID> datasetIds = new HashSet<UUID>();
        UUID dataSetId = UUID.fromString("8147cd6a-b742-4f63-be42-59c7c1ab5f2f");
        datasetIds.add(dataSetId);
        Path path = Files.createDirectories(this.tempDir.resolve("dsExport"), new FileAttribute[0]);
        UUID visibilityAreaId = UUID.fromString("0cce99d6-ef89-4163-8518-9e1dbf173a6d");
        ExportImportData exportData = new ExportImportData(visibilityAreaId, this.atpExportScope, ExportFormat.NTT);
        exportData.getExportScope().getEntities().put("datasets", datasetIds.stream().map(UUID::toString).collect(Collectors.toSet()));
        this.dataSetExportExecutor.exportToFolder(exportData, path);
        Path projectFile = path.resolve("AT_configuration").resolve(this.dataSetListName + ".cds");
        Assertions.assertTrue((boolean)Files.exists(projectFile, new LinkOption[0]));
        List<String> projectBodyLines = Files.readAllLines(projectFile);
        projectBodyLines.forEach(s -> {
            if (s.startsWith("dsName=")) {
                String _dsName = s.replace("dsName=", "");
                Assertions.assertEquals((Object)this.dsName, (Object)_dsName);
            } else if (s.startsWith("name=attribute 2;")) {
                String filePath = s.replace("name=attribute 2; description=; value=", "");
                String expectedFilePath = "./files/" + this.dslId.toString() + "/" + this.dsId.toString() + "/" + this.paramId.toString();
                Assertions.assertEquals((Object)Paths.get(filePath, new String[0]).toString(), (Object)Paths.get(expectedFilePath, new String[0]).toString());
            } else if (s.startsWith("name=attribute 1;")) {
                String value = s.replace("name=attribute 1; description=; value=", "");
                String expectedValue = "123";
                Assertions.assertEquals((Object)value, (Object)expectedValue);
            }
        });
        Path defaultProjectFile = path.resolve("AT_configuration").resolve("Default Project.cds");
        Assertions.assertTrue((boolean)Files.exists(defaultProjectFile, new LinkOption[0]));
        String defaultProjectBody = StringUtils.join(Files.readAllLines(defaultProjectFile), (String)"\n");
        Assertions.assertTrue((boolean)StringUtils.isEmpty((CharSequence)defaultProjectBody));
    }

    @Test
    public void expandExportScope_exportSpecificDsls_DslForDsIsCollected() throws DataSetServiceException {
        ExportImportData exportData = new ExportImportData(UUID.randomUUID(), this.atpExportScope, ExportFormat.ATP);
        exportData.getExportScope().getEntities().put("datasetStorage", new HashSet());
        HashSet<UUID> idsFromDb = new HashSet<UUID>();
        idsFromDb.add(this.dslId);
        Mockito.when((Object)this.jpaDataSetListRepository.getDslIdsByVa(exportData.getProjectId())).thenReturn(idsFromDb);
        this.dataSetExportExecutor.expandExportScope(exportData);
        Assertions.assertTrue((boolean)((Set)exportData.getExportScope().getEntities().getOrDefault("datasetStorage", new HashSet())).contains(this.dslId.toString()));
    }

    @Test
    public void expandExportScope_DsReferencedFromParamIsAndCorrespondingDslIsCollected() throws DataSetServiceException {
        ExportImportData exportData = new ExportImportData(null, this.atpExportScope, ExportFormat.ATP);
        exportData.getExportScope().getEntities().put("datasetStorage", new HashSet());
        UUID referencedDataSetListId = UUID.randomUUID();
        DataSetListEntity referencedDataSetList = new DataSetListEntity();
        referencedDataSetList.setName("dsl2");
        referencedDataSetList.setId(referencedDataSetListId);
        referencedDataSetList.setAttributes(new ArrayList());
        UUID referencedDataSetId = UUID.randomUUID();
        DataSetEntity referencedDataSet = new DataSetEntity();
        referencedDataSet.setId(referencedDataSetId);
        referencedDataSet.setName("ds2");
        referencedDataSet.setDataSetList(referencedDataSetList);
        referencedDataSet.setParameters(new ArrayList());
        UUID referencedDataSetId2 = UUID.randomUUID();
        DataSetEntity referencedDataSet2 = new DataSetEntity();
        referencedDataSet2.setId(referencedDataSetId2);
        referencedDataSet2.setName("ds3");
        referencedDataSet2.setDataSetList(referencedDataSetList);
        referencedDataSet2.setParameters(new ArrayList());
        HashSet<UUID> idsFromDb = new HashSet<UUID>();
        idsFromDb.add(this.dslId);
        Mockito.when((Object)this.jpaDataSetListRepository.getDslIdsByVa(exportData.getProjectId())).thenReturn(idsFromDb);
        Mockito.when((Object)this.jpaDataSetRepository.findById(referencedDataSetId)).thenReturn(Optional.of(referencedDataSet));
        Mockito.when((Object)this.jpaDataSetRepository.findById(referencedDataSetId2)).thenReturn(Optional.of(referencedDataSet2));
        ParameterEntity parameterEntity = (ParameterEntity)this.dataSet.getParameters().get(0);
        parameterEntity.setDataSetReferenceId(referencedDataSetId);
        ParameterEntity ds2Param = new ParameterEntity();
        ds2Param.setDataSet(referencedDataSet);
        ds2Param.setDataSetReferenceId(referencedDataSetId2);
        ds2Param.setAttribute((AbstractAttributeEntity)new AttributeEntity());
        ds2Param.getAttribute().setId(UUID.randomUUID());
        referencedDataSet.setParameters(Arrays.asList(ds2Param));
        this.dataSetExportExecutor.expandExportScope(exportData);
        Assertions.assertTrue((boolean)((Set)exportData.getExportScope().getEntities().getOrDefault("datasets", new HashSet())).contains(referencedDataSetId.toString()), (String)"Referenced from parameter DS should be collected");
        Assertions.assertTrue((boolean)((Set)exportData.getExportScope().getEntities().getOrDefault("datasets", new HashSet())).contains(referencedDataSetId2.toString()), (String)"Referenced from parameter DS should be collected");
        Assertions.assertTrue((boolean)((Set)exportData.getExportScope().getEntities().getOrDefault("datasetStorage", new HashSet())).contains(referencedDataSetListId.toString()), (String)"Referenced from parameter DS and corresponding DLS should be collected");
    }

    @Test
    public void expandExportScope_specificDsls_circlesShouldBeHandledProperly() throws DataSetServiceException {
        ExportImportData exportData = new ExportImportData(null, this.atpExportScope, ExportFormat.ATP);
        exportData.getExportScope().getEntities().put("datasetStorage", new HashSet());
        UUID referencedDataSetListId = UUID.randomUUID();
        DataSetListEntity referencedDataSetList = new DataSetListEntity();
        referencedDataSetList.setName("dsl2");
        referencedDataSetList.setId(referencedDataSetListId);
        referencedDataSetList.setAttributes(new ArrayList());
        UUID referencedDataSetId = UUID.randomUUID();
        DataSetEntity referencedDataSet = new DataSetEntity();
        referencedDataSet.setId(referencedDataSetId);
        referencedDataSet.setDataSetList(referencedDataSetList);
        referencedDataSet.setName("ds2");
        referencedDataSet.setParameters(new ArrayList());
        ParameterEntity parameterEntity = (ParameterEntity)this.dataSet.getParameters().get(0);
        parameterEntity.setDataSetReferenceId(referencedDataSetId);
        ParameterEntity ds2Param = new ParameterEntity();
        ds2Param.setDataSet(referencedDataSet);
        ds2Param.setDataSetReferenceId(this.dataSet.getId());
        ds2Param.setAttribute((AbstractAttributeEntity)new AttributeEntity());
        ds2Param.getAttribute().setId(UUID.randomUUID());
        referencedDataSet.setParameters(Arrays.asList(ds2Param));
        HashSet<UUID> idsFromDb = new HashSet<UUID>();
        idsFromDb.add(this.dslId);
        Mockito.when((Object)this.jpaDataSetListRepository.getDslIdsByVa(exportData.getProjectId())).thenReturn(idsFromDb);
        Mockito.when((Object)this.jpaDataSetRepository.findById(referencedDataSetId)).thenReturn(Optional.of(referencedDataSet));
        this.dataSetExportExecutor.expandExportScope(exportData);
        Assertions.assertTrue((boolean)((Set)exportData.getExportScope().getEntities().getOrDefault("datasets", new HashSet())).contains(this.dsId.toString()));
        Assertions.assertTrue((boolean)((Set)exportData.getExportScope().getEntities().getOrDefault("datasets", new HashSet())).contains(referencedDataSetId.toString()));
    }

    @Test
    public void expandExportScope_exportAllDsls_noDslExpansion() throws DataSetServiceException {
        ExportImportData exportData = new ExportImportData(UUID.randomUUID(), this.atpExportScope, ExportFormat.ATP);
        HashSet<UUID> dslIds = new HashSet<UUID>();
        dslIds.add(this.dslId);
        Mockito.when((Object)this.jpaDataSetListRepository.getDslIdsByVa(exportData.getProjectId())).thenReturn(dslIds);
        this.dataSetExportExecutor.expandExportScope(exportData);
        ((JpaDataSetListRepository)Mockito.verify((Object)this.jpaDataSetListRepository, (VerificationMode)Mockito.times((int)1))).getDslIdsByVa((UUID)Mockito.eq((Object)exportData.getProjectId()));
        Mockito.verifyNoInteractions((Object[])new Object[]{this.jpaDataSetRepository});
        Mockito.verifyNoInteractions((Object[])new Object[]{this.dataSetListContextService});
    }

    @Test
    public void expandExportScope_DslReferencedFromAttributesAreCollected() throws DataSetServiceException {
        ExportImportData exportData = new ExportImportData(null, this.atpExportScope, ExportFormat.ATP);
        UUID referencedDataSetListId = UUID.randomUUID();
        DataSetListEntity referencedDataSetList = new DataSetListEntity();
        referencedDataSetList.setName("dsl2");
        referencedDataSetList.setId(referencedDataSetListId);
        referencedDataSetList.setAttributes(new ArrayList());
        AttributeEntity attr = new AttributeEntity();
        UUID attrId = UUID.randomUUID();
        attr.setId(attrId);
        attr.setName("attribute 4");
        attr.setAttributeTypeId(Long.valueOf("4"));
        attr.setDataSetList(this.dataSetList);
        attr.setTypeDataSetListId(referencedDataSetListId);
        this.dataSetList.getAttributes().add(attr);
        this.dataSetExportExecutor.expandExportScope(exportData);
        Assertions.assertTrue((boolean)((Set)exportData.getExportScope().getEntities().getOrDefault("datasetStorage", new HashSet())).contains(referencedDataSetListId.toString()), (String)"Referenced from attribute DSL should be collected");
    }

    @Test
    public void expandExportScope_circlesAreHandledProperlyForAttributesDslReference() throws DataSetServiceException {
        ExportImportData exportData = new ExportImportData(null, this.atpExportScope, ExportFormat.ATP);
        UUID referencedDataSetListId = UUID.randomUUID();
        DataSetListEntity referencedDataSetList = new DataSetListEntity();
        referencedDataSetList.setName("dsl2");
        referencedDataSetList.setId(referencedDataSetListId);
        referencedDataSetList.setAttributes(new ArrayList());
        AttributeEntity attr = new AttributeEntity();
        UUID attrId = UUID.randomUUID();
        attr.setId(attrId);
        attr.setName("attribute 4");
        attr.setAttributeTypeId(Long.valueOf("4"));
        attr.setDataSetList(this.dataSetList);
        attr.setTypeDataSetListId(referencedDataSetListId);
        this.dataSetList.getAttributes().add(attr);
        AttributeEntity attr2 = new AttributeEntity();
        UUID attrId2 = UUID.randomUUID();
        attr2.setId(attrId2);
        attr2.setName("attribute 5");
        attr2.setAttributeTypeId(Long.valueOf("4"));
        attr2.setDataSetList(referencedDataSetList);
        attr2.setTypeDataSetListId(this.dataSetList.getId());
        referencedDataSetList.getAttributes().add(attr);
        this.dataSetExportExecutor.expandExportScope(exportData);
        Assertions.assertTrue((boolean)((Set)exportData.getExportScope().getEntities().getOrDefault("datasetStorage", new HashSet())).contains(referencedDataSetListId.toString()), (String)"Referenced from attribute DSL should be collected");
    }
}

