/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.ei;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.UUID;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.parallel.Isolated;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.qubership.atp.dataset.ei.DataSetImportExecutor;
import org.qubership.atp.dataset.ei.service.DataSetAttributesImporter;
import org.qubership.atp.dataset.ei.service.DataSetFileImporter;
import org.qubership.atp.dataset.ei.service.DataSetListImporter;
import org.qubership.atp.dataset.ei.service.DataSetParametersImporter;
import org.qubership.atp.dataset.ei.service.DataSetsImporter;
import org.qubership.atp.ei.node.dto.ExportImportData;
import org.qubership.atp.ei.node.dto.ValidationResult;
import org.qubership.atp.ei.node.dto.validation.ValidationType;
import org.springframework.test.context.junit.jupiter.SpringExtension;

@Isolated
@ExtendWith(value={SpringExtension.class})
public class DataSetImportExecutorTest {
    private DataSetImportExecutor dataSetImportExecutor;
    @Mock
    private DataSetListImporter dataSetListImporter;
    @Mock
    private DataSetsImporter dataSetsImporter;
    @Mock
    private DataSetAttributesImporter dataSetAttributesImporter;
    @Mock
    private DataSetParametersImporter dataSetParametersImporter;
    @Mock
    private DataSetFileImporter dataSetFileImporter;

    @BeforeEach
    public void setUp() throws Exception {
        this.dataSetImportExecutor = new DataSetImportExecutor(this.dataSetListImporter, this.dataSetsImporter, this.dataSetAttributesImporter, this.dataSetParametersImporter, this.dataSetFileImporter);
    }

    @Test
    public void validateData_1() throws Exception {
        ExportImportData importData = new ExportImportData(UUID.randomUUID(), null, null, false, false, null, new HashMap(), new HashMap(), ValidationType.VALIDATE, false);
        Path workDir = Paths.get("src/test/resources/ei/import/1d554fe3-4a15-4e1c-964a-1585e3206210", new String[0]);
        ValidationResult result = this.dataSetImportExecutor.validateData(importData, workDir);
        Assertions.assertTrue((boolean)result.isValid());
        Assertions.assertNotNull((Object)result.getDetails());
        Assertions.assertTrue((boolean)result.getDetails().isEmpty());
    }

    @Test
    public void validateData_2() throws Exception {
        UUID projectId = UUID.randomUUID();
        ExportImportData importData = new ExportImportData(projectId, null, null, false, false, null, new HashMap(), new HashMap(), ValidationType.VALIDATE, false);
        Path workDir = Paths.get("src/test/resources/ei/import/1d554fe3-4a15-4e1c-964a-1585e3206210", new String[0]);
        Mockito.when((Object)this.dataSetAttributesImporter.validateDataSetAttributes(workDir, Collections.emptyMap(), false)).thenReturn(Arrays.asList("There is a problem"));
        ValidationResult result = this.dataSetImportExecutor.validateData(importData, workDir);
        Assertions.assertFalse((boolean)result.isValid());
        Assertions.assertNotNull((Object)result.getDetails());
        Assertions.assertEquals((int)1, (int)result.getDetails().size());
    }

    @Test
    public void importData() throws Exception {
        ExportImportData importData = (ExportImportData)Mockito.mock(ExportImportData.class);
        Path workDir = Paths.get("src/test/resources/ei/import/1d554fe3-4a15-4e1c-964a-1585e3206210", new String[0]);
        ArrayList importedDsl = new ArrayList();
        Mockito.when((Object)this.dataSetListImporter.importDataSetLists(workDir, importData)).thenReturn(importedDsl);
        this.dataSetImportExecutor.importData(importData, workDir);
        ((DataSetListImporter)Mockito.verify((Object)this.dataSetListImporter, (VerificationMode)Mockito.times((int)1))).importDataSetLists(workDir, importData);
        ((DataSetsImporter)Mockito.verify((Object)this.dataSetsImporter, (VerificationMode)Mockito.times((int)1))).importDataSets(workDir, importData);
        ((DataSetAttributesImporter)Mockito.verify((Object)this.dataSetAttributesImporter, (VerificationMode)Mockito.times((int)1))).importDataSetAttributes(workDir, importedDsl, importData);
        ((DataSetAttributesImporter)Mockito.verify((Object)this.dataSetAttributesImporter, (VerificationMode)Mockito.times((int)1))).importDataSetAttributeKeys(workDir, importData);
        ((DataSetParametersImporter)Mockito.verify((Object)this.dataSetParametersImporter, (VerificationMode)Mockito.times((int)1))).importDataSetParameters(workDir, importData);
        ((DataSetFileImporter)Mockito.verify((Object)this.dataSetFileImporter, (VerificationMode)Mockito.times((int)1))).importFiles(workDir, importData);
    }
}

