/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.ei.service;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.UUID;
import javax.sql.DataSource;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.parallel.Isolated;
import org.qubership.atp.dataset.db.jpa.repositories.JpaAttributeKeyRepository;
import org.qubership.atp.dataset.ei.DataSetImportExecutor;
import org.qubership.atp.dataset.service.jpa.JpaAttributeService;
import org.qubership.atp.dataset.service.jpa.delegates.AttributeKey;
import org.qubership.atp.ei.node.dto.ExportImportData;
import org.qubership.atp.ei.node.dto.ValidationResult;
import org.qubership.atp.ei.node.dto.validation.ValidationType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.test.context.jdbc.Sql;
import org.springframework.test.context.junit.jupiter.SpringExtension;

@Isolated
@ExtendWith(value={SpringExtension.class})
@SpringBootTest
public class DataSetAttributesImporterIntegrationTest {
    @Autowired
    private JdbcTemplate jdbcTemplate;
    @Autowired
    protected JpaAttributeKeyRepository attributeKeyRepository;
    @Autowired
    protected JpaAttributeService attributeService;
    @Autowired
    private DataSetImportExecutor dataSetImportExecutor;
    private ExportImportData importData;
    @Autowired
    protected DataSource dataSource;

    @BeforeEach
    public void setUp() throws Exception {
        this.importData = new ExportImportData(null, null, null, false, false, null, new HashMap(), new HashMap(), ValidationType.VALIDATE, false);
    }

    @Test
    @Sql(scripts={"classpath:test_data/sql/overlap_lost_positive.sql"})
    public void importData_importOverlapIntoDbWithOverlapsWithTheSameParameters_OverlapsInDbShouldBeChangedWithoutDuplication() throws Exception {
        Path workDir = Paths.get("src/test/resources/ei/import/1d554fe3-4a15-4e1c-964a-1585e3206211", new String[0]);
        int attributeKeysNumber = this.attributeKeyRepository.findAll().size();
        this.dataSetImportExecutor.importData(this.importData, workDir);
        AttributeKey attributeKey = this.attributeService.getAttributeKeyById(UUID.fromString("f7d1609f-6f08-4742-b6d0-3a0c6ca1af6e"));
        Assertions.assertEquals((Object)"b37f7e80-1c04-4663-af6c-8f71f5f2dab9", (Object)attributeKey.getKey());
        Assertions.assertEquals((Object)UUID.fromString("f26f9fc4-7cea-44da-b02f-6392520801d9"), (Object)attributeKey.getDataSetList().getId());
        Assertions.assertEquals((Object)UUID.fromString("46cbd694-dbdd-4d1e-a967-e6edee97f318"), (Object)attributeKey.getDataSet().getId());
        Assertions.assertEquals((Object)UUID.fromString("d5d0b2d7-782c-4ae2-a273-c6377f874d82"), (Object)attributeKey.getAttribute().getId());
        Assertions.assertEquals((int)attributeKeysNumber, (int)this.attributeKeyRepository.findAll().size());
    }

    @Test
    @Sql(scripts={"classpath:test_data/sql/overlap_lost_negative.sql"})
    public void importData_importOverlapIntoDbWithOverlapsWithTheSameParameters_OverlapsInDbShouldBeDuplicated() throws Exception {
        Path workDir = Paths.get("src/test/resources/ei/import/1d554fe3-4a15-4e1c-964a-1585e3206211", new String[0]);
        int attributeKeysNumber = this.attributeKeyRepository.findAll().size();
        this.dataSetImportExecutor.importData(this.importData, workDir);
        AttributeKey ake1 = this.attributeService.getAttributeKeyById(UUID.fromString("f7d1609f-6f08-4742-b6d0-3a0c6ca1af6f"));
        AttributeKey ake2 = this.attributeService.getAttributeKeyById(UUID.fromString("f7d1609f-6f08-4742-b6d0-3a0c6ca1af6d"));
        Assertions.assertNotNull((Object)ake1);
        Assertions.assertEquals((Object)"b37f7e80-1c04-4663-af6c-8f71f5f2dab9", (Object)ake1.getKey());
        Assertions.assertEquals((Object)UUID.fromString("f26f9fc4-7cea-44da-b02f-6392520801d9"), (Object)ake1.getDataSetList().getId());
        Assertions.assertEquals((Object)UUID.fromString("46cbd694-dbdd-4d1e-a967-e6edee97f318"), (Object)ake1.getDataSet().getId());
        Assertions.assertEquals((Object)UUID.fromString("d5d0b2d7-782c-4ae2-a273-c6377f874d82"), (Object)ake1.getAttribute().getId());
        Assertions.assertNotNull((Object)ake2);
        Assertions.assertEquals((Object)"b37f7e80-1c04-4663-af6c-8f71f5f2dab9", (Object)ake2.getKey());
        Assertions.assertEquals((Object)UUID.fromString("f26f9fc4-7cea-44da-b02f-6392520801d9"), (Object)ake2.getDataSetList().getId());
        Assertions.assertEquals((Object)UUID.fromString("46cbd694-dbdd-4d1e-a967-e6edee97f318"), (Object)ake2.getDataSet().getId());
        Assertions.assertEquals((Object)UUID.fromString("d5d0b2d7-782c-4ae2-a273-c6377f874d81"), (Object)ake2.getAttribute().getId());
        Assertions.assertEquals((int)(attributeKeysNumber + 1), (int)this.attributeKeyRepository.findAll().size());
    }

    @Test
    public void handleCreateNewProjectValidation_validateData_returnReplacementMap() throws Exception {
        ExportImportData importData = new ExportImportData(UUID.randomUUID(), null, null, true, false, null, new HashMap(), new HashMap(), ValidationType.VALIDATE, false);
        Path workDir = Paths.get("src/test/resources/ei/import/1d554fe3-4a15-4e1c-964a-1585e3206211", new String[0]);
        ValidationResult result = this.dataSetImportExecutor.validateData(importData, workDir);
        Assertions.assertTrue((boolean)result.isValid());
        Assertions.assertNotNull((Object)result.getDetails());
        Assertions.assertTrue((boolean)result.getDetails().isEmpty());
        Assertions.assertEquals((int)10, (int)result.getReplacementMap().size());
    }

    @Test
    public void handleInterProjectImportValidation_validateData_returnReplacementMap() throws Exception {
        ExportImportData importData = new ExportImportData(UUID.randomUUID(), null, null, false, true, null, new HashMap(), new HashMap(), ValidationType.VALIDATE, false);
        Path workDir = Paths.get("src/test/resources/ei/import/1d554fe3-4a15-4e1c-964a-1585e3206211", new String[0]);
        ValidationResult result = this.dataSetImportExecutor.validateData(importData, workDir);
        Assertions.assertTrue((boolean)result.isValid());
        Assertions.assertNotNull((Object)result.getDetails());
        Assertions.assertTrue((boolean)result.getDetails().isEmpty());
        Assertions.assertEquals((int)10, (int)result.getReplacementMap().size());
    }

    @AfterEach
    public void clearDb() throws IOException {
        String pathStr = "src/test/resources/test_data/sql/overlap_lost_clear_tables.sql";
        Path path = Paths.get(pathStr, new String[0]);
        Files.readAllBytes(path);
        String query = new String(Files.readAllBytes(path), StandardCharsets.UTF_8);
        this.jdbcTemplate.execute(query);
    }
}

