/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.ei.service;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.parallel.Isolated;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.qubership.atp.dataset.ei.model.DataSetAttribute;
import org.qubership.atp.dataset.ei.model.DataSetList;
import org.qubership.atp.dataset.ei.model.IdEntity;
import org.qubership.atp.dataset.ei.service.DataSetAttributesImporter;
import org.qubership.atp.dataset.ei.service.DuplicateNameChecker;
import org.qubership.atp.dataset.ei.service.EntityManagerController;
import org.qubership.atp.dataset.service.jpa.DataSetServiceException;
import org.qubership.atp.dataset.service.jpa.JpaAttributeService;
import org.qubership.atp.dataset.service.jpa.JpaDataSetListService;
import org.qubership.atp.dataset.service.jpa.delegates.AbstractObjectWrapper;
import org.qubership.atp.dataset.service.jpa.delegates.Attribute;
import org.qubership.atp.dataset.service.jpa.delegates.AttributeKey;
import org.qubership.atp.dataset.service.jpa.delegates.ListValue;
import org.qubership.atp.dataset.service.jpa.model.AttributeTypeName;
import org.qubership.atp.ei.node.dto.ExportImportData;
import org.qubership.atp.ei.node.dto.validation.ValidationType;
import org.qubership.atp.ei.node.services.ObjectLoaderFromDiskService;
import org.springframework.test.context.junit.jupiter.SpringExtension;

@Isolated
@ExtendWith(value={SpringExtension.class})
public class DataSetAttributesImporterTest {
    private ObjectLoaderFromDiskService objectLoaderFromDiskService;
    private DataSetAttributesImporter dataSetAttributesImporter;
    @Mock
    private JpaAttributeService attrService;
    @Mock
    private JpaDataSetListService dslService;
    private DuplicateNameChecker duplicateNameChecker;
    @Mock
    private EntityManagerController entityManagerController;
    private ExportImportData importData;

    @BeforeEach
    public void setUp() throws Exception {
        this.duplicateNameChecker = new DuplicateNameChecker();
        this.objectLoaderFromDiskService = new ObjectLoaderFromDiskService();
        this.dataSetAttributesImporter = new DataSetAttributesImporter(this.objectLoaderFromDiskService, this.attrService, this.dslService, this.duplicateNameChecker, this.entityManagerController);
        this.importData = new ExportImportData(null, null, null, false, false, null, new HashMap(), new HashMap(), ValidationType.VALIDATE, false);
    }

    @Test
    public void validateDataSetAttributes_TypeDataSetListNotFound() {
        Path workDir = Paths.get("src/test/resources/ei/import/1d554fe3-4a15-4e1c-964a-1585e3206209", new String[0]);
        Mockito.when((Object)this.dslService.getById((UUID)ArgumentMatchers.any())).thenReturn(null);
        Mockito.when((Object)this.attrService.getById((UUID)ArgumentMatchers.any())).thenReturn(null);
        List result = this.dataSetAttributesImporter.validateDataSetAttributes(workDir, Collections.emptyMap(), false);
        result.contains("Link to DS Attribute 'ref_parameter' will be skipped because it refers to absent Data Set List");
        result.contains("Attribute 'text_value' from Link to DS Attribute group 'ref_parameter' will be skipped because it refers to absent Attribute");
    }

    @Test
    public void importDataSetAttributes_noOneDslImportedDoNothing() throws IOException {
        Path workDir = Paths.get("src/test/resources/ei/import/1d554fe3-4a15-4e1c-964a-1585e3206210", new String[0]);
        ArrayList dataSetLists = new ArrayList();
        this.dataSetAttributesImporter.importDataSetAttributes(workDir, dataSetLists, this.importData);
        ((JpaAttributeService)Mockito.verify((Object)this.attrService, (VerificationMode)Mockito.times((int)0))).remove((UUID)ArgumentMatchers.any());
        ((JpaAttributeService)Mockito.verify((Object)this.attrService, (VerificationMode)Mockito.times((int)0))).removeListValuesByAttributeId((UUID)ArgumentMatchers.any());
    }

    @Test
    public void importDataSetAttributes_1() throws DataSetServiceException, IOException {
        Path workDir = Paths.get("src/test/resources/ei/import/1d554fe3-4a15-4e1c-964a-1585e3206210", new String[0]);
        Map dataSetListsMap = this.objectLoaderFromDiskService.getListOfObjects(workDir, DataSetList.class);
        ArrayList dataSetLists = new ArrayList();
        dataSetLists.clear();
        dataSetLists.addAll(dataSetListsMap.keySet());
        UUID dslId = UUID.fromString("cb6fc56b-392c-456a-82d6-46fc38836a75");
        dataSetLists.remove(dslId);
        Mockito.when((Object)this.dslService.getById(dslId)).thenReturn(null);
        Mockito.when((Object)this.attrService.replicate((UUID)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (AttributeTypeName)ArgumentMatchers.any(), (UUID)ArgumentMatchers.any(), (UUID)ArgumentMatchers.any())).thenReturn((Object)((Attribute)Mockito.mock(Attribute.class)));
        this.dataSetAttributesImporter.importDataSetAttributes(workDir, dataSetLists, this.importData);
        ((JpaAttributeService)Mockito.verify((Object)this.attrService, (VerificationMode)Mockito.times((int)1))).replicate((UUID)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (AttributeTypeName)ArgumentMatchers.any(), (UUID)ArgumentMatchers.any(), (UUID)ArgumentMatchers.any());
        ((JpaAttributeService)Mockito.verify((Object)this.attrService, (VerificationMode)Mockito.times((int)0))).removeListValuesByAttributeId((UUID)ArgumentMatchers.any());
        ((JpaAttributeService)Mockito.verify((Object)this.attrService, (VerificationMode)Mockito.times((int)0))).replicateListValue((UUID)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (UUID)ArgumentMatchers.any(), (UUID)ArgumentMatchers.any());
    }

    @Test
    public void importDataSetAttributes_2() throws DataSetServiceException, IOException {
        Path workDir = Paths.get("src/test/resources/ei/import/1d554fe3-4a15-4e1c-964a-1585e3206210", new String[0]);
        Map dataSetListsMap = this.objectLoaderFromDiskService.getListOfObjects(workDir, DataSetList.class);
        ArrayList dataSetLists = new ArrayList();
        dataSetLists.clear();
        dataSetLists.addAll(dataSetListsMap.keySet());
        Mockito.when((Object)this.attrService.replicate((UUID)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (AttributeTypeName)ArgumentMatchers.any(), (UUID)ArgumentMatchers.any(), (UUID)ArgumentMatchers.any())).thenReturn((Object)((Attribute)Mockito.mock(Attribute.class)));
        this.dataSetAttributesImporter.importDataSetAttributes(workDir, dataSetLists, this.importData);
        ((JpaAttributeService)Mockito.verify((Object)this.attrService, (VerificationMode)Mockito.times((int)5))).replicate((UUID)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (AttributeTypeName)ArgumentMatchers.any(), (UUID)ArgumentMatchers.any(), (UUID)ArgumentMatchers.any());
        ((JpaAttributeService)Mockito.verify((Object)this.attrService, (VerificationMode)Mockito.times((int)4))).replicateListValue((UUID)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (UUID)ArgumentMatchers.any(), (UUID)ArgumentMatchers.any());
    }

    @Test
    public void importDataSetAttributes_21() throws DataSetServiceException, IOException {
        Path workDir = Paths.get("src/test/resources/ei/import/1d554fe3-4a15-4e1c-964a-1585e3206210", new String[0]);
        Map dataSetListsMap = this.objectLoaderFromDiskService.getListOfObjects(workDir, DataSetList.class);
        ArrayList dataSetLists = new ArrayList();
        dataSetLists.clear();
        dataSetLists.addAll(dataSetListsMap.keySet());
        Mockito.when((Object)this.attrService.getById((UUID)ArgumentMatchers.any())).thenReturn(null);
        Attribute existingAttribute = (Attribute)Mockito.mock(Attribute.class);
        Mockito.when((Object)this.attrService.getById(UUID.fromString("f5de3b5b-1d19-490b-a0ef-ecc48762a902"))).thenReturn((Object)existingAttribute);
        Mockito.when((Object)this.attrService.getListValueById((UUID)ArgumentMatchers.any())).thenReturn(null);
        ListValue existingListValue = (ListValue)Mockito.mock(ListValue.class);
        Mockito.when((Object)this.attrService.getListValueById(UUID.fromString("47a846d4-c44e-4c92-8dd9-8a0a78829ae6"))).thenReturn((Object)existingListValue);
        Mockito.when((Object)this.attrService.replicate((UUID)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (AttributeTypeName)ArgumentMatchers.any(), (UUID)ArgumentMatchers.any(), (UUID)ArgumentMatchers.any())).thenReturn((Object)((Attribute)Mockito.mock(Attribute.class)));
        this.dataSetAttributesImporter.importDataSetAttributes(workDir, dataSetLists, this.importData);
        ((JpaAttributeService)Mockito.verify((Object)this.attrService, (VerificationMode)Mockito.times((int)4))).replicate((UUID)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (AttributeTypeName)ArgumentMatchers.any(), (UUID)ArgumentMatchers.any(), (UUID)ArgumentMatchers.any());
        ((JpaAttributeService)Mockito.verify((Object)this.attrService, (VerificationMode)Mockito.times((int)3))).replicateListValue((UUID)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (UUID)ArgumentMatchers.any(), (UUID)ArgumentMatchers.any());
        ((JpaAttributeService)Mockito.verify((Object)this.attrService, (VerificationMode)Mockito.times((int)1))).save((AbstractObjectWrapper)existingAttribute);
        ((JpaAttributeService)Mockito.verify((Object)this.attrService, (VerificationMode)Mockito.times((int)1))).save((AbstractObjectWrapper)existingListValue);
    }

    @Test
    public void importDataSetAttributeKeys_1() throws DataSetServiceException, IOException {
        Path workDir = Paths.get("src/test/resources/ei/import/1d554fe3-4a15-4e1c-964a-1585e3206210", new String[0]);
        Mockito.when((Object)this.attrService.getById((UUID)ArgumentMatchers.any())).thenReturn(null);
        this.dataSetAttributesImporter.importDataSetAttributeKeys(workDir, this.importData);
        ((JpaAttributeService)Mockito.verify((Object)this.attrService, (VerificationMode)Mockito.times((int)0))).replicateAttributeKey((UUID)ArgumentMatchers.eq((Object)UUID.fromString("1c80d1bd-614e-4b01-9def-9fb9b9e79518")), (String)ArgumentMatchers.eq((Object)"2ae01b66-5000-410d-9468-428a418881e0"), (UUID)ArgumentMatchers.eq((Object)UUID.fromString("4400c445-d685-48ce-9817-d6dcebd927d9")), (UUID)ArgumentMatchers.eq((Object)UUID.fromString("8b911573-97ae-41fb-a3b8-d7d1f63d017c")), (UUID)ArgumentMatchers.eq((Object)UUID.fromString("e3786dc9-10ba-4251-9a43-7c12cac37ef6")), (UUID)ArgumentMatchers.eq((Object)UUID.fromString("1c80d1bd-614e-4b01-9def-9fb9b9e79518")));
    }

    @Test
    public void importDataSetAttributeKeys_2() throws DataSetServiceException, IOException {
        Path workDir = Paths.get("src/test/resources/ei/import/1d554fe3-4a15-4e1c-964a-1585e3206210", new String[0]);
        Mockito.when((Object)this.attrService.getById(UUID.fromString("4400c445-d685-48ce-9817-d6dcebd927d9"))).thenReturn(null);
        this.dataSetAttributesImporter.importDataSetAttributeKeys(workDir, this.importData);
        ((JpaAttributeService)Mockito.verify((Object)this.attrService, (VerificationMode)Mockito.times((int)0))).replicateAttributeKey((UUID)ArgumentMatchers.eq((Object)UUID.fromString("1c80d1bd-614e-4b01-9def-9fb9b9e79518")), (String)ArgumentMatchers.eq((Object)"2ae01b66-5000-410d-9468-428a418881e0"), (UUID)ArgumentMatchers.eq((Object)UUID.fromString("4400c445-d685-48ce-9817-d6dcebd927d9")), (UUID)ArgumentMatchers.eq((Object)UUID.fromString("8b911573-97ae-41fb-a3b8-d7d1f63d017c")), (UUID)ArgumentMatchers.eq((Object)UUID.fromString("e3786dc9-10ba-4251-9a43-7c12cac37ef6")), (UUID)ArgumentMatchers.eq((Object)UUID.fromString("1c80d1bd-614e-4b01-9def-9fb9b9e79518")));
    }

    @Test
    public void importDataSetAttributeKeys_3() throws DataSetServiceException, IOException {
        Path workDir = Paths.get("src/test/resources/ei/import/1d554fe3-4a15-4e1c-964a-1585e3206210", new String[0]);
        Mockito.when((Object)this.attrService.getById(UUID.fromString("4400c445-d685-48ce-9817-d6dcebd927d9"))).thenReturn((Object)((Attribute)Mockito.mock(Attribute.class)));
        this.dataSetAttributesImporter.importDataSetAttributeKeys(workDir, this.importData);
        ((JpaAttributeService)Mockito.verify((Object)this.attrService, (VerificationMode)Mockito.times((int)1))).replicateAttributeKey((UUID)ArgumentMatchers.eq((Object)UUID.fromString("1c80d1bd-614e-4b01-9def-9fb9b9e79518")), (String)ArgumentMatchers.eq((Object)"2ae01b66-5000-410d-9468-428a418881e0"), (UUID)ArgumentMatchers.eq((Object)UUID.fromString("4400c445-d685-48ce-9817-d6dcebd927d9")), (UUID)ArgumentMatchers.eq((Object)UUID.fromString("8b911573-97ae-41fb-a3b8-d7d1f63d017c")), (UUID)ArgumentMatchers.eq((Object)UUID.fromString("e3786dc9-10ba-4251-9a43-7c12cac37ef6")), (UUID)ArgumentMatchers.eq((Object)UUID.fromString("1c80d1bd-614e-4b01-9def-9fb9b9e79518")));
    }

    @Test
    public void importDataSetAttributeKeys_4() throws DataSetServiceException, IOException {
        Path workDir = Paths.get("src/test/resources/ei/import/1d554fe3-4a15-4e1c-964a-1585e3206210", new String[0]);
        Mockito.when((Object)this.attrService.getById(UUID.fromString("4400c445-d685-48ce-9817-d6dcebd927d9"))).thenReturn((Object)((Attribute)Mockito.mock(Attribute.class)));
        this.dataSetAttributesImporter.importDataSetAttributeKeys(workDir, this.importData);
        ((JpaAttributeService)Mockito.verify((Object)this.attrService, (VerificationMode)Mockito.times((int)1))).replicateAttributeKey((UUID)ArgumentMatchers.eq((Object)UUID.fromString("1c80d1bd-614e-4b01-9def-9fb9b9e79518")), (String)ArgumentMatchers.eq((Object)"2ae01b66-5000-410d-9468-428a418881e0"), (UUID)ArgumentMatchers.eq((Object)UUID.fromString("4400c445-d685-48ce-9817-d6dcebd927d9")), (UUID)ArgumentMatchers.eq((Object)UUID.fromString("8b911573-97ae-41fb-a3b8-d7d1f63d017c")), (UUID)ArgumentMatchers.eq((Object)UUID.fromString("e3786dc9-10ba-4251-9a43-7c12cac37ef6")), (UUID)ArgumentMatchers.eq((Object)UUID.fromString("1c80d1bd-614e-4b01-9def-9fb9b9e79518")));
    }

    @Test
    public void importDataSetAttributeKeys_importOverlapIntoDbWithOverlapWithTheSameParameters_OverlapsInDbShouldBeChangedWithoutDuplication() throws IOException {
        Path workDir = Paths.get("src/test/resources/ei/import/1d554fe3-4a15-4e1c-964a-1585e3206210", new String[0]);
        Mockito.when((Object)this.attrService.getById(UUID.fromString("4400c445-d685-48ce-9817-d6dcebd927d9"))).thenReturn((Object)((Attribute)Mockito.mock(Attribute.class)));
        AttributeKey attrKey = (AttributeKey)Mockito.mock(AttributeKey.class);
        Mockito.when((Object)this.attrService.getAttributeKeyByKeyAndDataSetListIdAndDataSetIdAndAttributeId((String)ArgumentMatchers.any(), (UUID)ArgumentMatchers.any(), (UUID)ArgumentMatchers.any(), (UUID)ArgumentMatchers.any())).thenReturn((Object)attrKey);
        this.dataSetAttributesImporter.importDataSetAttributeKeys(workDir, this.importData);
        ((AttributeKey)Mockito.verify((Object)attrKey, (VerificationMode)Mockito.times((int)1))).setKey((String)ArgumentMatchers.eq((Object)"2ae01b66-5000-410d-9468-428a418881e0"));
        ((AttributeKey)Mockito.verify((Object)attrKey, (VerificationMode)Mockito.times((int)1))).setAttribute((UUID)ArgumentMatchers.eq((Object)UUID.fromString("4400c445-d685-48ce-9817-d6dcebd927d9")));
        ((AttributeKey)Mockito.verify((Object)attrKey, (VerificationMode)Mockito.times((int)1))).setDataSet((UUID)ArgumentMatchers.eq((Object)UUID.fromString("8b911573-97ae-41fb-a3b8-d7d1f63d017c")));
        ((AttributeKey)Mockito.verify((Object)attrKey, (VerificationMode)Mockito.times((int)1))).setDataSetList((UUID)ArgumentMatchers.eq((Object)UUID.fromString("e3786dc9-10ba-4251-9a43-7c12cac37ef6")));
    }

    @Test
    public void checkAndCorrectName_noDuplicateInBase() {
        String name = "Object Name";
        UUID id = UUID.randomUUID();
        DataSetAttribute object = new DataSetAttribute();
        object.setName(name);
        object.setId(id);
        this.dataSetAttributesImporter.checkAndCorrectName(object);
        Assertions.assertEquals((Object)object.getName(), (Object)name);
    }

    @Test
    public void checkAndCorrectName_theSameObject() {
        String name = "Object Name";
        UUID id = UUID.randomUUID();
        DataSetAttribute object = new DataSetAttribute();
        object.setName(name);
        object.setId(id);
        UUID parentId = UUID.randomUUID();
        object.setDataSetList(parentId);
        DataSetAttribute entity = new DataSetAttribute();
        entity.setName(name);
        entity.setId(id);
        this.duplicateNameChecker.addToCache(parentId, (IdEntity)entity);
        this.dataSetAttributesImporter.checkAndCorrectName(object);
        Assertions.assertEquals((Object)object.getName(), (Object)name);
    }

    @Test
    public void checkAndCorrectName_theSameButWithOtherNameObject() {
        String name = "Object Name";
        UUID id = UUID.randomUUID();
        DataSetAttribute object = new DataSetAttribute();
        object.setName(name);
        object.setId(id);
        UUID parentId = UUID.randomUUID();
        object.setDataSetList(parentId);
        DataSetAttribute entity = new DataSetAttribute();
        entity.setName("Object Name 2");
        entity.setId(id);
        this.duplicateNameChecker.addToCache(parentId, (IdEntity)entity);
        this.dataSetAttributesImporter.checkAndCorrectName(object);
        Assertions.assertEquals((Object)object.getName(), (Object)name);
    }

    @Test
    public void checkAndCorrectName_twoDuplicateInBase() {
        String name = "Object Name";
        UUID id = UUID.randomUUID();
        DataSetAttribute object = new DataSetAttribute();
        object.setName(name);
        object.setId(id);
        UUID parentId = UUID.randomUUID();
        object.setDataSetList(parentId);
        DataSetAttribute entity = new DataSetAttribute();
        entity.setName(name);
        entity.setId(UUID.randomUUID());
        this.duplicateNameChecker.addToCache(parentId, (IdEntity)entity);
        DataSetAttribute entity2 = new DataSetAttribute();
        entity2.setName(name + " Copy");
        entity2.setId(UUID.randomUUID());
        this.duplicateNameChecker.addToCache(parentId, (IdEntity)entity2);
        DataSetAttribute entity3 = new DataSetAttribute();
        entity3.setName(name + " Copy _1");
        entity3.setId(UUID.randomUUID());
        this.duplicateNameChecker.addToCache(parentId, (IdEntity)entity3);
        this.dataSetAttributesImporter.checkAndCorrectName(object);
        Assertions.assertEquals((Object)object.getName(), (Object)(name + " Copy _2"));
    }
}

