/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.ei.service;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.parallel.Isolated;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.qubership.atp.dataset.config.TestConfiguration;
import org.qubership.atp.dataset.ei.DataSetExportExecutor;
import org.qubership.atp.dataset.service.jpa.service.AbstractJpaTest;
import org.qubership.atp.ei.node.dto.ExportFormat;
import org.qubership.atp.ei.node.dto.ExportImportData;
import org.qubership.atp.ei.node.dto.ExportScope;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.jdbc.Sql;
import org.springframework.test.context.junit.jupiter.SpringExtension;

@Isolated
@SpringBootTest
@ContextConfiguration(classes={TestConfiguration.class})
@ExtendWith(value={SpringExtension.class})
public class DataSetExportExecutorPostman
extends AbstractJpaTest {
    @Autowired
    DataSetExportExecutor dataSetExportExecutor;

    @Test
    @Sql(scripts={"classpath:test_data/sql/postman.export/clear_postman_export.sql", "classpath:test_data/sql/postman.export/postman_dsl.sql"})
    public void exportToFolder_PostmanFormat_successfulExport() throws Exception {
        String path = "src/test/resources/ei/postman";
        Path workDir = Paths.get(path, new String[0]);
        Files.createDirectories(workDir, new FileAttribute[0]);
        UUID visibilityAreaId = UUID.fromString("46094b3a-dc76-46f6-9a38-e3af2a8cc9fb");
        ExportImportData exportData = new ExportImportData(visibilityAreaId, new ExportScope(), ExportFormat.POSTMAN);
        String dsl = "1ca198cf-6b55-4a59-899c-bd9808bd5ad6";
        exportData.getExportScope().getEntities().put("datasetStorage", Collections.singleton(dsl));
        Mockito.when((Object)this.macrosFeignClient.findAllByProject((UUID)ArgumentMatchers.any())).thenReturn((Object)new ResponseEntity(Collections.emptyList(), HttpStatus.OK));
        this.dataSetExportExecutor.exportToFolder(exportData, workDir);
        String expectedFile1 = this.getFileValue("src/test/resources/test_data/postman.expected/dataset/postman_test_dsl.postman_ds1.dataset.json");
        String expectedFile2 = this.getFileValue("src/test/resources/test_data/postman.expected/dataset/postman_test_dsl.postman_ds2.dataset.json");
        String actualFileValue1 = this.getFileValue("src/test/resources/ei/postman/dataset/postman_test_dsl.postman_ds1.dataset.json");
        String actualFileValue2 = this.getFileValue("src/test/resources/ei/postman/dataset/postman_test_dsl.postman_ds2.dataset.json");
        File folder = new File(path + "/dataset");
        int count = folder.list().length;
        Assertions.assertEquals((int)2, (int)count);
        Assertions.assertEquals((Object)expectedFile1, (Object)actualFileValue1);
        Assertions.assertEquals((Object)expectedFile2, (Object)actualFileValue2);
        FileUtils.deleteDirectory((File)new File(path));
    }

    public String getFileValue(String stringPath) throws IOException {
        Path path = Paths.get(stringPath, new String[0]);
        return new String(Files.readAllBytes(path), StandardCharsets.UTF_8);
    }
}

