/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.ei.service;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.parallel.Isolated;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.qubership.atp.dataset.ei.service.DataSetParametersImporter;
import org.qubership.atp.dataset.ei.service.EntityManagerController;
import org.qubership.atp.dataset.service.direct.ClearCacheService;
import org.qubership.atp.dataset.service.jpa.DataSetServiceException;
import org.qubership.atp.dataset.service.jpa.JpaAttributeService;
import org.qubership.atp.dataset.service.jpa.JpaDataSetService;
import org.qubership.atp.dataset.service.jpa.JpaParameterService;
import org.qubership.atp.dataset.service.jpa.delegates.Attribute;
import org.qubership.atp.dataset.service.jpa.delegates.AttributeKey;
import org.qubership.atp.dataset.service.jpa.delegates.DataSet;
import org.qubership.atp.dataset.service.jpa.delegates.Parameter;
import org.qubership.atp.ei.node.dto.ExportImportData;
import org.qubership.atp.ei.node.dto.validation.ValidationType;
import org.qubership.atp.ei.node.services.ObjectLoaderFromDiskService;
import org.springframework.test.context.junit.jupiter.SpringExtension;

@Isolated
@ExtendWith(value={SpringExtension.class})
public class DataSetParametersImporterTest {
    private ObjectLoaderFromDiskService objectLoaderFromDiskService;
    private DataSetParametersImporter dataSetParametersImporter;
    @Mock
    private JpaParameterService paramService;
    @Mock
    private JpaAttributeService attrService;
    @Mock
    private JpaDataSetService dsService;
    @Mock
    private EntityManagerController entityManagerController;
    @Mock
    private ClearCacheService clearCacheService;
    private ExportImportData importData;

    @BeforeEach
    public void setUp() throws Exception {
        this.objectLoaderFromDiskService = new ObjectLoaderFromDiskService();
        this.dataSetParametersImporter = new DataSetParametersImporter(this.objectLoaderFromDiskService, this.paramService, this.attrService, this.dsService, this.entityManagerController, this.clearCacheService);
        this.importData = new ExportImportData(null, null, null, false, false, null, new HashMap(), new HashMap(), ValidationType.VALIDATE, false);
    }

    @Test
    public void validateDataSetParameters() {
        Path workDir = Paths.get("src/test/resources/ei/import/1d554fe3-4a15-4e1c-964a-1585e3206209", new String[0]);
        Mockito.when((Object)this.dsService.getById((UUID)ArgumentMatchers.any())).thenReturn(null);
        List result = this.dataSetParametersImporter.validateDataSetParameters(workDir, Collections.emptyMap(), false);
        Assertions.assertTrue((boolean)result.contains("Some Link to Data Set Attribute refers to absent Data Set."));
        Mockito.when((Object)this.dsService.getById((UUID)ArgumentMatchers.any())).thenReturn((Object)((DataSet)Mockito.mock(DataSet.class)));
        result = this.dataSetParametersImporter.validateDataSetParameters(workDir, Collections.emptyMap(), false);
        Assertions.assertTrue((boolean)result.isEmpty());
    }

    @Test
    public void importDataSetParameters_1() throws DataSetServiceException, IOException {
        Path workDir = Paths.get("src/test/resources/ei/import/1d554fe3-4a15-4e1c-964a-1585e3206209", new String[0]);
        Mockito.when((Object)this.attrService.getById((UUID)ArgumentMatchers.any())).thenReturn(null);
        Mockito.when((Object)this.attrService.getAttributeKeyById((UUID)ArgumentMatchers.any())).thenReturn(null);
        this.dataSetParametersImporter.importDataSetParameters(workDir, this.importData);
        ((JpaParameterService)Mockito.verify((Object)this.paramService, (VerificationMode)Mockito.times((int)0))).replicate((UUID)ArgumentMatchers.any(), (UUID)ArgumentMatchers.any(), (UUID)ArgumentMatchers.any(), (UUID)ArgumentMatchers.any());
    }

    @Test
    public void importDataSetParameters_2() throws DataSetServiceException, IOException {
        Path workDir = Paths.get("src/test/resources/ei/import/1d554fe3-4a15-4e1c-964a-1585e3206209", new String[0]);
        Mockito.when((Object)this.attrService.getById((UUID)ArgumentMatchers.any())).thenReturn((Object)((Attribute)Mockito.mock(Attribute.class)));
        Mockito.when((Object)this.paramService.replicate((UUID)ArgumentMatchers.any(), (UUID)ArgumentMatchers.any(), (UUID)ArgumentMatchers.any(), (UUID)ArgumentMatchers.any())).thenReturn((Object)((Parameter)Mockito.mock(Parameter.class)));
        this.dataSetParametersImporter.importDataSetParameters(workDir, this.importData);
        ((JpaParameterService)Mockito.verify((Object)this.paramService, (VerificationMode)Mockito.times((int)5))).replicate((UUID)ArgumentMatchers.any(), (UUID)ArgumentMatchers.any(), (UUID)ArgumentMatchers.any(), (UUID)ArgumentMatchers.any());
    }

    @Test
    public void importDataSetParameters_21() throws DataSetServiceException, IOException {
        Path workDir = Paths.get("src/test/resources/ei/import/1d554fe3-4a15-4e1c-964a-1585e3206209", new String[0]);
        Mockito.when((Object)this.attrService.getById((UUID)ArgumentMatchers.any())).thenReturn(null);
        Mockito.when((Object)this.attrService.getAttributeKeyById((UUID)ArgumentMatchers.any())).thenReturn((Object)((AttributeKey)Mockito.mock(AttributeKey.class)));
        Mockito.when((Object)this.paramService.replicate((UUID)ArgumentMatchers.any(), (UUID)ArgumentMatchers.any(), (UUID)ArgumentMatchers.any(), (UUID)ArgumentMatchers.any())).thenReturn((Object)((Parameter)Mockito.mock(Parameter.class)));
        this.dataSetParametersImporter.importDataSetParameters(workDir, this.importData);
        ((JpaParameterService)Mockito.verify((Object)this.paramService, (VerificationMode)Mockito.times((int)5))).replicate((UUID)ArgumentMatchers.any(), (UUID)ArgumentMatchers.any(), (UUID)ArgumentMatchers.any(), (UUID)ArgumentMatchers.any());
    }

    @Test
    public void importDataSetParameters_22() throws DataSetServiceException, IOException {
        Path workDir = Paths.get("src/test/resources/ei/import/1d554fe3-4a15-4e1c-964a-1585e3206209", new String[0]);
        Mockito.when((Object)this.attrService.getById((UUID)ArgumentMatchers.any())).thenReturn((Object)((Attribute)Mockito.mock(Attribute.class)));
        UUID absentAttributeId = UUID.fromString("1c80d1bd-614e-4b01-9def-9fb9b9e79518");
        Mockito.when((Object)this.attrService.getById(absentAttributeId)).thenReturn(null);
        Mockito.when((Object)this.attrService.getAttributeKeyById(absentAttributeId)).thenReturn(null);
        Mockito.when((Object)this.paramService.replicate((UUID)ArgumentMatchers.any(), (UUID)ArgumentMatchers.any(), (UUID)ArgumentMatchers.any(), (UUID)ArgumentMatchers.any())).thenReturn((Object)((Parameter)Mockito.mock(Parameter.class)));
        this.dataSetParametersImporter.importDataSetParameters(workDir, this.importData);
        ((JpaParameterService)Mockito.verify((Object)this.paramService, (VerificationMode)Mockito.times((int)4))).replicate((UUID)ArgumentMatchers.any(), (UUID)ArgumentMatchers.any(), (UUID)ArgumentMatchers.any(), (UUID)ArgumentMatchers.any());
    }

    @Test
    public void importDataSetParameters_3() throws DataSetServiceException, IOException {
        Path workDir = Paths.get("src/test/resources/ei/import/1d554fe3-4a15-4e1c-964a-1585e3206209", new String[0]);
        Mockito.when((Object)this.attrService.getById((UUID)ArgumentMatchers.any())).thenReturn((Object)((Attribute)Mockito.mock(Attribute.class)));
        Parameter parameter = (Parameter)Mockito.mock(Parameter.class);
        Mockito.when((Object)this.paramService.replicate((UUID)ArgumentMatchers.any(), (UUID)ArgumentMatchers.any(), (UUID)ArgumentMatchers.any(), (UUID)ArgumentMatchers.any())).thenReturn((Object)parameter);
        UUID dataSetReferenceValue = UUID.fromString("5bbb5c00-ef9a-4b02-81cc-7bd7cf91a7ce");
        Mockito.when((Object)this.dsService.getById(dataSetReferenceValue)).thenReturn((Object)((DataSet)Mockito.mock(DataSet.class)));
        this.dataSetParametersImporter.importDataSetParameters(workDir, this.importData);
        ((Parameter)Mockito.verify((Object)parameter, (VerificationMode)Mockito.times((int)1))).setDataSetReferenceId(dataSetReferenceValue);
        ((JpaParameterService)Mockito.verify((Object)this.paramService, (VerificationMode)Mockito.times((int)5))).replicate((UUID)ArgumentMatchers.any(), (UUID)ArgumentMatchers.any(), (UUID)ArgumentMatchers.any(), (UUID)ArgumentMatchers.any());
    }

    @Test
    public void importDataSetParameters_4() throws DataSetServiceException, IOException {
        Path workDir = Paths.get("src/test/resources/ei/import/1d554fe3-4a15-4e1c-964a-1585e3206209", new String[0]);
        Mockito.when((Object)this.attrService.getById((UUID)ArgumentMatchers.any())).thenReturn((Object)((Attribute)Mockito.mock(Attribute.class)));
        Parameter existingParameter = (Parameter)Mockito.mock(Parameter.class);
        Mockito.when((Object)this.paramService.getById(UUID.fromString("67094fbd-d205-4893-ac7a-a33877e7c14b"))).thenReturn((Object)existingParameter);
        Parameter parameter = (Parameter)Mockito.mock(Parameter.class);
        Mockito.when((Object)this.paramService.replicate((UUID)ArgumentMatchers.any(), (UUID)ArgumentMatchers.any(), (UUID)ArgumentMatchers.any(), (UUID)ArgumentMatchers.any())).thenReturn((Object)parameter);
        UUID dataSetReferenceValue = UUID.fromString("5bbb5c00-ef9a-4b02-81cc-7bd7cf91a7ce");
        Mockito.when((Object)this.dsService.getById(dataSetReferenceValue)).thenReturn((Object)((DataSet)Mockito.mock(DataSet.class)));
        this.dataSetParametersImporter.importDataSetParameters(workDir, this.importData);
        ((Parameter)Mockito.verify((Object)parameter, (VerificationMode)Mockito.times((int)1))).setDataSetReferenceId(dataSetReferenceValue);
        ((JpaParameterService)Mockito.verify((Object)this.paramService, (VerificationMode)Mockito.times((int)4))).replicate((UUID)ArgumentMatchers.any(), (UUID)ArgumentMatchers.any(), (UUID)ArgumentMatchers.any(), (UUID)ArgumentMatchers.any());
        ((JpaParameterService)Mockito.verify((Object)this.paramService, (VerificationMode)Mockito.times((int)1))).save(existingParameter);
        ((JpaParameterService)Mockito.verify((Object)this.paramService, (VerificationMode)Mockito.times((int)5))).save((Parameter)ArgumentMatchers.any());
    }
}

