/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.ei.service;

import java.util.UUID;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Isolated;
import org.mockito.Spy;
import org.qubership.atp.dataset.ei.model.IdEntity;
import org.qubership.atp.dataset.ei.service.DuplicateNameChecker;

@Isolated
public class DuplicateNameCheckerTest {
    @Spy
    private DuplicateNameChecker duplicateNameChecker = new DuplicateNameChecker();

    @Test
    public void isNameUsed_whenNameIsUsed_thenReturnTrue() {
        IdEntity entity = new IdEntity();
        entity.setId(UUID.randomUUID());
        entity.setName("Entity 1");
        UUID parentId = UUID.randomUUID();
        this.duplicateNameChecker.addToCache(parentId, entity);
        Assertions.assertTrue((boolean)this.duplicateNameChecker.isInitialized(IdEntity.class, parentId));
        entity.setId(UUID.randomUUID());
        Assertions.assertTrue((boolean)this.duplicateNameChecker.isNameUsed(parentId, entity));
    }

    @Test
    public void isNameUsed_whenNameIsUsedForTheSameObject_thenReturnFalse() {
        IdEntity entity = new IdEntity();
        entity.setId(UUID.randomUUID());
        entity.setName("Entity 1");
        UUID parentId = UUID.randomUUID();
        this.duplicateNameChecker.addToCache(parentId, entity);
        Assertions.assertTrue((boolean)this.duplicateNameChecker.isInitialized(IdEntity.class, parentId));
        Assertions.assertFalse((boolean)this.duplicateNameChecker.isNameUsed(parentId, entity));
    }

    @Test
    public void isNameUsed_whenNameIsNotUsed_thenReturnFalse() {
        IdEntity entity = new IdEntity();
        entity.setId(UUID.randomUUID());
        entity.setName("Entity 1");
        UUID parentId = UUID.randomUUID();
        this.duplicateNameChecker.addToCache(parentId, entity);
        Assertions.assertTrue((boolean)this.duplicateNameChecker.isInitialized(IdEntity.class, parentId));
        entity.setName("Entity 2");
        Assertions.assertFalse((boolean)this.duplicateNameChecker.isNameUsed(parentId, entity));
    }

    @Test
    public void checkAndCorrectName_whenNameIsUsed_thenGenerateNewName() {
        IdEntity entity = new IdEntity();
        entity.setId(UUID.randomUUID());
        entity.setName("Entity 1");
        UUID parentId = UUID.randomUUID();
        this.duplicateNameChecker.addToCache(parentId, entity);
        Assertions.assertTrue((boolean)this.duplicateNameChecker.isInitialized(IdEntity.class, parentId));
        entity.setId(UUID.randomUUID());
        this.duplicateNameChecker.checkAndCorrectName(parentId, entity);
        Assertions.assertEquals((Object)"Entity 1 Copy", (Object)entity.getName());
    }

    @Test
    public void checkAndCorrectName_whenNameIsUsedForTheSameObject_thenKeepCurrentName() {
        IdEntity entity = new IdEntity();
        entity.setId(UUID.randomUUID());
        entity.setName("Entity 1");
        UUID parentId = UUID.randomUUID();
        this.duplicateNameChecker.addToCache(parentId, entity);
        Assertions.assertTrue((boolean)this.duplicateNameChecker.isInitialized(IdEntity.class, parentId));
        this.duplicateNameChecker.checkAndCorrectName(parentId, entity);
        Assertions.assertEquals((Object)"Entity 1", (Object)entity.getName());
    }

    @Test
    public void checkAndCorrectName_whenNameIsNotUsed_thenKeepCurrentName() {
        IdEntity entity = new IdEntity();
        entity.setId(UUID.randomUUID());
        entity.setName("Entity 1");
        UUID parentId = UUID.randomUUID();
        this.duplicateNameChecker.addToCache(parentId, entity);
        Assertions.assertTrue((boolean)this.duplicateNameChecker.isInitialized(IdEntity.class, parentId));
        entity.setName("Entity 2");
        this.duplicateNameChecker.checkAndCorrectName(parentId, entity);
        Assertions.assertEquals((Object)"Entity 2", (Object)entity.getName());
    }
}

