/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.macros.impl;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Isolated;
import org.qubership.atp.dataset.RegexpMatcher;
import org.qubership.atp.dataset.config.TestMacrosConfiguration;
import org.qubership.atp.dataset.macros.impl.AbstractMacrosTest;
import org.qubership.atp.dataset.macros.impl.DateMacros;
import org.qubership.atp.dataset.model.DataSet;
import org.qubership.atp.dataset.model.DataSetList;
import org.qubership.atp.dataset.model.impl.DataSetImpl;
import org.qubership.atp.dataset.model.impl.DataSetListImpl;
import org.springframework.test.context.ContextConfiguration;

@Isolated
@ContextConfiguration(classes={TestMacrosConfiguration.class})
public class DateMacrosTest
extends AbstractMacrosTest {
    private final DateMacros DATE_MACROS = new DateMacros();

    @Test
    public void testDateMacrosParsFormatAndReturnsFormattedDate() throws Exception {
        String evaluate = (String)this.DATE_MACROS.evaluate("yyyy-MM-dd", null);
        Assertions.assertNotNull((Object)evaluate);
        MatcherAssert.assertThat((Object)evaluate, (Matcher)RegexpMatcher.matchesToRegExp("\\d{4}-\\d{2}-\\d{2}"));
        DateTime dateTime = DateTime.parse((String)evaluate);
        Assertions.assertEquals((int)DateTime.now().getDayOfYear(), (int)dateTime.getDayOfYear());
    }

    @Test
    public void testParseIncreaseToOneMonthAndFormatDate() throws Exception {
        String evaluate = (String)this.DATE_MACROS.evaluate("+1M,yyyy-MM-dd", null);
        MatcherAssert.assertThat((Object)evaluate, (Matcher)RegexpMatcher.matchesToRegExp("\\d{4}-\\d{2}-\\d{2}"));
        int monthOfYear = DateTime.now().getMonthOfYear();
        if (monthOfYear > 11) {
            monthOfYear = 0;
        }
        Assertions.assertTrue((monthOfYear < DateTime.parse((String)evaluate).getMonthOfYear() ? 1 : 0) != 0);
    }

    @Test
    public void testParseIncreaseToTwoMonthAndFormatDate() throws Exception {
        String evaluate = (String)this.DATE_MACROS.evaluate("+2M,yyyy-MM-dd", null);
        MatcherAssert.assertThat((Object)evaluate, (Matcher)RegexpMatcher.matchesToRegExp("\\d{4}-\\d{2}-\\d{2}"));
        int monthOfYear = DateTime.now().getMonthOfYear();
        if (monthOfYear > 10) {
            monthOfYear = 0;
        }
        Assertions.assertTrue((monthOfYear < DateTime.parse((String)evaluate).getMonthOfYear() ? 1 : 0) != 0);
    }

    @Test
    public void testParseIncrementationToZeroMonthAndFormatDate() throws Exception {
        String evaluate = (String)this.DATE_MACROS.evaluate("+0M,yyyy-MM-dd", null);
        MatcherAssert.assertThat((Object)evaluate, (Matcher)RegexpMatcher.matchesToRegExp("\\d{4}-\\d{2}-\\d{2}"));
        Assertions.assertEquals((int)DateTime.now().getDayOfYear(), (int)DateTime.parse((String)evaluate).getDayOfYear());
    }

    @Test
    public void testIncreaseYear() throws Exception {
        String evaluate = (String)this.DATE_MACROS.evaluate("+1y,yyyy-MM-dd", null);
        MatcherAssert.assertThat((Object)evaluate, (Matcher)RegexpMatcher.matchesToRegExp("\\d{4}-\\d{2}-\\d{2}"));
        Assertions.assertTrue((DateTime.now().getYear() < DateTime.parse((String)evaluate).getYear() ? 1 : 0) != 0);
    }

    @Test
    public void testIncreaseMonth() throws Exception {
        String evaluate = (String)this.DATE_MACROS.evaluate("+1M,yyyy-MM-dd", null);
        MatcherAssert.assertThat((Object)evaluate, (Matcher)RegexpMatcher.matchesToRegExp("\\d{4}-\\d{2}-\\d{2}"));
        Assertions.assertTrue((DateTime.now().getMillis() < DateTime.parse((String)evaluate).getMillis() ? 1 : 0) != 0);
    }

    @Test
    public void testIncreaseDay() throws Exception {
        String evaluate = (String)this.DATE_MACROS.evaluate("+1d,yyyy-MM-dd", null);
        MatcherAssert.assertThat((Object)evaluate, (Matcher)RegexpMatcher.matchesToRegExp("\\d{4}-\\d{2}-\\d{2}"));
        Assertions.assertTrue((DateTime.now().getMillis() < DateTime.parse((String)evaluate).getMillis() ? 1 : 0) != 0);
    }

    @Test
    public void testIncreaseHour() throws Exception {
        String evaluate = (String)this.DATE_MACROS.evaluate("+1h,yyyy-MM-dd HH:MM", null);
        MatcherAssert.assertThat((Object)evaluate, (Matcher)RegexpMatcher.matchesToRegExp("\\d{4}-\\d{2}-\\d{2} \\d{2}:\\d{2}"));
        Assertions.assertTrue((DateTime.now().getMillis() < DateTime.parse((String)evaluate, (DateTimeFormatter)DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:MM")).getMillis() ? 1 : 0) != 0);
    }

    @Test
    public void testIncreaseMinutes() throws Exception {
        DateTime now = DateTime.now();
        DateTime dateTime = new DateTime((Object)now);
        DateTime evaluate = this.DATE_MACROS.calculateDate(dateTime, "+1m");
        Assertions.assertTrue((now.getMillis() < evaluate.getMillis() ? 1 : 0) != 0);
    }

    @Test
    public void testIncreaseSecond() throws Exception {
        DateMacros dateMacros = new DateMacros();
        DateTime now = DateTime.now();
        DateTime dateTime = new DateTime((Object)now);
        DateTime evaluate = dateMacros.calculateDate(dateTime, "+1s");
        Assertions.assertTrue((now.getMillis() < evaluate.getMillis() ? 1 : 0) != 0);
    }

    @Test
    public void testDecreaseYear() throws Exception {
        String evaluate = (String)this.DATE_MACROS.evaluate("-1y,yyyy-MM-dd", null);
        MatcherAssert.assertThat((Object)evaluate, (Matcher)RegexpMatcher.matchesToRegExp("\\d{4}-\\d{2}-\\d{2}"));
        Assertions.assertTrue((DateTime.now().getYear() > DateTime.parse((String)evaluate).getYear() ? 1 : 0) != 0);
    }

    @Test
    public void usingCustomDate_decreasingHours_mayDecreaseDays() throws Exception {
        String evaluate = this.DATE_MACROS.formattedCalculatedDate("+2M-4h,yyyy-MM-dd", DateTime.parse((String)"2018-10-24T02:00"));
        Assertions.assertEquals((Object)"2018-12-23", (Object)evaluate);
    }

    @Test
    public void testEvaluatingWithEvaluator() throws Exception {
        String evaluate = this.evaluator.evaluate("#date(-1y+1d,yyyy-MM-dd)", (DataSetList)new DataSetListImpl(), (DataSet)new DataSetImpl());
        MatcherAssert.assertThat((Object)evaluate, (Matcher)RegexpMatcher.matchesToRegExp("\\d{4}-\\d{2}-\\d{2}"));
        DateTime dateTime = DateTime.parse((String)evaluate, (DateTimeFormatter)DateTimeFormat.forPattern((String)"yyyy-MM-dd"));
        DateTime now = DateTime.now();
        Assertions.assertEquals((int)(now.getYear() - 1), (int)dateTime.getYear());
    }

    @Test
    public void testExceptionIfOperationTypeUndefined() throws Exception {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.DATE_MACROS.evaluate("+1g,yyyy-MM-dd", null));
    }
}

