/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.macros.impl;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Isolated;
import org.qubership.atp.dataset.RegexpMatcher;
import org.qubership.atp.dataset.config.TestMacrosConfiguration;
import org.qubership.atp.dataset.macros.impl.AbstractMacrosTest;
import org.qubership.atp.dataset.model.DataSet;
import org.qubership.atp.dataset.model.DataSetList;
import org.qubership.atp.dataset.model.impl.DataSetImpl;
import org.qubership.atp.dataset.model.impl.DataSetListImpl;
import org.springframework.test.context.ContextConfiguration;

@Isolated
@ContextConfiguration(classes={TestMacrosConfiguration.class})
public class RandomBetweenMacrosTest
extends AbstractMacrosTest {
    @Test
    public void testRandomBetweenReturnsNumericValues() throws Exception {
        String evaluate = this.evaluator.evaluate("#RaNdOmBeTwEeN(1,10)", (DataSetList)new DataSetListImpl(), (DataSet)new DataSetImpl());
        MatcherAssert.assertThat((Object)evaluate, (Matcher)RegexpMatcher.matchesToRegExp("\\d+"));
    }

    @Test
    public void testRandomBetweenGeneratesValuesInSpecifiedRange() throws Exception {
        for (int count = 0; count < 100; ++count) {
            String evaluate = this.evaluator.evaluate("#RaNdOmBeTwEeN(2, 10)", (DataSetList)new DataSetListImpl(), (DataSet)new DataSetImpl());
            long result = Long.parseLong(evaluate);
            Assertions.assertTrue((result >= 2L && result <= 10L ? 1 : 0) != 0);
        }
    }
}

