/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.macros.impl;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Collections;
import java.util.UUID;
import org.junit.After;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Isolated;
import org.qubership.atp.dataset.config.TestMacrosConfiguration;
import org.qubership.atp.dataset.macros.impl.AbstractMacrosTest;
import org.qubership.atp.dataset.model.Attribute;
import org.qubership.atp.dataset.model.AttributeType;
import org.qubership.atp.dataset.model.DataSet;
import org.qubership.atp.dataset.model.DataSetList;
import org.qubership.atp.dataset.model.Parameter;
import org.qubership.atp.dataset.service.direct.AttributeService;
import org.qubership.atp.dataset.service.direct.DataSetListService;
import org.qubership.atp.dataset.service.direct.DataSetService;
import org.qubership.atp.dataset.service.direct.EvaluationService;
import org.qubership.atp.dataset.service.direct.ParameterService;
import org.qubership.atp.dataset.service.direct.VisibilityAreaService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;

@Isolated
@ContextConfiguration(classes={TestMacrosConfiguration.class})
public class ReferenceDslAliasMacrosTest
extends AbstractMacrosTest {
    @Autowired
    private DataSetListService dslService;
    @Autowired
    private DataSetService dataSetService;
    @Autowired
    private AttributeService attributeService;
    @Autowired
    private ParameterService parameterService;
    @Autowired
    private VisibilityAreaService visibilityAreaService;
    @Autowired
    private EvaluationService evaluationService;
    private DataSetList dataSetList;
    private DataSet dataSet;
    private UUID dsId;
    private UUID dslId;
    private UUID attributeId;
    private UUID vaId;

    @BeforeEach
    public void setUp() {
        this.dataSetList = this.createDSL();
    }

    @After
    public void tearDown() {
        this.visibilityAreaService.delete(this.vaId);
    }

    private DataSetList createDSL() {
        this.vaId = this.visibilityAreaService.create("RefAliasTestVA").getId();
        this.dslId = this.dslService.create(this.vaId, "ExternalDSL", null).getId();
        DataSetList dsl = (DataSetList)this.dslService.get(this.dslId);
        this.dataSet = this.dataSetService.create(dsl.getId(), "ExternalDS");
        this.dsId = this.dataSet.getId();
        Attribute attribute = this.attributeService.create(dsl.getId(), Integer.valueOf(0), "ExternalAttr", AttributeType.TEXT, null, null);
        this.attributeId = attribute.getId();
        this.parameterService.create(this.dsId, attribute.getId(), "Passed", null, null);
        return dsl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCalcReferenceInItfSerialization() {
        UUID testVa = null;
        try {
            String macros = "#CHARS_UPPERCASE(1)#CHARS_UPPERCASE(1)#CHARS_UPPERCASE(1)#CHARS_UPPERCASE(1)#CHARS_UPPERCASE(1)#CHARS_UPPERCASE(1)";
            testVa = this.visibilityAreaService.create("TestVa").getId();
            Parameter targetParameter = this.createTargetDsl(testVa);
            Parameter parentParameter = this.createParentDsl(testVa, targetParameter.getDataSet());
            Parameter childParameter = this.createChildDsl(testVa, targetParameter.getDataSet());
            DataSetList parentDsl = parentParameter.getDataSet().getDataSetList();
            this.parameterService.set(parentParameter.getDataSet().getId(), targetParameter.getAttribute().getId(), Collections.singletonList(parentParameter.getAttribute().getId()), macros, null, null);
            ObjectNode itfFormat = this.dataSetService.getInItfFormat(parentParameter.getDataSet().getMixInId());
            Assertions.assertNotEquals((Object)"Default", (Object)itfFormat.get("Address").get("Postal Code").get("Second").asText());
            Assertions.assertEquals((Object)itfFormat.get("Address").get("Provice").asText(), (Object)itfFormat.get("Address").get("Postal Code").get("Second").asText());
        }
        finally {
            if (testVa != null) {
                this.visibilityAreaService.delete(testVa);
            }
        }
    }

    private Parameter createChildDsl(UUID testVa, DataSet dataSet) {
        UUID testDsl = this.dslService.create(testVa, "Postal Code", null).getId();
        UUID testDS = this.dataSetService.create(testDsl, "PC #001").getId();
        Attribute child = this.attributeService.create(dataSet.getDataSetList().getId(), Integer.valueOf(1), "Postal Code", AttributeType.DSL, testDsl, null);
        this.parameterService.create(dataSet.getId(), child.getId(), null, null, testDS);
        Attribute attribute = this.attributeService.create(testDsl, Integer.valueOf(0), "Second", AttributeType.TEXT, null, null);
        return this.parameterService.create(testDS, attribute.getId(), "#REF_DSL(Customer.Customer 1.Address.Provice)", null, null);
    }

    private Parameter createParentDsl(UUID testVa, DataSet targetDs) {
        UUID testDsl = this.dslService.create(testVa, "Customer", null).getId();
        UUID testDS = this.dataSetService.create(testDsl, "Customer 1").getId();
        Attribute group = this.attributeService.create(testDsl, Integer.valueOf(0), "Address", AttributeType.DSL, targetDs.getDataSetList().getId(), null);
        return this.parameterService.create(testDS, group.getId(), null, null, targetDs.getId());
    }

    private Parameter createTargetDsl(UUID testVa) {
        UUID testDsl = this.dslService.create(testVa, "Address", null).getId();
        UUID testDS = this.dataSetService.create(testDsl, "ADR #001").getId();
        Attribute provice = this.attributeService.create(testDsl, Integer.valueOf(0), "Provice", AttributeType.TEXT, null, null);
        return this.parameterService.create(testDS, provice.getId(), "Default", null, null);
    }
}

