/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.macros.impl;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Isolated;
import org.qubership.atp.dataset.config.MockJaversCommitEntityServiceConfiguration;
import org.qubership.atp.dataset.config.TestMacrosConfiguration;
import org.qubership.atp.dataset.macros.impl.ReferenceMacrosTestData;
import org.qubership.atp.dataset.service.AbstractTest;
import org.qubership.atp.dataset.service.direct.EvaluationService;
import org.qubership.atp.dataset.service.direct.macros.DsEvaluator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;

@Isolated
@ContextConfiguration(classes={TestMacrosConfiguration.class, MockJaversCommitEntityServiceConfiguration.class})
public class ReferenceMacrosTest
extends AbstractTest {
    @Autowired
    private EvaluationService evaluationService;

    @Test
    public void testReference() throws Exception {
        ReferenceMacrosTestData d = this.createTestDataInstance(ReferenceMacrosTestData::new);
        try (DsEvaluator evaluator = this.evaluationService.getEvaluator(true, false);){
            String alias = this.wrapperService.wrapToAlias("#REF(DS.DS_ExternalDS.ExternalAttr)", d.va, d.dsl);
            String evaluate = evaluator.evaluateText(d.ds, alias);
            Assertions.assertEquals((Object)d.expectedValue, (Object)evaluate);
        }
    }

    @Test
    public void testReferenceToDsName() throws Exception {
        ReferenceMacrosTestData d = this.createTestDataInstance(ReferenceMacrosTestData::new);
        try (DsEvaluator evaluator = this.evaluationService.getEvaluator(true, false);){
            String alias = this.wrapperService.wrapToAlias("#REF(DS.DS_ExternalDS)", d.va, d.dsl);
            String evaluate = evaluator.evaluateText(d.ds, alias);
            Assertions.assertEquals((Object)d.externalDs.getName(), (Object)evaluate);
        }
    }
}

