/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.macros.impl;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Isolated;
import org.qubership.atp.dataset.config.TestMacrosConfiguration;
import org.qubership.atp.dataset.macros.exception.EvalException;
import org.qubership.atp.dataset.macros.impl.ReferenceMacrosTestData;
import org.qubership.atp.dataset.service.AbstractTest;
import org.qubership.atp.dataset.service.direct.EvaluationService;
import org.qubership.atp.dataset.service.direct.macros.DsEvaluator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.TestPropertySource;

@Isolated
@ContextConfiguration(classes={TestMacrosConfiguration.class})
@TestPropertySource(properties={"atp-dataset.javers.enabled=false"})
public class ReferenceToDslMacrosTest
extends AbstractTest {
    @Autowired
    private EvaluationService evaluationService;

    @Test
    public void testReferenceToDsl() throws EvalException {
        ReferenceMacrosTestData d = this.createTestDataInstance(ReferenceMacrosTestData::new);
        try (DsEvaluator evaluator = this.evaluationService.getEvaluator(true, false);){
            String inputText = this.wrapperService.wrapToAlias("#REF_DSL(ExternalDSL.ExternalDS.ExternalAttr)", d.va, d.dsl);
            String result = evaluator.evaluateText(d.ds, inputText);
            Assertions.assertEquals((Object)d.expectedValue, (Object)result);
        }
    }

    @Test
    public void testReferenceDslHasSameValueAfterReEvaluation() throws EvalException {
        ReferenceMacrosTestData d = this.createTestDataInstance(ReferenceMacrosTestData::new);
        try (DsEvaluator evaluator = this.evaluationService.getEvaluator(true, false);){
            this.parameterService.update(d.param.getId(), "#UUID()");
            String inputText = this.wrapperService.wrapToAlias("#REF_DSL(ExternalDSL.ExternalDS.ExternalAttr)", d.va, d.dsl);
            String result = evaluator.evaluateText(d.ds, inputText);
            String result2 = evaluator.evaluateText(d.ds, inputText);
            Assertions.assertEquals((Object)result, (Object)result2, (String)"Values must be equals");
        }
    }
}

