/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.macros.parser;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.qubership.atp.dataset.macros.parser.ParsingStateTest;
import org.qubership.atp.dataset.macros.parser.Token;
import org.qubership.atp.dataset.macros.parser.TokenType;
import org.qubership.atp.dataset.macros.parser.TokensIterator;

public class TokensIteratorTest {
    private static void validate(String inputMacro, Map.Entry<TokenType, String> ... entries) {
        TokensIterator iterator = new TokensIterator(ParsingStateTest.MACRO_FINDER, new StringBuilder(inputMacro));
        List<Map.Entry<TokenType, String>> er = Arrays.asList(entries);
        List ar = StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 16), false).map(entry -> new ImmutablePair((Object)((TokenType)entry.getKey()), (Object)((String)entry.getValue()))).collect(Collectors.toList());
        Assertions.assertEquals(er, ar);
    }

    private static void testUnionBack(String inputMacro) {
        TokensIterator iterator = new TokensIterator(ParsingStateTest.MACRO_FINDER, new StringBuilder(inputMacro));
        String ar = StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 16), false).map(Token::getSource).collect(Collectors.joining());
        Assertions.assertEquals((Object)inputMacro, (Object)ar);
    }

    @Test
    public void hasNestedMacro_NoExtraArgs_ContainsOnlyFormulas() throws Exception {
        TokensIteratorTest.validate("#REF_DSL(#sum(1,2,3))", new Map.Entry[]{new ImmutablePair((Object)TokenType.FORMULA_START, (Object)"REF_DSL"), new ImmutablePair((Object)TokenType.FORMULA_START, (Object)"sum"), new ImmutablePair((Object)TokenType.FORMULA_END, (Object)"1,2,3"), new ImmutablePair((Object)TokenType.FORMULA_END, (Object)"")});
    }

    @Test
    public void hasTextWithBraces_insideAMacro_ParsedBracesAsText() throws Exception {
        TokensIteratorTest.validate("#REF_DSL(Standard(24h))", new Map.Entry[]{new ImmutablePair((Object)TokenType.FORMULA_START, (Object)"REF_DSL"), new ImmutablePair((Object)TokenType.FORMULA_END, (Object)"Standard(24h)")});
    }

    @Test
    public void hasTextWithBraces_aroundMacro_ParsedBracesAsText() throws Exception {
        TokensIteratorTest.validate("Standard(#REF_DSL(Standard(24h)))", new Map.Entry[]{new ImmutablePair((Object)TokenType.TEXT_PART, (Object)"Standard("), new ImmutablePair((Object)TokenType.FORMULA_START, (Object)"REF_DSL"), new ImmutablePair((Object)TokenType.FORMULA_END, (Object)"Standard(24h)"), new ImmutablePair((Object)TokenType.TEXT_PART, (Object)")")});
    }

    @Test
    public void hasTextWithBraces_doubleInsideAMacro_ParsedBracesAsText() throws Exception {
        TokensIteratorTest.validate("#REF_DSL(Standard(24h),((24h)))", new Map.Entry[]{new ImmutablePair((Object)TokenType.FORMULA_START, (Object)"REF_DSL"), new ImmutablePair((Object)TokenType.FORMULA_END, (Object)"Standard(24h),((24h))")});
    }

    @Test
    public void hasTextWithBraces_aroundDoubleMacro_ParsedBracesAsText() throws Exception {
        TokensIteratorTest.validate("Standard(#REF_DSL(Standard(24h)),#REF_DSL(Standard(24h)))", new Map.Entry[]{new ImmutablePair((Object)TokenType.TEXT_PART, (Object)"Standard("), new ImmutablePair((Object)TokenType.FORMULA_START, (Object)"REF_DSL"), new ImmutablePair((Object)TokenType.FORMULA_END, (Object)"Standard(24h)"), new ImmutablePair((Object)TokenType.TEXT_PART, (Object)","), new ImmutablePair((Object)TokenType.FORMULA_START, (Object)"REF_DSL"), new ImmutablePair((Object)TokenType.FORMULA_END, (Object)"Standard(24h)"), new ImmutablePair((Object)TokenType.TEXT_PART, (Object)")")});
    }

    @Test
    public void text_EndedWithSharp_IsProbablyFormula() throws Exception {
        TokensIteratorTest.validate("123#", new Map.Entry[]{new ImmutablePair((Object)TokenType.PROBABLY_FORMULA, (Object)"123#")});
    }

    @Test
    public void macro_SurroundedWithSharp_EndsWithProbablyFormula() throws Exception {
        TokensIteratorTest.validate("##REF_DSL(1.2.3)#", new Map.Entry[]{new ImmutablePair((Object)TokenType.TEXT_PART, (Object)"#"), new ImmutablePair((Object)TokenType.FORMULA_START, (Object)"REF_DSL"), new ImmutablePair((Object)TokenType.FORMULA_END, (Object)"1.2.3"), new ImmutablePair((Object)TokenType.PROBABLY_FORMULA, (Object)"#")});
    }

    @Test
    public void macro_SurroundedWithText_EndsWithTextPart() throws Exception {
        TokensIteratorTest.validate("first.#REF_DSL(1.2.3).third", new Map.Entry[]{new ImmutablePair((Object)TokenType.TEXT_PART, (Object)"first."), new ImmutablePair((Object)TokenType.FORMULA_START, (Object)"REF_DSL"), new ImmutablePair((Object)TokenType.FORMULA_END, (Object)"1.2.3"), new ImmutablePair((Object)TokenType.TEXT_PART, (Object)".third")});
    }

    @Test
    public void hasNestedMacro_NoExtraArgs_UnitedCorrectly() throws Exception {
        TokensIteratorTest.testUnionBack("#REF_DSL(#sum(1,2,3))");
    }

    @Test
    public void text_EndedWithSharp_UnitedCorrectly() throws Exception {
        TokensIteratorTest.testUnionBack("123#");
    }

    @Test
    public void macro_SurroundedWithSharp_UnitedCorrectly() throws Exception {
        TokensIteratorTest.testUnionBack("##REF_DSL(1.2.3)#");
    }

    @Test
    public void macro_SurroundedWithText_UnitedCorrectly() throws Exception {
        TokensIteratorTest.testUnionBack("first.#REF_DSL(1.2.3).third");
    }
}

