/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.macros.processor;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Objects;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.qubership.atp.dataset.macros.exception.CtxEvalException;
import org.qubership.atp.dataset.macros.exception.EvalException;
import org.qubership.atp.dataset.macros.parser.ParsingStateTest;
import org.qubership.atp.dataset.macros.processor.AbstractMacroProcessor;
import org.qubership.atp.dataset.macros.processor.MacroContextBase;

public class AbstractMacroProcessorTest {
    private static void validate(String inputMacro, String overallEr, EvaluationStep ... steps) throws EvalException {
        final Iterator<EvaluationStep> er = Arrays.asList(steps).iterator();
        TestMacroProcessor p = new TestMacroProcessor(inputMacro){

            @Override
            protected void validate(@Nonnull TestMacroProcessor.TestMacroContext context) throws CtxEvalException {
                if (!er.hasNext()) {
                    throw new IllegalStateException("\nGot unexpected iteration:\n" + new EvaluationStep(context.macro, context.args.toString(), null));
                }
                EvaluationStep erItem = (EvaluationStep)er.next();
                context.text.append(erItem.evaluate(context));
            }
        };
        String ar = p.evaluateAll();
        if (er.hasNext()) {
            String extra = StreamSupport.stream(Spliterators.spliteratorUnknownSize(er, 16), false).map(Objects::toString).collect(Collectors.joining("\n"));
            throw new IllegalStateException("Additional iteration(s) expected:\n" + extra);
        }
        Assertions.assertEquals((Object)overallEr, (Object)ar, (String)"Overall evaluation result is wrong");
    }

    @Test
    public void macroReturnsMacroPart_MacroUnionInsideAnotherMacro_MacroPartEvaluated() throws EvalException {
        String vlookupMacro = "#REF_DSL(InternationalRateCost.#REF_#REF_THIS(OriginCountry.Zone).#REF_THIS(DestinationCountry.Zone))";
        AbstractMacroProcessorTest.validate(vlookupMacro, "end", new EvaluationStep("REF_THIS", "OriginCountry.Zone", "DSL(Countries.EU.From)"), new EvaluationStep("REF_THIS", "DestinationCountry.Zone", "#REF_DSL(Countries.EU.To)"), new EvaluationStep("REF_DSL", "Countries.EU.From", "from"), new EvaluationStep("REF_DSL", "Countries.EU.To", "to"), new EvaluationStep("REF_DSL", "InternationalRateCost.from.to", "end"));
    }

    @Test
    public void macroReturnsAnotherMacro_MacroUnionInsideAnotherMacro_BothAreEvaluated() throws EvalException {
        String vlookupMacro = "#REF_DSL(InternationalRateCost.#REF_THIS(OriginCountry.Zone).#REF_THIS(DestinationCountry.Zone))";
        AbstractMacroProcessorTest.validate(vlookupMacro, "end", new EvaluationStep("REF_THIS", "OriginCountry.Zone", "#REF_DSL(Countries.EU.Any)"), new EvaluationStep("REF_THIS", "DestinationCountry.Zone", "to"), new EvaluationStep("REF_DSL", "Countries.EU.Any", "from"), new EvaluationStep("REF_DSL", "InternationalRateCost.from.to", "end"));
    }

    @Test
    public void macroReturnsAnotherMacro_MacroUnionWithDifferentArgsCountInsideAnotherMacro_BothAreEvaluated() throws EvalException {
        String vlookupMacro = "#REF_DSL(National Rates.#REF_THIS(Subscription.TariffName).#REF_THIS(UsageType))";
        AbstractMacroProcessorTest.validate(vlookupMacro, "0", new EvaluationStep("REF_THIS", "Subscription.TariffName", "Pro Contact"), new EvaluationStep("REF_THIS", "UsageType", "SMS"), new EvaluationStep("REF_DSL", "National Rates.Pro Contact.SMS", "0"));
    }

    @Test
    public void macroReturnsAnotherMacro_insideAnotherMacro_AllAreEvaluated() throws EvalException {
        String vlookupMacro = "#REF_DSL(#REF_THIS(OriginCountry.Zone))";
        AbstractMacroProcessorTest.validate(vlookupMacro, "end", new EvaluationStep("REF_THIS", "OriginCountry.Zone", "#REF_DSL(Countries.EU.Any)"), new EvaluationStep("REF_DSL", "Countries.EU.Any", "from"), new EvaluationStep("REF_DSL", "from", "end"));
    }

    @Test
    public void macroReturnsAnotherMacro_rootMacro_AllAreEvaluated() throws EvalException {
        String vlookupMacro = "#REF_THIS(OriginCountry.Zone)";
        AbstractMacroProcessorTest.validate(vlookupMacro, "end", new EvaluationStep("REF_THIS", "OriginCountry.Zone", "#REF_DSL(Countries.EU.Any)"), new EvaluationStep("REF_DSL", "Countries.EU.Any", "end"));
    }

    @Test
    public void macroReturnsAnotherMacro_complexRootMacro_AllAreEvaluated() throws EvalException {
        String macro = "#REF_DSL(Roaming SMS Rates.#REF_THIS(Account.AccountType).#REF_THIS(OriginCountry.Zone).#REF_THIS(DestinationCountry.Zone))";
        String secondMacro = "#REF_DSL(International Voice Rates.#REF_THIS(Subscription.TariffName).#REF_THIS(UsageType).#REF_THIS(DestinationCountry.IntenationalZone))";
        AbstractMacroProcessorTest.validate(macro, "0.33", new EvaluationStep("REF_THIS", "Account.AccountType", "B2B"), new EvaluationStep("REF_THIS", "OriginCountry.Zone", "Belgium"), new EvaluationStep("REF_THIS", "DestinationCountry.Zone", "Magreb"), new EvaluationStep("REF_DSL", "Roaming SMS Rates.B2B.Belgium.Magreb", secondMacro), new EvaluationStep("REF_THIS", "Subscription.TariffName", "Pro Contact"), new EvaluationStep("REF_THIS", "UsageType", "SMS"), new EvaluationStep("REF_THIS", "DestinationCountry.IntenationalZone", "World 2"), new EvaluationStep("REF_DSL", "International Voice Rates.Pro Contact.SMS.World 2", "0.33"));
    }

    @Test
    public void macroUnion_InsideAnotherMacro_ThreeEvaluationStepsOccurred() throws EvalException {
        String vlookupMacro = "#REF_DSL(InternationalRateCost.#REF_THIS(OriginCountry.Zone).#REF_THIS(DestinationCountry.Zone))";
        AbstractMacroProcessorTest.validate(vlookupMacro, "end", new EvaluationStep("REF_THIS", "OriginCountry.Zone", "1"), new EvaluationStep("REF_THIS", "DestinationCountry.Zone", "2"), new EvaluationStep("REF_DSL", "InternationalRateCost.1.2", "end"));
    }

    @Test
    public void noMacro_textWithSpecialSymbols_NoEvaluationStepsOccurred() throws EvalException {
        String macro = "#just_a text #";
        AbstractMacroProcessorTest.validate(macro, macro, new EvaluationStep[0]);
    }

    @Test
    public void singleMacro_MacroBetweenTextParts_OneEvaluationStepsOccurred() throws EvalException {
        String macro = "#just_a text#REF_DSL(1.2.3)#";
        AbstractMacroProcessorTest.validate(macro, "#just_a text #", new EvaluationStep("REF_DSL", "1.2.3", " "));
    }

    private static abstract class TestMacroProcessor
    extends AbstractMacroProcessor<TestMacroContext> {
        protected TestMacroProcessor(String inputMacro) {
            super(new StringBuilder(inputMacro), ParsingStateTest.MACRO_FINDER);
            this.state = new TestMacroContext();
        }

        protected abstract void validate(@Nonnull TestMacroContext var1) throws CtxEvalException;

        @Nonnull
        protected String getArguments(@Nonnull TestMacroContext context) {
            return context.args.toString();
        }

        @Nonnull
        protected String getText(@Nonnull TestMacroContext context) {
            return context.text.toString();
        }

        protected void dropArguments(@Nonnull TestMacroContext context) {
            context.args.setLength(0);
        }

        protected void dropText(@Nonnull TestMacroContext testMacroContext) {
            testMacroContext.text.setLength(0);
        }

        protected TestMacroContext createChildContext(@Nonnull TestMacroContext parent, @Nonnull String macro) {
            return new TestMacroContext(parent, macro);
        }

        public final class TestMacroContext
        extends MacroContextBase {
            private StringBuilder args;
            private StringBuilder text;
            private String macro;

            public TestMacroContext() {
                this.text = new StringBuilder();
            }

            public TestMacroContext(@Nonnull MacroContextBase parent, String macro) {
                super(parent, macro);
                this.text = new StringBuilder();
                this.initialize(macro);
            }

            protected void pushArguments(@Nonnull String args) {
                this.args.append(args);
            }

            public void initialize(@Nonnull String macro) {
                super.initialize(macro);
                this.macro = macro;
                this.args = new StringBuilder();
            }

            protected void evaluate() throws CtxEvalException {
                this.getProcessor().validate(this);
            }

            protected void pushText(@Nonnull String text) {
                this.text.append(text);
            }

            @Nonnull
            public TestMacroProcessor getProcessor() {
                return TestMacroProcessor.this;
            }
        }
    }

    private static class EvaluationStep {
        public final String macroName;
        public final String macroArgs;
        public final String result;

        private EvaluationStep(String macroName, String macroArgs, String result) {
            this.macroName = macroName;
            this.macroArgs = macroArgs;
            this.result = result;
        }

        public String evaluate(TestMacroProcessor.TestMacroContext context) throws CtxEvalException {
            String macroName = context.macro;
            String macroArgs = context.args.toString();
            Assertions.assertEquals((Object)this, (Object)new EvaluationStep(macroName, macroArgs, this.result), (String)"Unexpected evaluation step");
            return this.result;
        }

        public String toString() {
            return "#" + this.macroName + "(" + this.macroArgs + ")=" + this.result;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof EvaluationStep)) {
                return false;
            }
            EvaluationStep that = (EvaluationStep)o;
            return Objects.equals(this.macroName, that.macroName) && Objects.equals(this.macroArgs, that.macroArgs) && Objects.equals(this.result, that.result);
        }

        public int hashCode() {
            return Objects.hash(this.macroName, this.macroArgs, this.result);
        }
    }
}

