/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.macros.processor;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Isolated;
import org.mockito.Mockito;
import org.qubership.atp.dataset.macros.EvalContextImpl;
import org.qubership.atp.dataset.macros.MacroRegistry;
import org.qubership.atp.dataset.macros.cache.MacroCacheKey;
import org.qubership.atp.dataset.macros.cache.NoCache;
import org.qubership.atp.dataset.macros.exception.CtxEvalException;
import org.qubership.atp.dataset.macros.impl.RefToRefTestData;
import org.qubership.atp.dataset.model.Attribute;
import org.qubership.atp.dataset.model.DataSet;
import org.qubership.atp.dataset.model.DataSetList;
import org.qubership.atp.dataset.model.Identified;
import org.qubership.atp.dataset.model.utils.OverlapItem;
import org.qubership.atp.dataset.model.utils.OverlapIterator;
import org.qubership.atp.dataset.service.direct.AliasWrapperService;
import org.qubership.atp.dataset.service.direct.helper.CreationFacade;
import org.qubership.atp.dataset.service.direct.helper.SimpleCreationFacade;
import org.qubership.atp.dataset.service.direct.macros.EvaluateDsParamStrategyImpl;

@Isolated
public class EvalContextImplTest {
    private static final CreationFacade FACADE = SimpleCreationFacade.INSTANCE;
    private static final MacroRegistry REGISTRY = (MacroRegistry)Mockito.mock(MacroRegistry.class);
    private static final AliasWrapperService ALIAS_WRAPPER_SVC = (AliasWrapperService)Mockito.mock(AliasWrapperService.class);
    private static final TestEvalStrategy EVAL = new TestEvalStrategy(REGISTRY, ALIAS_WRAPPER_SVC);

    private static OverlapItem.Reachable goTo(DataSet ds, Attribute targetAttribute) {
        return ((OverlapItem)OverlapIterator.create((DataSet)ds, (UUID)targetAttribute.getId(), Collections.emptyList()).next()).asReachable();
    }

    private static OverlapItem.Reachable goTo(DataSet ds, Attribute targetAttribute, List<Attribute> attributePath) {
        return ((OverlapItem)OverlapIterator.create((DataSet)ds, (UUID)targetAttribute.getId(), (Collection)attributePath.stream().map(Identified::getId).collect(Collectors.toList())).next()).asReachable();
    }

    private static OverlapItem.Reachable goTo(DataSet ds, Attribute targetAttribute, Attribute ... attributePath) {
        return EvalContextImplTest.goTo(ds, targetAttribute, Arrays.asList(attributePath));
    }

    private static TestEvalContext rootErContext(@Nonnull DataSet ds) {
        return EvalContextImplTest.erContext(null, ds, true, null, Collections.emptyList());
    }

    private static TestEvalContext erContext(@Nullable TestEvalContext parent, @Nonnull DataSet ds, boolean parentIsStrict, @Nullable Attribute targetAttrFromParent, Attribute ... pathFromParent) {
        return EvalContextImplTest.erContext(parent, ds, parentIsStrict, targetAttrFromParent, Arrays.asList(pathFromParent));
    }

    private static TestEvalContext erContext(@Nullable TestEvalContext parent, @Nonnull DataSet ds, boolean parentIsStrict, @Nullable Attribute targetAttrFromParent, @Nonnull List<Attribute> pathFromParent) {
        return new TestEvalContext(parent, REGISTRY, ALIAS_WRAPPER_SVC, ds.getDataSetList(), ds, parentIsStrict, pathFromParent, targetAttrFromParent);
    }

    @BeforeEach
    public void reset() {
        EVAL.reset();
    }

    @Test
    public void refDslToRefThis_ChildRefPointsToUninitializedParameter_GotEmptyString() throws Exception {
        RefToRefTestData.RefDslChildRefTargetParamIsUninitialized data = new RefToRefTestData.RefDslChildRefTargetParamIsUninitialized(FACADE);
        OverlapItem.Reachable nextParam = EvalContextImplTest.goTo(data.currentCase, data.parentRef.getAttribute());
        TestEvalContext parentRefCtx = EvalContextImplTest.rootErContext(data.currentCase);
        TestEvalContext curCtx = EVAL.next(nextParam);
        Assertions.assertEquals((Object)((Object)parentRefCtx), (Object)((Object)curCtx));
        nextParam = EvalContextImplTest.goTo(data.belgium, data.childRef.getAttribute());
        TestEvalContext childRefCtx = EvalContextImplTest.erContext(parentRefCtx, data.belgium, false, data.childRef.getAttribute(), Collections.emptyList());
        curCtx = EVAL.next(nextParam);
        Assertions.assertEquals((Object)((Object)childRefCtx), (Object)((Object)curCtx));
        Assertions.assertEquals((Object)Lists.newArrayList((Object[])new TestEvalContext[]{childRefCtx}), (Object)Lists.newArrayList((Iterator)childRefCtx.getStrictContexts()));
        Assertions.assertEquals((Object)Lists.newArrayList((Object[])new TestEvalContext[]{parentRefCtx}), (Object)Lists.newArrayList((Iterator)childRefCtx.getNonStrictContexts()));
    }

    @Test
    public void refDslToRefThis_ChildRefPointsToUnreachableAttribute_FoundInParentRefContext() throws Exception {
        RefToRefTestData.RefDslChildRefTargetAttrIsUnreachable data = new RefToRefTestData.RefDslChildRefTargetAttrIsUnreachable(FACADE);
        OverlapItem.Reachable nextParam = EvalContextImplTest.goTo(data.currentCase, data.parentRef.getAttribute());
        TestEvalContext parentRefCtx = EvalContextImplTest.rootErContext(data.currentCase);
        TestEvalContext curCtx = EVAL.next(nextParam);
        Assertions.assertEquals((Object)((Object)parentRefCtx), (Object)((Object)curCtx));
        nextParam = EvalContextImplTest.goTo(data.belgium, data.childRef.getAttribute());
        TestEvalContext childRefCtx = EvalContextImplTest.erContext(parentRefCtx, data.belgium, false, data.childRef.getAttribute(), Collections.emptyList());
        curCtx = EVAL.next(nextParam);
        Assertions.assertEquals((Object)((Object)childRefCtx), (Object)((Object)curCtx));
        nextParam = EvalContextImplTest.goTo(data.currentCase, data.capital);
        curCtx = EVAL.next(nextParam);
        Assertions.assertEquals((Object)((Object)parentRefCtx), (Object)((Object)curCtx));
        Assertions.assertEquals((Object)Lists.newArrayList((Object[])new TestEvalContext[]{childRefCtx}), (Object)Lists.newArrayList((Iterator)childRefCtx.getStrictContexts()));
        Assertions.assertEquals((Object)Lists.newArrayList((Object[])new TestEvalContext[]{parentRefCtx}), (Object)Lists.newArrayList((Iterator)childRefCtx.getNonStrictContexts()));
    }

    @Test
    public void refDslToRefThis_ChildRefPointsToInitializedParameter_GotTwoStrictContexts() throws Exception {
        RefToRefTestData.RefDslChildRefTargetParamIsInitialized data = new RefToRefTestData.RefDslChildRefTargetParamIsInitialized(FACADE);
        OverlapItem.Reachable nextParam = EvalContextImplTest.goTo(data.currentCase, data.parentRef.getAttribute());
        TestEvalContext parentRefCtx = EvalContextImplTest.rootErContext(data.currentCase);
        TestEvalContext curCtx = EVAL.next(nextParam);
        Assertions.assertEquals((Object)((Object)parentRefCtx), (Object)((Object)curCtx));
        nextParam = EvalContextImplTest.goTo(data.belgium, data.childRef.getAttribute());
        TestEvalContext childRefCtx = EvalContextImplTest.erContext(parentRefCtx, data.belgium, false, data.childRef.getAttribute(), Collections.emptyList());
        curCtx = EVAL.next(nextParam);
        Assertions.assertEquals((Object)((Object)childRefCtx), (Object)((Object)curCtx));
        nextParam = EvalContextImplTest.goTo(data.belgium, data.brussels.getAttribute());
        curCtx = EVAL.next(nextParam);
        Assertions.assertEquals((Object)((Object)childRefCtx), (Object)((Object)curCtx));
        Assertions.assertEquals((Object)Lists.newArrayList((Object[])new TestEvalContext[]{childRefCtx}), (Object)Lists.newArrayList((Iterator)childRefCtx.getStrictContexts()));
        Assertions.assertEquals((Object)Lists.newArrayList((Object[])new TestEvalContext[]{parentRefCtx}), (Object)Lists.newArrayList((Iterator)childRefCtx.getNonStrictContexts()));
    }

    @Test
    public void refThisToRefThis_ChildRefPointsToUnreachableAttribute_FoundInParentRefContext() throws Exception {
        RefToRefTestData.RefThisChildRefTargetAttrIsUnreachable data = new RefToRefTestData.RefThisChildRefTargetAttrIsUnreachable(FACADE);
        OverlapItem.Reachable nextParam = EvalContextImplTest.goTo(data.currentCase, data.parentRef.getAttribute());
        TestEvalContext parentRefCtx = EvalContextImplTest.rootErContext(data.currentCase);
        TestEvalContext curCtx = EVAL.next(nextParam);
        Assertions.assertEquals((Object)((Object)parentRefCtx), (Object)((Object)curCtx));
        nextParam = EvalContextImplTest.goTo(data.currentCase, data.childRef.getAttribute(), data.currentCaseIntoBelgium.getAttribute());
        TestEvalContext childRefCtx = EvalContextImplTest.erContext(parentRefCtx, data.currentCase, true, data.childRef.getAttribute(), data.currentCaseIntoBelgium.getAttribute());
        curCtx = EVAL.next(nextParam);
        Assertions.assertEquals((Object)((Object)childRefCtx), (Object)((Object)curCtx));
        nextParam = EvalContextImplTest.goTo(data.currentCase, data.capital);
        curCtx = EVAL.next(nextParam);
        Assertions.assertEquals((Object)((Object)parentRefCtx), (Object)((Object)curCtx));
        Assertions.assertEquals((Object)Lists.newArrayList((Object[])new TestEvalContext[]{childRefCtx, parentRefCtx}), (Object)Lists.newArrayList((Iterator)childRefCtx.getStrictContexts()));
        Assertions.assertEquals((Object)Lists.newArrayList((Object[])new TestEvalContext[]{childRefCtx}), (Object)Lists.newArrayList((Iterator)childRefCtx.getNonStrictContexts()));
    }

    @Test
    public void refThisToRefThis_ChildRefPointsToUninitializedParameter_GotEmptyString() throws Exception {
        RefToRefTestData.RefThisChildRefTargetParamIsUninitialized data = new RefToRefTestData.RefThisChildRefTargetParamIsUninitialized(FACADE);
        OverlapItem.Reachable nextParam = EvalContextImplTest.goTo(data.currentCase, data.parentRef.getAttribute());
        TestEvalContext parentRefCtx = EvalContextImplTest.rootErContext(data.currentCase);
        TestEvalContext curCtx = EVAL.next(nextParam);
        Assertions.assertEquals((Object)((Object)parentRefCtx), (Object)((Object)curCtx));
        nextParam = EvalContextImplTest.goTo(data.currentCase, data.childRef.getAttribute(), data.currentCaseIntoBelgium.getAttribute());
        TestEvalContext childRefCtx = EvalContextImplTest.erContext(parentRefCtx, data.currentCase, true, data.childRef.getAttribute(), data.currentCaseIntoBelgium.getAttribute());
        curCtx = EVAL.next(nextParam);
        Assertions.assertEquals((Object)((Object)childRefCtx), (Object)((Object)curCtx));
        nextParam = EvalContextImplTest.goTo(data.currentCase, data.capital, data.currentCaseIntoBelgium.getAttribute());
        curCtx = EVAL.next(nextParam);
        Assertions.assertEquals((Object)((Object)childRefCtx), (Object)((Object)curCtx));
        Assertions.assertEquals((Object)Lists.newArrayList((Object[])new TestEvalContext[]{childRefCtx, parentRefCtx}), (Object)Lists.newArrayList((Iterator)childRefCtx.getStrictContexts()));
        Assertions.assertEquals((Object)Lists.newArrayList((Object[])new TestEvalContext[]{childRefCtx}), (Object)Lists.newArrayList((Iterator)childRefCtx.getNonStrictContexts()));
    }

    @Test
    public void refThisToRefThis_ChildRefIsOverlapped_ContextOfDefaultIsUsed() throws Exception {
        RefToRefTestData.ChildRefIsOverlapped data = new RefToRefTestData.ChildRefIsOverlapped(FACADE);
        OverlapItem.Reachable nextParam = EvalContextImplTest.goTo(data.currentCase, data.parentRef.getAttribute());
        TestEvalContext parentRefCtx = EvalContextImplTest.rootErContext(data.currentCase);
        TestEvalContext curCtx = EVAL.next(nextParam);
        Assertions.assertEquals((Object)((Object)parentRefCtx), (Object)((Object)curCtx));
        nextParam = EvalContextImplTest.goTo(data.currentCase, data.childRef.getAttribute(), data.currentCaseIntoBelgium.getAttribute());
        TestEvalContext childRefCtx = EvalContextImplTest.erContext(parentRefCtx, data.currentCase, true, data.childRef.getAttribute(), data.currentCaseIntoBelgium.getAttribute());
        curCtx = EVAL.next(nextParam);
        Assertions.assertEquals((Object)((Object)childRefCtx), (Object)((Object)curCtx));
        nextParam = EvalContextImplTest.goTo(data.currentCase, data.capital, data.currentCaseIntoBelgium.getAttribute());
        curCtx = EVAL.next(nextParam);
        Assertions.assertEquals((Object)((Object)childRefCtx), (Object)((Object)curCtx));
        Assertions.assertEquals((Object)Lists.newArrayList((Object[])new TestEvalContext[]{childRefCtx, parentRefCtx}), (Object)Lists.newArrayList((Iterator)childRefCtx.getStrictContexts()));
        Assertions.assertEquals((Object)Lists.newArrayList((Object[])new TestEvalContext[]{childRefCtx}), (Object)Lists.newArrayList((Iterator)childRefCtx.getNonStrictContexts()));
    }

    @Test
    public void refThisToRefThis_ChildRefPointsToInitializedParameter_GotThreeStrictContexts() throws Exception {
        RefToRefTestData.RefThisChildRefTargetParamIsInitialized data = new RefToRefTestData.RefThisChildRefTargetParamIsInitialized(FACADE);
        OverlapItem.Reachable nextParam = EvalContextImplTest.goTo(data.currentCase, data.parentRef.getAttribute());
        TestEvalContext parentRefCtx = EvalContextImplTest.rootErContext(data.currentCase);
        TestEvalContext curCtx = EVAL.next(nextParam);
        Assertions.assertEquals((Object)((Object)parentRefCtx), (Object)((Object)curCtx));
        nextParam = EvalContextImplTest.goTo(data.currentCase, data.childRef.getAttribute(), data.currentCaseIntoBelgium.getAttribute());
        TestEvalContext childRefCtx = EvalContextImplTest.erContext(parentRefCtx, data.currentCase, true, data.childRef.getAttribute(), data.currentCaseIntoBelgium.getAttribute());
        curCtx = EVAL.next(nextParam);
        Assertions.assertEquals((Object)((Object)childRefCtx), (Object)((Object)curCtx));
        nextParam = EvalContextImplTest.goTo(data.currentCase, data.brussels.getAttribute(), data.currentCaseIntoBelgium.getAttribute());
        curCtx = EVAL.next(nextParam);
        Assertions.assertEquals((Object)((Object)childRefCtx), (Object)((Object)curCtx));
        Assertions.assertEquals((Object)Lists.newArrayList((Object[])new TestEvalContext[]{childRefCtx, parentRefCtx}), (Object)Lists.newArrayList((Iterator)childRefCtx.getStrictContexts()));
        Assertions.assertEquals((Object)Lists.newArrayList((Object[])new TestEvalContext[]{childRefCtx}), (Object)Lists.newArrayList((Iterator)childRefCtx.getNonStrictContexts()));
    }

    @Test
    public void refThis_RefTargetIsOverlapped_ContextOfOverlapIsUsed() throws Exception {
        RefToRefTestData.RefTargetParamIsOverlapped data = new RefToRefTestData.RefTargetParamIsOverlapped(FACADE);
        OverlapItem.Reachable nextParam = EvalContextImplTest.goTo(data.currentCase, data.childRef.getAttribute(), data.currentCaseIntoBelgium.getAttribute());
        TestEvalContext childRefCtx = EvalContextImplTest.erContext(null, data.currentCase, true, data.childRef.getAttribute(), data.currentCaseIntoBelgium.getAttribute());
        TestEvalContext curCtx = EVAL.next(nextParam);
        Assertions.assertEquals((Object)((Object)childRefCtx), (Object)((Object)curCtx));
        nextParam = EvalContextImplTest.goTo(data.currentCase, data.capital, data.currentCaseIntoBelgium.getAttribute());
        curCtx = EVAL.next(nextParam);
        Assertions.assertEquals((Object)((Object)childRefCtx), (Object)((Object)curCtx));
        Assertions.assertEquals((Object)Lists.newArrayList((Object[])new TestEvalContext[]{childRefCtx}), (Object)Lists.newArrayList((Iterator)childRefCtx.getStrictContexts()));
        Assertions.assertEquals((Object)Lists.newArrayList((Object[])new TestEvalContext[]{childRefCtx}), (Object)Lists.newArrayList((Iterator)childRefCtx.getNonStrictContexts()));
    }

    @Test
    public void refThisToRefThis_RefTargetIsOverlapped_ContextOfOverlapIsUsed() throws Exception {
        RefToRefTestData.ChildRefTargetParamIsOverlapped data = new RefToRefTestData.ChildRefTargetParamIsOverlapped(FACADE);
        OverlapItem.Reachable nextParam = EvalContextImplTest.goTo(data.currentCase, data.parentRef.getAttribute());
        TestEvalContext caseCtx = EvalContextImplTest.rootErContext(data.currentCase);
        TestEvalContext curCtx = EVAL.next(nextParam);
        Assertions.assertEquals((Object)((Object)caseCtx), (Object)((Object)curCtx));
        nextParam = EvalContextImplTest.goTo(data.currentCase, data.childRef.getAttribute(), data.currentCaseIntoBelgium.getAttribute());
        TestEvalContext childRefCtx = EvalContextImplTest.erContext(caseCtx, data.currentCase, true, data.childRef.getAttribute(), data.currentCaseIntoBelgium.getAttribute());
        curCtx = EVAL.next(nextParam);
        Assertions.assertEquals((Object)((Object)childRefCtx), (Object)((Object)curCtx));
        nextParam = EvalContextImplTest.goTo(data.currentCase, data.brussels.getAttribute(), data.currentCaseIntoBelgium.getAttribute());
        curCtx = EVAL.next(nextParam);
        Assertions.assertEquals((Object)((Object)childRefCtx), (Object)((Object)curCtx));
        Assertions.assertEquals((Object)Lists.newArrayList((Object[])new TestEvalContext[]{childRefCtx, caseCtx}), (Object)Lists.newArrayList((Iterator)childRefCtx.getStrictContexts()));
        Assertions.assertEquals((Object)Lists.newArrayList((Object[])new TestEvalContext[]{childRefCtx}), (Object)Lists.newArrayList((Iterator)childRefCtx.getNonStrictContexts()));
    }

    private static class TestEvalContext
    extends EvalContextImpl {
        private static TestEvalContext leaf;

        public TestEvalContext(@Nullable EvalContextImpl parent, @Nonnull MacroRegistry registry, @Nonnull AliasWrapperService wrapperService, @Nonnull DataSetList dsl, @Nonnull DataSet ds, boolean parentIsStrict, @Nonnull List<Attribute> pathFromParent, @Nullable Attribute targetAttrFromParent) {
            super(parent, registry, wrapperService, NoCache.INSTANCE, dsl, ds, parentIsStrict, pathFromParent, targetAttrFromParent);
        }

        @Nonnull
        protected EvalContextImpl createChild(@Nonnull DataSetList dsl, @Nonnull DataSet ds, boolean parentIsStrict, @Nonnull List<Attribute> pathFromParent, @Nonnull Attribute targetAttrFromParent) {
            return new TestEvalContext(this, this.registry, this.wrapperService, dsl, ds, parentIsStrict, pathFromParent, targetAttrFromParent);
        }

        @Nonnull
        protected String evaluate(@Nonnull String inputText, @Nonnull MacroCacheKey cacheKey) throws CtxEvalException {
            leaf = this;
            return inputText;
        }
    }

    private static class TestEvalStrategy
    extends EvaluateDsParamStrategyImpl {
        private TestEvalContext last = null;

        public TestEvalStrategy(@Nonnull MacroRegistry registry, @Nonnull AliasWrapperService wrapperService) {
            super(registry, wrapperService, NoCache.INSTANCE, false);
        }

        @Nonnull
        protected EvalContextImpl createContext(@Nonnull DataSetList dsl, @Nonnull DataSet ds, @Nonnull List<Attribute> pathFromParent, @Nullable Attribute targetAttrFromParent) {
            if (this.last == null) {
                this.last = new TestEvalContext(null, this.registry, this.wrapperService, dsl, ds, true, pathFromParent, targetAttrFromParent);
            }
            return this.last;
        }

        public TestEvalContext next(OverlapItem.Reachable item) {
            this.apply(item);
            return TestEvalContext.leaf;
        }

        void reset() {
            this.last = null;
        }
    }
}

