/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.macros.processor;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.qubership.atp.dataset.macros.EvaluationContext;
import org.qubership.atp.dataset.macros.MacroRegistry;
import org.qubership.atp.dataset.macros.Macros;
import org.qubership.atp.dataset.macros.Position;
import org.qubership.atp.dataset.macros.args.ArgsParser;
import org.qubership.atp.dataset.macros.args.DotSeparatedArgsParser;
import org.qubership.atp.dataset.macros.args.MacroArgFactory;
import org.qubership.atp.dataset.macros.args.MacroArgsFactory;
import org.qubership.atp.dataset.macros.args.SignatureArg;
import org.qubership.atp.dataset.macros.args.TextArg;
import org.qubership.atp.dataset.macros.exception.CtxEvalException;
import org.qubership.atp.dataset.macros.exception.EvalException;
import org.qubership.atp.dataset.macros.parser.ParsingStateTest;
import org.qubership.atp.dataset.macros.processor.RefAliasContext;
import org.qubership.atp.dataset.macros.processor.RefAliasProcessor;

public class RefAliasProcessorTest {
    public static final MacroRegistry MACRO_FINDER = new MacroRegistry(){

        public boolean fullyEquals(String to) {
            return ParsingStateTest.MACRO_FINDER.fullyEquals(to);
        }

        public boolean partiallyEquals(String to) {
            return ParsingStateTest.MACRO_FINDER.partiallyEquals(to);
        }

        @Nonnull
        public Macros getMacros(@Nonnull String key) {
            return new Macros(key.toUpperCase()){

                public Object evaluate(Stream input, EvaluationContext context) throws Exception {
                    throw new UnsupportedOperationException("Mock method");
                }

                public ArgsParser createArgsParser() {
                    return new DotSeparatedArgsParser(new MacroArgsFactory()){

                        protected SignatureArg createArg(int index, @Nonnull MacroArgFactory args) throws Exception {
                            return args.text();
                        }
                    };
                }

                public boolean doCache() {
                    return false;
                }
            };
        }
    };

    private static void validate(String inputMacro, TrackedStep ... steps) throws EvalException {
        final Iterator<TrackedStep> er = Arrays.asList(steps).iterator();
        RefAliasProcessor p = new RefAliasProcessor(MACRO_FINDER, inputMacro){

            protected void notifyRefsFound(RefAliasContext context, ArgsParser.Result args) throws CtxEvalException {
                if (!er.hasNext()) {
                    throw new IllegalStateException("\nGot unexpected iteration:\n" + new TrackedStep(context.macros.getDefinition(), args));
                }
                TrackedStep erItem = (TrackedStep)er.next();
                erItem.validate(context.macros.getDefinition(), args, context.offset);
            }
        };
        p.evaluateAll();
        if (er.hasNext()) {
            String extra = StreamSupport.stream(Spliterators.spliteratorUnknownSize(er, 16), false).map(Objects::toString).collect(Collectors.joining("\n"));
            throw new IllegalStateException("Additional iteration(s) expected:\n" + extra);
        }
    }

    private static SignatureArg text(String text, int start, int end) {
        return TextArg.of((Position)new Position(start, end), (String)text);
    }

    @Test
    public void macroArgs_MacroUnionInsideAnotherMacro_BestEffortMacroParsing() throws EvalException {
        String vlookupMacro = "#REF_DSL(InternationalRateCost.#REF_#REF_THIS(OriginCountry.Zone).#REF_THIS(DestinationCountry.Zone))";
        RefAliasProcessorTest.validate(vlookupMacro, new TrackedStep("REF_THIS", "OriginCountry.Zone", "", new SignatureArg[]{RefAliasProcessorTest.text("OriginCountry", 46, 59), RefAliasProcessorTest.text("Zone", 60, 64)}), new TrackedStep("REF_THIS", "DestinationCountry.Zone", "", new SignatureArg[]{RefAliasProcessorTest.text("DestinationCountry", 76, 94), RefAliasProcessorTest.text("Zone", 95, 99)}), new TrackedStep("REF_DSL", "InternationalRateCost.#REF_", "#REF_", new SignatureArg[]{RefAliasProcessorTest.text("InternationalRateCost", 9, 30)}));
    }

    @Test
    public void macroArgs_MacroInTheMiddleOfAnotherMacro_BestEffortMacroParsing() throws EvalException {
        String vlookupMacro = "#REF_DSL(InternationalRateCost.#REF_#REF_THIS(OriginCountry.Zone).target)";
        RefAliasProcessorTest.validate(vlookupMacro, new TrackedStep("REF_THIS", "OriginCountry.Zone", "", new SignatureArg[]{RefAliasProcessorTest.text("OriginCountry", 46, 59), RefAliasProcessorTest.text("Zone", 60, 64)}), new TrackedStep("REF_DSL", "InternationalRateCost.#REF_", "#REF_", new SignatureArg[]{RefAliasProcessorTest.text("InternationalRateCost", 9, 30)}));
    }

    @Test
    public void macroArgs_ContainsBrackets_Parsed() throws Exception {
        String vlookupMacro = "#REF_DSL(InternationalRateCost(brackets).#REF_#REF_THIS(OriginCountry(brackets).Zone(brackets)).target(brackets))";
        RefAliasProcessorTest.validate(vlookupMacro, new TrackedStep("REF_THIS", "OriginCountry(brackets).Zone(brackets)", "", new SignatureArg[]{RefAliasProcessorTest.text("OriginCountry(brackets)", 56, 79), RefAliasProcessorTest.text("Zone(brackets)", 80, 94)}), new TrackedStep("REF_DSL", "InternationalRateCost(brackets).#REF_", "#REF_", new SignatureArg[]{RefAliasProcessorTest.text("InternationalRateCost(brackets)", 9, 40)}));
    }

    @Test
    public void singleMacro_MacroBetweenTextParts_BestEffortMacroParsing() throws EvalException {
        String macro = "#just_a text#REF_DSL(1.2.3)#";
        RefAliasProcessorTest.validate(macro, new TrackedStep("REF_DSL", "1.2.3", "", new SignatureArg[]{RefAliasProcessorTest.text("1", 21, 22), RefAliasProcessorTest.text("2", 23, 24), RefAliasProcessorTest.text("3", 25, 26)}));
    }

    private static class TrackedStep {
        private final String macroName;
        private final String macroArgs;
        private final String unparsed;
        private final List<SignatureArg> parsed;

        private TrackedStep(String macroName, ArgsParser.Result result) {
            this(macroName, result.toString(), result.getUnparsed().orElse(""), result.getParsed());
        }

        private TrackedStep(String macroName, String macroArgs, String unparsed, SignatureArg ... parsed) {
            this(macroName, macroArgs, unparsed, Arrays.asList(parsed));
        }

        private TrackedStep(String macroName, String macroArgs, String unparsed, List<SignatureArg> parsed) {
            this.macroName = macroName;
            this.macroArgs = macroArgs;
            this.unparsed = unparsed;
            this.parsed = parsed;
        }

        public void validate(String macroName, ArgsParser.Result result, int argsEndPosition) {
            Optional error = result.getError();
            if (error.isPresent()) {
                throw new RuntimeException("Step evaluated with error: " + new TrackedStep(macroName, result), (Throwable)error.get());
            }
            int argsStartPosition = argsEndPosition - result.toString().length();
            for (SignatureArg macroArg : result.getParsed()) {
                Position position = macroArg.getSignature().getPosition();
                position.setStart(position.getStart() + argsStartPosition);
                position.setEnd(position.getEnd() + argsStartPosition);
            }
            Assertions.assertEquals((Object)this, (Object)new TrackedStep(macroName, result), (String)"Unexpected step");
        }

        public String toString() {
            return "#" + this.macroName + "(" + this.macroArgs + ") -> #" + this.macroName + "(parsed:" + this.parsed.stream().map(arg -> arg.getText() + arg.asSignature().map(sig -> sig.getSignature().getPosition().toString()).orElse("null")).collect(Collectors.joining("|")) + " unparsed:" + this.unparsed + ")";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof TrackedStep)) {
                return false;
            }
            TrackedStep that = (TrackedStep)o;
            return Objects.equals(this.macroName, that.macroName) && Objects.equals(this.macroArgs, that.macroArgs) && Objects.equals(this.unparsed, that.unparsed) && Objects.equals(this.parsed, that.parsed);
        }

        public int hashCode() {
            return Objects.hash(this.macroName, this.macroArgs, this.unparsed, this.parsed);
        }
    }
}

