/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.model.utils;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Test;
import org.qubership.atp.dataset.JsonMatcher;
import org.qubership.atp.dataset.model.DataSet;
import org.qubership.atp.dataset.model.utils.AtpDsSerializer;
import org.qubership.atp.dataset.model.utils.AtpDsTestData;
import org.qubership.atp.dataset.model.utils.EvaluatorMock;
import org.qubership.atp.dataset.service.direct.helper.CreationFacade;
import org.qubership.atp.dataset.service.direct.helper.SimpleCreationFacade;
import org.qubership.atp.dataset.service.direct.macros.DsEvaluator;

public class AtpSerializationTest {
    private static final CreationFacade CREATE = SimpleCreationFacade.INSTANCE;

    @Test
    public void dataSet_GroupInGroup_SerializedAsNestedGroups() throws Exception {
        AtpDsTestData.GroupInGroup testData = new AtpDsTestData.GroupInGroup(CREATE);
        String serialized = AtpDsSerializer.writeValueAsString((DataSet)testData.ds, (DsEvaluator)EvaluatorMock.INSTANCE);
        MatcherAssert.assertThat((Object)serialized, (Matcher)JsonMatcher.isMinified(testData.erJson));
    }

    @Test
    public void dataSet_EmptyParameters_SerializedWithoutValue() throws Exception {
        AtpDsTestData.EmptyParameters testData = new AtpDsTestData.EmptyParameters(CREATE);
        String serialized = AtpDsSerializer.writeValueAsString((DataSet)testData.ds, (DsEvaluator)EvaluatorMock.INSTANCE);
        MatcherAssert.assertThat((Object)serialized, (Matcher)JsonMatcher.isMinified(testData.erJson));
    }

    @Test
    public void dataSet_RegularParamsBetweenGroups_ParamsAreFirstAndGroupsAreNext() throws Exception {
        AtpDsTestData.ShuffleGroups testData = new AtpDsTestData.ShuffleGroups(CREATE);
        String serialized = AtpDsSerializer.writeValueAsString((DataSet)testData.ds, (DsEvaluator)EvaluatorMock.INSTANCE);
        MatcherAssert.assertThat((Object)serialized, (Matcher)JsonMatcher.isMinified(testData.erJson));
    }
}

