/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.model.utils;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.qubership.atp.dataset.JsonMatcher;
import org.qubership.atp.dataset.model.DataSet;
import org.qubership.atp.dataset.model.DataSetList;
import org.qubership.atp.dataset.model.utils.EvaluatorMock;
import org.qubership.atp.dataset.model.utils.MultiplyTestData;
import org.qubership.atp.dataset.model.utils.Utils;
import org.qubership.atp.dataset.service.direct.helper.CreationFacade;
import org.qubership.atp.dataset.service.direct.helper.SimpleCreationFacade;
import org.qubership.atp.dataset.service.direct.macros.DsEvaluator;
import org.qubership.atp.dataset.service.rest.dto.manager.UiManDataSetList;

public class ItfMultiplyTest {
    private static final ObjectMapper MAPPER = new ObjectMapper();

    @Test
    public void dataSetWithMixins_serializeInItfWay_shouldContainMixinData() throws IOException {
        MultiplyTestData d = new MultiplyTestData((CreationFacade)SimpleCreationFacade.INSTANCE);
        String expectedJson = "{\n    \"Account\": " + String.format("\"MULTIPLY %s %s\"", d.resCA.getId(), d.b2bCA.getId()) + "    ,\n    \"Subscription\": " + String.format("\"MULTIPLY %s %s %s\"", d.baseCheck.getId(), d.proStart.getId(), d.base.getId()) + "    }\n}";
        ObjectNode actual = Utils.serializeInItfWay((DataSet)d.mix, (ObjectMapper)MAPPER, (DsEvaluator)EvaluatorMock.INSTANCE);
        MatcherAssert.assertThat((Object)MAPPER.writeValueAsString((Object)actual), (Matcher)JsonMatcher.isMinified(expectedJson));
    }

    @Test
    public void dataSetWithMixins_serializeForUI_shouldContainMixinData() throws IOException {
        MultiplyTestData d = new MultiplyTestData((CreationFacade)SimpleCreationFacade.INSTANCE);
        UiManDataSetList actual = Utils.doUiDs((DataSetList)d.mix.getDataSetList(), (DsEvaluator)EvaluatorMock.INSTANCE, (boolean)true);
        MatcherAssert.assertThat((Object)MAPPER.writeValueAsString((Object)actual), (Matcher)JsonMatcher.isMinified(d.expectedJson));
    }

    @Test
    public void multiplication_3x3_got9() {
        List combinations = Utils.combinations((List)ImmutableList.of((Object)ImmutableList.of((Object)"a", (Object)"b", (Object)"c"), (Object)ImmutableList.of((Object)"d", (Object)"e", (Object)"f")), Collectors.joining()).collect(Collectors.toList());
        Assertions.assertEquals((Object)Lists.newArrayList((Object[])new String[]{"ad", "ae", "af", "bd", "be", "bf", "cd", "ce", "cf"}), combinations);
    }
}

