/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.model.utils;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.qubership.atp.dataset.model.Attribute;
import org.qubership.atp.dataset.model.DataSet;
import org.qubership.atp.dataset.model.DataSetList;
import org.qubership.atp.dataset.model.Parameter;
import org.qubership.atp.dataset.model.VisibilityArea;
import org.qubership.atp.dataset.model.utils.EvaluatorMock;
import org.qubership.atp.dataset.model.utils.TestData;
import org.qubership.atp.dataset.model.utils.Utils;
import org.qubership.atp.dataset.service.direct.helper.CreationFacade;
import org.qubership.atp.dataset.service.direct.helper.SimpleCreationFacade;
import org.qubership.atp.dataset.service.direct.macros.DsEvaluator;

public class ItfSerializationTest {
    private static final ObjectMapper MAPPER = new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT);
    private static final CreationFacade CREATE = SimpleCreationFacade.INSTANCE;

    private static DataSet customerWithEmptyCart() {
        DataSet result = ItfSerializationTest.customer1();
        VisibilityArea va = result.getDataSetList().getVisibilityArea();
        DataSet emptyCart = CREATE.ds(va, "emptyCart", "emptyCart1");
        CREATE.refParam(result, "emptyCart1", emptyCart);
        return result;
    }

    private static DataSet customer1() {
        VisibilityArea va = CREATE.va("va");
        DataSet customer1Ds = CREATE.ds(va, "Customer", "Customer1");
        DataSet addressDs = CREATE.ds(va, "Address", "Address1");
        CREATE.textParam(addressDs, "province", "Ontario");
        CREATE.refParam(customer1Ds, "Address1", addressDs);
        return customer1Ds;
    }

    private static DataSet customerWithOverlapsHierarchy() {
        DataSet customer1 = ItfSerializationTest.customer1();
        VisibilityArea va = customer1.getDataSetList().getVisibilityArea();
        Parameter customer1Address1Ref = (Parameter)customer1.getParameters().get(0);
        DataSet address1 = customer1Address1Ref.getDataSetReference();
        DataSet postalCode1 = CREATE.ds(va, "PostalCode", "PC1");
        Parameter firstPartParameter = CREATE.textParam(postalCode1, "firstPart", "A1A");
        Parameter address1PostalCode1Ref = CREATE.refParam(address1, "Postal Code", postalCode1);
        CREATE.overrideParam(address1, firstPartParameter.getAttribute(), "Overlapped by Address1", null, null, null, new Attribute[]{address1PostalCode1Ref.getAttribute()});
        CREATE.overrideParam(customer1, firstPartParameter.getAttribute(), "Overlapped by Customer1", null, null, null, new Attribute[]{customer1Address1Ref.getAttribute(), address1PostalCode1Ref.getAttribute()});
        return customer1;
    }

    private static DataSet customerWithAgeAndAddressAsHomeAndWorkWithOverlap() {
        VisibilityArea va = CREATE.va("va");
        DataSet customer = CREATE.ds(va, "Customer", "DefaultCustomer");
        Parameter age = CREATE.textParam(customer, "Age", "20");
        Parameter ageLV = CREATE.listParam(customer, "AgeLV", "20", new String[]{"10", "20", "30", "40"});
        DataSet address = CREATE.ds(va, "Address", "DefaultAddress");
        Parameter floor = CREATE.textParam(address, "Floor", "3");
        Parameter floorLV = CREATE.listParam(address, "FloorLV", "3", new String[]{"1", "2", "3", "4", "5"});
        Parameter customerToHome = CREATE.refParam(customer, "Home", address);
        Parameter customerToWork = CREATE.refParam(customer, "Work", address);
        CREATE.overrideParam(customer, floorLV.getAttribute(), null, "5", null, null, new Attribute[]{customerToWork.getAttribute()});
        CREATE.overrideParam(customer, floor.getAttribute(), "5", null, null, null, new Attribute[]{customerToWork.getAttribute()});
        return customer;
    }

    @Test
    public void dataSetParametersSerialized() throws Exception {
        String expectedJson = "{\"default\":\"text\",\"group\":{\"default\":\"text2\",\"overridden\":\"text3\"}}";
        DataSet ds = this.testDs();
        JsonNode expected = MAPPER.readTree(expectedJson);
        ObjectNode actual = Utils.serializeInItfWay((DataSet)ds, (ObjectMapper)MAPPER, (DsEvaluator)EvaluatorMock.INSTANCE);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void dataSetParametersSerializedWhenOverlapsInHierarchy() throws Exception {
        String expectedJson = "{\"Address1\":{\"province\":\"Ontario\",\"Postal Code\":{\"firstPart\":\"Overlapped by Customer1\"}}}";
        JsonNode expected = MAPPER.readTree(expectedJson);
        ObjectNode actual = Utils.serializeInItfWay((DataSet)ItfSerializationTest.customerWithOverlapsHierarchy(), (ObjectMapper)MAPPER, (DsEvaluator)EvaluatorMock.INSTANCE);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void dataSetParametersSerializedWhenRefDsIsEmpty() throws Exception {
        String expectedJson = "{\"Address1\":{\"province\":\"Ontario\"}}";
        JsonNode expected = MAPPER.readTree(expectedJson);
        ObjectNode actual = Utils.serializeInItfWay((DataSet)ItfSerializationTest.customerWithEmptyCart(), (ObjectMapper)MAPPER, (DsEvaluator)EvaluatorMock.INSTANCE);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void dataSetParametersSerializedWhenEmpty() throws Exception {
        String expectedJson = "{}";
        DataSet targetDs = CREATE.ds("va", "dsl", "ds");
        JsonNode expected = MAPPER.readTree(expectedJson);
        ObjectNode actual = Utils.serializeInItfWay((DataSet)targetDs, (ObjectMapper)MAPPER, (DsEvaluator)EvaluatorMock.INSTANCE);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void attributesListSerialized() throws Exception {
        String expectedJson = "[\"default\",\"group.default\",\"group.overridden\"]";
        DataSetList dsl = this.testDs().getDataSetList();
        JsonNode expected = MAPPER.readTree(expectedJson);
        ArrayNode actual = Utils.serializeAttrInItfWay((DataSetList)dsl, (ObjectMapper)MAPPER);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void attributesListSerializedWhenRefDsIsEmpty() throws Exception {
        String expectedJson = "[\"Address1.province\"]";
        JsonNode expected = MAPPER.readTree(expectedJson);
        ArrayNode actual = Utils.serializeAttrInItfWay((DataSetList)ItfSerializationTest.customerWithEmptyCart().getDataSetList(), (ObjectMapper)MAPPER);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void dataSetAttributesSerializedWhenNameOfRefIsDifferFromRefTargetName() throws Exception {
        String expectedJson = "[\"Address1.province\",\"Address1.Postal Code.firstPart\"]";
        JsonNode expected = MAPPER.readTree(expectedJson);
        ArrayNode actual = Utils.serializeAttrInItfWay((DataSetList)ItfSerializationTest.customerWithOverlapsHierarchy().getDataSetList(), (ObjectMapper)MAPPER);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void serializeDataSet_SameParameterUsedTwiceAndOneIsOverlapped_NotOverlappedParameterHasDefaultValue() throws Exception {
        String expectedJson = "{\"Age\":\"20\",\"AgeLV\":\"20\",\"Home\":{\"Floor\":\"3\",\"FloorLV\":\"3\"},\"Work\":{\"Floor\":\"5\",\"FloorLV\":\"5\"}}";
        JsonNode expected = MAPPER.readTree(expectedJson);
        ObjectNode actual = Utils.serializeInItfWay((DataSet)ItfSerializationTest.customerWithAgeAndAddressAsHomeAndWorkWithOverlap(), (ObjectMapper)MAPPER, (DsEvaluator)EvaluatorMock.INSTANCE);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void serializeDataSet_SameParameterUsedTwiceAndOneIsOverlappedInTheMiddleGroup_OverlappedParameterHasActualValueAtTopLayer() throws Exception {
        String expectedJson = "{\"Home\":{\"Postal Code\":{\"Code\":\"PC#OfHome\",\"CodeLV\":\"PC#OfHome\"}},\"Work\":{\"Postal Code\":{\"Code\":\"PC#OfWork\",\"CodeLV\":\"PC#OfWork\"}}}";
        JsonNode expected = MAPPER.readTree(expectedJson);
        ObjectNode actual = Utils.serializeInItfWay((DataSet)TestData.customerWithAddressAndPostalCode(CREATE), (ObjectMapper)MAPPER, (DsEvaluator)EvaluatorMock.INSTANCE);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void attributesListSerializedWhenEmpty() throws Exception {
        String expectedJson = "[]";
        DataSet targetDs = CREATE.ds("va", "dsl", "ds");
        JsonNode expected = MAPPER.readTree(expectedJson);
        ArrayNode actual = Utils.serializeAttrInItfWay((DataSetList)targetDs.getDataSetList(), (ObjectMapper)MAPPER);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    private DataSet testDs() {
        VisibilityArea va = CREATE.va("va1");
        DataSet ds1 = CREATE.ds(va, "dsl1", "dsl1_ds1");
        Parameter param1 = CREATE.textParam(ds1, "default", "text");
        ds1.getParameters().add(param1);
        DataSet ds2 = CREATE.ds(va, "dsl2", "dsl2_ds1");
        Parameter ds2Param = CREATE.textParam(ds2, "default", "text2");
        Parameter ds2TextParam2 = CREATE.textParam(ds2, "overridden", "should be overridden");
        ds2.getParameters().add(ds2TextParam2);
        ds2.getParameters().add(ds2Param);
        Parameter group = CREATE.refParam(ds1, "group", ds2);
        ds1.getParameters().add(group);
        Parameter text3 = CREATE.overrideParam(ds1, ds2TextParam2.getAttribute(), "text3", null, null, null, new Attribute[]{group.getAttribute()});
        ds1.getParameters().add(text3);
        return ds1;
    }
}

