/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.model.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.qubership.atp.dataset.JsonMatcher;
import org.qubership.atp.dataset.model.Attribute;
import org.qubership.atp.dataset.model.DataSet;
import org.qubership.atp.dataset.model.DataSetList;
import org.qubership.atp.dataset.model.Identified;
import org.qubership.atp.dataset.model.ListValue;
import org.qubership.atp.dataset.model.Named;
import org.qubership.atp.dataset.model.Parameter;
import org.qubership.atp.dataset.model.VisibilityArea;
import org.qubership.atp.dataset.model.utils.EvaluatorMock;
import org.qubership.atp.dataset.model.utils.Utils;
import org.qubership.atp.dataset.service.direct.helper.CreationFacade;
import org.qubership.atp.dataset.service.direct.helper.SimpleCreationFacade;
import org.qubership.atp.dataset.service.direct.macros.DsEvaluator;
import org.qubership.atp.dataset.service.rest.dto.manager.UiManAttribute;
import org.qubership.atp.dataset.service.rest.dto.manager.UiManDataSetList;
import org.springframework.test.context.junit.jupiter.SpringExtension;

@ExtendWith(value={SpringExtension.class})
public class UiSerializationTest {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final CreationFacade CREATE = SimpleCreationFacade.INSTANCE;

    private static Stream<Arguments> data() {
        return Stream.of(Arguments.of((Object[])new Object[]{"Ds ref parameter missing", UiSerializationTest.concreteAddressNotSpecified()}), Arguments.of((Object[])new Object[]{"Ds ref missing in parameter", UiSerializationTest.concreteAddressNotSpecifiedInParam()}), Arguments.of((Object[])new Object[]{"Ds ref parameter missing, but an overlap exists", UiSerializationTest.concreteAddressSpecifiedByOverlapWithNoDefault()}), Arguments.of((Object[])new Object[]{"Default ds ref is overlapped to a new value", UiSerializationTest.defaultStreetRefIsOverlapped()}));
    }

    private static UiDslTestData concreteAddressNotSpecified() {
        VisibilityArea va = CREATE.va("va");
        DataSet customer1 = CREATE.ds(va, "Customer", "Customer1");
        DataSet addr1 = CREATE.ds(va, "Address", "Address1");
        Parameter streetParam = CREATE.textParam(addr1, "Street", "Polevaya");
        Attribute custToAddr = CREATE.refAttr(customer1.getDataSetList(), "Address", addr1.getDataSetList());
        String erJsonStreet = "{\"id\":\"${attr: Street}\",\"name\":\"Street\",\"type\":\"TEXT\"}";
        String erJsonAddress = "{\"id\":\"${attr: Address}\",\"name\":\"Address\",\"type\":\"DSL\",\"dataSetListReference\":\"${dsl: Address}\",\"attributes\":[" + erJsonStreet + "]}";
        String erJsonDsl = "{\"id\":\"${dsl: Customer}\",\"name\":\"Customer\",\"dataSets\":[{\"id\":\"${ds: Customer1}\",\"name\":\"Customer1\",\"locked\":false}],\"attributes\":[" + erJsonAddress + "]}";
        UiDslTestData td = new UiDslTestData(customer1.getDataSetList(), erJsonDsl);
        UiAttrPathTestData addressTd = new UiAttrPathTestData(customer1, erJsonAddress);
        addressTd.attrPath.add(custToAddr.getId());
        td.uiAttrPathTestData.add(addressTd);
        UiAttrPathTestData streetTd = new UiAttrPathTestData(customer1, erJsonStreet);
        streetTd.attrPath.add(custToAddr.getId());
        streetTd.attrPath.add(streetParam.getAttribute().getId());
        td.uiAttrPathTestData.add(streetTd);
        return td;
    }

    private static UiDslTestData concreteAddressNotSpecifiedInParam() {
        VisibilityArea va = CREATE.va("va");
        DataSet customer1 = CREATE.ds(va, "Customer", "Customer1");
        DataSet addr1 = CREATE.ds(va, "Address", "Address1");
        Parameter streetParam = CREATE.textParam(addr1, "Street", "Polevaya");
        Attribute custToAddr = CREATE.refAttr(customer1.getDataSetList(), "Address", addr1.getDataSetList());
        CREATE.refParam(customer1, custToAddr, null);
        String erJsonStreet = "{\"id\":\"${attr: Street}\",\"name\":\"Street\",\"type\":\"TEXT\"}";
        String erJsonAddress = "{\"id\":\"${attr: Address}\",\"name\":\"Address\",\"type\":\"DSL\",\"dataSetListReference\":\"${dsl: Address}\",\"attributes\":[" + erJsonStreet + "]}";
        String erJsonDsl = "{\"id\":\"${dsl: Customer}\",\"name\":\"Customer\",\"dataSets\":[{\"id\":\"${ds: Customer1}\",\"name\":\"Customer1\",\"locked\":false}],\"attributes\":[" + erJsonAddress + "]}";
        UiDslTestData td = new UiDslTestData(customer1.getDataSetList(), erJsonDsl);
        UiAttrPathTestData addressTd = new UiAttrPathTestData(customer1, erJsonAddress);
        addressTd.attrPath.add(custToAddr.getId());
        td.uiAttrPathTestData.add(addressTd);
        UiAttrPathTestData streetTd = new UiAttrPathTestData(customer1, erJsonStreet);
        streetTd.attrPath.add(custToAddr.getId());
        streetTd.attrPath.add(streetParam.getAttribute().getId());
        td.uiAttrPathTestData.add(streetTd);
        return td;
    }

    private static UiDslTestData concreteAddressSpecifiedByOverlapWithNoDefault() {
        VisibilityArea va = CREATE.va("va");
        DataSet customer1 = CREATE.ds(va, "Customer", "Customer1");
        DataSet addr1 = CREATE.ds(va, "Address", "Address1");
        Parameter streetParam = CREATE.textParam(addr1, "Street", "Polevaya");
        Attribute custToAddr = CREATE.refAttr(customer1.getDataSetList(), "Address", addr1.getDataSetList());
        CREATE.overrideParam(customer1, streetParam.getAttribute(), "Moskovskaya", null, null, null, new Attribute[]{custToAddr});
        String erJsonStreet = "{\"id\":\"${attr: Street}\",\"name\":\"Street\",\"type\":\"TEXT\",\"parameters\":[{\"dataSet\":\"${ds: Customer1}\",\"value\":\"Moskovskaya\",\"overlap\":true}]}";
        String erJsonAddress = "{\"id\":\"${attr: Address}\",\"name\":\"Address\",\"type\":\"DSL\",\"dataSetListReference\":\"${dsl: Address}\",\"attributes\":[" + erJsonStreet + "]}";
        String erJsonDsl = "{\"id\":\"${dsl: Customer}\",\"name\":\"Customer\",\"dataSets\":[{\"id\":\"${ds: Customer1}\",\"name\":\"Customer1\",\"locked\":false}],\"attributes\":[" + erJsonAddress + "]}";
        UiDslTestData td = new UiDslTestData(customer1.getDataSetList(), erJsonDsl);
        UiAttrPathTestData addressTd = new UiAttrPathTestData(customer1, erJsonAddress);
        addressTd.attrPath.add(custToAddr.getId());
        td.uiAttrPathTestData.add(addressTd);
        UiAttrPathTestData streetTd = new UiAttrPathTestData(customer1, erJsonStreet);
        streetTd.attrPath.add(custToAddr.getId());
        streetTd.attrPath.add(streetParam.getAttribute().getId());
        td.uiAttrPathTestData.add(streetTd);
        return td;
    }

    private static UiDslTestData defaultStreetRefIsOverlapped() {
        VisibilityArea va = CREATE.va("va");
        DataSet customer = CREATE.ds(va, "Customer", "Customer1");
        DataSet addr = CREATE.ds(va, "Address", "Address1");
        Parameter custToAddr = CREATE.refParam(customer, "Address", addr);
        DataSet street1 = CREATE.ds(va, "Street", "Street1");
        Parameter streetName1 = CREATE.textParam(street1, "Name", "Polevaya");
        Parameter addrToStreet = CREATE.refParam(addr, "Street", street1);
        DataSet street2 = CREATE.ds(street1.getDataSetList(), "Street2");
        CREATE.textParam(street2, streetName1.getAttribute(), "Moskovskaya");
        CREATE.overrideParam(customer, addrToStreet.getAttribute(), null, null, street2, null, new Attribute[]{custToAddr.getAttribute()});
        String erJsonStreetName = "{\"id\":\"${attr: Name}\",\"name\":\"Name\",\"type\":\"TEXT\",\"parameters\":[{\"dataSet\":\"${ds: Customer1}\",\"value\":\"Moskovskaya\",\"overlap\":false}]}";
        String erJsonStreet = "{\"id\":\"${attr: Street}\",\"name\":\"Street\",\"type\":\"DSL\",\"dataSetListReference\":\"${dsl: Street}\",\"parameters\":[{\"dataSet\":\"${ds: Customer1}\",\"value\":\"Street2\",\"valueRef\":\"${ds: Street2}\",\"overlap\":true}],\"attributes\":[" + erJsonStreetName + "]}";
        String erJsonAddress = "{\"id\":\"${attr: Address}\",\"name\":\"Address\",\"type\":\"DSL\",\"dataSetListReference\":\"${dsl: Address}\",\"parameters\":[{\"dataSet\":\"${ds: Customer1}\",\"value\":\"Address1\",\"valueRef\":\"${ds: Address1}\",\"overlap\":false}],\"attributes\":[" + erJsonStreet + "]}";
        String erJsonDsl = "{\"id\":\"${dsl: Customer}\",\"name\":\"Customer\",\"dataSets\":[{\"id\":\"${ds: Customer1}\",\"name\":\"Customer1\",\"locked\":false}],\"attributes\":[" + erJsonAddress + "]}";
        UiDslTestData td = new UiDslTestData(customer.getDataSetList(), erJsonDsl);
        UiAttrPathTestData addressTd = new UiAttrPathTestData(customer, erJsonAddress);
        addressTd.attrPath.add(custToAddr.getAttribute().getId());
        td.uiAttrPathTestData.add(addressTd);
        UiAttrPathTestData streetTd = new UiAttrPathTestData(customer, erJsonStreet);
        streetTd.attrPath.add(custToAddr.getAttribute().getId());
        streetTd.attrPath.add(addrToStreet.getAttribute().getId());
        td.uiAttrPathTestData.add(streetTd);
        UiAttrPathTestData streetNameTd = new UiAttrPathTestData(customer, erJsonStreetName);
        streetNameTd.attrPath.add(custToAddr.getAttribute().getId());
        streetNameTd.attrPath.add(addrToStreet.getAttribute().getId());
        streetNameTd.attrPath.add(streetName1.getAttribute().getId());
        td.uiAttrPathTestData.add(streetNameTd);
        return td;
    }

    private static String replaceIds(Identified source, String jsonTarget) {
        Iterator items = Utils.allRefs((Identified)source).iterator();
        while (items.hasNext()) {
            Identified next = (Identified)items.next();
            String id = next.getId().toString();
            String name = next instanceof Named ? ((Named)next).getName() : "not_supported";
            String type = next instanceof DataSetList ? "dsl" : (next instanceof Attribute ? "attr" : (next instanceof DataSet ? "ds" : (next instanceof Parameter ? "param" : (next instanceof ListValue ? "lv" : next.getClass().getSimpleName()))));
            jsonTarget = jsonTarget.replaceAll(id, String.format("\\$\\{%s: %s\\}", type, name));
        }
        return jsonTarget;
    }

    private static void assertEquals(Identified source, Object arConverted, String erJson) throws JsonProcessingException {
        String arJson = UiSerializationTest.replaceIds(source, OBJECT_MAPPER.writeValueAsString(arConverted));
        MatcherAssert.assertThat((Object)arJson, (Matcher)JsonMatcher.is(erJson));
    }

    @ParameterizedTest(name="{index}: {0}")
    @MethodSource(value={"data"})
    public void dslSerialization(String str, UiDslTestData uiDslTestData) throws JsonProcessingException {
        UiManDataSetList converted = Utils.doUiDs((DataSetList)uiDslTestData.dsl, (DsEvaluator)EvaluatorMock.INSTANCE, (boolean)true);
        UiSerializationTest.assertEquals((Identified)uiDslTestData.dsl, converted, uiDslTestData.erJson);
    }

    @ParameterizedTest(name="{index}: {0}")
    @MethodSource(value={"data"})
    public void attrPathSerialization(String str, UiDslTestData uiDslTestData) throws IOException {
        for (UiAttrPathTestData data : uiDslTestData.uiAttrPathTestData) {
            UiManAttribute converted = Utils.doUiAttr((DataSet)data.ds, (DsEvaluator)EvaluatorMock.INSTANCE, (List)data.attrPath);
            UiSerializationTest.assertEquals((Identified)data.ds, converted, data.erJson);
        }
    }

    private static class UiDslTestData {
        private final DataSetList dsl;
        private final String erJson;
        private final List<UiAttrPathTestData> uiAttrPathTestData = Lists.newArrayList();

        private UiDslTestData(@Nonnull DataSetList dsl, @Nonnull String erJson) {
            this.dsl = dsl;
            this.erJson = erJson;
        }
    }

    private static class UiAttrPathTestData {
        private final DataSet ds;
        private final String erJson;
        private final List<UUID> attrPath = Lists.newArrayList();

        private UiAttrPathTestData(@Nonnull DataSet ds, @Nonnull String erJson) {
            this.ds = ds;
            this.erJson = erJson;
        }
    }
}

