/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.model.utils;

import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.qubership.atp.dataset.model.Attribute;
import org.qubership.atp.dataset.model.AttributeType;
import org.qubership.atp.dataset.model.DataSet;
import org.qubership.atp.dataset.model.DataSetList;
import org.qubership.atp.dataset.model.ListValue;
import org.qubership.atp.dataset.model.Parameter;
import org.qubership.atp.dataset.model.VisibilityArea;
import org.qubership.atp.dataset.model.utils.EvaluatorMock;
import org.qubership.atp.dataset.model.utils.Utils;
import org.qubership.atp.dataset.service.direct.helper.CreationFacade;
import org.qubership.atp.dataset.service.direct.helper.SimpleCreationFacade;
import org.qubership.atp.dataset.service.direct.macros.DsEvaluator;
import org.qubership.atp.dataset.service.rest.dto.manager.UiManAttribute;
import org.qubership.atp.dataset.service.rest.dto.manager.UiManDataSetList;
import org.qubership.atp.dataset.service.rest.dto.manager.UiManParameter;

public class UtilsTest {
    private static CreationFacade CREATE = SimpleCreationFacade.INSTANCE;

    @Test
    public void test_When_Serialize_Parameter_Ref_Value_Is_Set_For_Ds_param() {
        VisibilityArea va = CREATE.va("test_ds_ref_va");
        DataSetList dsl_source = CREATE.dsl(va, "test_dsl");
        DataSet source = CREATE.ds(dsl_source, "test_ds_ref_ds_source");
        DataSetList dslRef = CREATE.dsl(va, "test_dsl_ref");
        Attribute textAttr = CREATE.attr(dslRef, "text_attr", AttributeType.TEXT, null, null);
        DataSet ref = CREATE.ds(dslRef, "test_ds_ref_ds_ref");
        CREATE.textParam(ref, textAttr, "text");
        CREATE.refParam(source, "ref", ref);
        UiManDataSetList uiManDataSetList = Utils.doUiDs((DataSetList)dsl_source, (DsEvaluator)EvaluatorMock.INSTANCE, (boolean)true);
        List attributes = uiManDataSetList.getAttributes();
        UiManAttribute manAttribute = (UiManAttribute)attributes.get(0);
        UiManParameter manParameter = (UiManParameter)manAttribute.getParameters().get(0);
        Assertions.assertEquals((Object)ref.getId(), (Object)manParameter.getValueRef());
        Assertions.assertEquals((int)1, (int)manAttribute.getAttributes().size());
    }

    @Test
    public void test_thenRefValueIsSetForDsParam_expandAllDisabled_whenRefDsAttributesNotPresent() {
        VisibilityArea va = CREATE.va("test_va");
        DataSetList dsl_source = CREATE.dsl(va, "test_dsl");
        DataSet source = CREATE.ds(dsl_source, "test_ds_ref_ds_source");
        DataSetList dslRef = CREATE.dsl(va, "test_dsl_ref");
        Attribute textAttr = CREATE.attr(dslRef, "text_attr", AttributeType.TEXT, null, null);
        DataSet ref = CREATE.ds(dslRef, "test_ds_ref_ds_ref");
        CREATE.textParam(ref, textAttr, "text");
        CREATE.refParam(source, "ref", ref);
        UiManDataSetList uiManDataSetList = Utils.doUiDs((DataSetList)dsl_source, (DsEvaluator)EvaluatorMock.INSTANCE, (boolean)false);
        List attributes = uiManDataSetList.getAttributes();
        UiManAttribute manAttribute = (UiManAttribute)attributes.get(0);
        UiManParameter manParameter = (UiManParameter)manAttribute.getParameters().get(0);
        Assertions.assertEquals((Object)ref.getId(), (Object)manParameter.getValueRef());
        Assertions.assertEquals((int)0, (int)manAttribute.getAttributes().size());
    }

    @Test
    public void test_When_Serialize_Parameter_RefValue_Is_Set_For_List_Value() {
        VisibilityArea va = CREATE.va("test_lv_ref_va");
        DataSetList dsl = CREATE.dsl(va, "test_lv_ref_dsl");
        DataSet ds = CREATE.ds(dsl, "test_lv_ref_ds");
        String list_val = "list_val";
        Parameter parameter = CREATE.listParam(ds, "list_value_attr", list_val, new String[]{list_val});
        ListValue listValue = (ListValue)parameter.getAttribute().getListValues().get(0);
        UiManDataSetList manDataSetList = Utils.doUiDs((DataSetList)dsl, (DsEvaluator)EvaluatorMock.INSTANCE, (boolean)true);
        UiManAttribute manAttribute = (UiManAttribute)manDataSetList.getAttributes().get(0);
        UiManParameter manParameter = (UiManParameter)manAttribute.getParameters().get(0);
        Assertions.assertEquals((Object)listValue.getId(), (Object)manParameter.getValueRef());
    }
}

