/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.model.utils.tree;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.qubership.atp.dataset.model.utils.tree.LeafsWalker;
import org.qubership.atp.dataset.model.utils.tree.Position;
import org.qubership.atp.dataset.model.utils.tree.TestData;
import org.qubership.atp.dataset.model.utils.tree.TraverseAndLeafsHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LeafsWalkerTest
extends TestData {
    private static final Logger LOG = LoggerFactory.getLogger(LeafsWalkerTest.class);
    LinkedList path = new LinkedList();
    private StringToInt stringToInt = new StringToInt();
    private IntToString intToString = new IntToString();

    @Test
    public void IterateOverTree_OneRoot_TraverseHandlerMethodsInvocationOrderIsCorrect() throws Exception {
        this.animals.printTree(arg_0 -> ((Logger)LOG).info(arg_0));
        Position.ofLeafsWalker(item -> item.children.iterator(), this.animals).toTheNextItem(this.fish, h -> h.checkChildren(this.animals).wentUnder(this.animals).checkChildren(this.fish).leafFound(this.fish), this.animals.getPathInclusive()).toTheNextItem(this.lizard, h -> h.checkChildren(this.reptile).wentUnder(this.reptile).checkChildren(this.lizard).leafFound(this.lizard).wentUpper(1), this.animals.getPathInclusive()).toTheNextItem(this.equine, h -> h.checkChildren(this.mammal).wentUnder(this.mammal).checkChildren(this.equine).leafFound(this.equine), this.mammal.getPathInclusive()).toTheNextItem(this.bovine, h -> h.checkChildren(this.bovine).leafFound(this.bovine).wentUpper(2), Collections.emptyList()).toTheFinish(h -> {});
    }

    @Test
    public void IterateOverMultiTypeTree_MultipleRootsTwoTypes_TraverseHandlerTypeSafeIsGuaranteed() throws Exception {
        LeafsWalker walker = new LeafsWalker((Iterator)ImmutableList.of((Object)"1", (Object)"2").iterator(), (TraverseAndLeafsHandler)this.stringToInt, null);
        Leaf next = (Leaf)walker.next();
        Assertions.assertFalse((boolean)next.isString);
        Assertions.assertEquals((Object)0, (Object)next.leaf);
        Assertions.assertEquals((Object)new LinkedList<Object>(){
            {
                this.add("1");
            }
        }, (Object)next.path);
        next = (Leaf)walker.next();
        Assertions.assertFalse((boolean)next.isString);
        Assertions.assertEquals((Object)0, (Object)next.leaf);
        Assertions.assertEquals((Object)new LinkedList<Object>(){
            {
                this.add("2");
            }
        }, (Object)next.path);
        next = (Leaf)walker.next();
        Assertions.assertTrue((boolean)next.isString);
        Assertions.assertEquals((Object)"0", (Object)next.leaf);
        Assertions.assertEquals((Object)new LinkedList<Object>(){
            {
                this.add("2");
                this.add(1);
            }
        }, (Object)next.path);
    }

    private class StringToInt
    implements TraverseAndLeafsHandler<String, Integer, Leaf> {
        private StringToInt() {
        }

        @Nonnull
        public TraverseAndLeafsHandler<?, String, Leaf> backToPreviousParent() {
            LeafsWalkerTest.this.path.removeLast();
            return LeafsWalkerTest.this.intToString;
        }

        @Nonnull
        public TraverseAndLeafsHandler<Integer, ?, Leaf> forwardToNewParent(@Nonnull String parent) {
            MatcherAssert.assertThat((Object)parent, (Matcher)CoreMatchers.instanceOf(String.class));
            LeafsWalkerTest.this.path.add(parent);
            return LeafsWalkerTest.this.intToString;
        }

        public Iterator<? extends Integer> getChildren(@Nonnull String item) {
            MatcherAssert.assertThat((Object)item, (Matcher)CoreMatchers.instanceOf(String.class));
            int i = Integer.parseInt(item);
            return IntStream.range(0, i).boxed().iterator();
        }

        @Nullable
        public Leaf constructLeaf(@Nonnull String leaf) {
            MatcherAssert.assertThat((Object)leaf, (Matcher)CoreMatchers.instanceOf(String.class));
            return new Leaf(leaf, true, (List)ImmutableList.copyOf((Collection)LeafsWalkerTest.this.path));
        }
    }

    private class IntToString
    implements TraverseAndLeafsHandler<Integer, String, Leaf> {
        private IntToString() {
        }

        @Nonnull
        public TraverseAndLeafsHandler<?, Integer, Leaf> backToPreviousParent() {
            LeafsWalkerTest.this.path.removeLast();
            return LeafsWalkerTest.this.stringToInt;
        }

        @Nonnull
        public TraverseAndLeafsHandler<String, ?, Leaf> forwardToNewParent(@Nonnull Integer parent) {
            MatcherAssert.assertThat((Object)parent, (Matcher)CoreMatchers.instanceOf(Integer.class));
            LeafsWalkerTest.this.path.add(parent);
            return LeafsWalkerTest.this.stringToInt;
        }

        public Iterator<? extends String> getChildren(@Nonnull Integer item) {
            MatcherAssert.assertThat((Object)item, (Matcher)CoreMatchers.instanceOf(Integer.class));
            return IntStream.range(0, item).mapToObj(String::valueOf).iterator();
        }

        @Nullable
        public Leaf constructLeaf(@Nonnull Integer leaf) {
            MatcherAssert.assertThat((Object)leaf, (Matcher)CoreMatchers.instanceOf(Integer.class));
            return new Leaf(leaf, false, (List)ImmutableList.copyOf((Collection)LeafsWalkerTest.this.path));
        }
    }

    private static class Leaf {
        private final Object leaf;
        private final boolean isString;
        private final List path;

        private Leaf(Object leaf, boolean isString, List path) {
            this.leaf = leaf;
            this.isString = isString;
            this.path = path;
        }
    }
}

