/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.model.utils.tree;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.junit.jupiter.api.Assertions;
import org.mockito.ArgumentMatchers;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.qubership.atp.dataset.model.utils.tree.LeafsDetector;
import org.qubership.atp.dataset.model.utils.tree.LeafsWalker;
import org.qubership.atp.dataset.model.utils.tree.TraverseAndLeafsHandler;
import org.qubership.atp.dataset.model.utils.tree.TraverseHandler;
import org.qubership.atp.dataset.model.utils.tree.TraverseHandlerToMock;

class Position<T> {
    private final TraverseHandlerToMock<T> h;
    private final Iterator<T> iterator;
    private final InOrder inOrder;

    private Position(TraverseHandlerToMock<T> h, Iterator<T> iterator, InOrder inOrder) {
        this.h = h;
        this.iterator = iterator;
        this.inOrder = inOrder;
    }

    @SafeVarargs
    public static <T> Position<T> ofLeafsDetector(Function<T, Iterator<? extends T>> childrenSup, T ... roots) {
        return Position.ofLeafsDetector(childrenSup, Arrays.asList(roots).iterator());
    }

    public static <T> Position<T> ofLeafsDetector(Function<T, Iterator<? extends T>> childrenSup, Iterator<? extends T> data) {
        final TraverseHandlerToMock h = (TraverseHandlerToMock)Mockito.spy(new TraverseHandlerToMock<T>(childrenSup));
        LeafsDetector detector = new LeafsDetector<T, T, T>(data, (TraverseHandler)h, null){

            @Nullable
            protected Iterator<? extends T> getChildren(@Nonnull T parent) {
                Iterator result = super.getChildren(parent);
                if (result == null || !result.hasNext()) {
                    h.constructLeaf(parent);
                }
                return result;
            }
        };
        return new Position<T>(h, detector, Mockito.inOrder((Object[])new Object[]{h}));
    }

    @SafeVarargs
    public static <T> Position<T> ofLeafsWalker(Function<T, Iterator<? extends T>> childrenSup, T ... roots) {
        return Position.ofLeafsWalker(childrenSup, Arrays.asList(roots).iterator());
    }

    public static <T> Position<T> ofLeafsWalker(Function<T, Iterator<? extends T>> childrenSup, Iterator<? extends T> data) {
        TraverseHandlerToMock h = new TraverseHandlerToMock(childrenSup);
        h = (TraverseHandlerToMock)Mockito.spy(h);
        LeafsWalker walker = new LeafsWalker(data, (TraverseAndLeafsHandler)h, null);
        return new Position<T>(h, walker, Mockito.inOrder((Object[])new Object[]{h}));
    }

    public Position<T> toTheNextItem(@Nonnull T node, Consumer<HandlerMock> explanation, List<T> nodePath) {
        Mockito.reset((Object[])new TraverseHandlerToMock[]{this.h});
        Assertions.assertTrue((boolean)this.iterator.hasNext());
        T next = this.iterator.next();
        Assertions.assertEquals(node, next);
        this.verifyExplanation(explanation, nodePath);
        return this;
    }

    public Position<T> toTheFinish(Consumer<HandlerMock> explanation) {
        Mockito.reset((Object[])new TraverseHandlerToMock[]{this.h});
        Assertions.assertFalse((boolean)this.iterator.hasNext());
        this.verifyExplanation(explanation, Collections.emptyList());
        return this;
    }

    private void verifyExplanation(Consumer<HandlerMock> explanation, List<T> nodePath) {
        HandlerMock explanationH = new HandlerMock();
        explanation.accept(explanationH);
        explanationH.explained();
        Assertions.assertEquals(nodePath, this.h.currentPath);
    }

    public class HandlerMock {
        public HandlerMock leafFound(@Nonnull T leaf) {
            ((TraverseHandlerToMock)Position.this.inOrder.verify((Object)Position.this.h, Mockito.times((int)1))).constructLeaf(leaf);
            return this;
        }

        public HandlerMock wentUnder(T toItem) {
            ((TraverseHandlerToMock)Position.this.inOrder.verify((Object)Position.this.h, Mockito.times((int)1))).forwardToNewParent(toItem);
            return this;
        }

        public HandlerMock checkChildren(T of) {
            ((TraverseHandlerToMock)Position.this.inOrder.verify((Object)Position.this.h, Mockito.times((int)1))).getChildren(of);
            return this;
        }

        public HandlerMock wentUpper(int times) {
            ((TraverseHandlerToMock)Position.this.inOrder.verify((Object)Position.this.h, Mockito.times((int)times))).backToPreviousParent();
            return this;
        }

        private Position<T> explained() {
            ((TraverseHandlerToMock)Position.this.inOrder.verify((Object)Position.this.h, Mockito.never())).constructLeaf(ArgumentMatchers.any());
            ((TraverseHandlerToMock)Position.this.inOrder.verify((Object)Position.this.h, Mockito.never())).backToPreviousParent();
            ((TraverseHandlerToMock)Position.this.inOrder.verify((Object)Position.this.h, Mockito.never())).getChildren(ArgumentMatchers.any());
            ((TraverseHandlerToMock)Position.this.inOrder.verify((Object)Position.this.h, Mockito.never())).forwardToNewParent(ArgumentMatchers.any());
            return Position.this;
        }
    }
}

