/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.model.utils.tree;

import com.google.common.collect.Iterators;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.qubership.atp.dataset.model.utils.tree.AllRefsIterator;

public class TreeNode<T>
implements Iterable<TreeNode<T>> {
    T data;
    TreeNode<T> parent;
    List<TreeNode<T>> children;

    public TreeNode(T data) {
        this.data = data;
        this.children = new LinkedList<TreeNode<T>>();
    }

    public TreeNode<T> addChild(T child) {
        TreeNode<T> childNode = new TreeNode<T>(child);
        childNode.parent = this;
        this.children.add(childNode);
        return childNode;
    }

    @Override
    public Iterator<TreeNode<T>> iterator() {
        return this.children.iterator();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TreeNode treeNode = (TreeNode)o;
        return Objects.equals(this.data, treeNode.data) && Objects.equals(this.parent, treeNode.parent);
    }

    public int hashCode() {
        return Objects.hash(this.data, this.parent);
    }

    public void printTree(Consumer<String> lines) {
        final AtomicInteger offset = new AtomicInteger(0);
        new AllRefsIterator<TreeNode<T>>((Iterator)Iterators.singletonIterator((Object)this), false){

            @Nullable
            protected Iterator<? extends TreeNode<T>> getChildren(@Nonnull TreeNode<T> parent) {
                return parent.children.iterator();
            }

            protected void forwardToNewParent(TreeNode<T> parent) {
                offset.incrementAndGet();
            }

            protected void backToPreviousParent() {
                offset.decrementAndGet();
            }
        }.forEachRemaining(tTreeNode -> {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < offset.get(); ++i) {
                sb.append("     ");
            }
            sb.append(Objects.toString(tTreeNode.data));
            lines.accept(sb.toString());
        });
    }

    public List<TreeNode<T>> getPathInclusive() {
        List<TreeNode<T>> path = this.getPath();
        path.add(this);
        return path;
    }

    public List<TreeNode<T>> getPath() {
        TreeNode<T> parent = this.parent;
        ArrayList<TreeNode<T>> result = new ArrayList<TreeNode<T>>();
        while (parent != null) {
            result.add(0, parent);
            parent = parent.parent;
        }
        return result;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        if (this.parent != null) {
            result.append(this.parent.toString()).append(">");
        }
        result.append(Objects.toString(this.data.toString()));
        return result.toString();
    }
}

