/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.service.direct;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Optional;
import java.util.UUID;
import org.apache.commons.io.IOUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.io.TempDir;
import org.junit.jupiter.api.parallel.Isolated;
import org.qubership.atp.dataset.config.TestConfiguration;
import org.qubership.atp.dataset.db.GridFsRepository;
import org.qubership.atp.dataset.model.impl.file.FileData;
import org.qubership.atp.dataset.service.AbstractTest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit.jupiter.SpringExtension;

@Isolated
@ExtendWith(value={SpringExtension.class})
@ContextConfiguration(classes={TestConfiguration.class})
public class GridFsServiceTest
extends AbstractTest {
    @Autowired
    private GridFsRepository repository;
    @TempDir
    private Path tempDir;
    private File file;
    private UUID parameterUuid;

    @BeforeEach
    public void setUp() throws Exception {
        this.file = File.createTempFile("junit", null, this.tempDir.toFile());
        this.parameterUuid = UUID.randomUUID();
    }

    @AfterEach
    public void tearDown() {
        this.gridFsService.delete(this.parameterUuid);
    }

    @Test
    public void testUploadToGridFs_FileIsPresentInGridFs() throws IOException {
        this.saveFileToGridFs();
        Assertions.assertTrue((boolean)this.gridFsService.get(this.parameterUuid).isPresent());
    }

    @Test
    public void testDeleteFromGridFs_FileIsDisappearInGridFs() throws IOException {
        this.saveFileToGridFs();
        this.gridFsService.delete(this.parameterUuid);
        Assertions.assertFalse((boolean)this.gridFsService.get(this.parameterUuid).isPresent());
    }

    @Test
    public void testGetFromGridFs_ReturnOneFileWithExpectedContent() throws IOException {
        String er = "<sz>Test</sz>";
        Files.write(this.file.toPath(), er.getBytes(), new OpenOption[0]);
        this.saveFileToGridFs();
        Optional stream = this.gridFsService.get(this.parameterUuid);
        String output = this.getFileContent((InputStream)stream.orElseThrow(() -> new AssertionError((Object)("File not found in gridfs by id: " + this.parameterUuid))));
        Assertions.assertEquals((Object)er, (Object)output);
    }

    private String getFileContent(InputStream stream) throws IOException {
        return IOUtils.toString((InputStream)stream, (Charset)Charset.defaultCharset());
    }

    @Test
    public void testCopyFile_CopyOfFile_isAppeared() throws IOException {
        String er = "<sz>Test</sz>";
        Files.write(this.file.toPath(), er.getBytes(), new OpenOption[0]);
        this.saveFileToGridFs();
        UUID targetParameterUuid = UUID.randomUUID();
        this.gridFsService.copy(this.parameterUuid, targetParameterUuid, false);
        Optional stream = this.gridFsService.get(targetParameterUuid);
        String output = this.getFileContent((InputStream)stream.orElseThrow(() -> new AssertionError((Object)("File not found in gridfs by id: " + targetParameterUuid))));
        Assertions.assertEquals((Object)er, (Object)output);
    }

    @Test
    public void testGetFileInfo_It_Has_FileName_Type_ContentType() throws IOException {
        this.saveFileToGridFs();
        FileData fileInfo = this.gridFsService.getFileInfo(this.parameterUuid);
        Assertions.assertEquals((Object)"xml", (Object)fileInfo.getContentType());
        Assertions.assertEquals((Object)"tmp", (Object)fileInfo.getFileType());
        Assertions.assertEquals((Object)this.file.getName(), (Object)fileInfo.getFileName());
    }

    private void saveFileToGridFs() throws IOException {
        try (FileInputStream inputStream = new FileInputStream(this.file);){
            this.gridFsService.save(new FileData(this.file.getName(), this.parameterUuid, "xml"), (InputStream)inputStream, false);
        }
    }
}

