/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.service.direct;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.collection.IsIterableContainingInAnyOrder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Isolated;
import org.qubership.atp.dataset.JsonMatcher;
import org.qubership.atp.dataset.config.MockJaversCommitEntityServiceConfiguration;
import org.qubership.atp.dataset.config.TestConfiguration;
import org.qubership.atp.dataset.model.DataSet;
import org.qubership.atp.dataset.model.DataSetList;
import org.qubership.atp.dataset.model.Named;
import org.qubership.atp.dataset.model.utils.EvaluatorMock;
import org.qubership.atp.dataset.model.utils.MultiplyTestData;
import org.qubership.atp.dataset.model.utils.Utils;
import org.qubership.atp.dataset.service.AbstractTest;
import org.qubership.atp.dataset.service.direct.macros.DsEvaluator;
import org.qubership.atp.dataset.service.rest.dto.manager.UiManDataSetList;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;

@Isolated
@ContextConfiguration(classes={TestConfiguration.class, MockJaversCommitEntityServiceConfiguration.class})
public class ItfMultiplyTest
extends AbstractTest {
    @Autowired
    ObjectMapper MAPPER;

    @Test
    public void dsWithMixins_SerializeForUI_ContainMixinData() throws IOException {
        MultiplyTestData d = this.createTestDataInstance(MultiplyTestData::new);
        UiManDataSetList actual = Utils.doUiDs((DataSetList)d.mix.getDataSetList(), (DsEvaluator)EvaluatorMock.INSTANCE, (boolean)true);
        MatcherAssert.assertThat((Object)this.MAPPER.writeValueAsString((Object)actual), (Matcher)JsonMatcher.isMinified(d.expectedJson));
    }

    @Test
    public void dsWithMixins_GetAllEvaluated_HasValidNames() throws IOException {
        MultiplyTestData d = this.createTestDataInstance(MultiplyTestData::new);
        List children = this.dataSetListService.getChildren(d.mix.getDataSetList().getId(), true);
        List childrenNames = children.stream().map(Named::getName).collect(Collectors.toList());
        Assertions.assertEquals(MultiplyTestData.DS_NAMES, childrenNames);
    }

    @Test
    public void dsWithMixins_GetAllEvaluated_SerializedProperly() throws IOException {
        MultiplyTestData d = this.createTestDataInstance(MultiplyTestData::new);
        List children = this.dataSetListService.getChildren(d.mix.getDataSetList().getId(), true);
        DataSet ds = children.stream().filter(named -> "Account: B2B, Subscription: Pro Start".equals(named.getName())).findAny().get();
        ObjectNode ar = this.dataSetService.getInItfFormat(ds.getMixInId());
        MatcherAssert.assertThat((Object)this.MAPPER.writeValueAsString((Object)ar), (Matcher)JsonMatcher.isMinified("{  \"Account\" : {    \"AccountNum\" : \"B2B1\",    \"TaxInclusiveBoo\" : \"FALSE\"  },  \"Subscription\" : {    \"ProductId\" : \"10002\",    \"TariffId\" : \"10036\"  }}"));
    }

    @Test
    public void dsWithMixins_GetAllEvaluated_everyDsIsDifferent() {
        MultiplyTestData d = this.createTestDataInstance(MultiplyTestData::new);
        List children = this.dataSetListService.getChildren(d.mix.getDataSetList().getId(), true);
        HashSet ar = Sets.newHashSet((Iterable)children);
        MatcherAssert.assertThat((Object)children, (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])ar.toArray()));
    }
}

