/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.service.direct;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import org.junit.After;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Isolated;
import org.qubership.atp.dataset.config.TestConfiguration;
import org.qubership.atp.dataset.model.Attribute;
import org.qubership.atp.dataset.model.DataSet;
import org.qubership.atp.dataset.model.DataSetList;
import org.qubership.atp.dataset.model.Parameter;
import org.qubership.atp.dataset.model.VisibilityArea;
import org.qubership.atp.dataset.service.AbstractTest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.TestPropertySource;

@Isolated
@ContextConfiguration(classes={TestConfiguration.class})
@TestPropertySource(properties={"atp-dataset.javers.enabled=false"})
public class ItfSerializationTest
extends AbstractTest {
    @Autowired
    ObjectMapper mapper;
    private VisibilityArea va;
    private DataSet parentWithOverlap;
    private DataSet parentWithoutOverlap;
    private DataSet child1;
    private Attribute childAttr;
    private Parameter parentChild1;

    @BeforeEach
    public void setUp() {
        this.va = this.factory.va("ItfSerializationTest");
        this.child1 = this.factory.ds(this.va, "Child", "Child1");
        this.childAttr = this.factory.textAttr(this.child1.getDataSetList(), "Without parameter");
        this.parentWithOverlap = this.factory.ds(this.va, "Parent", "parentWithOverlap");
        this.parentWithoutOverlap = this.factory.ds(this.parentWithOverlap.getDataSetList(), "parentWithoutOverlap");
        this.parentChild1 = this.factory.refParam(this.parentWithOverlap, "Child", this.child1);
        this.factory.refParam(this.parentWithoutOverlap, this.parentChild1.getAttribute(), this.child1);
        this.factory.overrideParam(this.parentWithOverlap, this.childAttr, "Overlap", null, null, null, new Attribute[]{this.parentChild1.getAttribute()});
    }

    @After
    public void destroy() {
        this.visibilityAreaService.delete(this.va.getId());
    }

    @Test
    public void serializeDataSet_ParameterOverlapHasNoDefaultParameter_OverlappedParameterHandled() throws IOException {
        String expectedJson = "{\"Child\":{\"Without parameter\":\"Overlap\"}}";
        JsonNode expected = this.mapper.readTree(expectedJson);
        ObjectNode actual = this.dataSetService.getInItfFormat(this.parentWithOverlap.getMixInId());
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void targetParameterSerializedWhenItIsNotInitialized() throws IOException {
        String expectedJson = "{\"Child\":{\"Without parameter\":\"\"}}";
        JsonNode expected = this.mapper.readTree(expectedJson);
        ObjectNode actual = this.dataSetService.getInItfFormat(this.parentWithoutOverlap.getMixInId());
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void overlapSerializedWhenItIsRecreatedAsListValue() throws IOException {
        this.attributeService.delete(this.childAttr.getId());
        this.childAttr = this.factory.listAttr(this.child1.getDataSetList(), "Without parameter", new String[]{"", "Overlap"});
        this.factory.overrideParam(this.parentWithOverlap, this.childAttr, null, "Overlap", null, null, new Attribute[]{this.parentChild1.getAttribute()});
        String expectedJson = "{\"Child\":{\"Without parameter\":\"Overlap\"}}";
        JsonNode expected = this.mapper.readTree(expectedJson);
        ObjectNode actual = this.dataSetService.getInItfFormat(this.parentWithOverlap.getMixInId());
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void targetParameterSerializedWhenItIsRecreatedAsListValue() throws IOException {
        this.attributeService.delete(this.childAttr.getId());
        this.childAttr = this.factory.listAttr(this.child1.getDataSetList(), "Without parameter", new String[]{"", "Overlap"});
        String expectedJson = "{\"Child\":{\"Without parameter\":\"\"}}";
        JsonNode expected = this.mapper.readTree(expectedJson);
        ObjectNode actual = this.dataSetService.getInItfFormat(this.parentWithOverlap.getMixInId());
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Disabled
    @Test
    public void targetDslParameterSerializedWhenItIsNotInitialized() throws IOException {
        Attribute link_to_ds = this.factory.refAttr(this.parentWithoutOverlap.getDataSetList(), "Link To DS", this.child1.getDataSetList());
        this.factory.refParam(this.parentWithoutOverlap, link_to_ds, null);
        String expectedJson = "{\"Child\":{\"Without parameter\":\"Overlap\"}, \"Link To DS\": \"\"}";
        JsonNode expected = this.mapper.readTree(expectedJson);
        ObjectNode actual = this.dataSetService.getInItfFormat(this.parentWithOverlap.getMixInId());
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void itfIntegration_calculateReferencesFormulas_valueIsTheSameAsReferencedValue() {
        DataSet[] rootDs_1 = new DataSet[1];
        VisibilityArea va = super.createTestData(f -> {
            VisibilityArea resultVa = f.va("ATPII-1508");
            DataSetList dslRoot = f.dsl(resultVa, "root");
            rootDs_1[0] = f.ds(dslRoot, "ds");
            DataSetList dls_child_1 = f.dsl(resultVa, "dsl_child_1");
            DataSet ds_child_1 = f.ds(dls_child_1, "ds_child_1");
            DataSetList dls_child_2 = f.dsl(resultVa, "dsl_child_2");
            DataSet ds_child_2 = f.ds(dls_child_2, "ds_child_2");
            f.textParam(ds_child_2, "random_text", "#RANDOMBETWEEN(10, 100)");
            f.refParam(rootDs_1[0], "ref_to_ds_child_1", ds_child_1);
            f.refParam(rootDs_1[0], "ref_to_ds_child_2", ds_child_2);
            f.textParam(ds_child_1, "reference_to_random_text_from_child_1", "#REF_DSL(dsl_child_2.ds_child_2.random_text)");
            f.textParam(rootDs_1[0], "reference_to_random_text", "#REF_DSL(dsl_child_2.ds_child_2.random_text)");
            return resultVa;
        });
        ObjectNode result = this.dataSetService.getInItfFormat(rootDs_1[0].getMixInId());
        Assertions.assertNotEquals((Object)result.get("ref_to_ds_child_1").get("reference_to_random_text_from_child_1").textValue(), (Object)result.get("ref_to_ds_child_2").get("random_text").textValue());
        Assertions.assertNotEquals((Object)result.get("reference_to_random_text").textValue(), (Object)result.get("ref_to_ds_child_2").get("random_text").textValue());
    }
}

