/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.service.direct;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Isolated;
import org.qubership.atp.dataset.TestUtils;
import org.qubership.atp.dataset.config.TestConfiguration;
import org.qubership.atp.dataset.model.Attribute;
import org.qubership.atp.dataset.model.AttributeType;
import org.qubership.atp.dataset.model.DataSet;
import org.qubership.atp.dataset.model.DataSetList;
import org.qubership.atp.dataset.model.Identified;
import org.qubership.atp.dataset.model.ListValue;
import org.qubership.atp.dataset.model.Parameter;
import org.qubership.atp.dataset.model.impl.TableResponse;
import org.qubership.atp.dataset.model.utils.OverlapItem;
import org.qubership.atp.dataset.model.utils.OverlapIterator;
import org.qubership.atp.dataset.service.AbstractTest;
import org.qubership.atp.dataset.service.direct.DuplicateKeyException;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.TestPropertySource;

@Isolated
@ContextConfiguration(classes={TestConfiguration.class})
@TestPropertySource(properties={"atp-dataset.javers.enabled=false"})
public class ParameterServiceTest
extends AbstractTest {
    private UUID visibilityAreaId;
    private UUID dataSetListId;
    private List<String> listValues = new ArrayList<String>(Arrays.asList("ListValue1", "ListValue2"));
    private List<String> dataSetNames = new ArrayList<String>(Arrays.asList("DataSet1", "DataSet2"));
    private List<String> parameterTextValues = new ArrayList<String>(Arrays.asList("ParameterValue1", "ParameterValue2"));

    @BeforeEach
    public void setUp() {
        this.visibilityAreaId = this.visibilityAreaService.create("ParameterServiceTestVa").getId();
        this.dataSetListId = this.dataSetListService.create(this.visibilityAreaId, "ParameterServiceTestDsl1", null).getId();
    }

    @AfterEach
    public void tearDown() {
        this.visibilityAreaService.delete(this.visibilityAreaId);
    }

    @Test
    public void createTextParameter_withAllParameterValues_onlyTextNotNull() {
        String expectedTextValue = this.parameterTextValues.get(0);
        UUID parameterId = this.createParameterWithDataSetAnAllValues(AttributeType.TEXT, this.dataSetNames.get(0), expectedTextValue, null, null);
        this.verifyParameterTextValue(parameterId, expectedTextValue);
    }

    @Test
    public void createListParameter_withAllParameterValues_onlyListNotNull() {
        String expectedListValueName = this.listValues.get(0);
        UUID parameterId = this.createParameterWithDataSetAnAllValues(AttributeType.LIST, this.dataSetNames.get(0), null, expectedListValueName, null);
        this.verifyParameterListValue(parameterId, expectedListValueName);
    }

    @Test
    public void createReferenceParameter_withAllParameterValues_onlyReferenceNotNull() {
        String expectedReferencedDataSetName = this.dataSetNames.get(1);
        UUID parameterId = this.createParameterWithDataSetAnAllValues(AttributeType.DSL, this.dataSetNames.get(0), null, null, expectedReferencedDataSetName);
        this.verifyParameterReferenceValue(parameterId, expectedReferencedDataSetName);
    }

    @Test
    public void updateTextParameter_withAllParameterValues_onlyTextNotNull() {
        UUID parameterId = this.createParameterWithDataSetAnAllValues(AttributeType.TEXT, this.dataSetNames.get(0), this.parameterTextValues.get(0), null, null);
        String updatedTextValue = this.parameterTextValues.get(1);
        this.parameterService.update(parameterId, updatedTextValue);
        this.verifyParameterTextValue(parameterId, updatedTextValue);
    }

    @Disabled
    @Test
    public void overlapParameter_withTwoDSLs_overlapIsComputedProperly() throws DuplicateKeyException {
        UUID postalCodeDataSetListId = this.dataSetListService.create(this.visibilityAreaId, "PostalCode", null).getId();
        DataSet postalCodeDataSet = this.dataSetService.create(postalCodeDataSetListId, "PC#1");
        Attribute codeAttribute = this.attributeService.create(postalCodeDataSetListId, Integer.valueOf(0), "Code", AttributeType.TEXT, null, null);
        String codeOriginalValue = "OriginalValue";
        this.parameterService.create(postalCodeDataSet.getId(), codeAttribute.getId(), codeOriginalValue, null, null);
        UUID addressDataSetList = this.dataSetListService.create(this.visibilityAreaId, "Address", null).getId();
        DataSet addressDataSet1 = this.dataSetService.create(addressDataSetList, "ADR#1");
        Attribute postalCodeReferenceAttribute = this.attributeService.create(addressDataSetList, Integer.valueOf(0), "PostalCodeRef", AttributeType.DSL, postalCodeDataSetListId, null);
        this.parameterService.create(addressDataSet1.getId(), postalCodeReferenceAttribute.getId(), null, null, postalCodeDataSet.getId());
        String codeOverlappedByAddressValue = "Overlapped by address";
        this.parameterService.set(addressDataSet1.getId(), codeAttribute.getId(), (List)ImmutableList.of((Object)postalCodeReferenceAttribute.getId()), codeOverlappedByAddressValue, null, null);
        UUID customerDataSetList = this.dataSetListService.create(this.visibilityAreaId, "Customer", null).getId();
        DataSet customerDataSet = this.dataSetService.create(customerDataSetList, "Customer1");
        Attribute addressReferenceAttribute = this.attributeService.create(customerDataSetList, Integer.valueOf(0), "AddressRef", AttributeType.DSL, addressDataSetList, null);
        this.parameterService.create(customerDataSet.getId(), addressReferenceAttribute.getId(), null, null, addressDataSet1.getId());
        String codeOverlappedByCustomerValue = "Overlapped by customer";
        this.parameterService.set(customerDataSet.getId(), codeAttribute.getId(), (List)ImmutableList.of((Object)addressReferenceAttribute.getId(), (Object)postalCodeReferenceAttribute.getId()), codeOverlappedByCustomerValue, null, null);
        Parameter actualCode = (Parameter)((OverlapItem)OverlapIterator.create((DataSet)customerDataSet, (UUID)codeAttribute.getId(), (Collection)ImmutableList.of((Object)addressReferenceAttribute.getId(), (Object)postalCodeReferenceAttribute.getId())).next()).getParameter().get();
        Assertions.assertEquals((Object)codeOverlappedByCustomerValue, (Object)actualCode.getText());
        this.parameterService.delete(actualCode);
        customerDataSet = (DataSet)this.dataSetService.get(customerDataSet.getId());
        actualCode = (Parameter)((OverlapItem)OverlapIterator.create((DataSet)customerDataSet, (UUID)codeAttribute.getId(), (Collection)ImmutableList.of((Object)addressReferenceAttribute.getId(), (Object)postalCodeReferenceAttribute.getId())).next()).getParameter().get();
        Assertions.assertEquals((Object)codeOverlappedByAddressValue, (Object)actualCode.getText());
        actualCode = this.dataSetService.deleteParameterOverlap(addressDataSet1.getId(), codeAttribute.getId(), (List)ImmutableList.of((Object)postalCodeReferenceAttribute.getId()));
        Assertions.assertEquals((Object)codeOriginalValue, (Object)actualCode.getText());
    }

    @Test
    public void setValue_updateParameterWithLockDataSet_notUpdateParameterThrowException() throws DuplicateKeyException {
        UUID postalCodeDataSetListId = this.dataSetListService.create(this.visibilityAreaId, "PostalCode", null).getId();
        DataSet postalCodeDataSet = this.dataSetService.create(postalCodeDataSetListId, "PC#1");
        Attribute codeAttribute = this.attributeService.create(postalCodeDataSetListId, Integer.valueOf(0), "Code", AttributeType.TEXT, null, null);
        String codeOriginalValue = "OriginalValue";
        this.parameterService.create(postalCodeDataSet.getId(), codeAttribute.getId(), codeOriginalValue, null, null);
        String codeNewValue = "newValue";
        this.dataSetService.lock(postalCodeDataSetListId, Collections.singletonList(postalCodeDataSet.getId()), true);
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.parameterService.set(postalCodeDataSet.getId(), codeAttribute.getId(), Collections.emptyList(), codeNewValue, null, null));
    }

    @Test
    public void checkGetAffectedParametersByListValue_twoDataSetsInList_returnTwoParams() throws DuplicateKeyException {
        UUID dataSetList = this.dataSetListService.create(this.visibilityAreaId, "dsl", null).getId();
        DataSet dataSet1 = this.dataSetService.create(dataSetList, "ds1");
        DataSet dataSet2 = this.dataSetService.create(dataSetList, "ds2");
        Attribute listAttr = this.attributeService.create(dataSetList, Integer.valueOf(0), "lvAttr", AttributeType.LIST, null, Arrays.asList("Value1", "Value2"));
        ListValue listValueToDelete = (ListValue)listAttr.getListValues().get(0);
        Parameter param1 = this.parameterService.create(dataSet1.getId(), listAttr.getId(), null, listValueToDelete.getId(), null);
        Parameter param2 = this.parameterService.create(dataSet2.getId(), listAttr.getId(), null, listValueToDelete.getId(), null);
        List result = this.parameterService.getParametersAffectedByListValue(listValueToDelete.getId(), true);
        Assertions.assertEquals((int)2, (int)result.size());
        Assertions.assertTrue((boolean)(result.get(0) instanceof TableResponse));
        List possibleResponse = result;
        List ids = possibleResponse.stream().map(TableResponse::getId).collect(Collectors.toList());
        MatcherAssert.assertThat((String)"Contains in any order", Arrays.asList(param1.getId(), param2.getId()), (Matcher)Matchers.containsInAnyOrder((Object[])ids.toArray()));
    }

    @Test
    public void checkGetAffectedParametersByListValues_twoAndOneParamsAndThreeParams_returnThreeParams() throws DuplicateKeyException {
        UUID dataSetListId = this.dataSetListService.create(this.visibilityAreaId, "dsl", null).getId();
        DataSet dataSet1 = this.dataSetService.create(dataSetListId, "ds1");
        DataSet dataSet2 = this.dataSetService.create(dataSetListId, "ds2");
        DataSet dataSet3 = this.dataSetService.create(dataSetListId, "ds3");
        Attribute listAttr = this.attributeService.create(dataSetListId, Integer.valueOf(0), "lvAttr", AttributeType.LIST, null, Arrays.asList("Value1", "Value2", "Value3"));
        ListValue listValueToDelete1 = (ListValue)listAttr.getListValues().get(0);
        ListValue listValueToDelete2 = (ListValue)listAttr.getListValues().get(2);
        Parameter param1 = this.parameterService.create(dataSet1.getId(), listAttr.getId(), null, listValueToDelete1.getId(), null);
        Parameter param2 = this.parameterService.create(dataSet2.getId(), listAttr.getId(), null, listValueToDelete1.getId(), null);
        Parameter param3 = this.parameterService.create(dataSet3.getId(), listAttr.getId(), null, listValueToDelete2.getId(), null);
        List result = this.parameterService.getParametersAffectedByListValues(Arrays.asList(listValueToDelete1.getId(), listValueToDelete2.getId()));
        Assertions.assertEquals((int)3, (int)result.size());
        Assertions.assertTrue((boolean)(result.get(0) instanceof TableResponse));
        List possibleResponse = result;
        List ids = possibleResponse.stream().map(TableResponse::getId).collect(Collectors.toList());
        MatcherAssert.assertThat((String)"Contains in any order", Arrays.asList(param1.getId(), param2.getId(), param3.getId()), (Matcher)Matchers.containsInAnyOrder((Object[])ids.toArray()));
    }

    @Test
    public void bulkUpdateParametersListValue_twoParams_parametersUpdatedSuccessfully() throws DuplicateKeyException {
        UUID dataSetListId = this.dataSetListService.create(this.visibilityAreaId, "dsl", null).getId();
        DataSet dataSet1 = this.dataSetService.create(dataSetListId, "ds1");
        DataSet dataSet2 = this.dataSetService.create(dataSetListId, "ds2");
        Attribute listAttr = this.attributeService.create(dataSetListId, Integer.valueOf(0), "lvAttr", AttributeType.LIST, null, Arrays.asList("123", "234"));
        ListValue listValueOriginal = (ListValue)listAttr.getListValues().get(0);
        ListValue listValueChanged = (ListValue)listAttr.getListValues().get(1);
        Parameter param1 = this.parameterService.create(dataSet1.getId(), listAttr.getId(), null, listValueOriginal.getId(), null);
        Parameter param2 = this.parameterService.create(dataSet2.getId(), listAttr.getId(), null, listValueOriginal.getId(), null);
        this.parameterService.bulkUpdateValue(null, null, listValueChanged.getId(), Arrays.asList(param1.getId(), param2.getId()));
        Parameter updatedParam1 = (Parameter)this.parameterService.get(param1.getId());
        Parameter updatedParam2 = (Parameter)this.parameterService.get(param2.getId());
        Assertions.assertEquals((Object)listValueChanged.getId(), (Object)updatedParam1.getListValue().getId());
        Assertions.assertEquals((Object)listValueChanged.getId(), (Object)updatedParam2.getListValue().getId());
    }

    @Test
    public void bulkUpdateParametersReferences_twoParameters_parametersUpdatedSuccessfully() throws DuplicateKeyException {
        UUID dataSetList1Id = this.dataSetListService.create(this.visibilityAreaId, "dsl1", null).getId();
        UUID dataSetList2Id = this.dataSetListService.create(this.visibilityAreaId, "dsl2", null).getId();
        DataSet dataSet11 = this.dataSetService.create(dataSetList1Id, "ds11");
        DataSet dataSet12 = this.dataSetService.create(dataSetList1Id, "ds12");
        DataSet dataSet21 = this.dataSetService.create(dataSetList2Id, "ds21");
        DataSet dataSet22 = this.dataSetService.create(dataSetList2Id, "ds22");
        DataSet dataSet23 = this.dataSetService.create(dataSetList2Id, "ds23");
        Attribute dsRefAttr = this.attributeService.create(dataSetList1Id, Integer.valueOf(0), "dsAttr", AttributeType.DSL, dataSetList2Id, null);
        Parameter param1 = this.parameterService.create(dataSet11.getId(), dsRefAttr.getId(), null, null, dataSet21.getId());
        Parameter param2 = this.parameterService.create(dataSet12.getId(), dsRefAttr.getId(), null, null, dataSet22.getId());
        this.parameterService.bulkUpdateValue((String)null, dataSet23.getId(), null, Arrays.asList(param1.getId(), param2.getId()));
        Parameter updatedParam1 = (Parameter)this.parameterService.get(param1.getId());
        Parameter updatedParam2 = (Parameter)this.parameterService.get(param2.getId());
        Assertions.assertEquals((Object)dataSet23.getId(), (Object)updatedParam1.getDataSetReference().getId());
        Assertions.assertEquals((Object)dataSet23.getId(), (Object)updatedParam2.getDataSetReference().getId());
    }

    @Test
    public void bulkUpdate_dataSet2Locked_param1UpdatedAndParam2Skipped() throws DuplicateKeyException {
        this.dataSetListId = this.dataSetListService.create(this.visibilityAreaId, "PostalCode", null).getId();
        DataSet dataSet1 = this.dataSetService.create(this.dataSetListId, "PC#1");
        DataSet dataSet2 = this.dataSetService.create(this.dataSetListId, "PC#2");
        Attribute attribute = this.attributeService.create(this.dataSetListId, Integer.valueOf(0), "Code", AttributeType.TEXT, null, null);
        String codeOriginalValue1 = "OriginalValue1";
        String codeOriginalValue2 = "OriginalValue2";
        Parameter param1 = this.parameterService.create(dataSet1.getId(), attribute.getId(), codeOriginalValue1, null, null);
        Parameter param2 = this.parameterService.create(dataSet2.getId(), attribute.getId(), codeOriginalValue2, null, null);
        String updateValue = "updateValue";
        this.dataSetService.lock(this.dataSetListId, Collections.singletonList(dataSet2.getId()), true);
        ArrayList<UUID> dataSetIds = new ArrayList<UUID>();
        dataSetIds.add(dataSet1.getId());
        dataSetIds.add(dataSet2.getId());
        this.parameterService.bulkUpdate(this.dataSetListId, Collections.emptyList(), dataSetIds, attribute.getId(), updateValue, null);
        Assertions.assertEquals((Object)updateValue, (Object)((Parameter)this.parameterService.get(param1.getId())).getText());
        Assertions.assertEquals((Object)codeOriginalValue2, (Object)((Parameter)this.parameterService.get(param2.getId())).getText());
    }

    private void verifyParameterTextValue(UUID paramId, String expectedTextValue) {
        Parameter parameter = this.validateAndGetParameter(paramId);
        Assertions.assertEquals((Object)expectedTextValue, (Object)parameter.getText());
    }

    private void verifyParameterListValue(UUID paramId, String listValueName) {
        Parameter parameter = this.validateAndGetParameter(paramId);
        ListValue listValue = parameter.getListValue();
        Assertions.assertNotNull((Object)listValue);
        Assertions.assertEquals((Object)listValueName, (Object)listValue.getName());
    }

    private void verifyParameterReferenceValue(UUID paramId, String referencedDataSetExpectedName) {
        Parameter parameter = this.validateAndGetParameter(paramId);
        DataSet dataSetReference = parameter.getDataSetReference();
        Assertions.assertNotNull((Object)dataSetReference);
        Assertions.assertEquals((Object)referencedDataSetExpectedName, (Object)dataSetReference.getName());
    }

    private Parameter validateAndGetParameter(UUID paramId) {
        Assertions.assertNotNull((Object)paramId);
        Parameter parameter = (Parameter)this.parameterService.get(paramId);
        Assertions.assertNotNull((Object)parameter);
        boolean hasOnlyText = TestUtils.onlyOneIsNotNull(parameter.getText(), parameter.getListValue(), parameter.getDataSetReference());
        Assertions.assertTrue((boolean)hasOnlyText, (String)"Variable has multiple values");
        return parameter;
    }

    private UUID createAttribute(AttributeType attributeType, UUID referencedDataSetList, List<String> listValues) {
        return this.attributeService.create(this.dataSetListId, Integer.valueOf(0), "ParameterServiceTestAttr", attributeType, referencedDataSetList, listValues).getId();
    }

    private UUID createParameterWithDataSetAnAllValues(AttributeType attributeType, String dataSetName, String textValue, String listValueName, String referencedDataSetName) {
        UUID attributeId = this.createAttribute(attributeType, null, this.listValues);
        UUID dataSetId = this.dataSetService.create(this.dataSetListId, dataSetName).getId();
        UUID listValueId = Objects.nonNull(listValueName) ? this.attributeService.createListValue(attributeId, listValueName).getId() : null;
        UUID referencedDataSetId = Objects.nonNull(referencedDataSetName) ? this.dataSetService.create(this.dataSetListId, referencedDataSetName).getId() : null;
        Parameter parameter = this.parameterService.create(dataSetId, attributeId, textValue, listValueId, referencedDataSetId);
        return parameter.getId();
    }

    @Test
    public void deleteParameterWithoutOverlap() {
        UUID parameterId = this.createParameterWithDataSetAnAllValues(AttributeType.TEXT, this.dataSetNames.get(0), this.parameterTextValues.get(0), null, null);
        Parameter parameter = (Parameter)this.parameterService.get(parameterId);
        DataSet dataset = parameter.getDataSet();
        boolean result = this.parameterService.delete(parameter.getAttribute().getId(), dataset.getId(), dataset.getDataSetList().getId(), null);
        Assertions.assertTrue((boolean)result);
    }

    @Test
    public void delete_ParameterWithDatasetLocked_NonDeleteAndThrowException() {
        UUID parameterId = this.createParameterWithDataSetAnAllValues(AttributeType.TEXT, this.dataSetNames.get(0), this.parameterTextValues.get(0), null, null);
        Parameter parameter = (Parameter)this.parameterService.get(parameterId);
        DataSet dataset = parameter.getDataSet();
        this.dataSetService.lock(this.dataSetListId, Collections.singletonList(dataset.getId()), true);
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.parameterService.delete(parameter.getAttribute().getId(), dataset.getId(), dataset.getDataSetList().getId(), null));
    }

    @Disabled
    @Test
    public void deleteParameterWithOverlap() throws DuplicateKeyException {
        UUID visibilityAreaId = this.visibilityAreaService.create("ParameterServiceTestVa").getId();
        UUID postalCodeDataSetListId = this.dataSetListService.create(visibilityAreaId, "PostalCode", null).getId();
        DataSet postalCodeDataSet = this.dataSetService.create(postalCodeDataSetListId, "PC#1");
        Attribute codeAttribute = this.attributeService.create(postalCodeDataSetListId, Integer.valueOf(0), "Code", AttributeType.TEXT, null, null);
        String codeOriginalValue = "OriginalValue";
        this.parameterService.create(postalCodeDataSet.getId(), codeAttribute.getId(), codeOriginalValue, null, null);
        UUID addressDataSetList = this.dataSetListService.create(visibilityAreaId, "Address", null).getId();
        DataSet addressDataSet1 = this.dataSetService.create(addressDataSetList, "ADR#1");
        Attribute postalCodeReferenceAttribute = this.attributeService.create(addressDataSetList, Integer.valueOf(0), "PostalCodeRef", AttributeType.DSL, postalCodeDataSetListId, null);
        this.parameterService.create(addressDataSet1.getId(), postalCodeReferenceAttribute.getId(), null, null, postalCodeDataSet.getId());
        String codeOverlappedByAddressValue = "Overlapped by address";
        Parameter overlapParam = this.parameterService.set(addressDataSet1.getId(), codeAttribute.getId(), (List)ImmutableList.of((Object)postalCodeReferenceAttribute.getId()), codeOverlappedByAddressValue, null, null);
        addressDataSet1 = (DataSet)this.dataSetService.get(addressDataSet1.getId());
        List addressParameters = addressDataSet1.getParameters();
        Set addressParameterIds = addressParameters.stream().map(Identified::getId).collect(Collectors.toSet());
        Assertions.assertTrue((boolean)addressParameterIds.contains(overlapParam.getId()));
        List<UUID> attrPathIds = Collections.singletonList(postalCodeReferenceAttribute.getId());
        boolean result = this.parameterService.delete(overlapParam.getAttribute().getId(), addressDataSet1.getId(), addressDataSet1.getDataSetList().getId(), attrPathIds);
        Assertions.assertTrue((boolean)result);
        addressDataSet1 = (DataSet)this.dataSetService.get(addressDataSet1.getId());
        addressParameters = addressDataSet1.getParameters();
        addressParameterIds = addressParameters.stream().map(Identified::getId).collect(Collectors.toSet());
        Assertions.assertFalse((boolean)addressParameterIds.contains(overlapParam.getId()));
    }

    @Test
    public void create_updateEmptyRefParameter_parameterUpdatedSuccessfully() throws DuplicateKeyException {
        UUID dataSetList1Id = this.dataSetListService.create(this.visibilityAreaId, "dsl1", null).getId();
        UUID dataSetList2Id = this.dataSetListService.create(this.visibilityAreaId, "dsl2", null).getId();
        DataSet dataSet11 = this.dataSetService.create(dataSetList1Id, "ds11");
        DataSet dataSet21 = this.dataSetService.create(dataSetList2Id, "ds21");
        Attribute textAttr = this.attributeService.create(dataSetList2Id, Integer.valueOf(0), "TextAttribute", AttributeType.TEXT, null, null);
        Parameter textParam = this.parameterService.create(dataSet11.getId(), textAttr.getId(), "text", null, null);
        Attribute dsRefAttr = this.attributeService.create(dataSetList1Id, Integer.valueOf(0), "RefAttribute", AttributeType.DSL, dataSetList2Id, null);
        Parameter refParamBefore = this.parameterService.create(dataSet11.getId(), dsRefAttr.getId(), null, null, null);
        Parameter refParamAfter = this.parameterService.set(dataSet11.getId(), dsRefAttr.getId(), Collections.singletonList(textAttr.getId()), null, dataSet21.getId(), null);
        Assertions.assertNull((Object)refParamBefore.getDataSetReference());
        Assertions.assertEquals((Object)dataSet21.getId(), (Object)refParamAfter.getDataSetReference().getId());
    }

    @Test
    public void create_updateEmptyTexParameter_parameterUpdatedSuccessfully() throws DuplicateKeyException {
        String paramValue = "TextAttribute";
        UUID dataSetListId = this.dataSetListService.create(this.visibilityAreaId, "dsl", null).getId();
        DataSet dataSet = this.dataSetService.create(dataSetListId, "ds");
        Attribute textAttr = this.attributeService.create(dataSetListId, Integer.valueOf(0), paramValue, AttributeType.TEXT, null, null);
        Assertions.assertEquals((int)0, (int)textAttr.getParameters().size());
        this.parameterService.create(dataSet.getId(), textAttr.getId(), "text", null, null);
        Assertions.assertEquals((Object)paramValue, (Object)((Attribute)((DataSetList)this.dataSetListService.get(dataSetListId)).getAttributes().get(0)).getName());
    }
}

