/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.service.direct.impl;

import java.util.UUID;
import javax.transaction.Transactional;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Isolated;
import org.qubership.atp.dataset.config.TestConfiguration;
import org.qubership.atp.dataset.db.jpa.ModelsProvider;
import org.qubership.atp.dataset.model.api.DetailedComparisonDsRequest;
import org.qubership.atp.dataset.model.api.DetailedComparisonDsResponse;
import org.qubership.atp.dataset.model.enums.CompareStatus;
import org.qubership.atp.dataset.model.enums.DetailedComparisonStatus;
import org.qubership.atp.dataset.model.impl.ComparedAttribute;
import org.qubership.atp.dataset.service.direct.EncryptionService;
import org.qubership.atp.dataset.service.direct.GridFsService;
import org.qubership.atp.dataset.service.direct.impl.CompareDatasetServiceImpl;
import org.qubership.atp.dataset.service.direct.impl.DataSetBuilder;
import org.qubership.atp.dataset.service.jpa.model.AttributeTypeName;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.mock.mockito.SpyBean;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.TestPropertySource;
import org.springframework.test.context.jdbc.Sql;

@Isolated
@ContextConfiguration(classes={TestConfiguration.class})
@TestPropertySource(properties={"feign.atp.macros.url=", "feign.atp.macros.route=", "atp-dataset.javers.enabled=false"})
public class CompareDsTest
extends DataSetBuilder {
    @SpyBean
    CompareDatasetServiceImpl compareDs;
    @Autowired
    protected ModelsProvider modelsProvider;
    @SpyBean
    GridFsService gridFsService;
    @SpyBean
    EncryptionService encryptionService;
    private UUID leftDs = UUID.fromString("527b9023-b6a8-4a64-99c1-af80b94449d2");
    private UUID identicalDs = UUID.fromString("1919170b-5733-4a9a-b67d-80a6ca027d7d");
    private UUID oneParamDs = UUID.fromString("d450e596-1910-4ad4-8c94-61c576296e4d");
    private UUID diffAttrTypeDs = UUID.fromString("23be800d-dd13-4ead-ae82-883a4a228a92");
    private UUID diffAttrNameDs = UUID.fromString("e8fe4a2b-815c-46ba-b32f-13a63204eb8a");
    private UUID diffStringValueDs = UUID.fromString("fa11fd87-4461-4908-9069-f0c2f4a2d058");
    private UUID diffDslValueDs = UUID.fromString("1ff48d2c-1819-4682-afc1-a1092a198929");
    private UUID diffListValueDs = UUID.fromString("6ab9a777-3b0d-478c-8340-4b12843342e7");
    private UUID leftDsNoParameters = UUID.fromString("3e2d9226-453a-452d-999e-f060627f8c6c");
    private UUID rightDsNoParameters = UUID.fromString("9b3d09e7-2ddf-4381-a711-187174d7ad73");

    @Test
    @Transactional
    public void compare_IdenticalDs_statusOk() {
        UUID left = UUID.fromString("e72db491-a854-469d-aec3-63669d13d15d");
        UUID right = UUID.fromString("47144c96-44f2-4875-96ad-a3db9939f841");
        CompareStatus status = this.compareDs.compare(left, right);
        Assertions.assertEquals((Object)CompareStatus.OK, (Object)status);
    }

    @Test
    @Sql(scripts={"classpath:test_data/sql/compare_ds/cleanDb.sql", "classpath:test_data/sql/compare_ds/compareDs.sql"})
    @Transactional
    public void compare_secondDsHaveOneParam_statusWarning() {
        CompareStatus status = this.compareDs.compare(this.leftDs, this.oneParamDs);
        Assertions.assertEquals((Object)CompareStatus.WARNING, (Object)status);
    }

    @Test
    @Sql(scripts={"classpath:test_data/sql/compare_ds/cleanDb.sql", "classpath:test_data/sql/compare_ds/compareDs.sql"})
    @Transactional
    public void compare_SameCountParametersDifferentType_statusWarning() {
        CompareStatus status = this.compareDs.compare(this.leftDs, this.diffAttrTypeDs);
        Assertions.assertEquals((Object)CompareStatus.WARNING, (Object)status);
    }

    @Test
    @Sql(scripts={"classpath:test_data/sql/compare_ds/cleanDb.sql", "classpath:test_data/sql/compare_ds/compareDs.sql"})
    @Transactional
    public void compare_SameCountParametersDifferentAttributeName_statusWarning() {
        CompareStatus status = this.compareDs.compare(this.leftDs, this.diffAttrNameDs);
        Assertions.assertEquals((Object)CompareStatus.WARNING, (Object)status);
    }

    @Test
    @Sql(scripts={"classpath:test_data/sql/compare_ds/cleanDb.sql", "classpath:test_data/sql/compare_ds/compareDs.sql"})
    @Transactional
    public void compare_SameCountParametersDiffValueText_statusWarning() {
        CompareStatus status = this.compareDs.compare(this.leftDs, this.diffStringValueDs);
        Assertions.assertEquals((Object)CompareStatus.WARNING, (Object)status);
    }

    @Test
    @Sql(scripts={"classpath:test_data/sql/compare_ds/cleanDb.sql", "classpath:test_data/sql/compare_ds/compareDs.sql"})
    @Transactional
    public void compare_SameCountParametersDiffValueRefDsName_statusWarning() {
        CompareStatus status = this.compareDs.compare(this.leftDs, this.diffDslValueDs);
        Assertions.assertEquals((Object)CompareStatus.WARNING, (Object)status);
    }

    @Test
    @Sql(scripts={"classpath:test_data/sql/compare_ds/cleanDb.sql", "classpath:test_data/sql/compare_ds/compareDs.sql"})
    @Transactional
    public void compare_SameCountParametersDiffListValue_statusWarning() {
        CompareStatus status = this.compareDs.compare(this.leftDs, this.diffListValueDs);
        Assertions.assertEquals((Object)CompareStatus.WARNING, (Object)status);
    }

    @Test
    @Sql(scripts={"classpath:test_data/sql/compare_ds/cleanDb.sql", "classpath:test_data/sql/compare_ds/compareDs.sql"})
    @Transactional
    public void detailedComparison_IdenticalDs() {
        DetailedComparisonDsResponse result = this.compareDs.detailedComparison(new DetailedComparisonDsRequest(this.leftDs, this.identicalDs, 0, 3));
        Assertions.assertEquals((int)3, (int)result.getTotal());
        ComparedAttribute firstAttr = (ComparedAttribute)result.getAttributes().get(0);
        ComparedAttribute secondAttr = (ComparedAttribute)result.getAttributes().get(1);
        ComparedAttribute thirdAttr = (ComparedAttribute)result.getAttributes().get(2);
        Assertions.assertEquals((Object)DetailedComparisonStatus.EQUAL, (Object)firstAttr.getStatus());
        Assertions.assertEquals((Object)DetailedComparisonStatus.EQUAL, (Object)secondAttr.getStatus());
        Assertions.assertEquals((Object)DetailedComparisonStatus.EQUAL, (Object)thirdAttr.getStatus());
    }

    @Test
    @Sql(scripts={"classpath:test_data/sql/compare_ds/cleanDb.sql", "classpath:test_data/sql/compare_ds/compareDs.sql"})
    @Transactional
    public void detailedComparison_secondDsHaveOneParam() {
        DetailedComparisonDsResponse result = this.compareDs.detailedComparison(new DetailedComparisonDsRequest(this.leftDs, this.oneParamDs, 0, 3));
        Assertions.assertEquals((int)3, (int)result.getTotal());
        ComparedAttribute firstAttr = (ComparedAttribute)result.getAttributes().get(0);
        Assertions.assertEquals((Object)DetailedComparisonStatus.NOT_EQUAL, (Object)firstAttr.getStatus());
        Assertions.assertNotNull((Object)firstAttr.getLeftAttributeId());
        Assertions.assertNull((Object)firstAttr.getRightAttributeId());
        ComparedAttribute secondAttr = (ComparedAttribute)result.getAttributes().get(1);
        Assertions.assertEquals((Object)DetailedComparisonStatus.NOT_EQUAL, (Object)secondAttr.getStatus());
        Assertions.assertNotNull((Object)secondAttr.getLeftAttributeId());
        Assertions.assertNull((Object)secondAttr.getRightAttributeId());
        ComparedAttribute thirdAttr = (ComparedAttribute)result.getAttributes().get(2);
        Assertions.assertEquals((Object)DetailedComparisonStatus.EQUAL, (Object)thirdAttr.getStatus());
        Assertions.assertNotNull((Object)thirdAttr.getLeftAttributeId());
        Assertions.assertNotNull((Object)thirdAttr.getRightAttributeId());
    }

    @Test
    @Sql(scripts={"classpath:test_data/sql/compare_ds/cleanDb.sql", "classpath:test_data/sql/compare_ds/compareDs.sql"})
    @Transactional
    public void detailedComparison_SameCountParametersDifferentType() {
        DetailedComparisonDsResponse result = this.compareDs.detailedComparison(new DetailedComparisonDsRequest(this.leftDs, this.diffAttrTypeDs, 0, 3));
        Assertions.assertEquals((int)3, (int)result.getTotal());
        ComparedAttribute firstAttr = (ComparedAttribute)result.getAttributes().get(0);
        Assertions.assertEquals((Object)DetailedComparisonStatus.INCOMPATIBLE_TYPES, (Object)firstAttr.getStatus());
        Assertions.assertNotNull((Object)firstAttr.getLeftAttributeId());
        Assertions.assertNotNull((Object)firstAttr.getRightAttributeId());
        Assertions.assertEquals((Object)AttributeTypeName.DSL, (Object)firstAttr.getLeftAttributeType());
        Assertions.assertEquals((Object)AttributeTypeName.TEXT, (Object)firstAttr.getRightAttributeType());
        ComparedAttribute secondAttr = (ComparedAttribute)result.getAttributes().get(1);
        Assertions.assertEquals((Object)DetailedComparisonStatus.EQUAL, (Object)secondAttr.getStatus());
        Assertions.assertNotNull((Object)secondAttr.getLeftAttributeId());
        Assertions.assertNotNull((Object)secondAttr.getRightAttributeId());
        Assertions.assertEquals((Object)AttributeTypeName.LIST, (Object)secondAttr.getLeftAttributeType());
        Assertions.assertEquals((Object)AttributeTypeName.LIST, (Object)secondAttr.getRightAttributeType());
        ComparedAttribute thirdAttr = (ComparedAttribute)result.getAttributes().get(2);
        Assertions.assertEquals((Object)DetailedComparisonStatus.EQUAL, (Object)thirdAttr.getStatus());
        Assertions.assertNotNull((Object)thirdAttr.getLeftAttributeId());
        Assertions.assertNotNull((Object)thirdAttr.getRightAttributeId());
        Assertions.assertEquals((Object)AttributeTypeName.TEXT, (Object)thirdAttr.getLeftAttributeType());
        Assertions.assertEquals((Object)AttributeTypeName.TEXT, (Object)thirdAttr.getRightAttributeType());
    }

    @Test
    @Sql(scripts={"classpath:test_data/sql/compare_ds/cleanDb.sql", "classpath:test_data/sql/compare_ds/compareDs.sql"})
    @Transactional
    public void detailedComparison_SameCountParametersDifferentAttributeName() {
        DetailedComparisonDsResponse result = this.compareDs.detailedComparison(new DetailedComparisonDsRequest(this.leftDs, this.diffAttrNameDs, 0, 5));
        Assertions.assertEquals((int)5, (int)result.getTotal());
        ComparedAttribute firstAttr = (ComparedAttribute)result.getAttributes().get(0);
        Assertions.assertEquals((Object)DetailedComparisonStatus.NOT_EQUAL, (Object)firstAttr.getStatus());
        Assertions.assertNull((Object)firstAttr.getLeftAttributeId());
        Assertions.assertNotNull((Object)firstAttr.getRightAttributeId());
        Assertions.assertEquals((Object)AttributeTypeName.TEXT, (Object)firstAttr.getRightAttributeType());
        ComparedAttribute secondAttr = (ComparedAttribute)result.getAttributes().get(1);
        Assertions.assertEquals((Object)DetailedComparisonStatus.NOT_EQUAL, (Object)secondAttr.getStatus());
        Assertions.assertNull((Object)secondAttr.getLeftAttributeId());
        Assertions.assertNotNull((Object)secondAttr.getRightAttributeId());
        Assertions.assertEquals((Object)AttributeTypeName.DSL, (Object)secondAttr.getRightAttributeType());
        ComparedAttribute thirdAttr = (ComparedAttribute)result.getAttributes().get(2);
        Assertions.assertEquals((Object)DetailedComparisonStatus.NOT_EQUAL, (Object)thirdAttr.getStatus());
        Assertions.assertNotNull((Object)thirdAttr.getLeftAttributeId());
        Assertions.assertNull((Object)thirdAttr.getRightAttributeId());
        Assertions.assertEquals((Object)AttributeTypeName.DSL, (Object)thirdAttr.getLeftAttributeType());
        ComparedAttribute fourthAttr = (ComparedAttribute)result.getAttributes().get(3);
        Assertions.assertEquals((Object)DetailedComparisonStatus.NOT_EQUAL, (Object)fourthAttr.getStatus());
        Assertions.assertNotNull((Object)fourthAttr.getLeftAttributeId());
        Assertions.assertNotNull((Object)fourthAttr.getRightAttributeId());
        Assertions.assertEquals((Object)AttributeTypeName.LIST, (Object)fourthAttr.getLeftAttributeType());
        Assertions.assertEquals((Object)AttributeTypeName.LIST, (Object)fourthAttr.getRightAttributeType());
        Assertions.assertNotEquals((Object)fourthAttr.getLeftAttributeValue(), (Object)fourthAttr.getRightAttributeType());
        ComparedAttribute fifthAttr = (ComparedAttribute)result.getAttributes().get(4);
        Assertions.assertEquals((Object)DetailedComparisonStatus.NOT_EQUAL, (Object)fifthAttr.getStatus());
        Assertions.assertNotNull((Object)fifthAttr.getLeftAttributeId());
        Assertions.assertNull((Object)fifthAttr.getRightAttributeId());
        Assertions.assertEquals((Object)AttributeTypeName.TEXT, (Object)fifthAttr.getLeftAttributeType());
    }

    @Test
    @Sql(scripts={"classpath:test_data/sql/compare_ds/cleanDb.sql", "classpath:test_data/sql/compare_ds/compareDs.sql"})
    @Transactional
    public void detailedComparison_NoParametersButAttributes() {
        DetailedComparisonDsResponse result = this.compareDs.detailedComparison(new DetailedComparisonDsRequest(this.leftDsNoParameters, this.rightDsNoParameters, 0, 5));
        Assertions.assertEquals((int)2, (int)result.getTotal());
        ComparedAttribute firstAttr = (ComparedAttribute)result.getAttributes().get(0);
        Assertions.assertEquals((Object)DetailedComparisonStatus.EQUAL, (Object)firstAttr.getStatus());
        Assertions.assertNotNull((Object)firstAttr.getLeftAttributeId());
        Assertions.assertNotNull((Object)firstAttr.getRightAttributeId());
        Assertions.assertEquals((Object)AttributeTypeName.TEXT, (Object)firstAttr.getLeftAttributeType());
        Assertions.assertEquals((Object)AttributeTypeName.TEXT, (Object)firstAttr.getLeftAttributeType());
        Assertions.assertNull((Object)firstAttr.getLeftAttributeValue());
        Assertions.assertNull((Object)firstAttr.getRightAttributeValue());
        ComparedAttribute secondAttr = (ComparedAttribute)result.getAttributes().get(1);
        Assertions.assertEquals((Object)DetailedComparisonStatus.INCOMPATIBLE_TYPES, (Object)secondAttr.getStatus());
        Assertions.assertNotNull((Object)secondAttr.getLeftAttributeId());
        Assertions.assertNotNull((Object)secondAttr.getRightAttributeId());
        Assertions.assertEquals((Object)AttributeTypeName.TEXT, (Object)secondAttr.getLeftAttributeType());
        Assertions.assertEquals((Object)AttributeTypeName.FILE, (Object)secondAttr.getRightAttributeType());
        Assertions.assertNull((Object)secondAttr.getLeftAttributeValue());
        Assertions.assertNull((Object)secondAttr.getRightAttributeValue());
    }
}

