/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.service.direct.impl;

import com.google.common.collect.ImmutableList;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import junit.framework.TestCase;
import org.apache.commons.lang3.tuple.Pair;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Isolated;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.qubership.atp.dataset.config.TestConfiguration;
import org.qubership.atp.dataset.db.jpa.ModelsProvider;
import org.qubership.atp.dataset.db.jpa.entities.AttributeEntity;
import org.qubership.atp.dataset.db.jpa.entities.DataSetListEntity;
import org.qubership.atp.dataset.db.jpa.repositories.JpaAttributeRepository;
import org.qubership.atp.dataset.model.Attribute;
import org.qubership.atp.dataset.model.AttributeType;
import org.qubership.atp.dataset.model.DataSet;
import org.qubership.atp.dataset.model.DataSetList;
import org.qubership.atp.dataset.model.Label;
import org.qubership.atp.dataset.model.Parameter;
import org.qubership.atp.dataset.model.TestPlan;
import org.qubership.atp.dataset.model.VisibilityArea;
import org.qubership.atp.dataset.model.utils.DatasetResponse;
import org.qubership.atp.dataset.service.direct.DuplicateKeyException;
import org.qubership.atp.dataset.service.direct.impl.DataSetBuilder;
import org.qubership.atp.dataset.service.rest.dto.manager.AffectedDataSetList;
import org.qubership.atp.dataset.service.rest.dto.manager.UiManAttribute;
import org.qubership.atp.dataset.service.rest.dto.manager.UiManDataSet;
import org.qubership.atp.dataset.service.rest.dto.manager.UiManDataSetList;
import org.qubership.atp.dataset.service.rest.dto.manager.UiManParameter;
import org.qubership.atp.dataset.versioning.service.DataSetListSnapshotService;
import org.qubership.atp.macros.core.calculator.MacrosCalculator;
import org.qubership.atp.macros.core.client.MacrosFeignClient;
import org.qubership.atp.macros.core.clients.api.dto.macros.MacrosDto;
import org.qubership.atp.macros.core.model.Macros;
import org.qubership.atp.macros.core.processor.AbstractContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.mock.mockito.MockBean;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.TestPropertySource;
import org.springframework.test.util.ReflectionTestUtils;

@Isolated
@ContextConfiguration(classes={TestConfiguration.class})
@TestPropertySource(properties={"feign.atp.macros.url=", "feign.atp.macros.route=", "atp-dataset.javers.enabled=false"})
public class DataSetListServiceImplTest
extends DataSetBuilder {
    @MockBean
    private DataSetListSnapshotService dataSetListSnapshotService;
    @MockBean
    private JpaAttributeRepository attributeRepository;
    @MockBean
    private MacrosCalculator macrosCalculator;
    @MockBean
    private MacrosFeignClient macrosFeignClient;
    @Autowired
    protected ModelsProvider modelsProvider;
    @Mock
    MacrosDto macrosDto;

    @AfterEach
    public void tearDown() throws Exception {
        this.visibilityAreaService.delete(this.vaId);
    }

    @Test
    public void testRenameDslReplaceRefs() {
        this.parameterService.update(this.source.getId(), "#REF_DSL(DSL.DS.ATTR)");
        this.dataSetListService.rename(this.dataSetList.getId(), "SZ_Updated");
        Assertions.assertEquals((Object)"#REF_DSL(SZ_Updated.DS.ATTR)", (Object)this.wrapperService.unWrapAlias(((Parameter)this.parameterService.get(this.source.getId())).getText()));
    }

    @Test
    public void testRenameDslReplaceRefsInCurrentDsl() {
        this.parameterService.update(this.source.getId(), "#REF_DSL(DSL.DS.ATTR)");
        this.dataSetListService.rename(this.dataSetList.getId(), "SZ_Updated");
        String wrappedText = ((Parameter)this.parameterService.get(this.source.getId())).getText();
        Assertions.assertEquals((Object)"#REF_DSL(SZ_Updated.DS.ATTR)", (Object)this.wrapperService.unWrapAlias(wrappedText));
    }

    @Disabled
    @Test
    public void testRenameDslReplaceRef() {
        this.parameterService.update(this.source.getId(), "#REF(DS.DSL.ATTR)");
        this.dataSetListService.rename(this.dataSetList.getId(), "SZ_Updated");
        String wrappedText = ((Parameter)this.parameterService.get(this.source.getId())).getText();
        Assertions.assertEquals((Object)"#REF(DS.SZ_Updated.ATTR)", (Object)wrappedText);
    }

    @Disabled
    @Test
    public void testRenameDslWillNotReplaceRefsInCurrentDslDslNameEntriesInAnotherDslName() {
        this.dataSetListService.rename(this.dataSetList.getId(), "SZ_Updated");
        Assertions.assertEquals((Object)"#REF_DSL(DS.Input1.Attribute)", (Object)this.source.getText());
    }

    @Disabled
    @Test
    public void testRenameDslWillReplaceFewRefs() {
        this.source.setText("#REF_DSL(DS.Input.Attribute)REF_Abrakadabra#REF(DS.Input.Attribute)");
        Assertions.assertEquals((Object)"#REF_DSL(DS.SZ_Updated.Attribute)REF_Abrakadabra#REF(DS.SZ_Updated.Attribute)", (Object)this.source.getText());
    }

    @Test
    public void addTestPlanToDataSetList_testPlanWasAdded() {
        TestPlan testPlan = (TestPlan)this.testPlanService.create(this.vaId, "newTP").getFirst();
        this.dataSetListService.modify(this.dataSetList.getId(), this.dataSetList.getName(), testPlan.getId(), false);
        DataSetList dsl = (DataSetList)this.dataSetListService.get(this.dataSetList.getId());
        Assertions.assertEquals((Object)"newTP", (Object)dsl.getTestPlan().getName());
    }

    @Test
    public void clearTestPlanInDataSetList_testPlanWasDeleted() {
        TestPlan testPlan = (TestPlan)this.testPlanService.create(this.vaId, "TPtoDelete").getFirst();
        this.dataSetListService.modify(this.dataSetList.getId(), this.dataSetList.getName(), testPlan.getId(), false);
        this.dataSetListService.modify(this.dataSetList.getId(), this.dataSetList.getName(), null, true);
        DataSetList dsl = (DataSetList)this.dataSetListService.get(this.dataSetList.getId());
        TestCase.assertNull((Object)dsl.getTestPlan());
    }

    @Test
    public void testDeleteDataSetListCascade() throws DuplicateKeyException {
        DataSetList dsl = this.dataSetListService.create(this.vaId, "MustBeRemoved", null);
        DataSet dataSet = this.dataSetService.create(dsl.getId(), "MustBeRemoved");
        Attribute attribute = this.attributeService.create(dsl.getId(), Integer.valueOf(0), "MustBeRemoved", AttributeType.TEXT, null, null);
        Parameter parameter = this.parameterService.create(dataSet.getId(), attribute.getId(), "Text", null, null);
        this.dataSetListService.delete(dsl.getId());
        Assertions.assertNull((Object)this.dataSetListService.get(dsl.getId()));
        Assertions.assertNull((Object)this.dataSetService.get(dataSet.getId()));
        Assertions.assertNull((Object)this.attributeService.get(attribute.getId()));
        Assertions.assertNull((Object)this.parameterService.get(parameter.getId()));
        List all = this.visibilityAreaService.getAll();
        VisibilityArea area = all.stream().filter(va -> va.getId().equals(this.vaId)).findFirst().orElseThrow(() -> new AssertionError((Object)"VisibilityArea not found"));
        Assertions.assertNotNull((Object)area);
    }

    @Test
    public void testCopyDsl_withTextAndDslRefAndOverlapAttrs_dslWasCopiedWithOrWithoutDataInTestPlan() throws Exception {
        TestPlan testPlanToCopy = (TestPlan)this.testPlanService.create(this.vaId, "TP").getFirst();
        UUID postalCode = this.dataSetListService.create(this.vaId, "PostalCode", null).getId();
        DataSet pc1 = this.dataSetService.create(postalCode, "PC#1");
        UUID postalCode2 = this.dataSetListService.create(this.vaId, "PostalCode2", null).getId();
        DataSet pc12 = this.dataSetService.create(postalCode2, "PC#2");
        Attribute attributeToOverlap = this.attributeService.create(postalCode, Integer.valueOf(0), "text", AttributeType.TEXT, null, null);
        Parameter parameterToOverlap = this.parameterService.create(this.dataSet1.getId(), attributeToOverlap.getId(), "original", null, null);
        DataSetList dslToCopy = this.dataSetListService.create(this.vaId, "toCopy", null);
        DataSet dataSet = this.dataSetService.create(dslToCopy.getId(), "ds");
        Attribute attributeText = this.attributeService.create(dslToCopy.getId(), Integer.valueOf(1), "textAttr", AttributeType.TEXT, null, null);
        Parameter parameterText = this.parameterService.create(dataSet.getId(), attributeText.getId(), "Text", null, null);
        Attribute pcAttrRef2 = this.attributeService.create(dslToCopy.getId(), Integer.valueOf(2), "PostalCodeRef2", AttributeType.DSL, postalCode2, null);
        Parameter pcParamRef2 = this.parameterService.create(dataSet.getId(), pcAttrRef2.getId(), null, null, pc12.getId());
        Attribute pcAttrRef = this.attributeService.create(postalCode2, Integer.valueOf(3), "PostalCodeRef", AttributeType.DSL, postalCode, null);
        Parameter pcParamRef = this.parameterService.create(pc12.getId(), pcAttrRef.getId(), null, null, pc1.getId());
        this.parameterService.set(dataSet.getId(), attributeToOverlap.getId(), (List)ImmutableList.of((Object)pcAttrRef2.getId()), "Overlapped", null, null);
        DataSetList withData = this.dataSetListService.copy(this.vaId, dslToCopy.getId(), "dslWithData", Boolean.valueOf(true), testPlanToCopy.getId());
        DataSetList withoutData = this.dataSetListService.copy(this.vaId, dslToCopy.getId(), "dslWithoutData", Boolean.valueOf(false), testPlanToCopy.getId());
        Assertions.assertNotNull((Object)withoutData);
        Assertions.assertEquals((int)0, (int)withoutData.getDataSets().size());
        Assertions.assertNotNull((Object)withData);
        Assertions.assertEquals((int)1, (int)withData.getDataSets().size());
        List attrs = withoutData.getAttributes();
        Assertions.assertEquals((Object)((Attribute)attrs.get(0)).getName(), (Object)"textAttr");
        Assertions.assertEquals((Object)((Attribute)attrs.get(0)).getType(), (Object)AttributeType.TEXT);
        Assertions.assertEquals((Object)((Attribute)attrs.get(1)).getName(), (Object)"PostalCodeRef2");
        Assertions.assertEquals((Object)((Attribute)attrs.get(1)).getType(), (Object)AttributeType.DSL);
        List attrsWD = withData.getAttributes();
        Assertions.assertEquals((Object)((Attribute)attrsWD.get(0)).getName(), (Object)"textAttr");
        Assertions.assertEquals((Object)((Attribute)attrsWD.get(0)).getType(), (Object)AttributeType.TEXT);
        Assertions.assertEquals((Object)((Attribute)attrsWD.get(1)).getName(), (Object)"PostalCodeRef2");
        Assertions.assertEquals((Object)((Attribute)attrsWD.get(1)).getType(), (Object)AttributeType.DSL);
        Assertions.assertEquals((Object)withData.getTestPlan().getName(), (Object)"TP");
        Assertions.assertEquals((Object)withoutData.getTestPlan().getName(), (Object)"TP");
    }

    @Test
    public void getDatasetsIdsWithItsNameAndDatasetList_correct_StructureWereReturned() throws DuplicateKeyException {
        DataSetList dslWithTwoDatasets = this.dataSetListService.create(this.vaId, "dslWith2ds", null);
        DataSet ds1InsideDslWith2ds = this.dataSetService.create(dslWithTwoDatasets.getId(), "ds1InsideDslWith2ds");
        DataSet ds2InsideDslWith2ds = this.dataSetService.create(dslWithTwoDatasets.getId(), "ds2InsideDslWith2ds");
        DataSetList dslWithOneDataSet = this.dataSetListService.create(this.vaId, "dslWith1ds", null);
        DataSet dsInsideDslWith1ds = this.dataSetService.create(dslWithOneDataSet.getId(), "dsInsideDslWith1ds");
        DataSetList dslWithoutDataSets = this.dataSetListService.create(this.vaId, "dslWithoutDatasets", null);
        List result = this.dataSetListService.getListOfDsIdsAndNameAndDslId(Arrays.asList(dslWithTwoDatasets.getId(), dslWithOneDataSet.getId(), dslWithoutDataSets.getId()));
        Assertions.assertEquals((int)3, (int)result.size(), (String)"Result doesn't have 3 elements");
        MatcherAssert.assertThat(result.stream().map(DatasetResponse::getDataSetName).collect(Collectors.toSet()), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{ds1InsideDslWith2ds.getName(), ds2InsideDslWith2ds.getName(), dsInsideDslWith1ds.getName()}));
        MatcherAssert.assertThat(result.stream().map(DatasetResponse::getDataSetListId).collect(Collectors.toSet()), (Matcher)Matchers.containsInAnyOrder((Object[])new UUID[]{dslWithTwoDatasets.getId(), dslWithOneDataSet.getId()}));
    }

    @Test
    public void getDatasetsIdsWithItsNameAndDatasetList_correct_StructureWereReturnedWithSkippedNotFoundDsl() throws DuplicateKeyException {
        DataSetList dsl = this.dataSetListService.create(this.vaId, "dslist", null);
        DataSet dataSet1 = this.dataSetService.create(dsl.getId(), "ds1");
        List result = this.dataSetListService.getListOfDsIdsAndNameAndDslId(Arrays.asList(dsl.getId(), UUID.randomUUID()));
        Assertions.assertEquals((int)1, (int)result.size(), (String)"Result have 1 element");
        Assertions.assertEquals((Object)((DatasetResponse)result.get(0)).getDataSetName(), (Object)dataSet1.getName());
        Assertions.assertEquals((Object)((DatasetResponse)result.get(0)).getDataSetListId(), (Object)dsl.getId());
        Assertions.assertEquals((Object)((DatasetResponse)result.get(0)).getDataSetListName(), (Object)dsl.getName());
    }

    @Test
    public void getFilteredDatasets_datasetsWereFilteredById() throws DuplicateKeyException {
        DataSetList dsl = this.dataSetListService.create(this.vaId, "dsl", null);
        DataSet dataSet1 = this.dataSetService.create(dsl.getId(), "ds1");
        DataSet dataSet2 = this.dataSetService.create(dsl.getId(), "ds2");
        DataSet dataSet3 = this.dataSetService.create(dsl.getId(), "ds3");
        DataSet dataSet4 = this.dataSetService.create(dsl.getId(), "ds4");
        UiManDataSetList resultBefore = this.dataSetListService.getAsTree(dsl.getId(), false);
        Assertions.assertEquals((int)4, (int)resultBefore.getDataSets().size());
        List<UUID> filter = Arrays.asList(dataSet1.getId(), dataSet2.getId());
        UiManDataSetList resultAfter = this.dataSetListService.getAsTree(dsl.getId(), false, filter, false);
        Assertions.assertEquals((int)2, (int)resultAfter.getDataSets().size());
        Assertions.assertEquals((Object)dataSet1.getId(), (Object)((UiManDataSet)resultAfter.getDataSets().get(0)).getId());
        Assertions.assertEquals((Object)dataSet2.getId(), (Object)((UiManDataSet)resultAfter.getDataSets().get(1)).getId());
    }

    @Test
    public void getFilteredDatasets_datasetsWereFilteredByAttributes() throws DuplicateKeyException {
        DataSetList dsl = this.dataSetListService.create(this.vaId, "dsl", null);
        DataSet dataSet1 = this.dataSetService.create(dsl.getId(), "ds1");
        Attribute attribute1 = this.attributeService.create(dsl.getId(), Integer.valueOf(0), "text1", AttributeType.TEXT, null, null);
        Attribute attribute2 = this.attributeService.create(dsl.getId(), Integer.valueOf(1), "text2", AttributeType.TEXT, null, null);
        Attribute attribute3 = this.attributeService.create(dsl.getId(), Integer.valueOf(2), "text3", AttributeType.TEXT, null, null);
        Attribute attribute4 = this.attributeService.create(dsl.getId(), Integer.valueOf(3), "text4", AttributeType.TEXT, null, null);
        Parameter parameter1 = this.parameterService.create(dataSet1.getId(), attribute1.getId(), "1", null, null);
        Parameter parameter2 = this.parameterService.create(dataSet1.getId(), attribute2.getId(), "2", null, null);
        Parameter parameter3 = this.parameterService.create(dataSet1.getId(), attribute3.getId(), "3", null, null);
        Parameter parameter4 = this.parameterService.create(dataSet1.getId(), attribute4.getId(), "4", null, null);
        UiManDataSetList resultBefore = this.dataSetListService.getAsTree(dsl.getId(), false);
        Assertions.assertEquals((int)4, (int)resultBefore.getAttributes().size());
        List<UUID> filter = Arrays.asList(attribute1.getId(), attribute2.getId());
        UiManDataSetList resultAfter = this.dataSetListService.getAsTree(dsl.getId(), false, null, filter, null, null, false, true);
        Assertions.assertEquals((int)2, (int)resultAfter.getAttributes().size());
        Assertions.assertEquals((Object)attribute1.getId(), (Object)((UiManAttribute)resultAfter.getAttributes().get(0)).getId());
        Assertions.assertEquals((Object)attribute2.getId(), (Object)((UiManAttribute)resultAfter.getAttributes().get(1)).getId());
    }

    @Test
    public void getFilteredDatasets_datasetsWereFilteredByIdAndAttributes() throws DuplicateKeyException {
        DataSetList dsl = this.dataSetListService.create(this.vaId, "dsl", null);
        DataSet dataSet1 = this.dataSetService.create(dsl.getId(), "ds1");
        DataSet dataSet2 = this.dataSetService.create(dsl.getId(), "ds2");
        DataSet dataSet3 = this.dataSetService.create(dsl.getId(), "ds3");
        DataSet dataSet4 = this.dataSetService.create(dsl.getId(), "ds4");
        Attribute attribute1 = this.attributeService.create(dsl.getId(), Integer.valueOf(0), "text1", AttributeType.TEXT, null, null);
        Attribute attribute2 = this.attributeService.create(dsl.getId(), Integer.valueOf(1), "text2", AttributeType.TEXT, null, null);
        Attribute attribute3 = this.attributeService.create(dsl.getId(), Integer.valueOf(2), "text3", AttributeType.TEXT, null, null);
        Attribute attribute4 = this.attributeService.create(dsl.getId(), Integer.valueOf(3), "text4", AttributeType.TEXT, null, null);
        UiManDataSetList resultBefore = this.dataSetListService.getAsTree(dsl.getId(), false);
        Assertions.assertEquals((int)4, (int)resultBefore.getAttributes().size());
        Assertions.assertEquals((int)4, (int)resultBefore.getDataSets().size());
        List<UUID> filterDs = Arrays.asList(dataSet1.getId(), dataSet2.getId());
        List<UUID> filter = Arrays.asList(attribute1.getId(), attribute2.getId());
        UiManDataSetList resultAfter = this.dataSetListService.getAsTree(dsl.getId(), false, filterDs, filter, null, null, false, true);
        Assertions.assertEquals((int)2, (int)resultAfter.getAttributes().size());
        Assertions.assertEquals((int)2, (int)resultAfter.getDataSets().size());
        Assertions.assertEquals((Object)dataSet1.getId(), (Object)((UiManDataSet)resultAfter.getDataSets().get(0)).getId());
        Assertions.assertEquals((Object)dataSet2.getId(), (Object)((UiManDataSet)resultAfter.getDataSets().get(1)).getId());
        Assertions.assertEquals((Object)attribute1.getId(), (Object)((UiManAttribute)resultAfter.getAttributes().get(0)).getId());
        Assertions.assertEquals((Object)attribute2.getId(), (Object)((UiManAttribute)resultAfter.getAttributes().get(1)).getId());
    }

    @Test
    public void getAffectedAttributesByDatasetListId_returnResponse() {
        DataSetList toDelete = this.dataSetListService.create(this.vaId, "dsl", null);
        DataSetListEntity dsl1 = new DataSetListEntity();
        dsl1.setId(UUID.randomUUID());
        dsl1.setName("dsl 1");
        DataSetListEntity dsl2 = new DataSetListEntity();
        dsl2.setId(UUID.randomUUID());
        dsl2.setName("dsl 2");
        AttributeEntity attribute1 = new AttributeEntity();
        attribute1.setId(UUID.randomUUID());
        attribute1.setName("attr 1");
        attribute1.setDataSetList(dsl1);
        AttributeEntity attribute2 = new AttributeEntity();
        attribute2.setId(UUID.randomUUID());
        attribute2.setName("attr 2");
        attribute2.setDataSetList(dsl2);
        Mockito.when((Object)this.attributeRepository.getByTypeDataSetListId((UUID)ArgumentMatchers.any(), (Pageable)ArgumentMatchers.any())).thenReturn((Object)new PageImpl(Arrays.asList(attribute1, attribute2)));
        List responses = this.dataSetListService.getAffectedAttributes(toDelete.getId(), null, null).getEntities();
        MatcherAssert.assertThat((Object)responses, (Matcher)Matchers.hasSize((int)2));
        MatcherAssert.assertThat((Object)responses, (Matcher)Matchers.hasItem((Matcher)Matchers.hasProperty((String)"attributeId", (Matcher)CoreMatchers.equalTo((Object)attribute1.getId()))));
        MatcherAssert.assertThat((Object)responses, (Matcher)Matchers.hasItem((Matcher)Matchers.hasProperty((String)"attributeId", (Matcher)CoreMatchers.equalTo((Object)attribute2.getId()))));
    }

    @Test
    public void testGetAffectedDataSetLists_shouldReturnsEmptyList_whenDataSetListIsNotExists() {
        List affectedDataSetLists = this.dataSetListService.getAffectedDataSetLists(UUID.randomUUID(), Integer.valueOf(1), Integer.valueOf(0));
        MatcherAssert.assertThat((Object)affectedDataSetLists, (Matcher)Matchers.hasSize((int)0));
    }

    @Test
    public void testGetAffectedDataSetLists_shouldReturnsListWithOneElement_whenDataSetListIsExists() {
        DataSetList toDelete = this.dataSetListService.create(this.vaId, "dsl", null);
        DataSetList dsl1 = this.dataSetListService.create(this.vaId, "dsl1", null);
        DataSetList dsl2 = this.dataSetListService.create(this.vaId, "dsl2", null);
        this.attributeService.create(dsl1.getId(), Integer.valueOf(0), "dsl", AttributeType.DSL, toDelete.getId(), null);
        this.attributeService.create(dsl2.getId(), Integer.valueOf(0), "dsl", AttributeType.DSL, toDelete.getId(), null);
        List affectedDataSetLists = this.dataSetListService.getAffectedDataSetLists(toDelete.getId(), Integer.valueOf(1), Integer.valueOf(0));
        MatcherAssert.assertThat((Object)affectedDataSetLists, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)dsl1.getId(), (Matcher)CoreMatchers.equalTo((Object)((AffectedDataSetList)affectedDataSetLists.get(0)).getDslId()));
        MatcherAssert.assertThat((Object)dsl1.getName(), (Matcher)CoreMatchers.equalTo((Object)((AffectedDataSetList)affectedDataSetLists.get(0)).getDslName()));
    }

    @Test
    public void testGetAffectedDataSetLists_shouldReturnsEmptyList_whenDataSetListIsExistsAndOffsetMoreThanCount() {
        DataSetList toDelete = this.dataSetListService.create(this.vaId, "dsl", null);
        DataSetList dsl1 = this.dataSetListService.create(this.vaId, "dsl1", null);
        DataSetList dsl2 = this.dataSetListService.create(this.vaId, "dsl2", null);
        this.attributeService.create(dsl1.getId(), Integer.valueOf(0), "dsl", AttributeType.DSL, toDelete.getId(), null);
        this.attributeService.create(dsl2.getId(), Integer.valueOf(0), "dsl", AttributeType.DSL, toDelete.getId(), null);
        List affectedDataSetLists = this.dataSetListService.getAffectedDataSetLists(toDelete.getId(), Integer.valueOf(1), Integer.valueOf(10));
        MatcherAssert.assertThat((Object)affectedDataSetLists, (Matcher)Matchers.hasSize((int)0));
    }

    @Test
    public void testGetAffectedDataSetLists_shouldThrowAnException_whenLimitIsNegative() {
        DataSetList toDelete = this.dataSetListService.create(this.vaId, "dsl", null);
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.dataSetListService.getAffectedDataSetLists(toDelete.getId(), Integer.valueOf(-1), Integer.valueOf(0)));
    }

    @Test
    public void testGetAffectedDataSetLists_shouldThrowAnException_whenOffsetIsNegative() {
        DataSetList toDelete = this.dataSetListService.create(this.vaId, "dsl", null);
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.dataSetListService.getAffectedDataSetLists(toDelete.getId(), Integer.valueOf(1), Integer.valueOf(-1)));
    }

    @Test
    public void testCopyDslWithDatasets_dslWasCopiedWithoutTestPlan() throws Exception {
        UUID postalCode = this.dataSetListService.create(this.vaId, "PostalCode", null).getId();
        DataSet pc1 = this.dataSetService.create(postalCode, "PC#1");
        UUID postalCode2 = this.dataSetListService.create(this.vaId, "PostalCode2", null).getId();
        DataSet pc12 = this.dataSetService.create(postalCode2, "PC#2");
        Attribute attributeToOverlap = this.attributeService.create(postalCode, Integer.valueOf(0), "text", AttributeType.TEXT, null, null);
        this.parameterService.create(this.dataSet1.getId(), attributeToOverlap.getId(), "original", null, null);
        DataSetList dslToCopy = this.dataSetListService.create(this.vaId, "toCopy", null);
        DataSet dataSet = this.dataSetService.create(dslToCopy.getId(), "ds");
        DataSetList dslToCopy2 = this.dataSetListService.create(this.vaId, "toCopy2", null);
        DataSet dataSet2 = this.dataSetService.create(dslToCopy2.getId(), "ds2");
        DataSet dataSet3 = this.dataSetService.create(dslToCopy2.getId(), "ds3");
        DataSet dataSet4 = this.dataSetService.create(dslToCopy2.getId(), "ds4");
        Attribute attributeText = this.attributeService.create(dslToCopy.getId(), Integer.valueOf(1), "textAttr", AttributeType.TEXT, null, null);
        this.parameterService.create(dataSet.getId(), attributeText.getId(), "Text", null, null);
        Attribute pcAttrRef2 = this.attributeService.create(dslToCopy.getId(), Integer.valueOf(2), "PostalCodeRef2", AttributeType.DSL, postalCode2, null);
        this.parameterService.create(dataSet.getId(), pcAttrRef2.getId(), null, null, pc12.getId());
        Attribute pcAttrRef = this.attributeService.create(postalCode2, Integer.valueOf(3), "PostalCodeRef", AttributeType.DSL, postalCode, null);
        this.parameterService.create(pc12.getId(), pcAttrRef.getId(), null, null, pc1.getId());
        this.parameterService.set(dataSet.getId(), attributeToOverlap.getId(), (List)ImmutableList.of((Object)pcAttrRef2.getId()), "Overlapped", null, null);
        HashMap<UUID, HashSet<UUID>> structureToCopy = new HashMap<UUID, HashSet<UUID>>();
        structureToCopy.put(dslToCopy.getId(), new HashSet<UUID>(Arrays.asList(dataSet.getId())));
        structureToCopy.put(dslToCopy2.getId(), new HashSet<UUID>(Arrays.asList(dataSet2.getId(), dataSet3.getId())));
        Map result = this.dataSetListService.copy("prefix", structureToCopy);
        Assertions.assertNotNull((Object)result);
        Assertions.assertEquals((int)3, (int)result.size());
        DataSetList resultDsl1 = (DataSetList)this.dataSetListService.get((UUID)((Pair)result.get(dataSet.getId())).getValue());
        Assertions.assertEquals((int)2, (int)((DataSetList)this.dataSetListService.get((UUID)((Pair)result.get(dataSet2.getId())).getValue())).getDataSets().size(), (String)"second dsl has only 2 datasets");
        List attrs = resultDsl1.getAttributes();
        Assertions.assertEquals((Object)"textAttr", (Object)((Attribute)attrs.get(0)).getName());
        Assertions.assertEquals((Object)AttributeType.TEXT, (Object)((Attribute)attrs.get(0)).getType());
        Assertions.assertEquals((Object)"PostalCodeRef2", (Object)((Attribute)attrs.get(1)).getName());
        Assertions.assertEquals((Object)AttributeType.DSL, (Object)((Attribute)attrs.get(1)).getType());
        Assertions.assertNull((Object)resultDsl1.getTestPlan());
    }

    @Test
    public void testExistsById_shouldReturnsFalse_whenDataSetListIsNotExists() {
        boolean exists = this.dataSetListService.existsById(UUID.randomUUID());
        MatcherAssert.assertThat((Object)exists, (Matcher)CoreMatchers.equalTo((Object)false));
    }

    @Test
    public void testExistsById_shouldReturnsTrue_whenDataSetListIsExists() {
        DataSetList dsl = this.dataSetListService.create(this.vaId, "dsl", null);
        boolean exists = this.dataSetListService.existsById(dsl.getId());
        MatcherAssert.assertThat((Object)exists, (Matcher)CoreMatchers.equalTo((Object)true));
    }

    @Test
    public void testExistsById_shouldThrowAnException_whenDataSetListIdIsNull() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.dataSetListService.existsById(null));
    }

    @Test
    public void testGetDataSetListModifiedWhen_shouldReturnsNull_whenDataSetListIsNotExists() {
        Timestamp modifiedWhen = this.dataSetListService.getModifiedWhen(UUID.randomUUID());
        MatcherAssert.assertThat((Object)modifiedWhen, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void testGetDataSetListModifiedWhen_shouldReturnsNull_whenDataSetListModifiedWhenIsNotExists() {
        DataSetList dsl = this.dataSetListService.create(this.vaId, "dsl", null);
        Timestamp modifiedWhen = this.dataSetListService.getModifiedWhen(dsl.getId());
        long modifiedWhenActual = modifiedWhen.getTime();
        long modifiedWhenExpected = dsl.getModifiedWhen().getTime();
        MatcherAssert.assertThat((Object)modifiedWhenActual, (Matcher)CoreMatchers.equalTo((Object)modifiedWhenExpected));
    }

    @Test
    public void testGetDataSetListModifiedWhen_shouldThrowAnException_whenDataSetListIdIsNull() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.dataSetListService.getModifiedWhen(null));
    }

    @Test
    public void testDelete_shouldRollbackTransaction_whenExceptionIsOccured() {
        ((DataSetListSnapshotService)Mockito.doThrow(RuntimeException.class).when((Object)this.dataSetListSnapshotService)).deleteDataSetList((UUID)ArgumentMatchers.any());
        try {
            this.dataSetListService.delete(this.dataSetList.getId());
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertNotNull((Object)this.dataSetListService.get(this.dataSetList.getId()));
    }

    @Test
    public void test_UiManDataSetList_whenMacrosAtpIs() throws DuplicateKeyException {
        ReflectionTestUtils.setField((Object)this.dataSetListService, (String)"macroFeignUrl", (Object)"testUrl");
        VisibilityArea area = this.visibilityAreaService.create("TestVA");
        DataSetList dsl = this.dataSetListService.create(area.getId(), "dsl", null);
        DataSet dataSet1 = this.dataSetService.create(dsl.getId(), "ds1");
        DataSet dataSet2 = this.dataSetService.create(dsl.getId(), "ds2");
        Attribute attribute1 = this.attributeService.create(dsl.getId(), Integer.valueOf(0), "macros1", AttributeType.TEXT, null, null);
        Attribute attribute2 = this.attributeService.create(dsl.getId(), Integer.valueOf(1), "macros2", AttributeType.TEXT, null, null);
        Parameter parameter1 = this.parameterService.create(dataSet1.getId(), attribute1.getId(), "32#RANDOMBETWEEN(31,31)", null, null);
        Parameter parameter2 = this.parameterService.create(dataSet2.getId(), attribute1.getId(), "Simple text", null, null);
        Parameter parameter3 = this.parameterService.create(dataSet1.getId(), attribute2.getId(), "Simple text2", null, null);
        Parameter parameter4 = this.parameterService.create(dataSet2.getId(), attribute2.getId(), "69#RANDOMBETWEEN(1,1)", null, null);
        Mockito.when((Object)this.macrosFeignClient.findAllByProject((UUID)ArgumentMatchers.any(UUID.class))).thenReturn((Object)new ResponseEntity(Collections.singletonList(this.macrosDto), HttpStatus.OK));
        Mockito.when((Object)this.macrosFeignClient.findNonTechnicalMacrosByProject((UUID)ArgumentMatchers.any(UUID.class))).thenReturn((Object)new ResponseEntity(Collections.singletonList(this.macrosDto), HttpStatus.OK));
        Mockito.when((Object)this.macrosCalculator.calculate((Macros)ArgumentMatchers.any(), (List)ArgumentMatchers.any(), (AbstractContext)ArgumentMatchers.any())).thenReturn((Object)"OK_MACRO_VALUE");
        Mockito.when((Object)this.macrosDto.getName()).thenReturn((Object)"RANDOMBETWEEN");
        UiManDataSetList dataSetListUi = this.dataSetListService.getAsTree(dsl.getId(), true, null, null, null, null, false, true);
        Assertions.assertEquals((Object)"32OK_MACRO_VALUE", (Object)((UiManParameter)((UiManAttribute)dataSetListUi.getAttributes().get(0)).getParameters().get(0)).getValue());
        Assertions.assertEquals((Object)"Simple text", (Object)((UiManParameter)((UiManAttribute)dataSetListUi.getAttributes().get(0)).getParameters().get(1)).getValue());
        Assertions.assertEquals((Object)"Simple text2", (Object)((UiManParameter)((UiManAttribute)dataSetListUi.getAttributes().get(1)).getParameters().get(0)).getValue());
        Assertions.assertEquals((Object)"69OK_MACRO_VALUE", (Object)((UiManParameter)((UiManAttribute)dataSetListUi.getAttributes().get(1)).getParameters().get(1)).getValue());
        this.visibilityAreaService.delete(area.getId());
    }

    @Test
    public void test_UiManDataSetList_emptyNonTechnicalMacrosList() throws DuplicateKeyException {
        ReflectionTestUtils.setField((Object)this.dataSetListService, (String)"macroFeignUrl", (Object)"testUrl");
        VisibilityArea area = this.visibilityAreaService.create("TestVA");
        DataSetList dsl = this.dataSetListService.create(area.getId(), "dsl", null);
        DataSet dataSet1 = this.dataSetService.create(dsl.getId(), "ds1");
        DataSet dataSet2 = this.dataSetService.create(dsl.getId(), "ds2");
        Attribute attribute1 = this.attributeService.create(dsl.getId(), Integer.valueOf(0), "macros1", AttributeType.TEXT, null, null);
        Attribute attribute2 = this.attributeService.create(dsl.getId(), Integer.valueOf(1), "macros2", AttributeType.TEXT, null, null);
        Parameter parameter1 = this.parameterService.create(dataSet1.getId(), attribute1.getId(), "32#RANDOMBETWEEN(31,31)", null, null);
        Parameter parameter2 = this.parameterService.create(dataSet2.getId(), attribute1.getId(), "Simple text", null, null);
        Parameter parameter3 = this.parameterService.create(dataSet1.getId(), attribute2.getId(), "Simple text2", null, null);
        Parameter parameter4 = this.parameterService.create(dataSet2.getId(), attribute2.getId(), "69#RANDOMBETWEEN(1,1)", null, null);
        Mockito.when((Object)this.macrosFeignClient.findAllByProject((UUID)ArgumentMatchers.any(UUID.class))).thenReturn((Object)new ResponseEntity(Collections.singletonList(this.macrosDto), HttpStatus.OK));
        Mockito.when((Object)this.macrosFeignClient.findNonTechnicalMacrosByProject((UUID)ArgumentMatchers.any(UUID.class))).thenReturn((Object)new ResponseEntity(Collections.emptyList(), HttpStatus.OK));
        Mockito.when((Object)this.macrosDto.getName()).thenReturn((Object)"RANDOMBETWEEN");
        UiManDataSetList dataSetListUi = this.dataSetListService.getAsTree(dsl.getId(), true, null, null, null, null, false, true);
        Assertions.assertEquals((Object)"32#RANDOMBETWEEN(31,31)", (Object)((UiManParameter)((UiManAttribute)dataSetListUi.getAttributes().get(0)).getParameters().get(0)).getValue());
        Assertions.assertEquals((Object)"Simple text", (Object)((UiManParameter)((UiManAttribute)dataSetListUi.getAttributes().get(0)).getParameters().get(1)).getValue());
        Assertions.assertEquals((Object)"Simple text2", (Object)((UiManParameter)((UiManAttribute)dataSetListUi.getAttributes().get(1)).getParameters().get(0)).getValue());
        Assertions.assertEquals((Object)"69#RANDOMBETWEEN(1,1)", (Object)((UiManParameter)((UiManAttribute)dataSetListUi.getAttributes().get(1)).getParameters().get(1)).getValue());
        this.visibilityAreaService.delete(area.getId());
    }

    @Test
    public void getAsTree_runEvaluateMacros_macrosParameterEvaluated() throws DuplicateKeyException {
        String str = "35#RANDOMBETWEEN(31,31)";
        DataSetList dsl = this.dataSetListService.create(this.vaId, "dsl", null);
        DataSet dataSet = this.dataSetService.create(dsl.getId(), "ds1");
        Attribute attribute = this.attributeService.create(dsl.getId(), Integer.valueOf(0), "Test", AttributeType.TEXT, null, null);
        this.parameterService.create(dataSet.getId(), attribute.getId(), str, null, null);
        UiManDataSetList resultBefore = this.dataSetListService.getAsTree(dsl.getId(), false);
        UiManDataSetList resultAfter = this.dataSetListService.getAsTree(dsl.getId(), true);
        Assertions.assertTrue((boolean)((UiManParameter)((UiManAttribute)resultBefore.getAttributes().get(0)).getParameters().get(0)).getValue().toString().contains(str));
        Assertions.assertTrue((boolean)((UiManParameter)((UiManAttribute)resultAfter.getAttributes().get(0)).getParameters().get(0)).getValue().toString().contains("3531"));
    }

    @Test
    public void mark_setLabelToDatasetList_dataSetListHasLabel() {
        String labelName = "Label";
        this.dataSetListService.mark(this.dslId, labelName);
        List labels = ((DataSetList)this.dataSetListService.get(this.dslId)).getLabels();
        Assertions.assertEquals((Object)labelName, (Object)((Label)labels.get(0)).getName());
    }

    @Test
    public void unmark_deleteLabelFromDatasetList_dataSetListHasNotLabel() {
        String labelName = "Label";
        Label label = this.dataSetListService.mark(this.dslId, labelName);
        this.dataSetListService.unmark(this.dslId, label.getId());
        List labels = ((DataSetList)this.dataSetListService.get(this.dslId)).getLabels();
        Assertions.assertEquals((int)0, (int)labels.size());
    }

    @Test
    public void getAll_getDslOfNotExistedProject_DataSetListIsEmpty() {
        UUID vaUuid = UUID.fromString("31fdbadd-540c-4021-89e5-ad00880ba595");
        Assertions.assertEquals((int)0, (int)this.dataSetListService.getAll(vaUuid, null).size());
    }
}

