/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.service.direct.impl;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNot;
import org.hamcrest.core.IsNull;
import org.junit.After;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Isolated;
import org.qubership.atp.dataset.config.TestConfiguration;
import org.qubership.atp.dataset.model.DataSet;
import org.qubership.atp.dataset.model.DataSetList;
import org.qubership.atp.dataset.model.Filter;
import org.qubership.atp.dataset.model.Label;
import org.qubership.atp.dataset.model.VisibilityArea;
import org.qubership.atp.dataset.service.AbstractTest;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.TestPropertySource;

@Isolated
@ContextConfiguration(classes={TestConfiguration.class})
@TestPropertySource(properties={"atp-dataset.javers.enabled=false"})
public class FilterServiceImplTest
extends AbstractTest {
    private static final String TEST_FILTER_NAME = "Test";
    private VisibilityArea va;
    private DataSetList dsl;
    private DataSet ds;
    private Label dslLabel;
    private Filter filter;
    private List<UUID> dslLabels;

    @BeforeEach
    public void setUp() {
        this.va = this.visibilityAreaService.create("Filter_test_VA");
        this.dsl = this.dataSetListService.create(this.va.getId(), "DSL", null);
        this.ds = this.dataSetService.create(this.dsl.getId(), "DS");
        this.dslLabel = this.dataSetListService.mark(this.dsl.getId(), "T_Label");
        this.dslLabels = Collections.singletonList(this.dslLabel.getId());
        this.filter = this.filterService.create(TEST_FILTER_NAME, this.va.getId(), Collections.emptyList(), this.dslLabels);
    }

    @Test
    public void testFilterCreationFailedDueToBothLabelReferenceIsEmpty() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.filterService.create(TEST_FILTER_NAME, this.va.getId(), Collections.emptyList(), Collections.emptyList()));
    }

    @Test
    public void testFilterIsCreated() {
        MatcherAssert.assertThat((Object)this.filter, (Matcher)IsNot.not((Matcher)IsNull.nullValue()));
        MatcherAssert.assertThat((Object)this.filter.getName(), (Matcher)Is.is((Object)TEST_FILTER_NAME));
        Assertions.assertTrue((this.filter.getId() != null && this.filter.getId() instanceof UUID ? 1 : 0) != 0);
        MatcherAssert.assertThat((Object)this.filter.getDataSetLabels(), (Matcher)Is.is(Collections.emptyList()));
        MatcherAssert.assertThat((Object)this.filter.getDataSetListLabels(), (Matcher)Is.is(this.dslLabels));
    }

    @Test
    public void testFilterIsGetFromRepository() {
        this.filter = (Filter)this.filterService.get(this.filter.getId());
        Assertions.assertNotNull((Object)this.filter);
        MatcherAssert.assertThat((Object)this.filter.getDataSetLabels().size(), (Matcher)Is.is((Object)0));
        MatcherAssert.assertThat((Object)this.filter.getDataSetListLabels().size(), (Matcher)Is.is((Object)1));
        MatcherAssert.assertThat((Object)this.filter.getName(), (Matcher)Is.is((Object)TEST_FILTER_NAME));
    }

    @Test
    public void testFilterDoesNotExistAfterDeletion() {
        this.filterService.delete(this.filter.getId());
        MatcherAssert.assertThat((Object)((Filter)this.filterService.get(this.filter.getId())), (Matcher)IsNull.nullValue());
    }

    @Test
    public void testUpdateFilterSavedName() {
        Filter secondFilter = this.filterService.create(TEST_FILTER_NAME, this.va.getId(), Collections.emptyList(), this.dslLabels);
        this.filterService.update(this.filter.getId(), "Updated", this.filter.getDataSetLabels(), this.filter.getDataSetListLabels());
        secondFilter = (Filter)this.filterService.get(secondFilter.getId());
        Filter filter = (Filter)this.filterService.get(this.filter.getId());
        MatcherAssert.assertThat((Object)filter, (Matcher)IsNot.not((Matcher)IsNull.nullValue()));
        MatcherAssert.assertThat((Object)filter.getName(), (Matcher)Is.is((Object)"Updated"));
        MatcherAssert.assertThat((Object)secondFilter.getName(), (Matcher)Is.is((Object)TEST_FILTER_NAME));
    }

    @Test
    public void testUpdateFilterAtSaveWillAddRefToLabel() {
        Label secondDSL = this.dataSetListService.mark(this.dsl.getId(), "SecondDSL");
        this.filterService.update(this.filter.getId(), TEST_FILTER_NAME, Collections.emptyList(), Arrays.asList(this.dslLabel.getId(), secondDSL.getId()));
        Filter filter = (Filter)this.filterService.get(this.filter.getId());
        MatcherAssert.assertThat((Object)filter.getDataSetListLabels().size(), (Matcher)Is.is((Object)2));
    }

    @Test
    public void testDeleteCascade() {
        this.visibilityAreaService.delete(this.va.getId());
        Assertions.assertNull((Object)this.filterService.get(this.filter.getId()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetAllUnderVaIdReturnsAllLabelsUnderVa() {
        VisibilityArea secondVa = this.visibilityAreaService.create("Second");
        try {
            DataSetList secondDsl = this.dataSetListService.create(secondVa.getId(), "SecondDsl", null);
            Label secondDslLabel = this.dataSetListService.mark(secondDsl.getId(), "ShouldNotBeDisplayed");
            Filter secondFilter = this.filterService.create("SecondFilter", secondVa.getId(), Collections.emptyList(), Collections.singletonList(secondDslLabel.getId()));
            List all = this.filterService.getAll(this.va.getId());
            Assertions.assertFalse((boolean)all.contains(secondFilter));
            Assertions.assertTrue((boolean)all.contains(this.filter));
        }
        finally {
            this.visibilityAreaService.delete(secondVa.getId());
        }
    }

    @Test
    public void getAll_createNewFilterAndGetAllFiltersOnDsl_newFilterIsPresent() {
        Label dslLabel = this.dataSetListService.mark(this.dsl.getId(), "ShouldBeDisplayed");
        Filter filter = this.filterService.create("Filter", this.va.getId(), Collections.emptyList(), Collections.singletonList(dslLabel.getId()));
        List filters = this.filterService.getAll(this.va.getId());
        Assertions.assertTrue((boolean)filters.contains(filter));
    }

    @After
    public void tearDown() {
        this.visibilityAreaService.delete(this.va.getId());
    }
}

