/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.service.direct.impl;

import java.util.UUID;
import java.util.function.Supplier;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Isolated;
import org.qubership.atp.dataset.config.MockJaversCommitEntityServiceConfiguration;
import org.qubership.atp.dataset.config.TestConfiguration;
import org.qubership.atp.dataset.model.Attribute;
import org.qubership.atp.dataset.model.DataSet;
import org.qubership.atp.dataset.model.DataSetList;
import org.qubership.atp.dataset.model.Parameter;
import org.qubership.atp.dataset.model.VisibilityArea;
import org.qubership.atp.dataset.service.AbstractTest;
import org.qubership.atp.dataset.service.direct.helper.CreationFacade;
import org.springframework.test.context.ContextConfiguration;

@Isolated
@ContextConfiguration(classes={TestConfiguration.class, MockJaversCommitEntityServiceConfiguration.class})
public class ReferenceResolveServiceImplTest
extends AbstractTest {
    private TestData data;

    @BeforeEach
    public void setUp() {
        this.data = this.createTestDataInstance(TestData::new);
    }

    @Test
    public void testRefDslWrapperReturnsWrappedToAliasInsteadOfNames() {
        String resolve = this.wrapperService.wrapToAlias("dasdasd #REF_DSL(DSL.DS.ATTR)", this.data.va, this.data.dsl);
        resolve = resolve.substring(17, resolve.length() - 1);
        String[] split = resolve.split("\\.");
        String dslAliasId = split[0];
        String dsAliasId = split[1];
        String attrAliasId = split[2];
        Assertions.assertNotNull((Object)dslAliasId);
        Assertions.assertNotNull((Object)dsAliasId);
        Assertions.assertNotNull((Object)split[2]);
        Assertions.assertEquals((Object)this.data.attr.getId(), (Object)UUID.fromString(attrAliasId));
    }

    @Test
    public void testRefDslWrapperReturnsUnwrappedNamesOfObjects() {
        String expected = "dasdasd #REF_DSL(DSL.DS.ATTR)";
        String wrapped = this.wrapperService.wrapToAlias(expected, this.data.va, this.data.dsl);
        String unwrapped = this.wrapperService.unWrapAlias(wrapped);
        Assertions.assertEquals((Object)expected, (Object)unwrapped);
    }

    @Test
    public void testRefWrapperReturnsWrappedToAliasInsteadOfNames() {
        String resolve = this.wrapperService.wrapToAlias("dasdasd #REF(DS.ATTR)", this.data.va, this.data.dsl);
        resolve = resolve.substring(13, resolve.length() - 1);
        String[] split = resolve.split("\\.");
        String dsAliasId = split[0];
        String attrAliasId = split[1];
        Assertions.assertNotNull((Object)dsAliasId);
        Assertions.assertNotNull((Object)attrAliasId);
        Assertions.assertEquals((Object)this.data.attr.getId(), (Object)UUID.fromString(attrAliasId));
    }

    @Test
    public void testRefWrapperReturnsUnwrappedNamesOfObjects() {
        String expected = "dasdasd #REF(DS.ATTR)";
        String wrapped = this.wrapperService.wrapToAlias(expected, this.data.va, this.data.dsl);
        String unwrapped = this.wrapperService.unWrapAlias(wrapped);
        Assertions.assertEquals((Object)expected, (Object)unwrapped);
    }

    @Test
    public void testRefAndRefDslWrapperReturnsUnwrappedNamesOfObjects() {
        String expected = "dasdasd #REF(DS.ATTR) 123 #REF_DSL(DSL.DS.ATTR)";
        String wrapped = this.wrapperService.wrapToAlias(expected, this.data.va, this.data.dsl);
        String unwrapped = this.wrapperService.unWrapAlias(wrapped);
        Assertions.assertEquals((Object)expected, (Object)unwrapped);
    }

    @Test
    public void testWrapperReturnsSourceValueIfError() {
        String expected = "dasdasd #REF(DS1.ATTR) 123 #REF_DSL(D3SL.DS.ATTR)";
        String wrapped = this.wrapperService.wrapToAlias(expected, this.data.va, this.data.dsl);
        Assertions.assertEquals((Object)expected, (Object)wrapped);
        String unwrapped = this.wrapperService.unWrapAlias(wrapped);
        Assertions.assertEquals((Object)expected, (Object)unwrapped);
    }

    @Test
    public void testNestedMacro_withUnion() {
        String source = "dasdasd #REF_DSL(DSL.#REF(DS.ATTR).#REF_THIS(ATTR)) 123 #REF_DSL(DSL.DS.ATTR)";
        String wrapped = this.wrapperService.wrapToAlias(source, this.data.va, this.data.dsl);
        UUID dslRef = this.data.dsl.getId();
        UUID dsRef = this.data.ds.getId();
        UUID attrRef = this.data.attr.getId();
        String expected = String.format("dasdasd #REF_DSL(%s.#REF(%s.%s).#REF_THIS(%s)) 123 #REF_DSL(%s.%s.%s)", dslRef, dsRef, attrRef, attrRef, dslRef, dsRef, attrRef);
        Assertions.assertEquals((Object)expected, (Object)wrapped);
        String unwrapped = this.wrapperService.unWrapAlias(wrapped);
        Assertions.assertEquals((Object)source, (Object)unwrapped);
    }

    @Test
    public void testNestedMacro_withAdditionalArgs() {
        String source = "dasdasd #REF_DSL(DSL.#REF(DS.ATTR).ATTR) 123 #REF_DSL(DSL.DS.ATTR)";
        String wrapped = this.wrapperService.wrapToAlias(source, this.data.va, this.data.dsl);
        UUID dslRef = this.data.dsl.getId();
        UUID dsRef = this.data.ds.getId();
        UUID attrRef = this.data.attr.getId();
        String expected = String.format("dasdasd #REF_DSL(%s.#REF(%s.%s).ATTR) 123 #REF_DSL(%s.%s.%s)", dslRef, dsRef, attrRef, dslRef, dsRef, attrRef);
        Assertions.assertEquals((Object)expected, (Object)wrapped);
        String unwrapped = this.wrapperService.unWrapAlias(wrapped);
        Assertions.assertEquals((Object)source, (Object)unwrapped);
    }

    public static class TestData
    implements Supplier<VisibilityArea> {
        private final VisibilityArea va;
        private final DataSetList dsl;
        private final DataSet ds;
        private final Attribute attr;
        private final Parameter param;

        public TestData(CreationFacade create) {
            this.va = create.va("ReferenceResolveServiceImplTestVa");
            this.dsl = create.dsl(this.va, "DSL");
            this.ds = create.ds(this.dsl, "DS");
            this.attr = create.textAttr(this.dsl, "ATTR");
            this.param = create.textParam(this.ds, this.attr, "txt");
        }

        @Override
        public VisibilityArea get() {
            return this.va;
        }
    }
}

