/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.service.direct.impl;

import java.util.UUID;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Isolated;
import org.qubership.atp.dataset.config.TestConfiguration;
import org.qubership.atp.dataset.model.TestPlan;
import org.qubership.atp.dataset.model.VisibilityArea;
import org.qubership.atp.dataset.model.utils.TestData;
import org.qubership.atp.dataset.service.AbstractTest;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.TestPropertySource;
import org.springframework.test.context.jdbc.Sql;

@Isolated
@ContextConfiguration(classes={TestConfiguration.class})
@TestPropertySource(properties={"atp-dataset.javers.enabled=false"})
public class TestPlanImplTest
extends AbstractTest {
    private UUID visibilityAreaId = UUID.fromString("fcc17c65-6c8c-4ee4-878c-8b7d70664b06");

    @Test
    @Sql(scripts={"classpath:test_data/sql/test_plan_impl_test/TestPlanImplTest.sql"})
    public void renameTestPlan_testPlanWasRenamed() {
        TestPlan testPlan = (TestPlan)this.testPlanService.create(this.visibilityAreaId, "TP").getFirst();
        this.testPlanService.rename(testPlan.getId(), "renamedTP");
        TestPlan renamedTestPlan = (TestPlan)this.testPlanService.get(testPlan.getId());
        Assertions.assertEquals((Object)"renamedTP", (Object)renamedTestPlan.getName());
    }

    @Test
    @Sql(scripts={"classpath:test_data/sql/test_plan_impl_test/TestPlanImplTest.sql"})
    public void createTestPlanWithDuplicatedName_testPlanWasNotCreated() {
        this.testPlanService.create(this.visibilityAreaId, "TP");
        Assertions.assertFalse((boolean)((Boolean)this.testPlanService.create(this.visibilityAreaId, "TP").getSecond()));
    }

    @Test
    @Sql(scripts={"classpath:test_data/sql/test_plan_impl_test/TestPlanImplTest.sql"})
    public void deleteTestPlan_testPlanWasRemoved() {
        VisibilityArea visibilityArea = this.createTestData(TestData::addTestPlan);
        boolean deleted = this.testPlanService.delete(this.testPlanService.getByNameUnderVisibilityArea(visibilityArea.getId(), "TP").getId());
        Assertions.assertTrue((boolean)deleted);
    }

    @Test
    @Sql(scripts={"classpath:test_data/sql/test_plan_impl_test/TestPlanImplTest.sql"})
    public void deleteTestPlanByName_testPlanWasRemoved() {
        VisibilityArea visibilityArea = this.createTestData(TestData::addTestPlan);
        boolean deleted = this.testPlanService.delete(visibilityArea.getId(), "TP");
        Assertions.assertTrue((boolean)deleted);
    }
}

