/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.service.direct.importexport.service;

import clover.com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackageAccess;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsMapContaining;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.parallel.Isolated;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.qubership.atp.dataset.db.jpa.ModelsProvider;
import org.qubership.atp.dataset.db.jpa.Wrapper;
import org.qubership.atp.dataset.db.jpa.entities.AttributeEntity;
import org.qubership.atp.dataset.db.jpa.entities.AttributeKeyEntity;
import org.qubership.atp.dataset.db.jpa.entities.DataSetEntity;
import org.qubership.atp.dataset.db.jpa.entities.DataSetListEntity;
import org.qubership.atp.dataset.db.jpa.entities.ListValueEntity;
import org.qubership.atp.dataset.exception.excel.ExcelImportEmptyExcelException;
import org.qubership.atp.dataset.exception.excel.ExcelImportNotExistingAttributeException;
import org.qubership.atp.dataset.exception.excel.ExcelImportNotExistingRefParameterException;
import org.qubership.atp.dataset.exception.excel.ImportExcelNotEqualsAttributeTypeException;
import org.qubership.atp.dataset.exception.excel.ImportExcelNotSupportedAttributeTypeException;
import org.qubership.atp.dataset.model.Attribute;
import org.qubership.atp.dataset.model.AttributeType;
import org.qubership.atp.dataset.model.DataSetList;
import org.qubership.atp.dataset.model.Parameter;
import org.qubership.atp.dataset.model.impl.AttributeImpl;
import org.qubership.atp.dataset.model.impl.DataSetImpl;
import org.qubership.atp.dataset.model.impl.DataSetListImpl;
import org.qubership.atp.dataset.model.impl.ListValueImpl;
import org.qubership.atp.dataset.model.impl.ParameterImpl;
import org.qubership.atp.dataset.service.direct.ParameterService;
import org.qubership.atp.dataset.service.direct.importexport.converters.DatasetLinkAttributeImportConverter;
import org.qubership.atp.dataset.service.direct.importexport.converters.EncryptedAttributeImportConverter;
import org.qubership.atp.dataset.service.direct.importexport.converters.ListAttributeImportConverter;
import org.qubership.atp.dataset.service.direct.importexport.converters.TextAttributeImportConverter;
import org.qubership.atp.dataset.service.direct.importexport.converters.XlsxToListConverter;
import org.qubership.atp.dataset.service.direct.importexport.exceptions.ImportFailedException;
import org.qubership.atp.dataset.service.direct.importexport.models.AttributeImportContext;
import org.qubership.atp.dataset.service.direct.importexport.service.DataSetListImportExportFactory;
import org.qubership.atp.dataset.service.direct.importexport.service.DatasetListImportService;
import org.qubership.atp.dataset.service.direct.importexport.utils.ImportUtils;
import org.qubership.atp.dataset.service.direct.importexport.utils.StreamUtils;
import org.qubership.atp.dataset.service.jpa.JpaAttributeService;
import org.qubership.atp.dataset.service.jpa.JpaDataSetListService;
import org.qubership.atp.dataset.service.jpa.JpaDataSetService;
import org.qubership.atp.dataset.service.jpa.delegates.AbstractObjectWrapper;
import org.qubership.atp.dataset.service.jpa.delegates.AttributeKey;
import org.qubership.atp.dataset.service.jpa.delegates.DataSet;
import org.qubership.atp.dataset.service.jpa.delegates.ListValue;
import org.qubership.atp.dataset.service.jpa.model.AttributeTypeName;
import org.springframework.test.context.TestPropertySource;
import org.springframework.test.context.junit.jupiter.SpringExtension;
import org.springframework.test.util.ReflectionTestUtils;

@Isolated
@ExtendWith(value={SpringExtension.class})
@TestPropertySource(properties={"atp-dataset.javers.enabled=false"})
public class DatasetListImportServiceTest {
    @Mock
    private DataSetListImportExportFactory factory;
    @Mock
    private JpaDataSetListService dataSetListService;
    @Mock
    private JpaDataSetService dataSetService;
    @Mock
    private JpaAttributeService attributeService;
    @Mock
    private ParameterService parameterService;
    @Mock
    private EntityManager entityManager;
    @Mock
    private AttributeImportContext importContext;
    @Mock
    private org.qubership.atp.dataset.service.jpa.delegates.Attribute attribute;
    @Mock
    private AttributeKey attributeKey;
    @InjectMocks
    private DatasetListImportService importService;
    private UUID targetProjectId;
    private UUID targetDslId;
    private org.qubership.atp.dataset.service.jpa.delegates.DataSetList dsl1;
    private org.qubership.atp.dataset.service.jpa.delegates.DataSetList dsl2;
    private org.qubership.atp.dataset.service.jpa.delegates.DataSetList dsl3;
    private org.qubership.atp.dataset.service.jpa.delegates.DataSetList dsl4;
    private DataSet ds1;
    private DataSet ds2;
    private DataSet ds3;
    private DataSet ds4;
    private DataSet ds5;
    private DataSet ds6;
    private DataSet ds7;
    private DataSet ds8;
    private org.qubership.atp.dataset.service.jpa.delegates.Attribute text_attr;
    private org.qubership.atp.dataset.service.jpa.delegates.Attribute text_attr2;
    private org.qubership.atp.dataset.service.jpa.delegates.Attribute text_attr3;
    private org.qubership.atp.dataset.service.jpa.delegates.Attribute list_attr;
    private org.qubership.atp.dataset.service.jpa.delegates.Attribute list_attr2;
    private org.qubership.atp.dataset.service.jpa.delegates.Attribute enc_attr;
    private org.qubership.atp.dataset.service.jpa.delegates.Attribute dsl2Ref;
    private org.qubership.atp.dataset.service.jpa.delegates.Attribute a;
    private org.qubership.atp.dataset.service.jpa.delegates.Attribute b;
    private org.qubership.atp.dataset.service.jpa.delegates.Attribute enc;
    private org.qubership.atp.dataset.service.jpa.delegates.Attribute country;
    private org.qubership.atp.dataset.service.jpa.delegates.Attribute dsl3Ref;
    private org.qubership.atp.dataset.service.jpa.delegates.Attribute e;
    private org.qubership.atp.dataset.service.jpa.delegates.Attribute dsl4Ref;
    private org.qubership.atp.dataset.service.jpa.delegates.Attribute f;
    private ListValue cListValue;
    private ListValue dListValue;
    private ListValue uaListValue;
    private ListValue frListValue;
    private List<DataSet> dsl1Datasets;
    private List<DataSet> refDatasets;
    private List<org.qubership.atp.dataset.service.jpa.delegates.DataSetList> refDatasetLists;
    private Set<UUID> refDslDatasetIds;

    @BeforeEach
    public void setUp() throws NoSuchFieldException, IllegalAccessException {
        ReflectionTestUtils.setField(Wrapper.class, (String)"modelsProvider", (Object)new ModelsProvider());
        ReflectionTestUtils.setField(Wrapper.class, (String)"entityManager", (Object)this.entityManager);
        this.targetProjectId = UUID.randomUUID();
        this.targetDslId = UUID.randomUUID();
        this.dsl1 = this.generateDataSetList(this.targetDslId, "DSL 1");
        this.dsl2 = this.generateDataSetList("DSL 2");
        this.dsl3 = this.generateDataSetList("DSL 3");
        this.dsl4 = this.generateDataSetList("DSL 4");
        this.ds1 = this.generateDataset("DS 1", this.dsl1);
        this.ds2 = this.generateDataset("DS 2", this.dsl1);
        this.ds3 = this.generateDataset("DS 3", this.dsl2);
        this.ds4 = this.generateDataset("DS 4", this.dsl2);
        this.ds5 = this.generateDataset("DS 5", this.dsl3);
        this.ds6 = this.generateDataset("DS 6", this.dsl3);
        this.ds7 = this.generateDataset("DS 7", this.dsl4);
        this.ds8 = this.generateDataset("DS 8", this.dsl4);
        this.dsl1Datasets = Arrays.asList(this.ds1, this.ds2);
        this.setDatasets(this.dsl1, this.ds1, this.ds2);
        this.setDatasets(this.dsl2, this.ds3, this.ds4);
        this.setDatasets(this.dsl3, this.ds5, this.ds6);
        this.setDatasets(this.dsl4, this.ds7, this.ds8);
        List<org.qubership.atp.dataset.service.jpa.delegates.DataSetList> projectDatasetLists = Arrays.asList(this.dsl1, this.dsl2, this.dsl3, this.dsl4);
        this.text_attr = this.generateAttribute("text_attr", this.dsl1, 1L);
        this.text_attr2 = this.generateAttribute("text_attr2", this.dsl1, 1L);
        this.text_attr3 = this.generateAttribute("text_attr3", this.dsl1, 1L);
        this.list_attr = this.generateAttribute("list_attr", this.dsl1, 3L);
        this.list_attr2 = this.generateAttribute("list_attr2", this.dsl1, 3L);
        this.enc_attr = this.generateAttribute("enc_attr", this.dsl1, 6L);
        this.dsl2Ref = this.generateAttribute("DSL 2 ref", this.dsl1, this.dsl2, 4L);
        List<org.qubership.atp.dataset.service.jpa.delegates.Attribute> dsl1Attributes = Arrays.asList(this.text_attr, this.text_attr2, this.text_attr3, this.list_attr, this.list_attr2, this.enc_attr, this.dsl2Ref);
        this.setAttributes((DataSetListEntity)this.dsl1.getEntity(), this.text_attr, this.text_attr2, this.text_attr3, this.list_attr, this.list_attr2, this.enc_attr, this.dsl2Ref);
        this.a = this.generateAttribute("a", this.dsl2, 1L);
        this.b = this.generateAttribute("b", this.dsl2, 1L);
        this.enc = this.generateAttribute("enc", this.dsl2, 6L);
        this.country = this.generateAttribute("country", this.dsl2, 3L);
        this.dsl3Ref = this.generateAttribute("DSL 3 ref", this.dsl2, this.dsl3, 4L);
        this.setAttributes((DataSetListEntity)this.dsl2.getEntity(), this.a, this.b, this.enc, this.country, this.dsl3Ref);
        this.e = this.generateAttribute("e", this.dsl3, 1L);
        this.dsl4Ref = this.generateAttribute("DSL 4 ref", this.dsl3, this.dsl4, 4L);
        this.setAttributes((DataSetListEntity)this.dsl3.getEntity(), this.e, this.dsl4Ref);
        this.f = this.generateAttribute("f", this.dsl4, 1L);
        this.setAttributes((DataSetListEntity)this.dsl4.getEntity(), this.f);
        ListValue aListValue = this.generateListValue("a");
        ListValue bListValue = this.generateListValue("b");
        this.cListValue = this.generateListValue("c");
        this.dListValue = this.generateListValue("d");
        this.uaListValue = this.generateListValue("UA");
        ListValue spListValue = this.generateListValue("SP");
        this.frListValue = this.generateListValue("FR");
        List<ListValue> list_attrListValues = Arrays.asList(aListValue, bListValue, this.cListValue, this.dListValue);
        List<ListValue> countryListValues = Arrays.asList(this.uaListValue, spListValue, this.frListValue);
        Object ds1_text_attr = null;
        Parameter ds2_text_attr = this.generateParameter("land", this.ds2, this.text_attr, null, null);
        Parameter ds1_text_attr2 = this.generateParameter("", this.ds1, this.text_attr2, null, null);
        Parameter ds2_text_attr2 = this.generateParameter("la", this.ds2, this.text_attr2, null, null);
        Parameter ds1_text_attr3 = this.generateParameter("", this.ds1, this.text_attr3, null, null);
        Parameter ds2_text_attr3 = this.generateParameter("text", this.ds2, this.text_attr3, null, null);
        Parameter ds1_list_attr = this.generateParameter("c", this.ds1, this.list_attr, this.cListValue, null);
        Parameter ds2_list_attr = this.generateParameter("", this.ds2, this.list_attr, null, null);
        Parameter ds1_list_attr2 = this.generateParameter("c", this.ds1, this.list_attr2, this.cListValue, null);
        Parameter ds2_list_attr2 = this.generateParameter("d", this.ds2, this.list_attr2, this.dListValue, null);
        Parameter dsl2_ds3_dsl2ref = this.generateParameter("DSL 2 ref", this.ds1, this.dsl2Ref, null, this.ds4);
        Parameter dsl2_ds3_a = this.generateParameter("1", this.ds3, this.a, null, null);
        Parameter dsl2_ds3_b = this.generateParameter("2", this.ds3, this.b, null, null);
        Parameter dsl2_ds3_country = this.generateParameter("UA", this.ds3, this.country, this.uaListValue, null);
        Object dsl2_ds4_dsl2ref = null;
        Parameter dsl2_ds4_a = this.generateParameter("3", this.ds4, this.a, null, null);
        Parameter dsl2_ds4_b = this.generateParameter("4", this.ds4, this.b, null, null);
        Parameter dsl2_ds4_country = this.generateParameter("SP", this.ds4, this.country, spListValue, null);
        Parameter dsl3_ds5_dsl3ref = this.generateParameter("DSL 3 ref", this.ds3, this.dsl3Ref, null, this.ds5);
        Parameter dsl3_ds5_e = this.generateParameter("5", this.ds5, this.e, null, null);
        Parameter dsl3_ds6_dsl3ref = this.generateParameter("DSL 3 ref", this.ds4, this.dsl3Ref, null, this.ds6);
        Parameter dsl3_ds6_e = this.generateParameter("6", this.ds6, this.e, null, null);
        Parameter dsl4_ds7_dsl4ref = this.generateParameter("DSL 4 ref", this.ds5, this.dsl4Ref, null, this.ds7);
        Parameter dsl4_ds7_f = this.generateParameter("4", this.ds7, this.f, null, null);
        Parameter dsl4_ds8_dsl4ref = this.generateParameter("DSL 4 ref", this.ds6, this.dsl4Ref, null, this.ds8);
        Parameter dsl4_ds8_f = this.generateParameter("5", this.ds8, this.f, null, null);
        HashSet dsl2DatasetIds = Sets.newHashSet((Object[])new UUID[]{this.ds3.getId(), this.ds4.getId()});
        ImmutableMap.of((Object)this.a, Arrays.asList(dsl2_ds3_a, dsl2_ds4_a), (Object)this.b, Arrays.asList(dsl2_ds3_b, dsl2_ds4_b), (Object)this.country, Arrays.asList(dsl2_ds3_country, dsl2_ds4_country), (Object)this.dsl3Ref, Arrays.asList(dsl3_ds5_dsl3ref, dsl3_ds6_dsl3ref)).forEach((attr, parameters) -> Mockito.when((Object)this.parameterService.getByAttributeIdAndDatasetIds(attr.getId(), dsl2DatasetIds)).thenReturn(parameters));
        HashSet dsl3DatasetIds = Sets.newHashSet((Object[])new UUID[]{this.ds5.getId(), this.ds6.getId()});
        ImmutableMap.of((Object)this.e, Arrays.asList(dsl3_ds5_e, dsl3_ds6_e), (Object)this.dsl4Ref, Arrays.asList(dsl4_ds7_dsl4ref, dsl4_ds8_dsl4ref)).forEach((attr, parameters) -> Mockito.when((Object)this.parameterService.getByAttributeIdAndDatasetIds(attr.getId(), dsl3DatasetIds)).thenReturn(parameters));
        HashSet dsl4DatasetIds = Sets.newHashSet((Object[])new UUID[]{this.ds7.getId(), this.ds8.getId()});
        ImmutableMap.of((Object)this.f, Arrays.asList(dsl4_ds7_f, dsl4_ds8_f)).forEach((attr, parameters) -> Mockito.when((Object)this.parameterService.getByAttributeIdAndDatasetIds(attr.getId(), dsl4DatasetIds)).thenReturn(parameters));
        Mockito.when((Object)this.attributeService.getByDataSetListId(this.targetDslId)).thenReturn(dsl1Attributes);
        Mockito.when((Object)this.dataSetService.getByDataSetListId(this.targetDslId)).thenReturn(this.dsl1Datasets);
        Mockito.when((Object)this.dataSetListService.getByVisibilityAreaId(this.targetProjectId)).thenReturn(projectDatasetLists);
        this.refDatasetLists = Arrays.asList(this.dsl2, this.dsl3, this.dsl4);
        this.refDatasets = Arrays.asList(this.ds3, this.ds4, this.ds5, this.ds6, this.ds7, this.ds8);
        this.refDslDatasetIds = StreamUtils.extractIds(this.refDatasets, DataSet::getId);
        Mockito.when((Object)this.dataSetService.getByDataSetListIdIn((Collection)StreamUtils.extractIds(this.refDatasetLists, org.qubership.atp.dataset.service.jpa.delegates.DataSetList::getId))).thenReturn(this.refDatasets);
        Mockito.when((Object)this.attributeService.getListValuesByAttributeId(this.list_attr.getId())).thenReturn(list_attrListValues);
        Mockito.when((Object)this.attributeService.getListValuesByAttributeId(this.list_attr2.getId())).thenReturn(list_attrListValues);
        Mockito.when((Object)this.attributeService.getListValuesByAttributeId(this.country.getId())).thenReturn(countryListValues);
        Mockito.when((Object)this.attributeService.getListValueByAttributeIdAndValue(this.list_attr2.getId(), this.dListValue.getText())).thenReturn((Object)this.dListValue);
        Mockito.when((Object)this.attributeService.getListValueByAttributeIdAndValue(this.country.getId(), this.frListValue.getText())).thenReturn((Object)this.frListValue);
        Mockito.when((Object)this.factory.getAttributeImportConverter(AttributeType.TEXT.getName())).thenReturn((Object)new TextAttributeImportConverter(this.parameterService));
        Mockito.when((Object)this.factory.getAttributeImportConverter(AttributeType.LIST.getName())).thenReturn((Object)new ListAttributeImportConverter(this.parameterService, this.attributeService));
        Mockito.when((Object)this.factory.getAttributeImportConverter(AttributeType.DSL.getName())).thenReturn((Object)new DatasetLinkAttributeImportConverter(this.parameterService));
        Mockito.when((Object)this.factory.getAttributeImportConverter(AttributeType.ENCRYPTED.getName())).thenReturn((Object)new EncryptedAttributeImportConverter(this.parameterService));
        Mockito.when((Object)((DataSetListEntity)this.entityManager.find(DataSetListEntity.class, (Object)this.dsl2Ref.getTypeDataSetListId()))).thenReturn((Object)((DataSetListEntity)this.dsl2.getEntity()));
        Mockito.when((Object)((DataSetListEntity)this.entityManager.find(DataSetListEntity.class, (Object)this.dsl3Ref.getTypeDataSetListId()))).thenReturn((Object)((DataSetListEntity)this.dsl3.getEntity()));
        Mockito.when((Object)((DataSetListEntity)this.entityManager.find(DataSetListEntity.class, (Object)this.dsl4Ref.getTypeDataSetListId()))).thenReturn((Object)((DataSetListEntity)this.dsl4.getEntity()));
        Mockito.when((Object)this.parameterService.getByDataSetIdAttributeId(this.ds1.getId(), this.text_attr.getId())).thenReturn(ds1_text_attr);
        Mockito.when((Object)this.parameterService.getByDataSetIdAttributeId(this.ds2.getId(), this.text_attr.getId())).thenReturn((Object)ds2_text_attr);
        Mockito.when((Object)this.parameterService.getByDataSetIdAttributeId(this.ds1.getId(), this.text_attr2.getId())).thenReturn((Object)ds1_text_attr2);
        Mockito.when((Object)this.parameterService.getByDataSetIdAttributeId(this.ds2.getId(), this.text_attr2.getId())).thenReturn((Object)ds2_text_attr2);
        Mockito.when((Object)this.parameterService.getByDataSetIdAttributeId(this.ds1.getId(), this.text_attr3.getId())).thenReturn((Object)ds1_text_attr3);
        Mockito.when((Object)this.parameterService.getByDataSetIdAttributeId(this.ds2.getId(), this.text_attr3.getId())).thenReturn((Object)ds2_text_attr3);
        Mockito.when((Object)this.parameterService.getByDataSetIdAttributeId(this.ds1.getId(), this.list_attr.getId())).thenReturn((Object)ds1_list_attr);
        Mockito.when((Object)this.parameterService.getByDataSetIdAttributeId(this.ds2.getId(), this.list_attr.getId())).thenReturn((Object)ds2_list_attr);
        Mockito.when((Object)this.parameterService.getByDataSetIdAttributeId(this.ds1.getId(), this.list_attr2.getId())).thenReturn((Object)ds1_list_attr2);
        Mockito.when((Object)this.parameterService.getByDataSetIdAttributeId(this.ds2.getId(), this.list_attr2.getId())).thenReturn((Object)ds2_list_attr2);
        Mockito.when((Object)this.parameterService.getByDataSetIdAttributeId(this.ds1.getId(), this.dsl2Ref.getId())).thenReturn((Object)dsl2_ds3_dsl2ref);
        Mockito.when((Object)this.parameterService.getByDataSetIdAttributeId(this.ds2.getId(), this.dsl2Ref.getId())).thenReturn(dsl2_ds4_dsl2ref);
        Mockito.when((Object)this.parameterService.getByDataSetIdAttributeId(this.ds3.getId(), this.a.getId())).thenReturn((Object)dsl2_ds3_a);
        Mockito.when((Object)this.parameterService.getByDataSetIdAttributeId(this.ds4.getId(), this.a.getId())).thenReturn((Object)dsl2_ds4_a);
        Mockito.when((Object)this.parameterService.getByDataSetIdAttributeId(this.ds3.getId(), this.b.getId())).thenReturn((Object)dsl2_ds3_b);
        Mockito.when((Object)this.parameterService.getByDataSetIdAttributeId(this.ds4.getId(), this.b.getId())).thenReturn((Object)dsl2_ds4_b);
        Mockito.when((Object)this.parameterService.getByDataSetIdAttributeId(this.ds3.getId(), this.country.getId())).thenReturn((Object)dsl2_ds3_country);
        Mockito.when((Object)this.parameterService.getByDataSetIdAttributeId(this.ds4.getId(), this.country.getId())).thenReturn((Object)dsl2_ds4_country);
        Mockito.when((Object)this.parameterService.getByDataSetIdAttributeId(this.ds5.getId(), this.e.getId())).thenReturn((Object)dsl3_ds5_e);
        Mockito.when((Object)this.parameterService.getByDataSetIdAttributeId(this.ds6.getId(), this.e.getId())).thenReturn((Object)dsl3_ds6_e);
        Mockito.when((Object)this.parameterService.getByDataSetIdAttributeId(this.ds7.getId(), this.f.getId())).thenReturn((Object)dsl4_ds7_f);
        Mockito.when((Object)this.parameterService.getByDataSetIdAttributeId(this.ds8.getId(), this.f.getId())).thenReturn((Object)dsl4_ds8_f);
    }

    @Test
    public void importDataSetList_ImportExcelFileWhenLockedDataSet_Exception() throws Exception {
        this.ds1.setLocked(true);
        List<DataSet> lockedDataSets = Collections.singletonList(this.ds1);
        Mockito.when((Object)this.dataSetService.getLockedDataSets(this.targetDslId)).thenReturn(lockedDataSets);
        Mockito.when((Object)this.dataSetListService.getById(this.targetDslId)).thenReturn((Object)this.dsl1);
        try {
            Path path = Paths.get("src/test/resources/excel/import/valid_import_file.xlsx", new String[0]);
            this.importService.importDataSetList(this.targetProjectId, this.targetDslId, Files.newInputStream(path, new OpenOption[0]), false);
        }
        catch (ImportFailedException e) {
            Assertions.assertTrue((boolean)e.getMessage().contains("Failed to import DataSetList"));
        }
    }

    @Test
    public void importDataSetList() throws Exception {
        File file = Paths.get("src/test/resources/excel/import/valid_import_file.xlsx", new String[0]).toFile();
        this.importService.importDataSetList(this.targetProjectId, this.targetDslId, (InputStream)new FileInputStream(file), false);
        UUID ds1Id = this.ds1.getId();
        UUID ds2Id = this.ds2.getId();
        ((ParameterService)Mockito.verify((Object)this.parameterService, (VerificationMode)Mockito.never())).setParamSelectJavers(ds1Id, this.text_attr.getId(), Collections.emptyList(), "", null, null, false);
        ((ParameterService)Mockito.verify((Object)this.parameterService, (VerificationMode)Mockito.never())).setParamSelectJavers(ds2Id, this.text_attr.getId(), Collections.emptyList(), "land", null, null, false);
        ((ParameterService)Mockito.verify((Object)this.parameterService, (VerificationMode)Mockito.never())).setParamSelectJavers(ds1Id, this.text_attr2.getId(), Collections.emptyList(), "", null, null, false);
        ((ParameterService)Mockito.verify((Object)this.parameterService, (VerificationMode)Mockito.times((int)1))).setParamSelectJavers(ds2Id, this.text_attr2.getId(), Collections.emptyList(), "land2", null, null, false);
        ((ParameterService)Mockito.verify((Object)this.parameterService, (VerificationMode)Mockito.times((int)1))).setParamSelectJavers(ds1Id, this.text_attr3.getId(), Collections.emptyList(), "text1", null, null, false);
        ((ParameterService)Mockito.verify((Object)this.parameterService, (VerificationMode)Mockito.times((int)1))).setParamSelectJavers(ds2Id, this.text_attr3.getId(), Collections.emptyList(), "", null, null, false);
        ((ParameterService)Mockito.verify((Object)this.parameterService, (VerificationMode)Mockito.never())).setParamSelectJavers(ds1Id, this.list_attr.getId(), Collections.emptyList(), this.cListValue.getText(), null, this.cListValue.getId(), false);
        ((ParameterService)Mockito.verify((Object)this.parameterService, (VerificationMode)Mockito.never())).deleteParamSelectJavers(this.list_attr.getId(), ds2Id, this.targetDslId, Collections.emptyList(), false);
        ((ParameterService)Mockito.verify((Object)this.parameterService, (VerificationMode)Mockito.times((int)1))).setParamSelectJavers(ds1Id, this.list_attr2.getId(), Collections.emptyList(), null, null, this.dListValue.getId(), false);
        ((ParameterService)Mockito.verify((Object)this.parameterService, (VerificationMode)Mockito.times((int)1))).deleteParamSelectJavers(this.list_attr2.getId(), ds2Id, this.targetDslId, Collections.emptyList(), false);
        ((ParameterService)Mockito.verify((Object)this.parameterService, (VerificationMode)Mockito.times((int)1))).setParamSelectJavers(ds1Id, this.enc_attr.getId(), Collections.emptyList(), "", null, null, false);
        ((ParameterService)Mockito.verify((Object)this.parameterService, (VerificationMode)Mockito.times((int)1))).setParamSelectJavers(ds2Id, this.enc_attr.getId(), Collections.emptyList(), "cXdlcnR5cXFxcXE=", null, null, false);
        ((ParameterService)Mockito.verify((Object)this.parameterService, (VerificationMode)Mockito.times((int)1))).setParamSelectJavers(ds1Id, this.dsl2Ref.getId(), Collections.emptyList(), null, this.ds3.getId(), null, false);
        ((ParameterService)Mockito.verify((Object)this.parameterService, (VerificationMode)Mockito.times((int)1))).setParamSelectJavers(ds2Id, this.dsl2Ref.getId(), Collections.emptyList(), null, this.ds4.getId(), null, false);
        List<UUID> dsl2RefAttributePath = Collections.singletonList(this.dsl2Ref.getId());
        ((ParameterService)Mockito.verify((Object)this.parameterService, (VerificationMode)Mockito.never())).setParamSelectJavers(ds1Id, this.a.getId(), Collections.emptyList(), "1", null, null, false);
        ((ParameterService)Mockito.verify((Object)this.parameterService, (VerificationMode)Mockito.times((int)1))).setParamSelectJavers(ds2Id, this.a.getId(), dsl2RefAttributePath, "4444", null, null, false);
        ((ParameterService)Mockito.verify((Object)this.parameterService, (VerificationMode)Mockito.times((int)1))).setParamSelectJavers(ds1Id, this.b.getId(), dsl2RefAttributePath, "3333", null, null, false);
        ((ParameterService)Mockito.verify((Object)this.parameterService, (VerificationMode)Mockito.never())).setParamSelectJavers(ds2Id, this.b.getId(), Collections.emptyList(), "4", null, null, false);
        ((ParameterService)Mockito.verify((Object)this.parameterService, (VerificationMode)Mockito.times((int)1))).setParamSelectJavers(ds1Id, this.enc.getId(), dsl2RefAttributePath, "cXdldw==", null, null, false);
        ((ParameterService)Mockito.verify((Object)this.parameterService, (VerificationMode)Mockito.times((int)1))).setParamSelectJavers(ds2Id, this.enc.getId(), dsl2RefAttributePath, "cXdlcQ==", null, null, false);
        ((ParameterService)Mockito.verify((Object)this.parameterService, (VerificationMode)Mockito.never())).setParamSelectJavers(ds1Id, this.country.getId(), Collections.emptyList(), this.uaListValue.getText(), null, this.uaListValue.getId(), false);
        ((ParameterService)Mockito.verify((Object)this.parameterService, (VerificationMode)Mockito.times((int)1))).setParamSelectJavers(ds2Id, this.country.getId(), dsl2RefAttributePath, null, null, this.frListValue.getId(), false);
        ((ParameterService)Mockito.verify((Object)this.parameterService, (VerificationMode)Mockito.never())).setParamSelectJavers(ds1Id, this.dsl3Ref.getId(), Collections.emptyList(), null, this.ds5.getId(), null, false);
        ((ParameterService)Mockito.verify((Object)this.parameterService, (VerificationMode)Mockito.never())).setParamSelectJavers(ds2Id, this.dsl3Ref.getId(), Collections.emptyList(), null, this.ds6.getId(), null, false);
        List<UUID> dsl3RefAttributePath = Arrays.asList(this.dsl2Ref.getId(), this.dsl3Ref.getId());
        ((ParameterService)Mockito.verify((Object)this.parameterService, (VerificationMode)Mockito.never())).setParamSelectJavers(ds1Id, this.e.getId(), Collections.emptyList(), "5", null, null, false);
        ((ParameterService)Mockito.verify((Object)this.parameterService, (VerificationMode)Mockito.times((int)1))).setParamSelectJavers(ds2Id, this.e.getId(), dsl3RefAttributePath, "666", null, null, false);
        ((ParameterService)Mockito.verify((Object)this.parameterService, (VerificationMode)Mockito.never())).setParamSelectJavers(ds1Id, this.dsl4Ref.getId(), Collections.emptyList(), null, this.ds7.getId(), null, false);
        ((ParameterService)Mockito.verify((Object)this.parameterService, (VerificationMode)Mockito.never())).setParamSelectJavers(ds2Id, this.dsl4Ref.getId(), Collections.emptyList(), null, this.ds8.getId(), null, false);
        List<UUID> dsl4RefAttributePath = Arrays.asList(this.dsl2Ref.getId(), this.dsl3Ref.getId(), this.dsl4Ref.getId());
        ((ParameterService)Mockito.verify((Object)this.parameterService, (VerificationMode)Mockito.never())).setParamSelectJavers(ds1Id, this.f.getId(), Collections.emptyList(), "4", null, null, false);
        ((ParameterService)Mockito.verify((Object)this.parameterService, (VerificationMode)Mockito.times((int)1))).setParamSelectJavers(ds2Id, this.f.getId(), dsl4RefAttributePath, "7", null, null, false);
    }

    @Test
    public void importDataSetList_ThereAreDuplicateDslNames_ErrorWhileImportDataSetList() throws Exception {
        ((JpaDataSetListService)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException("There are duplicate DSL names : []")}).when((Object)this.dataSetListService)).checkDslNames(this.targetProjectId);
        File file = Paths.get("src/test/resources/excel/import/valid_import_file.xlsx", new String[0]).toFile();
        Assertions.assertThrows(Exception.class, () -> this.importService.importDataSetList(this.targetProjectId, this.targetDslId, (InputStream)new FileInputStream(file), false));
    }

    @Test
    public void importFileWithNotSupportedAttributeType_validateImportFileSchema_expectImportExcelNotSupportedAttributeTypeException() {
        ListIterator<Map<Integer, String>> rowsIterator = this.getFileRowIterator("import_file_with_not_supported_attribute_type.xlsx");
        Assertions.assertThrows(ImportExcelNotSupportedAttributeTypeException.class, () -> this.importService.validateImportFileSchema(this.targetDslId, rowsIterator, this.importContext), (String)"Invalid attribute 'text_attr' type: 'FILE'. Supported import types: [TEXT, LIST, DSL, ENCRYPTED]");
    }

    @Test
    public void importFileWithNotExistedDsRefParamValue_validateImportFileSchema_expectExcelImportNotExistingRefParameterException() {
        ListIterator<Map<Integer, String>> rowsIterator = this.getFileRowIterator("import_file_with_not_existed_ds_ref_param_value.xlsx");
        String atrName = "DSL 2 ref";
        String textAttrName = "text_attr";
        String listAttrName = "list_attr";
        String encryptAttrName = "enc_attr";
        HashMap<String, org.qubership.atp.dataset.service.jpa.delegates.Attribute> attributesNameMap = new HashMap<String, org.qubership.atp.dataset.service.jpa.delegates.Attribute>();
        attributesNameMap.put(atrName, this.attribute);
        attributesNameMap.put(textAttrName, this.attribute);
        attributesNameMap.put(listAttrName, this.attribute);
        attributesNameMap.put(encryptAttrName, this.attribute);
        Mockito.when((Object)this.importContext.getAttributesNameMap()).thenReturn(attributesNameMap);
        Mockito.when((Object)this.attribute.getTypeDataSetListId()).thenReturn((Object)UUID.randomUUID());
        Mockito.when((Object)this.attribute.getAttributeType()).thenReturn((Object)AttributeTypeName.TEXT).thenReturn((Object)AttributeTypeName.LIST).thenReturn((Object)AttributeTypeName.ENCRYPTED).thenReturn((Object)AttributeTypeName.DSL);
        Assertions.assertThrows(ExcelImportNotExistingRefParameterException.class, () -> this.importService.validateImportFileSchema(this.targetDslId, rowsIterator, this.importContext), (String)"Provided referenced [DSL 2 ->  NOT EXISTED DS], DS ' NOT EXISTED DS', in attribute 'DSL 2 ref' parameter doesn't exist");
    }

    @Test
    public void importFileWithNotExistedAttribute_validateImportFileSchema_expectImportExcelNotEqualsAttributeTypeException() {
        ListIterator<Map<Integer, String>> rowsIterator = this.getFileRowIterator("import_file_with_not_existed_attribute.xlsx");
        String textAttrName = "text_attr";
        HashMap<String, org.qubership.atp.dataset.service.jpa.delegates.Attribute> attributesNameMap = new HashMap<String, org.qubership.atp.dataset.service.jpa.delegates.Attribute>();
        attributesNameMap.put(textAttrName, this.attribute);
        Mockito.when((Object)this.importContext.getAttributesNameMap()).thenReturn(attributesNameMap);
        Mockito.when((Object)this.attribute.getAttributeType()).thenReturn((Object)AttributeTypeName.LIST);
        Assertions.assertThrows(ImportExcelNotEqualsAttributeTypeException.class, () -> this.importService.validateImportFileSchema(this.targetDslId, rowsIterator, this.importContext), (String)"Failed to import data set list: attribute 'some_not_existed_attr' doesn't exist in DSL schema");
    }

    @Test
    public void importFileWithNotExistedAttribute_validateImportFileSchema_expectExcelImportNotExistingAttributeException() {
        ListIterator<Map<Integer, String>> rowsIterator = this.getFileRowIterator("import_file_with_not_existed_attribute.xlsx");
        String textAttrName = "text_attr";
        HashMap<String, org.qubership.atp.dataset.service.jpa.delegates.Attribute> attributesNameMap = new HashMap<String, org.qubership.atp.dataset.service.jpa.delegates.Attribute>();
        attributesNameMap.put(textAttrName, this.attribute);
        Mockito.when((Object)this.importContext.getAttributesNameMap()).thenReturn(attributesNameMap);
        Mockito.when((Object)this.attribute.getAttributeType()).thenReturn((Object)AttributeTypeName.TEXT);
        Assertions.assertThrows(ExcelImportNotExistingAttributeException.class, () -> this.importService.validateImportFileSchema(this.targetDslId, rowsIterator, this.importContext), (String)"Failed to import data set list: attribute 'some_not_existed_attr' doesn't exist in DSL schema");
    }

    @Test
    public void emptyImportFileImported_validateImportFileSchema_expectImportException() {
        ListIterator<Map<Integer, String>> rowsIterator = this.getFileRowIterator("empty_import_file.xlsx");
        Assertions.assertThrows(ExcelImportEmptyExcelException.class, () -> this.importService.validateImportFileSchema(this.targetDslId, rowsIterator, this.importContext), (String)"Failed to import data set list. Reason: empty import file content");
    }

    @Test
    public void emptyHeadingRowImportFileImported_validateImportFileSchema_expectImportException() {
        ListIterator<Map<Integer, String>> rowsIterator = this.getFileRowIterator("empty_heading_row_import_file.xlsx");
        Assertions.assertThrows(ExcelImportEmptyExcelException.class, () -> this.importService.validateImportFileSchema(this.targetDslId, rowsIterator, this.importContext), (String)"Failed to import data set list. Reason: empty import file content");
    }

    @Test
    public void invalidImportFileWithoutAttributeHeading_validateImportFileSchema_expectImportException() {
        ListIterator<Map<Integer, String>> rowsIterator = this.getFileRowIterator("import_file_without_attribute_heading.xlsx");
        Assertions.assertThrows(ImportFailedException.class, () -> this.importService.validateImportFileSchema(this.targetDslId, rowsIterator, this.importContext), (String)"Required heading 'Attribute' is absent");
    }

    @Test
    public void invalidImportFileIncorrectAttributeHeading_validateImportFileSchema_expectImportException() {
        ListIterator<Map<Integer, String>> rowsIterator = this.getFileRowIterator("import_file_incorrect_attribute_heading.xlsx");
        Assertions.assertThrows(ImportFailedException.class, () -> this.importService.validateImportFileSchema(this.targetDslId, rowsIterator, this.importContext), (String)"Required heading 'Attribute' has incorrect name");
    }

    @Test
    public void invalidImportFileIncorrectTypeHeading_validateImportFileSchema_expectImportException() {
        ListIterator<Map<Integer, String>> rowsIterator = this.getFileRowIterator("import_file_incorrect_type_heading.xlsx");
        Assertions.assertThrows(ImportFailedException.class, () -> this.importService.validateImportFileSchema(this.targetDslId, rowsIterator, this.importContext), (String)"Required heading 'Type' has incorrect name");
    }

    @Test
    public void invalidImportFileWithoutTypeHeading_validateImportFileSchema_expectImportException() {
        ListIterator<Map<Integer, String>> rowsIterator = this.getFileRowIterator("import_file_without_type_heading.xlsx");
        Assertions.assertThrows(ImportFailedException.class, () -> this.importService.validateImportFileSchema(this.targetDslId, rowsIterator, this.importContext), (String)"Required heading 'Type' is absent");
    }

    @Test
    public void importFileWithNotExistedDataset_prepareImportContext_expectCreateDatasetCell() throws Exception {
        ListIterator<Map<Integer, String>> rowsIterator = this.getFileRowIterator("valid_import_file_with_not_existed_datasets.xlsx");
        ArgumentCaptor datasetNameCaptor = ArgumentCaptor.forClass(String.class);
        ArgumentCaptor datasetDslIdCaptor = ArgumentCaptor.forClass(UUID.class);
        String ds3Name = "DS 3";
        String ds4Name = "DS 4";
        Mockito.when((Object)this.dataSetService.createDsSelectJavers("DS 3", this.targetDslId, false)).thenReturn((Object)this.generateDataset("DS 3", this.dsl1));
        Mockito.when((Object)this.dataSetService.createDsSelectJavers("DS 4", this.targetDslId, false)).thenReturn((Object)this.generateDataset("DS 4", this.dsl1));
        this.importService.prepareImportContext(this.targetProjectId, this.targetDslId, rowsIterator, false);
        ((JpaDataSetService)Mockito.verify((Object)this.dataSetService, (VerificationMode)Mockito.times((int)2))).createDsSelectJavers((String)datasetNameCaptor.capture(), (UUID)datasetDslIdCaptor.capture(), ArgumentMatchers.eq((boolean)false));
        List datasetNames = datasetNameCaptor.getAllValues();
        MatcherAssert.assertThat((Object)datasetNames, (Matcher)Matchers.hasSize((int)2));
        MatcherAssert.assertThat((Object)datasetNames, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"DS 3", "DS 4"}));
        HashSet targetDslIds = new HashSet(datasetDslIdCaptor.getAllValues());
        MatcherAssert.assertThat(targetDslIds, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat(targetDslIds, (Matcher)CoreMatchers.hasItem((Object)this.targetDslId));
    }

    @Test
    public void allNeededEntitiesAreLoadedFromDb_prepareImportContext_expectCorrectContextData() {
        ListIterator<Map<Integer, String>> rowsIterator = this.getFileRowIterator("valid_import_file.xlsx");
        AttributeImportContext importContext = this.importService.prepareImportContext(this.targetProjectId, this.targetDslId, rowsIterator, false);
        Map datasetsMap = importContext.getDatasetsMap();
        Map datasetsNameIdMap = importContext.getDatasetsNameIdMap();
        MatcherAssert.assertThat((String)"Dataset name to id map has incorrect size", (Object)datasetsMap.size(), (Matcher)CoreMatchers.is((Object)this.dsl1Datasets.size()));
        this.dsl1Datasets.forEach(dataset -> {
            String datasetName = dataset.getName();
            UUID datasetId = dataset.getId();
            String datasetsMapErrorMsg = String.format("Dataset map should contain dataset: %s", datasetName);
            MatcherAssert.assertThat((String)datasetsMapErrorMsg, (Object)datasetsMap, (Matcher)IsMapContaining.hasEntry((Object)datasetId, (Object)dataset));
            String datasetsNameIdMapErrorMsg = String.format("Dataset name to id map should contain dataset: %s", datasetName);
            MatcherAssert.assertThat((String)datasetsNameIdMapErrorMsg, (Object)datasetsNameIdMap, (Matcher)IsMapContaining.hasEntry((Object)datasetName, (Object)datasetId));
        });
        Map refDatasetsNameIdMap = importContext.getRefDatasetsNameIdMap();
        MatcherAssert.assertThat((String)"Ref dataset name to id map has incorrect size", (Object)refDatasetsNameIdMap.size(), (Matcher)CoreMatchers.is((Object)this.refDatasets.size()));
        this.refDatasets.forEach(refDataset -> {
            UUID datasetId = refDataset.getId();
            String datasetKey = ImportUtils.getDatasetKey((DataSet)refDataset);
            String refDatasetsNameIdMapErrorMsg = String.format("Ref dataset name to id map should contain dataset with key: %s", datasetKey);
            MatcherAssert.assertThat((String)refDatasetsNameIdMapErrorMsg, (Object)refDatasetsNameIdMap, (Matcher)IsMapContaining.hasEntry((Object)datasetKey, (Object)datasetId));
        });
        Map refDslDatasetsMap = importContext.getRefDslDatasetIdsMap();
        MatcherAssert.assertThat((String)"Ref DSL datasets map has incorrect size", (Object)refDslDatasetsMap.size(), (Matcher)CoreMatchers.is((Object)this.refDatasetLists.size()));
        this.refDatasetLists.forEach(refDatasetList -> {
            String refDatasetListName = refDatasetList.getName();
            String refDslDatasetsErrorMsg = String.format("Ref DSL datasets map should contain DSL with key: %s", refDatasetListName);
            MatcherAssert.assertThat((String)refDslDatasetsErrorMsg, (Object)refDslDatasetsMap, (Matcher)IsMapContaining.hasKey((Object)refDatasetListName));
            Set dslDatasetIds = (Set)refDslDatasetsMap.get(refDatasetListName);
            dslDatasetIds.forEach(dslDatasetId -> {
                String refDslDatasetsIdErrorMsg = String.format("Ref DSL datasets map DSL '%s' should contain dataset with id: %s", refDatasetListName, dslDatasetId);
                Assertions.assertTrue((boolean)this.refDslDatasetIds.contains(dslDatasetId), (String)refDslDatasetsIdErrorMsg);
            });
        });
    }

    @Test
    public void allAttributesSet_getDslAttributesMap_getValidDslAttributesMap() {
        Map resultDslAttributesMap = this.importService.getDslAttributesMap(this.targetDslId);
        String errorMessage = "DSL attribute map doesn't contain required key";
        MatcherAssert.assertThat((String)errorMessage, (Object)resultDslAttributesMap, (Matcher)IsMapContaining.hasKey((Object)this.text_attr.getName()));
        MatcherAssert.assertThat((String)errorMessage, (Object)resultDslAttributesMap, (Matcher)IsMapContaining.hasKey((Object)this.list_attr.getName()));
        MatcherAssert.assertThat((String)errorMessage, (Object)resultDslAttributesMap, (Matcher)IsMapContaining.hasKey((Object)this.enc_attr.getName()));
        MatcherAssert.assertThat((String)errorMessage, (Object)resultDslAttributesMap, (Matcher)IsMapContaining.hasKey((Object)this.dsl2Ref.getName()));
    }

    @Test
    public void invalidImportFileWithoutDatasetHeadings_getExistedDatasetsCellIndexMap_expectException() {
        Map<Integer, String> headingRow = this.getFileHeadingRow("import_file_without_dataset_headings.xlsx");
        Assertions.assertThrows(ImportFailedException.class, () -> this.importService.getExistedDatasetsCellIndexMap(headingRow), (String)"Imported dataset columns are absent");
    }

    @Test
    public void validImportFileWithDatasetHeadings_getExistedDatasetsCellIndexMap_expectValidCellIndexMap() {
        Map<Integer, String> headingRow = this.getFileHeadingRow("import_file_with_dataset_headings.xlsx");
        Map resultCellIndexMap = this.importService.getExistedDatasetsCellIndexMap(headingRow);
        HashMap<String, Integer> expectedCellIndexMap = new HashMap<String, Integer>();
        expectedCellIndexMap.put("DS 1", 2);
        expectedCellIndexMap.put("DS 2", 3);
        expectedCellIndexMap.put("DS 3", 4);
        MatcherAssert.assertThat((String)"Dataset cell index map is incorrect after heading row parsing", (Object)resultCellIndexMap, (Matcher)CoreMatchers.is(expectedCellIndexMap));
    }

    private void setDatasets(org.qubership.atp.dataset.service.jpa.delegates.DataSetList datasetList, DataSet ... datasets) {
        List dataSetEntities = Arrays.stream(datasets).map(dataSet -> {
            DataSetEntity dataSetEntity = new DataSetEntity();
            dataSetEntity.setId(dataSet.getId());
            dataSetEntity.setName(dataSet.getName());
            return dataSetEntity;
        }).collect(Collectors.toList());
        DataSetListEntity entity = (DataSetListEntity)datasetList.getEntity();
        entity.setDataSets(dataSetEntities);
    }

    private Map<Integer, String> getFileHeadingRow(String filePath) {
        ListIterator<Map<Integer, String>> rowIterator = this.getFileRowIterator(filePath);
        if (rowIterator.hasNext()) {
            return rowIterator.next();
        }
        throw new RuntimeException("Failed to iterate throw tested excel file rows");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ListIterator<Map<Integer, String>> getFileRowIterator(String filePath) {
        String locationPrefix = "src/test/resources/excel/import/";
        Path path = Paths.get(locationPrefix + filePath, new String[0]);
        ArrayList sheetConvertList = new ArrayList();
        try {
            OPCPackage pkg = OPCPackage.open((String)path.toString(), (PackageAccess)PackageAccess.READ);
            try {
                XlsxToListConverter xlsxToListConverter = new XlsxToListConverter(pkg, sheetConvertList);
                xlsxToListConverter.process();
                ListIterator<Map<Integer, String>> listIterator = sheetConvertList.listIterator();
                return listIterator;
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to load tested excel file rows");
            }
            finally {
                pkg.revert();
            }
        }
        catch (InvalidFormatException e) {
            throw new RuntimeException("Failed to load tested excel file rows, cause InvalidFormatException");
        }
    }

    private org.qubership.atp.dataset.service.jpa.delegates.DataSetList generateDataSetList(String name, org.qubership.atp.dataset.service.jpa.delegates.Attribute ... attributes) {
        return this.generateDataSetList(UUID.randomUUID(), name);
    }

    private org.qubership.atp.dataset.service.jpa.delegates.DataSetList generateDataSetList(String name) {
        return this.generateDataSetList(UUID.randomUUID(), name);
    }

    private org.qubership.atp.dataset.service.jpa.delegates.DataSetList generateDataSetList(UUID id, String name) {
        DataSetListEntity dataSetListEntity = new DataSetListEntity();
        dataSetListEntity.setId(id);
        dataSetListEntity.setName(name);
        return new org.qubership.atp.dataset.service.jpa.delegates.DataSetList(dataSetListEntity);
    }

    private void setAttributes(DataSetListEntity dataSetListEntity, org.qubership.atp.dataset.service.jpa.delegates.Attribute ... attributes) {
        if (attributes.length > 0) {
            dataSetListEntity.setAttributes(Arrays.stream(attributes).map(AbstractObjectWrapper::getEntity).collect(Collectors.toList()));
        }
    }

    private DataSet generateDataset(String name, org.qubership.atp.dataset.service.jpa.delegates.DataSetList datasetList) {
        DataSetEntity dataSetEntity = new DataSetEntity();
        dataSetEntity.setId(UUID.randomUUID());
        dataSetEntity.setName(name);
        dataSetEntity.setDataSetList((DataSetListEntity)datasetList.getEntity());
        return new DataSet(dataSetEntity);
    }

    private org.qubership.atp.dataset.service.jpa.delegates.Attribute generateAttribute(String name, org.qubership.atp.dataset.service.jpa.delegates.DataSetList datasetList, org.qubership.atp.dataset.service.jpa.delegates.DataSetList refDatasetList, long attributeTypeId) {
        AttributeEntity attributeEntity = new AttributeEntity();
        attributeEntity.setId(UUID.randomUUID());
        attributeEntity.setName(name);
        attributeEntity.setDataSetList((DataSetListEntity)datasetList.getEntity());
        attributeEntity.setAttributeTypeId(Long.valueOf(attributeTypeId));
        if (Objects.nonNull(refDatasetList)) {
            attributeEntity.setTypeDataSetListId(refDatasetList.getId());
        }
        return new org.qubership.atp.dataset.service.jpa.delegates.Attribute(attributeEntity);
    }

    private org.qubership.atp.dataset.service.jpa.delegates.Attribute generateAttribute(String name, org.qubership.atp.dataset.service.jpa.delegates.DataSetList datasetList, long attributeTypeId) {
        return this.generateAttribute(name, datasetList, null, attributeTypeId);
    }

    private AttributeKey generateAttributeKey(String key, org.qubership.atp.dataset.service.jpa.delegates.Attribute attribute, org.qubership.atp.dataset.service.jpa.delegates.DataSetList datasetList, DataSet dataSet) {
        AttributeKeyEntity attributeEntity = new AttributeKeyEntity();
        attributeEntity.setId(UUID.randomUUID());
        attributeEntity.setKey(key);
        attributeEntity.setAttribute((AttributeEntity)attribute.getEntity());
        attributeEntity.setDataSet((DataSetEntity)dataSet.getEntity());
        attributeEntity.setDataSetList((DataSetListEntity)datasetList.getEntity());
        return new AttributeKey(attributeEntity);
    }

    private ListValue generateListValue(String name) {
        ListValueEntity listValueEntity = new ListValueEntity();
        listValueEntity.setId(UUID.randomUUID());
        listValueEntity.setText(name);
        return new ListValue(listValueEntity);
    }

    private Parameter generateParameter(String text, DataSet dataset, org.qubership.atp.dataset.service.jpa.delegates.Attribute attribute, AttributeKey attributeKey, ListValue listValue, DataSet refDataset) {
        ParameterImpl parameter = new ParameterImpl();
        parameter.setId(UUID.randomUUID());
        parameter.setText(text);
        org.qubership.atp.dataset.service.jpa.delegates.DataSetList dataSetList = dataset.getDataSetList();
        DataSetListImpl dsl = new DataSetListImpl();
        dsl.setId(dataSetList.getId());
        dsl.setName(dataSetList.getName());
        DataSetImpl ds = new DataSetImpl(dataset.getId(), dataset.getName(), (DataSetList)dsl, null, null, Boolean.valueOf(false));
        parameter.setDataSet((org.qubership.atp.dataset.model.DataSet)ds);
        if (Objects.nonNull(refDataset)) {
            DataSetImpl refDs = new DataSetImpl(refDataset.getId(), refDataset.getName(), null, null, null, Boolean.valueOf(false));
            parameter.setDataSetReference((org.qubership.atp.dataset.model.DataSet)refDs);
        }
        AttributeImpl attr = new AttributeImpl();
        if (Objects.nonNull(attribute)) {
            attr.setId(attribute.getId());
            attr.setName(attribute.getName());
        } else {
            attr.setId(attributeKey.getId());
            attr.setName(attributeKey.getName());
        }
        parameter.setAttribute((Attribute)attr);
        if (Objects.nonNull(listValue)) {
            ListValueImpl lv = new ListValueImpl();
            lv.setId(listValue.getId());
            lv.setName(listValue.getText());
            parameter.setListValue((org.qubership.atp.dataset.model.ListValue)lv);
        }
        return parameter;
    }

    private Parameter generateParameter(String text, DataSet dataset, org.qubership.atp.dataset.service.jpa.delegates.Attribute attribute, ListValue listValue, DataSet refDataset) {
        return this.generateParameter(text, dataset, attribute, null, listValue, refDataset);
    }

    private Parameter generateParameter(String text, DataSet dataset, AttributeKey attributeKey, ListValue listValue, DataSet refDataset) {
        return this.generateParameter(text, dataset, null, attributeKey, listValue, refDataset);
    }

    private static class Att {
        private Att() {
        }
    }
}

