/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.service.jpa.model.tree.params.macros;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.script.ScriptEngineManager;
import org.apache.commons.lang3.math.NumberUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.parallel.Isolated;
import org.qubership.atp.dataset.service.jpa.impl.macro.MacroContext;
import org.qubership.atp.dataset.service.jpa.model.tree.params.AbstractTextParameter;
import org.qubership.atp.dataset.service.jpa.model.tree.params.TextParameter;
import org.qubership.atp.dataset.service.jpa.model.tree.params.macros.AtpMacro;
import org.qubership.atp.dataset.service.jpa.model.tree.params.macros.ParameterPositionContext;
import org.qubership.atp.dataset.service.jpa.model.tree.params.macros.TestUtils;
import org.qubership.atp.dataset.service.jpa.model.tree.params.macros.matcher.MatcherFactory;
import org.qubership.atp.macros.core.calculator.MacrosCalculator;
import org.qubership.atp.macros.core.calculator.ScriptMacrosCalculator;
import org.qubership.atp.macros.core.model.Macros;
import org.springframework.test.context.junit.jupiter.SpringExtension;

@Isolated
@ExtendWith(value={SpringExtension.class})
public class AtpMacroTest {
    private ParameterPositionContext parameterPositionContext;
    private MacroContext macroContext;
    private Macros uuidMacros;
    private Macros customMacros;
    private Macros contextMacros;
    private Macros innMacros;
    private Macros uuidUpperCaseMacros;
    private Macros randomBetweenMacros;
    private Macros dateMacros;
    private Macros charsMacros;
    private Macros charsUpperCaseMacros;
    private Macros sumMacros;
    private Macros trNameMacros;
    private Macros shiftDayMacros;

    @BeforeEach
    public void setUp() {
        this.macroContext = new MacroContext();
        this.uuidMacros = TestUtils.getUuidMacros();
        this.customMacros = TestUtils.getCustomMacros();
        this.contextMacros = TestUtils.getContextMacros();
        this.innMacros = TestUtils.getInnMacros();
        this.uuidUpperCaseMacros = TestUtils.getUuidUpperCaseMacros();
        this.randomBetweenMacros = TestUtils.getRandomBetweenMacros();
        this.dateMacros = TestUtils.getDateMacros();
        this.charsMacros = TestUtils.getCharsMacros();
        this.charsUpperCaseMacros = TestUtils.getCharsUpperCaseMacros();
        this.sumMacros = TestUtils.getSumMacros();
        this.trNameMacros = TestUtils.getTrNameMacros();
        this.shiftDayMacros = TestUtils.getShiftDayMacros();
        List<Macros> macrosList = Arrays.asList(this.uuidMacros, this.customMacros, this.contextMacros, this.innMacros, this.uuidUpperCaseMacros, this.randomBetweenMacros, this.dateMacros, this.charsMacros, this.charsUpperCaseMacros, this.sumMacros, this.trNameMacros, this.shiftDayMacros);
        this.macroContext.setMacros(macrosList);
        this.macroContext.setMacrosCalculator((MacrosCalculator)new ScriptMacrosCalculator(new ScriptEngineManager()));
        this.parameterPositionContext = new ParameterPositionContext(Collections.emptyList(), 0, null, Long.valueOf(0L), null);
    }

    @Test
    public void testGetEvaluatedValue_shouldReturnUuidValue_whenMacrosIsUuid() {
        AtpMacro macro = new AtpMacro(this.uuidMacros.getName(), this.macroContext, this.parameterPositionContext, this.uuidMacros);
        String evaluatedValue = macro.getEvaluatedValue(macro.getArguments());
        MatcherAssert.assertThat((Object)evaluatedValue, MatcherFactory.isUuid());
    }

    @Test
    public void testGetEvaluatedValue_shouldReturnCustomValue_whenMacrosIsCustom() {
        AtpMacro macro = new AtpMacro(this.customMacros.getName(), this.macroContext, this.parameterPositionContext, this.customMacros);
        String evaluatedValue = macro.getEvaluatedValue(macro.getArguments());
        MatcherAssert.assertThat((Object)evaluatedValue, (Matcher)CoreMatchers.is((Object)"CUSTOM_VALUE"));
    }

    @Test
    public void testGetEvaluatedValue_shouldReturnContextValue_whenMacrosIsContext() {
        this.macroContext.addAtpDataSetContext("{'VAR1': '12345'}");
        AtpMacro macro = new AtpMacro(this.contextMacros.getName(), this.macroContext, this.parameterPositionContext, this.contextMacros);
        macro.addTextParameter((AbstractTextParameter)new TextParameter("VAR1", this.parameterPositionContext));
        String evaluatedValue = macro.getEvaluatedValue(macro.getArguments());
        MatcherAssert.assertThat((Object)evaluatedValue, (Matcher)CoreMatchers.is((Object)"12345"));
    }

    @Test
    public void testGetEvaluatedValue_shouldReturnUnknownValue_whenMacrosIsContext() {
        this.macroContext.addAtpDataSetContext("{'VAR1': '12345'}");
        AtpMacro macro = new AtpMacro(this.contextMacros.getName(), this.macroContext, this.parameterPositionContext, this.contextMacros);
        macro.addTextParameter((AbstractTextParameter)new TextParameter("VAR2", this.parameterPositionContext));
        String evaluatedValue = macro.getEvaluatedValue(macro.getArguments());
        MatcherAssert.assertThat((Object)evaluatedValue, (Matcher)CoreMatchers.is((Object)"Unknown VAR2"));
    }

    @Test
    public void testGetEvaluatedValue_shouldReturnInnValue_whenMacrosIsInn() {
        AtpMacro macro = new AtpMacro(this.innMacros.getName(), this.macroContext, this.parameterPositionContext, this.innMacros);
        String evaluatedValue = macro.getEvaluatedValue(macro.getArguments());
        MatcherAssert.assertThat((Object)evaluatedValue, MatcherFactory.isInn());
    }

    @Test
    public void testGetEvaluatedValue_shouldReturnUuidUpperCaseValue_whenMacrosIsUuidUpperCase() {
        AtpMacro macro = new AtpMacro(this.uuidUpperCaseMacros.getName(), this.macroContext, this.parameterPositionContext, this.uuidUpperCaseMacros);
        String evaluatedValue = macro.getEvaluatedValue(macro.getArguments());
        MatcherAssert.assertThat((Object)evaluatedValue, MatcherFactory.isUuidUpperCase());
    }

    @Test
    public void testGetEvaluatedValue_shouldReturnRandomBetweenValue_whenMacrosIsRandomBetween() {
        AtpMacro macro = new AtpMacro(this.randomBetweenMacros.getName(), this.macroContext, this.parameterPositionContext, this.randomBetweenMacros);
        macro.addTextParameter((AbstractTextParameter)new TextParameter("11", this.parameterPositionContext));
        macro.addTextParameter((AbstractTextParameter)new TextParameter("20", this.parameterPositionContext));
        String evaluatedValue = macro.getEvaluatedValue(macro.getArguments());
        Assertions.assertTrue((boolean)NumberUtils.isParsable((String)evaluatedValue));
        MatcherAssert.assertThat((Object)Integer.parseInt(evaluatedValue), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.both((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(11))).and(Matchers.lessThanOrEqualTo((Comparable)Integer.valueOf(20)))));
    }

    @Test
    public void testGetEvaluatedValue_shouldReturnNaNValue_whenMacrosIsRandomBetween() {
        AtpMacro macro = new AtpMacro(this.randomBetweenMacros.getName(), this.macroContext, this.parameterPositionContext, this.randomBetweenMacros);
        macro.addTextParameter((AbstractTextParameter)new TextParameter("abc", this.parameterPositionContext));
        macro.addTextParameter((AbstractTextParameter)new TextParameter("def", this.parameterPositionContext));
        String evaluatedValue = macro.getEvaluatedValue(macro.getArguments());
        MatcherAssert.assertThat((Object)evaluatedValue, MatcherFactory.isNaN());
    }

    @Test
    public void testGetEvaluatedValue_shouldReturnDateValue_whenMacrosIsDate() {
        AtpMacro macro = new AtpMacro(this.dateMacros.getName(), this.macroContext, this.parameterPositionContext, this.dateMacros);
        macro.addTextParameter((AbstractTextParameter)new TextParameter("yyyy-MM-dd\\'T\\'HH:mm:ss.SSSZ", this.parameterPositionContext));
        macro.addTextParameter((AbstractTextParameter)new TextParameter("GMT+2", this.parameterPositionContext));
        String evaluatedValue = macro.getEvaluatedValue(macro.getArguments());
        MatcherAssert.assertThat((Object)evaluatedValue, MatcherFactory.isIsoDate());
    }

    @Test
    public void testGetEvaluatedValue_shouldReturnCharsValue_whenMacrosIsChars() {
        AtpMacro macro = new AtpMacro(this.charsMacros.getName(), this.macroContext, this.parameterPositionContext, this.charsMacros);
        macro.addTextParameter((AbstractTextParameter)new TextParameter("200", this.parameterPositionContext));
        String evaluatedValue = macro.getEvaluatedValue(macro.getArguments());
        MatcherAssert.assertThat((Object)evaluatedValue, MatcherFactory.isChars(200));
    }

    @Test
    public void testGetEvaluatedValue_shouldReturnCharsUpperCaseValue_whenMacrosIsCharsUpperCase() {
        AtpMacro macro = new AtpMacro(this.charsUpperCaseMacros.getName(), this.macroContext, this.parameterPositionContext, this.charsUpperCaseMacros);
        macro.addTextParameter((AbstractTextParameter)new TextParameter("200", this.parameterPositionContext));
        String evaluatedValue = macro.getEvaluatedValue(macro.getArguments());
        MatcherAssert.assertThat((Object)evaluatedValue, MatcherFactory.isCharsUpperCase(200));
    }

    @Test
    public void testGetEvaluatedValue_shouldThrowAnException_whenMacrosIsSum() {
        AtpMacro macro = new AtpMacro(this.sumMacros.getName(), this.macroContext, this.parameterPositionContext, this.sumMacros);
        macro.addTextParameter((AbstractTextParameter)new TextParameter("abc", this.parameterPositionContext));
        macro.addTextParameter((AbstractTextParameter)new TextParameter("123", this.parameterPositionContext));
        String evaluatedValue = macro.getEvaluatedValue(macro.getArguments());
        MatcherAssert.assertThat((Object)evaluatedValue, MatcherFactory.isNaN());
    }

    @Test
    public void testGetEvaluatedValue_shouldReturnSumValue_whenMacrosIsSum() {
        AtpMacro macro = new AtpMacro(this.sumMacros.getName(), this.macroContext, this.parameterPositionContext, this.sumMacros);
        macro.addTextParameter((AbstractTextParameter)new TextParameter("11", this.parameterPositionContext));
        macro.addTextParameter((AbstractTextParameter)new TextParameter("20", this.parameterPositionContext));
        String evaluatedValue = macro.getEvaluatedValue(macro.getArguments());
        Assertions.assertTrue((boolean)NumberUtils.isParsable((String)evaluatedValue));
    }

    @Test
    public void testGetEvaluatedValue_whenTestRunNameUnknown_shouldReturnUnevaluatedValue() {
        AtpMacro macro = new AtpMacro(this.trNameMacros.getName(), this.macroContext, this.parameterPositionContext, this.trNameMacros);
        String evaluatedValue = macro.getEvaluatedValue(macro.getArguments());
        Assertions.assertEquals((Object)macro.getUnevaluatedValue(""), (Object)evaluatedValue);
    }

    @Test
    public void testGetEvaluatedValue_shouldReturnShiftDayValue_whenMacrosIsShiftDay() {
        AtpMacro macro = new AtpMacro(this.shiftDayMacros.getName(), this.macroContext, this.parameterPositionContext, this.shiftDayMacros);
        macro.addTextParameter((AbstractTextParameter)new TextParameter("57", this.parameterPositionContext));
        macro.addTextParameter((AbstractTextParameter)new TextParameter("05.11.2020", this.parameterPositionContext));
        macro.addTextParameter((AbstractTextParameter)new TextParameter("dd.MM.yyyy", this.parameterPositionContext));
        String evaluatedValue = macro.getEvaluatedValue(macro.getArguments());
        MatcherAssert.assertThat((Object)evaluatedValue, MatcherFactory.isDate());
    }
}

