/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.service.jpa.model.tree.params.macros.matcher;

import org.hamcrest.Matcher;
import org.qubership.atp.dataset.service.jpa.model.tree.params.macros.matcher.RegexMatcher;

public class MatcherFactory {
    public static Matcher<String> isUuid() {
        return new RegexMatcher("[0-9a-f]{8}(?:-[0-9a-f]{4}){3}-[0-9a-f]{12}");
    }

    public static Matcher<String> isUuidUpperCase() {
        return new RegexMatcher("[0-9A-F]{8}(?:-[0-9A-F]{4}){3}-[0-9A-F]{12}");
    }

    public static Matcher<String> isInn() {
        return new RegexMatcher("[0-9]{10}");
    }

    public static Matcher<String> isIsoDate() {
        return new RegexMatcher("[0-9]{4}(-[0-9]{2}){2}T([0-9]{2}:){2}[0-9]{2}.[0-9]{3}.[0-9]{4}");
    }

    public static Matcher<String> isIsoDateWithoutMs() {
        return new RegexMatcher("[0-9]{4}(-[0-9]{2}){2}T([0-9]{2}:){2}[0-9]{2}.[0-9]{4}");
    }

    public static Matcher<String> isIsoDateWithoutMsAndWithTimezoneInQuotes() {
        return new RegexMatcher("\"[0-9]{4}(-[0-9]{2}){2}T([0-9]{2}:){2}[0-9]{2}.[0-9]{2}.[0-9]{2}\"");
    }

    public static Matcher<String> isIsoDateWithTimezoneCharacter() {
        return new RegexMatcher("[0-9]{4}(-[0-9]{2}){2}T([0-9]{2}:){2}[0-9]{2}.[0-9]{3}Z");
    }

    public static Matcher<String> isIsoDateWithTimezoneCharacterInQuotes() {
        return new RegexMatcher("\"[0-9]{4}(-[0-9]{2}){2}T([0-9]{2}:){2}[0-9]{2}.[0-9]{3}Z\"");
    }

    public static Matcher<String> isIsoDateWithoutMsAndWithoutTimezoneInQuotes() {
        return new RegexMatcher("\"[0-9]{4}(-[0-9]{2}){2}T([0-9]{2}:){2}[0-9]{2}\"");
    }

    public static Matcher<String> isIsoDateWithoutMsAndWithTimezoneCharacter() {
        return new RegexMatcher("[0-9]{4}(-[0-9]{2}){2}T([0-9]{2}:){2}[0-9]{2}Z");
    }

    public static Matcher<String> isIsoDateWithoutMsAndWithTimezoneCharacterInQuotes() {
        return new RegexMatcher("\"[0-9]{4}(-[0-9]{2}){2}T([0-9]{2}:){2}[0-9]{2}Z\"");
    }

    public static Matcher<String> isIsoDateWithoutTimeInQuotes() {
        return new RegexMatcher("\"[0-9]{4}(-[0-9]{2}){2}T\"");
    }

    public static Matcher<String> isDate() {
        return new RegexMatcher("([0-9]{2}.){2}[0-9]{4}");
    }

    public static Matcher<String> isChars(int count) {
        return new RegexMatcher(String.format("[a-z]{%d}", count));
    }

    public static Matcher<String> isCharsUpperCase(int count) {
        return new RegexMatcher(String.format("[A-Z]{%d}", count));
    }

    public static Matcher<String> isNaN() {
        return new RegexMatcher("NaN");
    }
}

