/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.service.jpa.service;

import java.util.List;
import java.util.UUID;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.qubership.atp.dataset.config.TestConfiguration;
import org.qubership.atp.dataset.exception.visibilityarea.VisibilityAreaNameException;
import org.qubership.atp.dataset.service.jpa.model.VisibilityAreaFlatModel;
import org.qubership.atp.dataset.service.jpa.service.AbstractJpaTest;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit.jupiter.SpringExtension;

@Disabled
@SpringBootTest
@ContextConfiguration(classes={TestConfiguration.class})
@ExtendWith(value={SpringExtension.class})
public class JpaVisibilityAreaServiceTest
extends AbstractJpaTest {
    @Test
    public void getSorted_notNullNotEmpty() {
        List byNameAsc = this.visibilityAreaService.getAllSortedByNameAsc();
        Assertions.assertNotNull((Object)byNameAsc);
        Assertions.assertFalse((boolean)byNameAsc.isEmpty());
    }

    @Test
    public void getAllAreas_notNullNotEmpty() {
        List all = this.visibilityAreaService.getAll();
        Assertions.assertNotNull((Object)all);
        Assertions.assertFalse((boolean)all.isEmpty());
    }

    @Test
    public void createWithName_correctName_uuidNotNull() throws Exception {
        String testName = "test name";
        UUID withName = this.visibilityAreaService.getOrCreateWithName(testName);
        Assertions.assertNotNull((Object)withName);
        VisibilityAreaFlatModel visibilityArea = this.visibilityAreaService.getFlatById(withName);
        Assertions.assertEquals((Object)visibilityArea.getName(), (Object)testName);
    }

    @Test
    public void createWithName_twiceSameName_returnsExisting() throws Exception {
        String testName = "test name";
        UUID firstTry = this.visibilityAreaService.getOrCreateWithName(testName);
        UUID secondTry = this.visibilityAreaService.getOrCreateWithName(testName);
        Assertions.assertEquals((Object)firstTry, (Object)secondTry);
    }

    @Test
    public void createWithName_null_throwsException() {
        Assertions.assertThrows(VisibilityAreaNameException.class, () -> this.visibilityAreaService.getOrCreateWithName(null));
    }

    @Test
    public void createWithName_empty_throwsException() throws Exception {
        Assertions.assertThrows(VisibilityAreaNameException.class, () -> this.visibilityAreaService.getOrCreateWithName(""));
    }

    @Test
    public void setName_correct_nameSet() throws Exception {
        UUID visibilityAreaId = this.visibilityAreaService.getOrCreateWithName("test1 correct");
        String newName = "new name correct";
        this.visibilityAreaService.setName(visibilityAreaId, newName);
        VisibilityAreaFlatModel visibilityArea = this.visibilityAreaService.getFlatById(visibilityAreaId);
        Assertions.assertEquals((Object)visibilityArea.getName(), (Object)newName);
    }

    @Test
    public void setName_null_throwsException() throws Exception {
        UUID visibilityAreaId = this.visibilityAreaService.getOrCreateWithName("test2 name");
        Assertions.assertThrows(VisibilityAreaNameException.class, () -> this.visibilityAreaService.setName(visibilityAreaId, null));
    }

    @Test
    public void setName_empty_throwsException() throws Exception {
        UUID visibilityAreaId = this.visibilityAreaService.getOrCreateWithName("test3 removed");
        Assertions.assertThrows(VisibilityAreaNameException.class, () -> this.visibilityAreaService.setName(visibilityAreaId, ""));
    }

    @Test
    public void delete_returnNullWhenSelectByIdAfterDelete() throws Exception {
        VisibilityAreaFlatModel result = this.visibilityAreaService.getFlatById(UUID.randomUUID());
        Assertions.assertNull((Object)result);
    }
}

